function lyngby_ui_lzit_init(command,parameter1) 

% lyngby_ui_lzit_init  - GUI for iterative Lange-Zeger initialization
%
%       function lyngby_ui_lzit_init.m(command,parameter1)
%
%       This function controls the window that enable the user to
%       set the initialization parameters for Iterative Lange-Zeger
%       algorithm. 
%
%        - Minimum change is an iteration-stop criterion: It is the
%                        minimum  change in the costfunction required
%                        for the iteration to stop.
% 
%        - Number of iterations  is an iteration-stop criterion: This
%                        is the maximum number of iterations in the
%                        optimization algorithm
% 
%        - Stepsize      is the gradient descent parameter. 
%
%       See also LYNGBY, LYNGBY_LZIT_MAIN, LYNGBY_UI_MAIN.
%
% $Id: lyngby_ui_lzit_init.m,v 1.5 2003/04/23 13:31:31 fnielsen Exp $ 

%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 
%
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 



    lyngby_lzit_global;
    lyngby_ui_option;
    
    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editIterations')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editStepsize')) 
	command = 5; 
      elseif strcmp(lower(command),lower('editMinchange'))
	command = 6; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_lzit_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_lzit_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonHelp = handle_list(4); 
	buttonApply = handle_list(5); 
	buttonClose = handle_list(6); 
	editIterations = handle_list(7); 
	textIterations = handle_list(8); 
	editStepsize = handle_list(9); 
	textStepsize = handle_list(10); 
	editMinchange = handle_list(11); 
	textMinchange = handle_list(12); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 400 350 200 ],... 
	  'resize','On','tag','lyngby_ui_lzit_init',... 
	  'menubar','Figure','name','lyngby - iterative Lange Zeger analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      ButtonWidth = 0.25;
      ButtonHeight = 0.12;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row2 = 0.28; % Lower buttons
      Row3 = 0.42; % Middle buttons
      Row4 = 0.56; % Upper buttons
      Row5 = 0.68; % Lower title
      Row6 = 0.75; % Upper title
      Column1 = 0.07; % Left window button
      Column2 = 0.38; % Middle window button
      Column3 = 0.69; % Right window button
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width

      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the Iterative Lange-Zeger algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row6 0.9 0.18 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
      
      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''buttonApply'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''buttonClose'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''buttonHelp'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
      
      textMinchange = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''textMinchange'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_FRAME,... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row4 LabelWidth ButtonHeight ],... 
	  'String','Minimum change:',... 
	  'Style','text',... 
	  'Tag','textMinchange',... 
	  'UserData',''); 
      editMinchange = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''editMinchange'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Units','normalized',... 
	  'Position',[ Column5 Row4 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editMinchange',... 
	  'UserData',''); 
      textIterations = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''textIterations'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_FRAME,... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row3 LabelWidth ButtonHeight ],... 
	  'String','Number of Iterations:',... 
	  'Style','text',... 
	  'Tag','textIterations',... 
	  'UserData',''); 
      editIterations = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''editIterations'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Units','normalized',... 
	  'Position',[ Column5 Row3 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editIterations',... 
	  'UserData',''); 

      textStepsize = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''textStepsize'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_FRAME,... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row2 LabelWidth ButtonHeight ],... 
	  'String','Stepsize:',... 
	  'Style','text',... 
	  'Tag','textStepsize',... 
	  'UserData',''); 
      editStepsize = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''editStepsize'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Units','normalized',... 
	  'Position',[ Column5 Row2 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editStepsize',... 
	  'UserData',''); 
      

      set(editIterations, 'String', num2str(LZ2_ITERATIONS));
      set(editMinchange, 'String', num2str(LZ2_MINCHANGE));
      set(editStepsize, 'String', num2str(LZ2_STEPSIZE));

      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonHelp buttonApply buttonClose ... 
	  editIterations textIterations ... 
	  editStepsize textStepsize ... 
	  editMinchange textMinchange ... 
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [lz2_Iterations, count1] = sscanf(get(editIterations, 'String'), '%d'); 
      if (count1==1 & lz2_Iterations > 0) 
	LZ2_ITERATIONS = lz2_Iterations; 
      else 
	error('Number of iterations must be integer and larger than 0.'); 
      end 

      [lz2_Stepsize, count1] = sscanf(get(editStepsize, 'String'), '%f'); 
      if (count1==1 & lz2_Stepsize > 0) 
	LZ2_STEPSIZE = lz2_Stepsize;
      else 
	error('The stepsize must be positive.'); 
      end 

      [lz2_Minchange, count1] = sscanf(get(editMinchange, 'String'), '%f'); 
      if (count1==1 & lz2_Minchange > 0) 
	LZ2_MINCHANGE = lz2_Minchange;
      else 
	error('The minimal change must be positive.'); 
      end 

      lyngby_log('New parameters updated')
      
    elseif command == 2 

      helpwin('lyngby_ui_lzit_init')
      
    elseif command == 3 
      
      close(gcf); 
      
    elseif command == 4 

      lyngby_log('Parameters edited')
      
    elseif command == 5 

      lyngby_log('Parameters edited')
    
    elseif command == 6

      lyngby_log('Parameters edited')

    else 
      error('Error: lyngby_ui_lzit_init.m called with incorrect command.') 
    end 





