function lyngby_ui_main(command,parameter1) 

% lyngby_ui_main       - Main function for the GUI for lyngby
%
%       function lyngby_ui_main(command,parameter1)
%       function lyngby_ui_main
%
%       Input:  command,parameter1  Both are internal callback arguments, 
%                                   to start this function just type
%                                   lyngby_ui_main
%
%       Main function for the graphical interface to lyngby. Calls the
%       setup windows, main analysis and viewing functions.
%
%           lyngby_ui_view    Result viewing
%           lyngby_bat_test   Ardekani t-test
%           lyngby_baf_test   Ardekani F-test
%           lyngby_baf2_main  Ardekani F-test with nuisance estimation
%           lyngby_xcorr      Cross-correlation 
%           lyngby_fir_main   FIR filter
%           lyngby_efir_main  Exhaustive FIR filter
%           lyngby_km_main    K-means
%           lyngby_ks_main    Kolmogorov-Smirnov
%           lyngby_lzit_main  Lange-Zeger
%           lyngby_pois_main  Poisson filter
%           lyngby_ts_main    Ordinary t-text
%           lyngby_cons_main  Consensus modeling
%
%       See also LYNGBY, LYNGBY_UI_VIEW, LYNGBY_BAT_TEST,
%                LYNGBY_BAF_TEST, LYNGBY_BAF2_TEST, LYNGBY_XCORR,
%                LYNGBY_FIR_MAIN, LYNGBY_EFIR_MAIN, LYNGBY_KM_MAIN,
%                LYNGBY_KS_MAIN, LYNGBY_LZIT_MAIN, LYNGBY_POIS_MAIN,
%                LYNGBY_TS_MAIN, LYNGBY_CONS_MAIN.  
% 
% $Id: lyngby_ui_main.m,v 1.136 2002/03/12 16:14:37 fnielsen Exp $ 

%  Made with:	GUI Maker Ver 2.1 by Patrick Marchand 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 



% Globals

    lyngby_global;
    lyngby_ui_global;		
    lyngby_prep_global;

    lyngby_bat_global;
    lyngby_baf_global;
    lyngby_baf2_global;
    lyngby_cc_global;
    lyngby_efir_global;
    lyngby_fir_global;
    lyngby_lzgs_global;
    lyngby_lzit_global;
    lyngby_km_global;
    lyngby_ikm_global;
    lyngby_ks_global;
    lyngby_nnr_global;
    lyngby_nns_global;
    lyngby_pois_global;
    lyngby_ts_global;
    lyngby_svd_global;
    lyngby_ica_global;
    lyngby_scva_global;
    lyngby_sop_global;

    lyngby_cons_global
    lyngby_mkm_global;

    global UIHANDLE_LOG
    global RUN     % Necessary due to Windows "bug"

    % Method Identifiers
    amNone  = 1;
    amCc = 2;
    amFir = 3;
    amEFir = 4; 
    amKm = 5;
    amIKm = 6;
    amLZGS = 7;
    amLzIT = 8;
    amBAT = 9;
    amBAF = 10;
    amBAF2  = 11;
    amTs = 12;
    amKS = 13;
    amNNR   = 14; 
    amNNS   = 15;
    amPois  = 16;
    amSVD   = 17;
    amICA   = 18;
    amSCVA  = 19;
    amSOP   = 20;

    amCONS  = 1;
    amMKM   = 2;
    
    
    UI_ON = 1;

    % This function toggles the state of the tooltips help.
    ToggleTooltips = [ ...
	  'ver = (version);', ...
	  'ver = str2num(ver(1:3));', ...
	  'if ver >= 5.2 & strcmp(get(menuTooltips, ''Checked''), ''on''),',...
	  '  UI_TOOLTIPS = 0;',...
	  '  set(menuTooltips, ''Checked'',''off'');',...
	  '  set(buttonLoadNew, ''TooltipString'','''');',...
	  '  set(buttonLoadWorksheet, ''TooltipString'','''');',...
	  '  set(buttonDataSetup, ''TooltipString'','''');',...
	  '  set(buttonParadigmEdit, ''TooltipString'','''');',...
	  '  set(buttonRunEdit, ''TooltipString'','''');',...
	  '  set(popupAnalysisAlg, ''TooltipString'','''');',...
	  '  set(buttonAnalysisParam, ''TooltipString'','''');',...
	  '  set(buttonAnalysisCalc, ''TooltipString'','''');',...
	  '  set(buttonSAnalysisCalc, ''TooltipString'','''');',...
	  '  set(buttonAnalysisView, ''TooltipString'','''');',...
	  '  set(buttonSAnalysisView, ''TooltipString'','''');',...
	  '  set(popupPostProcessAlg, ''TooltipString'','''');',...
	  '  set(buttonPostProcessParam, ''TooltipString'','''');',...
	  '  set(buttonPostProcessCalc, ''TooltipString'','''');',...
	  '  set(buttonSPostProcessCalc, ''TooltipString'','''');',...
	  '  set(buttonPostProcessView, ''TooltipString'','''');',...
	  '  set(buttonSPostProcessView, ''TooltipString'','''');',...
	  '  set(buttonSaveWorksheet, ''TooltipString'','''');',...
	  '  set(buttonExit, ''TooltipString'','''');',...
	  '  set(textLog, ''TooltipString'','''');',...
	  'elseif ver >= 5.2,',...
	  '  UI_TOOLTIPS = 1;',...
	  '  set(menuTooltips, ''Checked'',''on'');',...
	  '  set(buttonLoadNew, ''TooltipString'',''Press to load data from a variety of formats'');',...
	  '  set(buttonLoadWorksheet, ''TooltipString'',''Press to load a previous lyngby worksheet'');',...
	  '  set(buttonParadigmEdit, ''TooltipString'',''Allows you to create a reference/activation function'');',...
	  '  set(buttonRunEdit, ''TooltipString'',''Allows you to define the different stages in the experiment'');',...
	  '  set(buttonDataSetup, ''TooltipString'',''This leads to all the necessary data design and pre-processing steps'');',...
	  '  set(popupAnalysisAlg, ''TooltipString'',''Choose an algorithm from the pop-up list'');',...
	  '  set(buttonAnalysisParam, ''TooltipString'',''Set the parameters for the chosen algorithm'');',...
	  '  set(buttonAnalysisCalc, ''TooltipString'',''Calculate a result for the chosen algorithm'');',...
	  '  set(buttonSAnalysisCalc, ''TooltipString'',''Show, in the command window, what matlab code will be run upon pressing Calculate'');',...
	  '  set(buttonAnalysisView, ''TooltipString'',''View the results of the above algorithm'');',...
	  '  set(buttonSAnalysisView, ''TooltipString'',''Show, in the command window, what matlab code will be run upon pressing View'');',...
	  '  set(popupPostProcessAlg, ''TooltipString'',''Choose an post-processing algorithm from the pop-up list'');',...
	  '  set(buttonPostProcessParam, ''TooltipString'',''Set the parameters for the chosen algorithm'');',...
	  '  set(buttonPostProcessCalc, ''TooltipString'',''Calculate a result for the chosen algorithm'');',...
	  '  set(buttonSPostProcessCalc, ''TooltipString'',''Show, in the command window, what matlab code will be run upon pressing Calculate'');',...
	  '  set(buttonPostProcessView, ''TooltipString'',''View the results of the above algorithm'');',...
	  '  set(buttonSPostProcessView, ''TooltipString'',''Show, in the command window, what matlab code will be run upon pressing View'');',...
	  '  set(buttonSaveWorksheet, ''TooltipString'',''Save the present worksheet (i.e. data and results)'');',...
	  '  set(buttonExit, ''TooltipString'',''Close this interface - results are still accessible from the command line'');',...
	  '  set(textLog, ''TooltipString'',''Lyngby status line. Press for Copyright info'');',...
	  'end,',...
	  ];


    
    % This function grays the buttons 
    UpdateButtonEnabling = [ ...
	  'if ~isempty(X),',...
	  '  set(buttonDataSetup, ''Enable'', ''on'');',...
	  '  set(buttonSaveWorksheet, ''Enable'', ''on'');',...
	  'else,',...
	  '  set(buttonDataSetup, ''Enable'', ''off'');',...
	  '  set(buttonSaveWorksheet, ''Enable'', ''off'');',...
	  'end;',...
	  'AnalysisMethod = get(popupAnalysisAlg,''Value'');',...
	  'if ~isempty(XN),',...
	  '  set(popupAnalysisAlg, ''Enable'', ''on'');',...
	  '  set(buttonAnalysisView, ''Enable'', ''on'');',...
	  '  set(buttonSAnalysisView, ''Enable'', ''on'');',...
	  '  if AnalysisMethod == amNone,',...
	  '    set(buttonAnalysisParam, ''Enable'', ''off'');',...
	  '    set(buttonAnalysisCalc, ''Enable'', ''off'');',...
	  '    set(buttonSAnalysisCalc, ''Enable'', ''off'');',...
	  '  else,',... 
	  '    set(buttonAnalysisParam, ''Enable'', ''on'');',...
	  '    set(buttonAnalysisCalc, ''Enable'', ''on'');',...
	  '    set(buttonSAnalysisCalc, ''Enable'', ''on'');',...
	  '  end,',...
	  'else,',...
	  '  set(popupAnalysisAlg, ''Enable'', ''off'');',...
	  '  set(buttonAnalysisParam, ''Enable'', ''off'');',...
	  '  set(buttonAnalysisCalc, ''Enable'', ''off'');',...
	  '  set(buttonSAnalysisCalc, ''Enable'', ''off'');',...
	  '  set(buttonAnalysisView, ''Enable'', ''off'');',...
	  '  set(buttonSAnalysisView, ''Enable'', ''off'');',...
	  'end;', ...
	  'if ~isempty(XN),',... 
	  '  set(popupPostProcessAlg, ''Enable'', ''on'');',...
	  '  set(buttonPostProcessParam, ''Enable'', ''on'');',...
	  '  set(buttonPostProcessCalc, ''Enable'', ''on'');',...
	  '  set(buttonSPostProcessCalc, ''Enable'', ''on'');',...
	  '  set(buttonPostProcessView, ''Enable'', ''on'');',...
	  '  set(buttonSPostProcessView, ''Enable'', ''on'');',...
	  'else,',...
	  '  set(popupPostProcessAlg, ''Enable'', ''off'');',...
	  '  set(buttonPostProcessParam, ''Enable'', ''off'');',...
	  '  set(buttonPostProcessCalc, ''Enable'', ''off'');',...
	  '  set(buttonSPostProcessCalc, ''Enable'', ''off'');',...
	  '  set(buttonPostProcessView, ''Enable'', ''off'');',...
	  '  set(buttonSPostProcessView, ''Enable'', ''off'');',...
	  'end;',...
	  ];


    if nargin == 0 
      command = 'new'; 
      lyngby_init;        
      
      PARADIGM = lyngby_paradigm;
      RUN = lyngby_run;
      
    end 


    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 

      elseif strcmp(lower(command),lower('buttonLoadNew')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonLoadWorksheet')) 
	command = 2; 

      elseif strcmp(lower(command),lower('buttonCallExternals')) 
	command = 18;
	
      elseif strcmp(lower(command),lower('buttonRunEdit')) 
	command = 19;
      elseif strcmp(lower(command),lower('buttonRunHelp')) 
	command = 20;
      elseif strcmp(lower(command),lower('buttonParadigmEdit')) 
	command = 21;
      elseif strcmp(lower(command),lower('buttonParadigmHelp')) 
	command = 22;
	
	
      elseif strcmp(lower(command),lower('buttonDataSetup')) 
	command = 401; 

      elseif strcmp(lower(command),lower('popupAnalysisAlg')) 
	command = 500; 
      elseif strcmp(lower(command),lower('buttonAnalysisParam')) 
	command = 501; 
      elseif strcmp(lower(command),lower('buttonAnalysisCalc')) 
	command = 502; 
      elseif strcmp(lower(command),lower('buttonAnalysisView')) 
	command = 503; 
      elseif strcmp(lower(command),lower('buttonSAnalysisCalc')) 
	command = 504; 
      elseif strcmp(lower(command),lower('buttonSAnalysisView')) 
	command = 505; 
      
      elseif strcmp(lower(command),lower('popupPostProcessAlg')) 
	command = 600; 
      elseif strcmp(lower(command),lower('buttonPostProcessParam')) 
	command = 601; 
      elseif strcmp(lower(command),lower('buttonPostProcessCalc')) 
	command = 602; 
      elseif strcmp(lower(command),lower('buttonPostProcessView')) 
	command = 603; 
      elseif strcmp(lower(command),lower('buttonSPostProcessCalc')) 
	command = 604; 
      elseif strcmp(lower(command),lower('buttonSPostProcessView')) 
	command = 605;

      elseif strcmp(lower(command),lower('ToggleTooltips'))
	command = 800;
	
      elseif strcmp(lower(command),lower('buttonSaveWorksheet')) 
	command = 910; 

      elseif strcmp(lower(command),lower('textLog')) 
	command = 930; 

      elseif strcmp(lower(command),lower('buttonExit')) 
	command = 1000; 
	
      elseif strcmp(lower(command),lower('UpdateButtonEnabling')) 
	command = 9000; 
	
      end 

    end 



    if command ~= 0 
      % Just in case there accidentally is an axes in the main window
      legend off;
      delete(gca);
      
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_main'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_main.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 

	buttonLoadNew = handle_list(1); 
	buttonLoadWorksheet = handle_list(2);

	buttonDataSetup = handle_list(3); 

	popupAnalysisAlg = handle_list(4); 
	buttonAnalysisParam = handle_list(5); 
	buttonAnalysisCalc = handle_list(6); 
	buttonSAnalysisCalc = handle_list(7); 
	buttonAnalysisView = handle_list(8);
	buttonSAnalysisView = handle_list(9);

	popupPostProcessAlg = handle_list(10); 
	buttonPostProcessParam = handle_list(11); 
	buttonPostProcessCalc = handle_list(12); 
	buttonSPostProcessCalc = handle_list(13); 
	buttonPostProcessView = handle_list(14); 
	buttonSPostProcessView = handle_list(15); 

	buttonSaveWorksheet = handle_list(16);
	buttonExit = handle_list(17);

	textLog = handle_list(18);

	frameExternals = handle_list(19);
	textExternalsTitle = handle_list(20);
	buttonCallExternals = handle_list(21);
	textRun = handle_list(22);
	buttonRunEdit = handle_list(23);
	buttonRunHelp = handle_list(24);
	textParadigm = handle_list(25);
	buttonParadigmEdit = handle_list(26);
	buttonParadigmHelp = handle_list(27);

	menuOptions = handle_list(28);
	menuTooltips = handle_list(29);
      end 
    end 

    if command == 0 
      

      % Initialize
      lyngby_ui_option;
      
      lyngby_baf_init;
      lyngby_baf2_init;
      lyngby_bat_init;
      lyngby_efir_init;
      lyngby_fir_init;
      lyngby_lzgs_init;
      lyngby_lzit_init;
      lyngby_km_init;
      lyngby_ikm_init;
      lyngby_ks_init;
      lyngby_nnr_init;
      lyngby_nns_init;
      lyngby_pois_init;
      lyngby_svd_init;
      lyngby_ica_init;
      lyngby_scva_init;
      lyngby_sop_init;
      lyngby_ts_init;
      
      lyngby_cons_init;
      lyngby_mkm_init;

      sc = get(0, 'ScreenSize');
      fig = figure('position',[ 10 max(1, sc(4)-632) 200 583 ],... 
	  'resize','on','tag','lyngby_ui_main',... 
	  'MenuBar', 'None',...
	  'visible','off',...
	  'name', 'Lyngby',...
	  'numbertitle', 'off',...
	  'color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 

      % Button
      bh = 0.038;

	% Left justified, full width button (load data, algorithms etc)
	bw1 = 0.85;
	bx1 = 0.075;

	% Left justified, approx. half-width button (Save worksheet)
	bw2 = 0.52;
	bx2 = bx1;

	% Right justified, medium button (Exit)
	bw3 = 0.3;
	bx3 = 0.625;

	% Left justified, medium button (Parameters)
	bw4 = 0.39;
	bx4 = bx1;

	% Near-right justified, medium button (Calculate)
	bw5 = 0.35;
	bx5 = 0.475;

	% Right justified, small button (! - script)
	bw6 = 0.1;
	bx6 = 0.825;

	% Left justified, large button (View results)
	bw7 = 0.75;
	bx7 = bx1;
	
	% Frame
	fx = 0.025;
	fw = 0.95;

	% Text labels

	% Object Rows
	y01 = 0.917; % Main Title
	y02 = 0.870; % textDatasetTitle
	y03 = 0.837; % textDataset
	y04 = 0.783; % textDataInputTitle
	y05 = 0.747; % buttonLoadNew
	y06 = 0.704; % buttonLoadWorksheet
	y07 = 0.651; % textExternalsTitle
	y08 = 0.640; % 
	y09 = 0.616; % buttonCallExternals
	y10 = 0.562; % textPreProcessTitle
	y11 = 0.527; % buttonDataSetup
	y12 = 0.475; % textAnalysisTitle
	y13 = 0.440; % popupAnalysisAlg
	y14 = 0.394; % buttonAnalysisParam
	y15 = 0.348; % buttonAnalysisView
	y16 = 0.291; % textPostProcessTitle
	y17 = 0.258; % popupPostProcessAlg
	y18 = 0.212; % buttonPostProcessParam
	y19 = 0.166; % buttonPostProcessView
	y20 = 0.092; % buttonSaveWorksheet
	y21 = 0.024; % textLog
	
	% Frame Rows
	fy1 = 0.914; % frameTitle
	fy2 = 0.829; % frameDataset
	fy3 = 0.694; % frameDataInput
	fy4 = 0.604; % frameExternals
	fy5 = 0.516; % frameDataSetup
	fy6 = 0.338; % frameAnalysis
	fy7 = 0.156; % framePostProc
	fy8 = 0.084; % frameExit
	fy9 = 0.010; % frameStatus
	

      % Positions need fine tuning...
      % Title Frame etc
	frameTitle = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ fx fy1 fw 0.075 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameTitle',... 
	  'UserData',''); 

	textMainTitle = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.1 y01 0.8 0.065 ],... 
	  'FontSize',12,...
	  'String','Lyngby Functional Imaging Toolbox',... 
	  'Style','text',... 
	  'Tag','textMainTitle',... 
	  'UserData',''); 
      
      % Dataset Location
	frameDataset = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ fx fy2 fw 0.077 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameDataset',... 
	  'UserData',''); 

	textDatasetTitle = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.1 y02 0.8 0.021 ],... 
	  'FontSize',10,...
	  'String','Dataset currently loaded:-',... 
	  'Style','text',... 
	  'Tag','textDatasetTitle',... 
	  'UserData',''); 

	textDataset = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_STATUS,...
	  'Position',[ 0.1 y03 0.8 0.029 ],... 
	  'String','No data currently loaded!',... 
	  'Style','text',... 
	  'Tag','textDataset',... 
	  'UserData',''); 

      % Data Input
 	frameDataInput = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ fx fy3 fw 0.125 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameDataInput',... 
	  'UserData',''); 

	textDataInputTitle = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.09 y04 0.8 0.026 ],... 
	  'String','Data Input',... 
	  'Style','text',... 
	  'Tag','textDataInputTitle',... 
	  'UserData',''); 

      buttonLoadNew = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonLoadNew'');',... 
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Position',[ bx1 y05 bw1 bh ],... 
	  'String','Load new data...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonLoadNew',... 
	  'UserData',''); 

      buttonLoadWorksheet = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonLoadWorksheet'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ bx1 y06 bw1 bh ],... 
	  'String','Load Worksheet!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonLoadWorksheet',... 
	  'UserData',''); 

      % Data Setup
	frameDataSetup = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ fx fy5 fw 0.08 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameDataSetup',... 
	  'UserData',''); 

	textPreProcessTitle = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.09 y10 0.8 0.026 ],... 
	  'String','Pre-processing and Design',... 
	  'Style','text',... 
	  'Tag','textPreProcessTitle',... 
	  'UserData',''); 

      buttonDataSetup = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonDataSetup'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx1 y11 bw1 bh ],... 
	  'String','Data Setup...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonDataSetup',... 
	  'UserData',''); 

      
      % Data Analysis
      frameAnalysis = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ fx fy6 fw 0.17 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameAnalysis',... 
	  'UserData',''); 

      textAnalysisTitle = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.09 y12 0.8 0.026 ],... 
	  'String','Data Analysis',... 
	  'Style','text',... 
	  'Tag','textAnalysisTitle',... 
	  'UserData',''); 

      popupAnalysisAlg = uicontrol(... 
	  'CallBack','lyngby_ui_main(''popupAnalysisAlg'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ bx1 y13 bw1 bh ],... 
	  'String',[...
	    '       Original|',...
	    '(-)    Cross-correlation|',...
	    '(-)    FIR filter|',...
	    '(-)    Exhaustive FIR filter|',...
	    '(-)    K-means|',...
	    '(-)    Iterative K-means|',...
	    '(-)    Grid Search Lange-Zeger|',...
	    '(-)    Iterative Lange-Zeger|',...
	    '(-)    Ardekani t-test|',...
	    '(-)    Ardekani F-test|',...
	    '(-)    Ardekani F-test (nuisance subspace)|',...
	    '(-)    Ordinary t-test|',... 
	    '(-)    Kolmogorov Smirnov test|',... 
	    '(-)    Neural network regression|', ...
	    '(-)    Neural network saliency|', ...
	    '(-)    Poisson filter|',...
	    '(-)    Singular Value Decomposition|', ...
	    '(-)    Independent component analysis|', ...
	    '(-)    Strother CVA|', ...
	    '(-)    Strother Orthonormalized PLS', ...
	    ],...        
	  'HorizontalAlignment','left',...
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupAnalysisAlg',... 
	  'UserData',''); 
      
      buttonAnalysisParam = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonAnalysisParam'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx4 y14 bw4 bh ],... 
	  'String','Parameters...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonAnalysisParam',... 
	  'UserData',''); 

      buttonAnalysisCalc = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonAnalysisCalc'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx5 y14 bw5 bh],... 
	  'String','Calculate!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonAnalysisCalc',... 
	  'UserData',''); 

      buttonSAnalysisCalc = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonSAnalysisCalc'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx6 y14 bw6 bh ],... 
	  'String','!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSAnalysisCalc',... 
	  'UserData',''); 

      buttonAnalysisView = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonAnalysisView'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx7 y15 bw7 bh ],... 
	  'String','View these results!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonAnalysisView',... 
	  'UserData',''); 

      buttonSAnalysisView = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonSAnalysisView'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx6 y15 bw6 bh ],... 
	  'String','!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSAnalysisView',... 
	  'UserData',''); 
      
      % PostProcess
      framePostProc = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ fx fy7 fw 0.17 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','framePostProc',... 
	  'UserData',''); 

      textPostProcessTitle = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.09 y16 0.8 0.03 ],... 
	  'String','Post-Processing',... 
	  'Style','text',... 
	  'Tag','textPostProcessTitle',... 
	  'UserData',''); 

      popupPostProcessAlg = uicontrol(... 
	  'CallBack','lyngby_ui_main(''popupPostProcessAlg'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ bx1 y17 bw1 bh ],... 
	  'String','Consensus|Meta K-Means',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupPostProcessAlg',... 
	  'UserData',''); 

      buttonPostProcessParam = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonPostProcessParam'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx4 y18 bw4 bh ],... 
	  'String','Parameters...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonPostProcessParam',... 
	  'UserData',''); 

      buttonPostProcessCalc = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonPostProcessCalc'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx5 y18 bw5 bh ],... 
	  'String','Calculate!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonPostProcessCalc',... 
	  'UserData',''); 

      buttonSPostProcessCalc = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonSPostProcessCalc'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx6 y18 bw6 bh ],... 
	  'String','!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSPostProcessCalc',... 
	  'UserData',''); 

      buttonPostProcessView = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonPostProcessView'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx7 y19 bw7 bh ],... 
	  'String','View these results!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonPostProcessView',... 
	  'UserData',''); 

      buttonSPostProcessView = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonSPostProcessView'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx6 y19 bw6 bh ],... 
	  'String','!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSPostProcessView',... 
	  'UserData',''); 
      
      % Save
      frameExit = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ fx fy8 fw 0.06 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameExit',... 
	  'UserData',''); 

      buttonSaveWorksheet = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonSaveWorksheet'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ bx2 y20 bw2 bh ],... 
	  'String','Save Worksheet!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSaveWorksheet',... 
	  'UserData',''); 

      buttonExit = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonExit'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ bx3 y20 bw3 bh ],... 
	  'String','Exit!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonExit',... 
	  'UserData',''); 

      % Status Line
      frameStatus = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ fx fy9 fw 0.06 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameStatus',... 
	  'UserData',''); 

      textLog = uicontrol(... 
	  'CallBack','lyngby_ui_main(''textLog'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_STATUS,...
	  'String','  Infomation about Lyngby...',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ bx1 y21 bw1 0.034 ],... 
	  'Tag','textLog',... 
	  'UserData','',...
	  'HorizontalAlignment','left'...
	  ); 


      % Added Run and Paradigm buttons back into main window
      frameExternals = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ fx fy4 fw 0.08 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameExternals',... 
	  'Visible','on',...
	  'UserData',''); 

      textExternalsTitle = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.09 y07 0.8 0.026 ],... 
	  'String','External Influences',... 
	  'Style','text',... 
	  'Tag','textExternalsTitle',... 
	  'Visible','on',...
	  'UserData',''); 

      buttonCallExternals = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonCallExternals'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ bx1 y09 bw1 bh ],... 
	  'String','Create/Edit External Influences...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonCallExternals',... 
	  'Visible', 'on',...
	  'UserData','');       
            
      textRun = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_main(''textRun'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.05 y09 0.3 bh ],... 
	  'String','Run',... 
	  'Style','text',... 
	  'Tag','textRun',... 
	  'Visible', 'off',...
	  'UserData',''); 
      buttonRunEdit = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonRunEdit'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ bx1 y09 bw1 bh ],... 
	  'String','Create/Edit Run...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonRunEdit',... 
	  'Visible', 'off',...
	  'UserData','');       
      buttonRunHelp = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonRunHelp'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[  bx3 y09 bw3 bh ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonRunHelp',... 
	  'Visible', 'off',...
	  'UserData',''); 
      
      textParadigm = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_main(''textParadigm'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.05 y08 0.3 bh ],... 
	  'String','Paradigm',... 
	  'Style','text',... 
	  'Tag','textParadigm',... 
	  'Visible', 'off',...
	  'UserData',''); 
      buttonParadigmEdit = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonParadigmEdit'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ bx1 y08 bw1 bh ],... 
	  'String','Create/Edit Paradigm...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonParadigmEdit',... 
	  'Visible', 'off',...
	  'UserData','');       
      buttonParadigmHelp = uicontrol(... 
	  'CallBack','lyngby_ui_main(''buttonParadigmHelp'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ bx3 y08 bw3 bh ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonParadigmHelp',... 
	  'Visible', 'off',...
	  'UserData',''); 
            
      
      % Setup Menu controls
      ver = (version);
      ver = str2num(ver(1:3));
      if ver >= 5.2 
	menuOptions = uimenu( ...
	    'Parent',fig,...
	    'Label','Options',...
	    'Tag','TagMenuOptions',...
	    'Visible','on');
	menuTooltips = uimenu(...
	    'Parent',menuOptions,...
	    'Label','&Toggle Tooltips',...
	    'Checked','on',...
	    'Callback','lyngby_ui_main(''ToggleTooltips'');',...
	    'Tag','TagMenuTooltips',...
	    'Accelerator','T',...
	    'Visible','on');
      else
	menuOptions = 0;
	menuTooltips = 0;
      end
      
      % Test global Tooltips settings and set this window to the same
      if UI_TOOLTIPS == 0  
	eval(ToggleTooltips);
      end

      eval(UpdateButtonEnabling);
      
      UIHANDLE_LOG = textLog;

      %  Axes and Text Object Creation 
      
      % Handle list
      handle_list = [ ...  
	  buttonLoadNew ... 
	  buttonLoadWorksheet ...
	  buttonDataSetup ...
	  popupAnalysisAlg ... 
	  buttonAnalysisParam ...
	  buttonAnalysisCalc ...
	  buttonSAnalysisCalc ...
	  buttonAnalysisView ... 
	  buttonSAnalysisView ...
	  popupPostProcessAlg ...
	  buttonPostProcessParam ...
	  buttonPostProcessCalc ...
	  buttonSPostProcessCalc ...
	  buttonPostProcessView ...
	  buttonSPostProcessView ...
	  buttonSaveWorksheet ...
	  buttonExit ...
	  textLog ...
	  frameExternals textExternalsTitle ...
	  buttonCallExternals ...
	  textRun buttonRunEdit buttonRunHelp ...
	  textParadigm buttonParadigmEdit buttonParadigmHelp ...
	  menuOptions ...
	  menuTooltips ...
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 
      set(fig,'visible','on'); % Explicitly set fig to visible for
			       %  MS Windows Matlab version...

    elseif command == 1 
      %disp('buttonLoadNew selected.') 

      lyngby_log('Calling loading setup ...');
      lyngby_ui_loadfile;
      lyngby_log('Loading setup called!');

      eval(UpdateButtonEnabling);
      
    elseif command == 2

      lyngby_log('Restoring workspace...');
%     load lyngby_workspace;

      % New routine
      [file,path] = uigetfile('*.mat', 'Choose a .mat file'); 
	if file ~= 0, 
	  filename = [ path file ];
	  eval(['load ' filename]);
	
	  FILENAME_WORKSPACE = file;
	  UIHANDLE_LOG = findobj(gcf,'tag', 'textLog');
	  % lyngby_log('Workspace restored from ''lyngby_workspace.mat''!')
	  lyngby_log(sprintf('Workspace restored from  %s !', file));
 
	  % Update dataset title
	  mainfigurehandle = findobj(get(0,'children'),'flat','tag','lyngby_ui_main');
	  set(findobj(mainfigurehandle,'Tag','textDataset'), 'String', file);
	else
	  lyngby_log(sprintf('Workspace not restored!'));
	  % Update dataset title
	  mainfigurehandle = findobj(get(0,'children'),'flat','tag','lyngby_ui_main');
	  set(findobj(mainfigurehandle,'Tag','textDataset'), 'String', 'New workspace not loaded!');
	end
	  
	% Cannot call eval(UpdateButtonEnabling) because the 'load
	% lyngby_workspace as overwritten some of the variables.
	lyngby_ui_main('UpdateButtonEnabling');
 
    elseif command == 18      
      % buttonCallExternals
      lyngby_log('Calling Externals Setup...');
      lyngby_ui_externals;
      lyngby_log('Externals Setup called!');
            
    elseif command == 19 
      % buttonRunEdit
      lyngby_log('Calling run ...');
      lyngby_ui_run;
      lyngby_log('Run called!');

    elseif command == 20 
      % buttonRunHelp
      S1 = [...
	    'Press ''Edit'' to define the RUN global variable. This is ',...
	    'used to specify, in time, the seperate experiment trials.',...
	    ];
      helpdlg(sprintf('%s', S1), 'Run Help');

    elseif command == 21 
      % buttonParadigmEdit
      lyngby_log('Calling paradigm ...');
      lyngby_ui_paradigm;
      lyngby_log('Paradigm called!');


    elseif command == 22 
      % buttonParadigmHelp
      S1 = [...
	    'Press ''Edit'' to define the PARADIGM global variable. This is ',...
	    'used to define the time-based correlation with the experimental stimulus ',...
	    ];
      helpdlg(sprintf('%s', S1), 'Paradigm Help');
      
      
      
    elseif command == 401 
      %disp('buttonDataSetup selected.') 

      lyngby_log('Calling Data Setup ...');
      lyngby_ui_preproc;
      lyngby_log('Data Setup called!');

      eval(UpdateButtonEnabling);
      
    elseif command == 500

      AnalysisMethod = get(popupAnalysisAlg,'Value');

      if AnalysisMethod == amNone
	set(buttonAnalysisParam, 'Enable', 'off');
	set(buttonAnalysisCalc, 'Enable', 'off');
	set(buttonSAnalysisCalc, 'Enable', 'off');
	lyngby_log('No analysis method chosen');
      else
	set(buttonAnalysisParam, 'Enable', 'on');
	set(buttonAnalysisCalc, 'Enable', 'on');
	set(buttonSAnalysisCalc, 'Enable', 'on');
	if AnalysisMethod == amFir
	  lyngby_log('FIR filter chosen'); 
	elseif AnalysisMethod == amEFir
	  lyngby_log('Exhaustive FIR filter chosen'); 
	elseif AnalysisMethod == amCc
	  lyngby_log('Cross-correlation chosen'); 
	elseif AnalysisMethod == amKm
	  lyngby_log('K-means chosen'); 
	elseif AnalysisMethod == amIKm
	  lyngby_log('Iterative K-means chosen'); 
	elseif AnalysisMethod == amLZGS
	  lyngby_log('Grid Search Lange-Zeger chosen'); 
	elseif AnalysisMethod == amLzIT
	  lyngby_log('Iterative Lange-Zeger chosen'); 
	elseif AnalysisMethod == amBAT
	  lyngby_log('Ardekani t-test chosen'); 
	elseif AnalysisMethod == amBAF
	  lyngby_log('Ardekani F-test chosen'); 
	elseif AnalysisMethod == amBAF2
	  lyngby_log('Ardekani F-test (nuisance estimation) chosen'); 
	elseif AnalysisMethod == amTs
	  lyngby_log('Ordinary t-test chosen'); 
	elseif AnalysisMethod == amKS
	  lyngby_log('Kolmogorov Smirnov test chosen'); 
	elseif AnalysisMethod == amPois
	  lyngby_log('Poisson filter chosen'); 
	elseif AnalysisMethod == amNNR
	  lyngby_log('Neural network regression chosen'); 
	elseif AnalysisMethod == amNNS
	  lyngby_log('Neural network saliency chosen'); 
	elseif AnalysisMethod == amSVD
	  lyngby_log('SVD chosen'); 
	elseif AnalysisMethod == amICA
	  lyngby_log('ICA chosen'); 
	elseif AnalysisMethod == amSCVA
	  lyngby_log('Strother CVA chosen'); 
	elseif AnalysisMethod == amSOP
	  lyngby_log('Strother OPLS chosen'); 
	else
	  error(sprintf('Internal error: AnalysisMethod = %d', AnalysisMethod));
	end
      end
    elseif command == 501
      lyngby_log('Analysis Parameters') 

      AnalysisMethod = get(popupAnalysisAlg,'Value');

      if AnalysisMethod == amNone
	%lyngby_ui_message(['''None'' is just for viewing the orginal ', ...
	%      'preprocessed data. No Initialization here.']);
      elseif AnalysisMethod == amFir
	lyngby_ui_fir_init;
      elseif AnalysisMethod == amEFir
	lyngby_ui_efir_init;
      elseif AnalysisMethod == amCc
	lyngby_ui_cc_init;
      elseif AnalysisMethod == amKm
	lyngby_ui_km_init;
      elseif AnalysisMethod == amIKm
	lyngby_ui_ikm_init;
      elseif AnalysisMethod == amLZGS
	lyngby_ui_lzgs_init;
      elseif AnalysisMethod == amLzIT
	lyngby_ui_lzit_init;
      elseif AnalysisMethod == amBAT
	lyngby_ui_bat_init;
      elseif AnalysisMethod == amBAF
	lyngby_ui_baf_init;
      elseif AnalysisMethod == amBAF2
	lyngby_ui_baf2_init;
      elseif AnalysisMethod == amTs
	lyngby_ui_ts_init;
      elseif AnalysisMethod == amKS
	lyngby_ui_ks_init;
      elseif AnalysisMethod == amPois
	lyngby_ui_pois_init;
      elseif AnalysisMethod == amNNR
	lyngby_ui_nnr_init;
      elseif AnalysisMethod == amNNS
	lyngby_ui_nns_init;
      elseif AnalysisMethod == amSVD
	lyngby_ui_svd_init;
      elseif AnalysisMethod == amICA
	lyngby_ui_ica_init;
      elseif AnalysisMethod == amSCVA
	lyngby_ui_scva_init;
      elseif AnalysisMethod == amSOP
	lyngby_ui_sop_init
      else
	error(sprintf([ 'Internal error: Analysis init, ' ...
	      'AnalysisMethod = %d'], AnalysisMethod));
      end
      st = get(popupAnalysisAlg,'String');
      if st(get(popupAnalysisAlg,'value'),2)~='-'
	st(get(popupAnalysisAlg,'value'),2)='!';    
	set(popupAnalysisAlg,'String',st);
      end

    elseif command == 502
      
      AnalysisMethod = get(popupAnalysisAlg,'Value');
      
      
      if ~exist('XN')  | isempty(XN) 
	lyngby_ui_message('You have to preprocess the data first.');
	
      elseif ~exist('PN')  | isempty(PN) 
	lyngby_ui_message([...
	      'The design variables are not processed. ' ...
	      'Go to ''Data setup'' and process the design. ' ...
	      ]);
	
      elseif size(PN,1) ~= size(XN,1)
	lyngby_ui_message(sprintf('%s XN:%dx%d, PN: %dx%d', [...
	      'The design variables and the datamatrix are not of ' ...
	      'the same size. ' ...
	      ], size(XN), size(PN)));
	
      elseif any(AnalysisMethod == [amBAF amBAF2 amEFir amSCVA amSOP]) & ...
	    (~exist('R') | isempty(R))
	lyngby_ui_message([...
	      'The run structure ''R'' is empty. ' ...
	      'Some of the analysis methods require this structure. ',...
	      'Please define the run (Press the ''Run...'' button in ''Data Setup'').' ...
	      ]);
	
      else

	% The actual analysis
	lyngby_log('Analysis beginning ...');


	if AnalysisMethod == amNone
	  s = 'No action here';
	  lyngby_ui_message(s);
	elseif AnalysisMethod == amFir	
	  lyngby_uis_fir;
	elseif AnalysisMethod == amEFir
	  lyngby_uis_efir;
	elseif AnalysisMethod == amCc
	  lyngby_uis_cc;
	elseif AnalysisMethod == amKm
	  lyngby_uis_km;
	elseif AnalysisMethod == amIKm
	  lyngby_uis_ikm;
	elseif AnalysisMethod == amLZGS
	  lyngby_uis_lzgs;
	elseif AnalysisMethod == amLzIT
	  lyngby_uis_lzit;
	elseif AnalysisMethod == amBAT
	  lyngby_uis_bat;
	elseif AnalysisMethod == amBAF
	  lyngby_uis_baf;
	elseif AnalysisMethod == amBAF2
	  lyngby_uis_baf2;
	elseif AnalysisMethod == amTs
	  lyngby_uis_ts;
	elseif AnalysisMethod == amKS
	  lyngby_uis_ks;
	elseif AnalysisMethod == amNNR
	  lyngby_uis_nnr;
	elseif AnalysisMethod == amNNS
	  lyngby_uis_nns;
	elseif AnalysisMethod == amPois
	  lyngby_uis_pois;
	elseif AnalysisMethod == amSVD
	  lyngby_uis_svd;
	elseif AnalysisMethod == amICA
	  lyngby_uis_ica;
	elseif AnalysisMethod == amSCVA
	  lyngby_uis_scva;
	elseif AnalysisMethod == amSOP
	  lyngby_uis_sop;
	else
	  error(sprintf(['Internal error: Analysis, ' ...
		'AnalysisMethod = %d'], AnalysisMethod));
	end
	
	st = get(popupAnalysisAlg,'String');
	st(get(popupAnalysisAlg,'value'),2)='+';
	set(popupAnalysisAlg,'String',st);

	lyngby_log('Analysis completed!');
	
	
      end


    elseif command == 504
      
      AnalysisMethod = get(popupAnalysisAlg,'Value');

      if AnalysisMethod == amNone 
	
      elseif AnalysisMethod == amCc
	type lyngby_uis_cc
      elseif AnalysisMethod == amFir
	type lyngby_uis_fir
      elseif AnalysisMethod == amEFir 
	type lyngby_uis_efir
      elseif AnalysisMethod == amKm	
	type lyngby_uis_km
      elseif AnalysisMethod == amIKm	
	type lyngby_uis_ikm
      elseif AnalysisMethod == amLZGS	
	type lyngby_uis_lzgs
      elseif AnalysisMethod == amLzIT	
	type lyngby_uis_lzit
      elseif AnalysisMethod == amBAT	
	type lyngby_uis_bat
      elseif AnalysisMethod == amBAF	
	type lyngby_uis_baf
      elseif AnalysisMethod == amBAF2  
	type lyngby_uis_baf2
      elseif AnalysisMethod == amTs	
	type lyngby_uis_ts
      elseif AnalysisMethod == amKS	
	type lyngby_uis_ks
      elseif AnalysisMethod == amNNR   
	type lyngby_uis_nnr
      elseif AnalysisMethod == amNNS   
	type lyngby_uis_nns
      elseif AnalysisMethod == amPois  
	type lyngby_uis_pois
      elseif AnalysisMethod == amSVD 
	type lyngby_uis_svd
      elseif AnalysisMethod == amICA 
	type lyngby_uis_ica
      elseif AnalysisMethod == amSCVA
	type lyngby_uis_scva
      elseif AnalysisMethod == amSOP 
	type lyngby_uis_sop
      else
	error(sprintf(['Internal error: Analysis !, ' , ...
	      'AnalysisMethod = %d'], AnalysisMethod));
      end
      
      
    elseif command == 503

      lyngby_log('Displaying analysis results');

      AnalysisMethod = get(popupAnalysisAlg,'Value');

      if AnalysisMethod == amNone
	lyngby_uis_none_v;
      elseif AnalysisMethod == amCc
	lyngby_uis_cc_v;
      elseif AnalysisMethod == amFir	
	lyngby_uis_fir_v;
      elseif AnalysisMethod == amEFir	
	lyngby_uis_efir_v;
      elseif AnalysisMethod == amKm
	lyngby_uis_km_v;
      elseif AnalysisMethod == amIKm
	lyngby_uis_ikm_v;
      elseif AnalysisMethod == amLZGS,
	lyngby_uis_lzgs_v;
      elseif AnalysisMethod == amLzIT
	lyngby_uis_lzit_v;
      elseif AnalysisMethod == amBAT
	lyngby_uis_bat_v;
      elseif AnalysisMethod == amBAF
	lyngby_uis_baf_v;
      elseif AnalysisMethod == amBAF2
	lyngby_uis_baf2_v;
      elseif AnalysisMethod == amKS
	lyngby_uis_ks_v;
      elseif AnalysisMethod == amNNR
	lyngby_uis_nnr_v;
      elseif AnalysisMethod == amNNS
	lyngby_uis_nns_v;
      elseif AnalysisMethod == amPois
	lyngby_uis_pois_v;
      elseif AnalysisMethod == amSVD
	lyngby_uis_svd_v;
      elseif AnalysisMethod == amICA
	lyngby_uis_ica_v;
      elseif AnalysisMethod == amSCVA
	lyngby_uis_scva_v;
      elseif AnalysisMethod == amSOP
	lyngby_uis_sop_v;
      elseif AnalysisMethod == amTs
	lyngby_uis_ts_v
      else
	error('Internal error');
      end


    elseif command == 505
      
      AnalysisMethod = get(popupAnalysisAlg,'Value');
      
      if AnalysisMethod == amNone 
	type lyngby_uis_none_v;
      elseif AnalysisMethod == amCc
	type lyngby_uis_cc_v;
      elseif AnalysisMethod == amFir
	type lyngby_uis_fir_v
      elseif AnalysisMethod == amEFir 
	type lyngby_uis_efir_v;
      elseif AnalysisMethod == amKm	
	type lyngby_uis_km_v;
      elseif AnalysisMethod == amIKm	
	type lyngby_uis_ikm_v;
      elseif AnalysisMethod == amLZGS	
	type lyngby_uis_lzgs_v;
      elseif AnalysisMethod == amLzIT	
	type lyngby_uis_lzit_v;
      elseif AnalysisMethod == amBAT	
	type lyngby_uis_bat_v;
      elseif AnalysisMethod == amBAF	
	type lyngby_uis_baf_v;
      elseif AnalysisMethod == amBAF2  
	type lyngby_uis_baf2_v;
      elseif AnalysisMethod == amTs	
	type lyngby_uis_ts_v;
      elseif AnalysisMethod == amKS	
	type lyngby_uis_ks_v;
      elseif AnalysisMethod == amNNR   
	type lyngby_uis_nnr_v;
      elseif AnalysisMethod == amNNS   
	type lyngby_uis_nns_v;
      elseif AnalysisMethod == amPois  
	type lyngby_uis_pois_v;
      elseif AnalysisMethod == amSVD 
	type lyngby_uis_svd_v
      elseif AnalysisMethod == amICA 
	type lyngby_uis_ica_v
      elseif AnalysisMethod == amSCVA
	type lyngby_uis_scva_v;
      elseif AnalysisMethod == amSOP 
	type lyngby_uis_sop_v
      else
	error('Internal error');
      end
      
      
    elseif command == 600 
      % disp('popupPostProcess selected.') 

      PostProcessMethod = get(popupPostProcessAlg, 'Value');
      if PostProcessMethod == amCONS
	lyngby_log('Consensus chosen'); 
      elseif PostProcessMethod == amMKM
	lyngby_log('Meta K-means chosen'); 
      else
	error('Internal error');
      end

    elseif command == 601
      % disp('buttonPostProcessParam selected.') 
      
      lyngby_log('PostProcess Parameters') 

      PostProcessMethod = get(popupPostProcessAlg,'Value');
      if PostProcessMethod == amCONS
	lyngby_ui_cons_init;
      elseif PostProcessMethod == amMKM
	lyngby_ui_mkm_init;
      else
	error('Internal error');
      end
      
    elseif command == 602 
      % disp('buttonPostProcessCalc selected.') 

      lyngby_log('PostProcessing beginning');

      PostProcessMethod = get(popupPostProcessAlg,'Value');
      
      if PostProcessMethod == amCONS
	lyngby_uis_cons
      elseif PostProcessMethod == amMKM
	lyngby_uis_mkm;
      else
	error('Internal error');
      end

      lyngby_log('PostProcessing completed!');
      
    elseif command == 603 
      % disp('buttonPostProcessView selected.') 

      lyngby_log('Displaying PostProcess results');

      PostProcessMethod = get(popupPostProcessAlg,'Value');

      if PostProcessMethod == amCONS
	lyngby_uis_cons_v;
      elseif PostProcessMethod == amMKM
	lyngby_uis_mkm_v;
      end

    elseif command == 604 
      
      PostProcessMethod = get(popupPostProcessAlg,'Value');

      if PostProcessMethod == amCONS
	type lyngby_uis_cons
      elseif PostProcessMethod == amMKM
	type lyngby_uis_mkm
      else
	error('Internal error');
      end
      
    elseif command == 605
      
      PostProcessMethod = get(popupPostProcessAlg,'Value');

      if PostProcessMethod == amCONS
	type lyngby_uis_cons_v
      elseif PostProcessMethod == amMKM
	type lyngby_uis_mkm_v
      else
	error('Internal error');
      end
      
    elseif command == 800
      % Toggle the state of the Tooltips help (on/off)
      eval(ToggleTooltips);
    
    elseif command == 910

      [sfile,spath] = uiputfile('lyngby_workspace.mat', 'Save your Lyngby workspace as: '); 
	if sfile ~= 0, 
	  sfilename = [ spath sfile ];
	  eval(['save ' sfilename]);
	
	  % FILENAME_WORKSPACE = sfile;
	  UIHANDLE_LOG = findobj(gcf,'tag', 'textLog');
	  % lyngby_log('Workspace restored from ''lyngby_workspace.mat''!')
	  lyngby_log(sprintf('Workspace saved as  %s !', sfile));
	else
	  lyngby_log(sprintf('Workspace not saved!'));
	end

      % lyngby_log('Saving workspace in ''lyngby_workspace.mat'' ...');
      % save lyngby_workspace;
      % lyngby_log('Workspace saved in ''lyngby_workspace.mat''!');


    elseif command == 930
      % The log panel
      
      lyngby_ui_credit;
      
    elseif command == 1000
      % Close
      
      UIHANDLE_LOG = [];
      
      close(gcf);

    elseif command == 9000
      
      eval(UpdateButtonEnabling);
      
    else 
      error(sprintf(['Error: lyngby_ui_main.m called ' ...
	    'with incorrect command: %d'], command))
    end 














