function lyngby_ui_mkm_init(command,parameter1) 

% lyngby_ui_mkm_init   - GUI for Meta K-means initialization
%
%       function lyngby_ui_mkm_init(command,parameter1) 
%       function lyngby_ui_mkm_init
%
%       This function controls the window for the initialization/setup
%       of the parameters to the Meta K-means method.
%
%       It is called through lyngby_ui_main when the user press a
%       button in the main window.
%
%       See also: lyngby_km_main, lyngby_mkm_global
%
%	Made with GUI Maker Ver 2.1 by Patrick Marchand 

%  Created: 26-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs :  $Id: lyngby_ui_mkm_init.m,v 1.12 1999/06/11 12:13:37 mgl Exp $
%        $Revision: 1.12 $

    lyngby_mkm_global
    lyngby_global
    lyngby_ui_option


    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 3; 
      elseif strcmp(lower(command),lower('popupStandard')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editIterations')) 
	command = 5; 
      elseif strcmp(lower(command),lower('editClusters')) 
	command = 6; 
      elseif strcmp(lower(command),lower('editDecayRate')) 
	command = 7; 
      elseif strcmp(lower(command),lower('popupVariable')) 
	command = 8; 
      elseif strcmp(lower(command),lower('popupType')) 
	command = 9; 
      elseif strcmp(lower(command),lower('editPositionWeight')) 
	command = 10; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_mkm_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_mkm_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonClose = handle_list(4); 
	buttonApply = handle_list(5); 
	buttonHelp = handle_list(6); 
	popupStandard = handle_list(7); 
	editIterations = handle_list(8); 
	editClusters = handle_list(9); 
	editDecayRate = handle_list(10); 
	textStandard = handle_list(11); 
	textVariable = handle_list(12); 
	textIterations = handle_list(13); 
	textDecayRate = handle_list(14); 
	textClusters = handle_list(15); 
	textType = handle_list(16); 
	popupVariable = handle_list(17); 
	popupType = handle_list(18); 
	editPositionWeight = handle_list(19);
	textPositionWeight = handle_list(20); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 300 350 300 ],... 
	  'resize','On','tag','lyngby_ui_mkm_init',... 
	  'menubar','Figure','name','lyngby - Meta K-means initialization',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 

      x1 = 0.15;
      x2 = 0.5;
      
      h1 = 0.08;
      h2 = h1;
      w1 = 0.2;
      w2 = 0.33;
      w3 = 0.2;

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.08;
      WButtonHeight = 0.08;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.02; % Window controls
      Row2 = 0.14; % Components
      Row3 = 0.16; % Variable
      Row4 = 0.27; % Iterations
      Row5 = 0.38; % Decay Rate
      Row6 = 0.49; % Initial cluster centres
      Row7 = 0.60; % Clusters
      Row8 = 0.71; % Type
      Row9 = 0.84; % Title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.125 FrameWidth 0.86 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.01 FrameWidth 0.105 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the K-Means algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row9 0.9 0.10 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''buttonApply'');',... 
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth WButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth WButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''buttonHelp'');',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth WButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textType = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''textType'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 Row8 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Type:',... 
	  'Style','text',... 
	  'Tag','textType',... 
	  'UserData',''); 
      popupType = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''popupType'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x2 Row8 0.35 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Mean|Median',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupType',... 
	  'UserData',''); 

      textStandard = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''textStandard'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row7 0.43 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Standardization:',... 
	  'Style','text',... 
	  'Tag','textStandard',... 
	  'UserData',''); 
      popupStandard = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''popupStandard'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 Row7 0.3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','popupmenu',... 
	  'String', 'None|Std|Range',...
	  'Value', 1,...
	  'Tag','popupStandard',... 
	  'UserData',''); 

      textClusters = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''textClusters'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.08 Row6 0.4 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Number of Clusters:',... 
	  'Style','text',... 
	  'Tag','textClusters',... 
	  'UserData',''); 
      editClusters = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''editClusters'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 Row6 w3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','edit',... 
	  'Tag','editClusters',... 
	  'UserData',''); 
      
      textDecayRate = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''textDecayRate'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 Row5 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Decay Rate:',... 
	  'Style','text',... 
	  'Tag','textDecayRate',... 
	  'UserData',''); 
      editDecayRate = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''editDecayRate'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 Row5 w3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','edit',... 
	  'Tag','editDecayRate',... 
	  'UserData',''); 

      textIterations = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''textIterations'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row4 0.43 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Number of Iterations:',... 
	  'Style','text',... 
	  'Tag','textIterations',... 
	  'UserData',''); 
      editIterations = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''editIterations'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 Row4 w3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','edit',... 
	  'Tag','editIterations',... 
	  'UserData',''); 

      textVariable = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''textVariable'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 Row3 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Variable:',... 
	  'Style','text',... 
	  'Tag','textVariable',... 
	  'UserData',''); 
      popupVariable = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''popupVariable'');',... 
	  'Max',[ 1 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x2 Row3 0.44 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','FIR Coefficients|LZ Parameters|FIR Coef/LZ Param',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupVariable',... 
	  'UserData',''); 

      textPositionWeight = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''textPositionWeight'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 Row2 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Position weight:',... 
	  'Style','text',... 
          'visible','off',...
	  'Tag','textPositionWeight',... 
	  'UserData',''); 
      editPositionWeight = uicontrol(... 
	  'CallBack','lyngby_ui_mkm_init(''editPositionWeight'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 Row2 w3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','edit',... 
          'visible','off',...
	  'Tag','editPositionWeight',... 
	  'UserData',''); 


      if strcmp(MKM_TYPE, 'mean')
	Type = 1;
      else	
	Type = 2;
      end

      if strcmp(lower(MKM_VARIABLE), 'fir coefficients')
	Variable = 1;
      elseif strcmp(lower(MKM_VARIABLE), 'lz parameters')
	Variable = 2;
      elseif strcmp(lower(MKM_VARIABLE), 'fir coef/lz param')
	Variable = 3;
      else
	error(sprintf('Wrong value for MKM_VARIABLE: %s', ...
	    MKM_VARIABLE));
      end

      if strcmp(lower(MKM_STANDARDIZATION), 'none')
	standard = 1;
      elseif strcmp(lower(MKM_STANDARDIZATION), 'std')
	standard = 2;
      elseif strcmp(lower(MKM_STANDARDIZATION), 'range')
	standard = 3;
      else
	error(sprintf('Wrong value for MKM_STANDARDIZATION: %s', ...
	    MKM_STANDARDIZATION));
      end

      
      
      set(popupType, 'Value', Type);
      set(editClusters, 'String', num2str(MKM_CLUSTERS));
      set(editDecayRate, 'String', num2str(MKM_DECAYRATE));
      set(editIterations, 'String', num2str(MKM_ITERATIONS));
      set(popupVariable, 'Value', Variable);
      set(popupStandard, 'Value', standard);
      set(editPositionWeight, 'String', num2str(MKM_POSITIONWEIGHT));

      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonClose buttonApply buttonHelp ... 
	  popupStandard editIterations editClusters editDecayRate ... 
	  textStandard textVariable textIterations textDecayRate ... 
	  textClusters textType popupVariable popupType editPositionWeight... 
	  textPositionWeight...
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      % disp('buttonClose selected.') 

      close(gcf);

    elseif command == 2 
      % disp('buttonApply selected.') 

      % !!! Needs upper bound for Clusters and Components 
      [Clusters, countClusters] = sscanf(get(editClusters, 'String'), '%d');
      [DecayRate, countDecayRate] = sscanf(get(editDecayRate, 'String'), '%f');
      [PositionWeight, countPositionWeight] = sscanf(get(editPositionWeight, 'String'), '%f');
      [Iterations, countIterations] = sscanf(get(editIterations, 'String'), '%d');
      if countClusters ~= 1
	error('Clusters must be a single integer');
      elseif countDecayRate ~= 1
	error('Decay rate must be a single float');
      elseif countPositionWeight ~= 1
	error('PositionWeight must be a single float');
      elseif countIterations ~= 1
	error('Iterations must be a single integer');
      elseif Clusters < 1
	error('Clusters cannot be <1');
      elseif DecayRate >= 1 | DecayRate < 0 
	error('Decay rate must be in ]0;1]');
      elseif PositionWeight <0 
	error('Position weight must be non-negative');
      elseif Iterations < 1
	error('Iterations cannot be <1');
      else
	Type = get(popupType, 'Value');
	Variable = get(popupVariable, 'Value');
	standard = get(popupStandard, 'Value');
	if Type == 1
	  MKM_TYPE = 'mean';
	else
	  MKM_TYPE = 'median';
	end
	if Variable == 1
	  MKM_VARIABLE = 'FIR Coefficients';
	elseif Variable == 2
	  MKM_VARIABLE = 'LZ Parameters';
	elseif Variable == 3
	  MKM_VARIABLE = 'FIR Coef/LZ Param';
	end
	if standard == 1
	  MKM_STANDARDIZATION = 'None';
	elseif standard == 2
	  MKM_STANDARDIZATION = 'Std';
	elseif standard == 3
	  MKM_STANDARDIZATION = 'Range';
	end
	MKM_CLUSTERS = Clusters;
	MKM_DECAYRATE = DecayRate;
	MKM_POSITIONWEIGHT = PositionWeight;
	MKM_ITERATIONS = Iterations;
      end
      
      lyngby_log('New parameters updated')

    elseif command == 3 
      % disp('buttonHelp selected.') 

      s1 = [...
            'This window allows you to choose the settings used for Meta ' ...
            'K-Means analysis of the results from the Data Analysis section: '...
            ];
      s2 = [...
            '* ''Type'': ' ...
            'Whether the median or the mean of the cluster members is '...
            'used to determine the cluster center at the next iteration. '...
            ];
      s3 = [...
            '* ''Clusters'' (>1): Number of clusters ' ...
            ];
      s4 = [...
            '* ''Decay rate'' (between 0 and 1): The weight between the '...
	    'cluster center in the ' ...    
            'previous iteration and the new estimate of the cluster center ' ...
            '(this will regularize the performance). A value of zero will use ' ...
            'only the new estimate. ' ...
            ];
      s5 = [...
            '* ''Iterations'' (>0): Number of iterations. ' ...
            ];
      s6 = [...
            '* ''Variable'': The result variable to cluster from. '...
            ];
      s10 = [...
            'Function: lyngby_ui_mkm_init' ...
            ];
      s11 = [...
            'See also: lyngby_km_main' ...
            ];
      
      helpdlg(sprintf('%s\n\n%s\n\n%s\n\n%s\n\n%s\n\n%s\n\n%s\n%s', s1, s2, s3, s4, ...
	  s5, s6, s10, s11),...
	  'Initialization of Meta K-means parameters')   

    elseif command == 4 
      % disp('popupStandard selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 5 
      % disp('editIterations selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 6 
      % disp('editClusters selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 7 
      % disp('editDecayRate selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 8 
      % disp('popupVariable selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 9 
      % disp('popupType selected.') 
      
      lyngby_log('Parameters edited')

    elseif command == 10
      % disp('editPositionWeight selected.') 

      lyngby_log('Parameters edited')
    
    else 
      error('Error: lyngby_ui_km_init.m called with incorrect command.') 
    end 






