function lyngby_ui_movie(command,parameter1) 

% lyngby_ui_movie   - User interface for movie
%
%	function lyngby_ui_movie(command,parameter1)
%	function lyngby_ui_movie
%  Peter 


% cvs : $Id: lyngby_ui_movie.m,v 1.1 1997/11/24 14:44:42 pto Exp $ 
%       $Revision: 1.1 $

    lyngby_ui_option;
    
    global X;
    global P;
    
    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonGenerate')) 
	command = 3; 
      elseif strcmp(lower(command),lower('buttonShow')) 
	command = 4; 
      elseif strcmp(lower(command),lower('popupPlane')) 
	command = 5; 
      elseif strcmp(lower(command),lower('popupScale')) 
	command = 6; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_movie'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_movie.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	fig = handle_list(1);
	buttonHelp = handle_list(2);
	buttonClose = handle_list(3); 
	buttonGenerate = handle_list(4); 
	buttonShow = handle_list(5); 
        popupPlane = handle_list(6); 
        popupScale = handle_list(7); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 200 300 150 ],... 
	  'resize','On','tag','lyngby_ui_movie',... 
	  'menubar','Figure','name','lyngby - Movie inspection',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOR_BACK); 

     
      bs = [0.4 0.2];
      
      dim = lyngby_roi;
      roidim = dim(:,2)-dim(:,1);
      [dummy,initplane] = min(roidim);

      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_movie(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.1 0.10 bs ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_movie(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.5 0.10 bs ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonGenerate = uicontrol(... 
	  'CallBack','lyngby_ui_movie(''buttonGenerate'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.1 0.4 bs ],... 
	  'String','Generate',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonShow = uicontrol(... 
	  'CallBack','lyngby_ui_movie(''buttonGenerate'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.5 0.4 bs ],... 
	  'String','Show',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 

      popupPlane = uicontrol(... 
	  'CallBack','lyngby_ui_movie(''popupPlane'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Max',[ 3 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.1 0.7 bs ],... 
	  'String','Sagittal|Coronal|Transversal',... 
	  'Style','popupmenu',... 
	  'Value',initplane,... 
	  'Tag','popupPlane',... 
	  'UserData','');      

      popupScale = uicontrol(... 
	  'CallBack','lyngby_ui_movie(''popupPlane'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Max',[ 5 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.5 0.7 bs ],... 
	  'String','Scale 1|Scale 2|Scale 3|Scale 4|Scale 5',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupPlane',... 
	  'UserData','');      

      handle_list = [ ...
	    fig  ... 
            buttonHelp buttonClose ... 
            buttonGenerate buttonShow ...
            popupPlane popupScale ...
            ]; 

      set(fig, 'userdata', handle_list); 
      drawnow;pause(.1); 
      set(fig,'visible','on'); 

      
    elseif command == 1 
      %disp('buttonHelp selected.') 
      
      s1 = [...
            'In this window the data can be inspected'...
            ];
      
      helpdlg(sprintf('%s',s1));   

      
    elseif command == 2 
      %disp('buttonClose selected.') 

      close(fig); 
      
    elseif command == 3 
      %disp('buttonGenerate selected.') 
      
      hf = figure('position',[100 100 get(popupScale,'value')*[150 100]],...
          'tag','lyngby_movie',...
          'name','lyngby - movie inspection',... 
          'Color', UI_COLOR_BACK); 



      h = axes;
      ds = get(h, 'position');
      
      set(h,'position',[0.1 0.15 0.85 0.6]);
      h2 = axes;
      set(h2,'position',[0.1 0.8 0.85 0.15]);
            
      colormap(UI_IMAGECOLORMAP);

      [NoTime,NoVoxels] = size(X);
      maxmax=max(max(X));
      minmin=min(min(X));
      M = moviein(NoTime,h);

      dim = lyngby_roi;
      planeType = get(popupPlane, 'Value');
      
      for i=1:NoTime
        
        axes(h2)
        plot(P,'r');
        hold on
        plot(i,P(i),'bo');
        hold off
        set(h2,'Xticklabel','');
        set(h2,'Yticklabel','');
        sP=max(P)-min(P);      
        axis([0 length(P)+1 min(P)-0.1*sP max(P)+0.1*sP])    
      
        lyngby_log(sprintf('Making movie (%i/%i)',i,NoTime));
        if planeType == 1,
          I = lyngby_getslice(X(i,:), 's', 'mean');
          firstCoords = dim(2,1):dim(2,2);
          secondCoords = dim(3,1):dim(3,2);
          planeString = 'Sagittal';
          xlabelString = 'y';
          ylabelString = 'z';
        elseif planeType == 2,
          I = lyngby_getslice(X(i,:), 'c', 'mean');
          firstCoords = dim(1,1):dim(1,2);
          secondCoords = dim(3,1):dim(3,2);
          planeString = 'Coronal';
          xlabelString = 'x';
          ylabelString = 'z';
        elseif planeType == 3,
          I = lyngby_getslice(X(i,:), 't', 'mean');
          firstCoords = dim(1,1):dim(1,2);
          secondCoords = dim(2,1):dim(2,2);
          planeString = 'Transversal';
          xlabelString = 'x';
          ylabelString = 'y';
        end
        axes(h);
        imagesc(I',[minmin maxmax]);
        xlabel(xlabelString);
        ylabel(ylabelString);
        set(h, 'YDir', 'normal');
        drawnow;
        M(:,i) = getframe;
      end
      movie(M,h,1);
        
    elseif command == 4 
      %disp('buttonShow selected.') 

    elseif command == 5 
      %disp('popupPlane selected.') 
      
    elseif command == 6 
      %disp('popupScale selected.') 

    else 
      error('Error: lyngby_ui_movie.m called with incorrect command.') 
    end 



















