function lyngby_ui_nnr_init(command,parameter1) 

% lyngby_ui_nnr_init   - User interface for NNR method
%
%	function lyngby_ui_nnr_init(command,parameter1)
%	function lyngby_ui_nnr_init
%
%       This function controls the initialization window for neural
%       network regression.
%       
%       See also: lyngby_nnr_main, lyngby_ui_main
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


% cvs : $Id: lyngby_ui_nnr_init.m,v 1.7 1999/06/08 15:37:36 mgl Exp $ 
%       $Revision: 1.7 $

    lyngby_nnr_global;
    lyngby_ui_global;
    lyngby_ui_option;

    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editLag')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editRegularization')) 
	command = 5; 
      elseif strcmp(lower(command),lower('popupInputtype')) 
	command = 6; 
      elseif strcmp(lower(command),lower('buttonSVD')) 
	command = 7; 
      elseif strcmp(lower(command),lower('editHiddenUnits')) 
	command = 8; 

      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_nnr_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_nnr_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	fig = handle_list(4);
	figSVD = handle_list(5);
	buttonApply = handle_list(6); 
	buttonHelp = handle_list(7); 
	buttonClose = handle_list(8); 
	buttonSVD = handle_list(9);
	textLag = handle_list(10); 
	editLag = handle_list(11); 
	textRegularization = handle_list(12); 
	editRegularization = handle_list(13); 
	textHiddenUnits = handle_list(14); 
	editHiddenUnits = handle_list(15); 
	textInputtype = handle_list(16); 
	popupInputtype = handle_list(17); 
      end 
    end 


    if command == 0 

      figSVD = -1;

      fig = figure('position',[ 300 470 400 250 ],... 
	  'resize','On','tag','lyngby_ui_nnr_init',... 
	  'menubar','Figure','name','lyngby - Neural network regression',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      
      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.09;
      FrameWidth = 0.98;
      FrameColumn = 0.01;
      Row1 = 0.04; % Window controls
      Row2 = 0.22; % Input Type
      Row3 = 0.35; % Hidden Units
      Row4 = 0.48; % Regularization parameter
      Row5 = 0.61; % Lag
      Row6 = 0.66; % Title
      Row7 = 0.77; % Title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.17 FrameWidth 0.83 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.14 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the Neural Network Regression algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row7 0.9 0.18 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 

      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.35 Row1 0.20 ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.56 Row1 0.20 ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.77 Row1 0.20 ButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      buttonSVD = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''buttonSVD'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.02 Row1 0.32 ButtonHeight ],... 
	  'String','Show singular values',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSVD',... 
	  'UserData',''); 
      
      textLag = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''textLag'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 0.43 ButtonHeight ],... 
	  'String','Lag:',... 
	  'Style','text',... 
	  'Tag','textLag',... 
	  'UserData',''); 
      editLag = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''editLag'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row5 0.14 ButtonHeight ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editLag',... 
	  'UserData','',...
	  'String', NNR_LAG); 
      textRegularization = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''textRegularization'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row4 0.43 ButtonHeight ],... 
	  'String','Regularization parameter:',... 
	  'Style','text',... 
	  'Tag','textRegularization',... 
	  'UserData',''); 
      editRegularization = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''editRegularization'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row4 0.14 ButtonHeight ],... 
	  'String','11',... 
	  'Style','edit',... 
	  'Tag','editRegularization',... 
	  'UserData','',...
	  'String', NNR_REGULARIZATION); 
      textHiddenUnits = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''textHiddenUnits'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row3 0.43 ButtonHeight ],... 
	  'String','Hidden units:',... 
	  'Style','text',... 
	  'Tag','textHiddenUnits',... 
	  'UserData',''); 
      editHiddenUnits = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''editHiddenUnits'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row3 0.14 ButtonHeight ],... 
	  'String','11',... 
	  'Style','edit',... 
	  'Tag','editHiddenUnits',... 
	  'UserData','',...
	  'String', NNR_HIDDENUNITS); 
      textInputtype = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''textInputtype'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row2 0.43 ButtonHeight ],... 
	  'String','Input type:',... 
	  'Style','text',... 
	  'Tag','textInputtype',... 
	  'UserData',''); 
      popupInputtype = uicontrol(... 
	  'CallBack','lyngby_ui_nnr_init(''popupInputtype'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row2 0.30 ButtonHeight ],... 
	  'String','Direct|SVD Preprocessed',... 
	  'Style','popupmenu',... 
	  'Value', 1,... 
	  'Tag','popupInputtype',... 
	  'UserData','');          

      set(editLag, 'String', num2str(NNR_LAG));
      set(editRegularization, 'String', num2str(NNR_REGULARIZATION));
      set(editHiddenUnits, 'String', num2str(NNR_HIDDENUNITS));
      
      if strcmp('direct', lower(NNR_INPUTTYPE))
	set(popupInputtype, 'value', 1);
      elseif strcmp('svdpreprocessed', lower(NNR_INPUTTYPE))
	set(popupInputtype, 'value', 2);
      else
	set(popupInputtype, 'value', 1);
	NNR_INPUTTYPE = 1;
	lyngby_log('Wrong NNR_INPUTTYPE')
      end
      
      handle_list = [ ...
	  frameEdit frameControl textTitle ...
	  fig figSVD ... 
	  buttonHelp buttonApply buttonClose buttonSVD ...
	  textLag editLag textRegularization editRegularization ...
	  textHiddenUnits editHiddenUnits textInputtype ...
	  popupInputtype ...
		    ];

      set(fig, 'userdata', handle_list); 
      drawnow;pause(.1); 
      set(fig,'visible','on'); 

    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [nnr_lag, count1] = sscanf(get(editLag, 'String'), '%d'); 
      [nnr_regularization, count2] = sscanf(get(editRegularization, 'String'), '%f');  
      [nnr_hiddenunits, count3] = sscanf(get(editHiddenUnits, 'String'), '%d');  
      if (count1==1 & count2==1 & count3==1 & nnr_lag>0 & ...
	    nnr_regularization>=0 & nnr_hiddenunits >= 1) 
	NNR_LAG = nnr_lag; 
	NNR_REGULARIZATION = nnr_regularization; 
	NNR_HIDDENUNITS = nnr_hiddenunits;
	it = get(popupInputtype, 'Value');
	if it == 1
	  NNR_INPUTTYPE = 'Direct';
	elseif it == 2
	  NNR_INPUTTYPE = 'SVDPreprocessed';
	end
      else 
	error('Order must be integer (>0), regularization a float (>=0).'); 
      end 

      if figSVD ~= -1
	figure(figSVD);
	lyngby_ui_nnr_init(100);
      end

      lyngby_log('New parameters updated')
      
    elseif command == 2 
      %disp('buttonHelp selected.') 

      s1 = [ ...
	    'This window allows you to setup the ' ...
	    'parameters of the neural network regression analysis. ' ...
	    ];
      s2 = [ ...
	    '* Lag: The time lag'...
	    ];
      s3 = [ ...
	    '* Regularization parameter: The weight decay (ridge parameter)' ...   
	    ];
      s4 = [ ...
	    '* Hidden Units: The number of hidden units in the '...
	    'neural network ' ...   
	    ];
      s5 = [ ...
	    '* Input type:  ''Direct'' feeds the input (the ' ...
	    'paradigm) directly to the input of the neural network. '...
	    '''SVD-preprocessed'' puts the paradigm through a '...
	    'singular decomposition layer first before feeding it to '...
	    'the input of the neural network.' ...
	    ];
      s10 = [ ...
	    'Function: lyngby_ui_nnr_init'...
	    ];
      s11 = [ ...
	    'See also: lyngby_nnr_main '...
	    ];

      helpdlg(sprintf('%s\n\n%s\n\n%s\n\n%s\n\n%s\n\n%s\n%s', s1, s2, s3, ...
	  s4, s5, s10, s11), ...
	  'Initialization of Neural network regression');
      
      
    elseif command == 3 
      %disp('buttonClose selected.') 

      if (figSVD ~= -1)
	figure(figSVD);
	close(figSVD)
      end
      close(fig); 
      
    elseif command == 4 
      %disp('editLag selected.') 

      lyngby_log('Parameters edited');
      
    elseif command == 5 
      %disp('editRegularization selected.') 

      lyngby_log('Parameters edited');
      
    elseif command == 6 
      %disp('popupInputtype selected.') 

      lyngby_log('Parameters edited');

      if (figSVD == -1)
	set(buttonSVD, 'String', 'Show singular values');
      else
	set(buttonSVD, 'String', 'Hide singular values');
      end

    elseif command == 7 

      if (figSVD == -1)
	handle_list = get(h_fig_list,'userdata'); 
	figSVD = figure('position',[ 300 60 400 300 ],... 
	    'resize','On','tag','lyngby_ui_nnr_init_svd',... 
	    'menubar','Figure','name', ... 
	    'lyngby - NNR filter analysis, Singular values',... 
	    'numbertitle','Off','visible','on','Color', UI_COLOUR_FRAME);
	handle_list(5) = figSVD;
	set(h_fig_list, 'userdata', handle_list); 
	lyngby_ui_nnr_init(100);
	set(buttonSVD, 'String', 'Hide singular values');
      else
	handle_list = get(h_fig_list,'userdata'); 
	handle_list(5) = -1;
	set(h_fig_list, 'userdata', handle_list); 
	figure(figSVD);
	close(figSVD);
	set(buttonSVD, 'String', 'Show singular values');
      end
      
    elseif command == 8
      %disp('editHiddenUnits selected.') 

      lyngby_log('Parameters edited');
      
    elseif command == 100
      
      p = PARADIGM;

      % Number of equations to determine the filter coefficients:
      Rows = size(X,1) - NNR_LAG+1;	
      
      unitM = eye(NNR_LAG);         % A unit matrix for the regularization
      
      Xm = zeros(Rows,NNR_LAG);     % The Input as a matrix
      for row = 1:Rows,
	Xm(row,:) = p(NNR_LAG+row-1:-1:row)';
      end
      Xmm = Xm'*Xm;
      [u,s,v] = svd(Xmm);
      dia = diag(s);
      HowMany = sum(dia>NNR_REGULARIZATION);

      
      plot(dia,'b');          
      xlabel('Number of singular value');
      ylabel('Level of singular value');
      title(sprintf('Using %i singular values of %i possible',...
	  HowMany,length(s)));
      
      hold on
      plot(get(gca,'XLim'),[NNR_REGULARIZATION NNR_REGULARIZATION],'r');
      plot([HowMany HowMany],get(gca,'YLim'),'g');
      legend('singular values','Threshold','Threshold');                    
      hold off;

      ss = (1./(s+eps)).*(s>NNR_REGULARIZATION);
      preX = v*ss*u'*Xm';

    else 
      error('Error: lyngby_ui_nnr_init.m called with incorrect command.') 
    end 

















