function lyngby_ui_nns_init(command,parameter1) 

% lyngby_ui_nns_init   - GUI for Neural network saliency
%
%	function lyngby_ui_nns_init(command,parameter1)
%	function lyngby_ui_nns_init
%
%       This function controls the NNS initialization window.
%       
%       See also: lyngby_nns_main, lyngby_ui_main
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


% cvs : $Id: lyngby_ui_nns_init.m,v 1.15 1999/06/08 15:37:49 mgl Exp $ 
%       $Revision: 1.15 $

    lyngby_nns_global;
    lyngby_ui_global;
    lyngby_ui_option;

    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('popupType')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editSVDComponents')) 
	command = 5; 
      elseif strcmp(lower(command),lower('popupNNInput')) 
	command = 6; 
      elseif strcmp(lower(command),lower('popupValidation')) 
	command = 7; 
      elseif strcmp(lower(command),lower('popupGenOptim')) 
	command = 8; 
      elseif strcmp(lower(command),lower('editRegularization')) 
	command = 9; 
      elseif strcmp(lower(command),lower('editHiddenUnits')) 
	command = 10; 
      elseif strcmp(lower(command),lower('popupInformation')) 
	command = 11; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_nns_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_nns_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	fig = handle_list(4);
	buttonApply = handle_list(5); 
	buttonHelp = handle_list(6); 
	buttonClose = handle_list(7); 
	textType = handle_list(8); 
	popupType = handle_list(9); 
	textSVDComponents = handle_list(10); 
	editSVDComponents = handle_list(11); 
	textNNInput = handle_list(12); 
	popupNNInput = handle_list(13); 
	textValidation = handle_list(14); 
	popupValidation = handle_list(15); 
	textGenOptim = handle_list(16); 
	popupGenOptim = handle_list(17); 
	textRegularization = handle_list(18); 
	editRegularization = handle_list(19); 
	textHiddenUnits = handle_list(20); 
	editHiddenUnits = handle_list(21); 
	textInformation = handle_list(22);
	popupInformation = handle_list(23);
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 250 350 350 ],... 
	  'resize','On','tag','lyngby_ui_nns_init',... 
	  'menubar','Figure','name','lyngby - Neural network saliency',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      w2 = 0.43;     % width of text
      w3 = 0.2;      % Width of edit
      w4 = 0.45;     % Width of popups

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.06;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.02; % Window controls
      Row2 = 0.14; %  Running Information
      Row3 = 0.23; %  Hidden Units
      Row4 = 0.32; %  Regularization Parameter
      Row5 = 0.41; %  Validation
      Row6 = 0.50; %  Generalization Optimization
      Row7 = 0.59; %  Neural network input
      Row8 = 0.68; %  SVD Components
      Row9 = 0.77; %  Type
      Row10= 0.88; % Title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.105 FrameWidth 0.88 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.01 FrameWidth 0.085 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the Neural Network Saliency algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row10 0.9 0.08 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textType = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''textType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row9 w2 ButtonHeight ],... 
	  'String','Type:',... 
	  'Style','text',... 
	  'Tag','textType',... 
	  'UserData',''); 
      popupType = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''popupType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.5 Row9 w4 ButtonHeight ],... 
	  'String', ...
	  ['LS|LS, second order|Entropy|Entropy, second order'],... 
	  'Style','popupmenu',... 
	  'Tag','popupType',... 
	  'UserData',''); 
      
      textSVDComponents = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''textSVDComponents'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row8 w2 ButtonHeight ],... 
	  'String','SVD Components:',... 
	  'Style','text',... 
	  'Tag','textSVDComponents',... 
	  'UserData',''); 
      editSVDComponents = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''editSVDComponents'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row8 w3 ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editSVDComponents',... 
	  'UserData','',...
	  'String', '50'); 

      textNNInput = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''textNNInput'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row7 w2 ButtonHeight ],... 
	  'String','Neural network input:',... 
	  'Style','text',... 
	  'Tag','textNNInput',... 
	  'UserData',''); 
      popupNNInput = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''popupNNInput'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row7 w4 ButtonHeight ],... 
	  'String', [ 'Direct|SVD|SVD normalized|', ...
	    'SOP|SOP normalized|SOP residual SVD' ],... 
	  'Style','popupmenu',... 
	  'Value', 2,... 
	  'Tag','popupNNInput',... 
	  'UserData','');          

      textGenOptim = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''textGenOptim'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row6 w2 ButtonHeight ],... 
	  'String','Generalization optimization:',... 
	  'Style','text',... 
	  'Tag','textGenOptim',... 
	  'UserData',''); 
      popupGenOptim = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''popupgenOptim'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row6 w4 ButtonHeight ],... 
	  'String',[...
	    'Free|Early stop|Hidden Units / Early Stop' ... 
	    '|Pruning|Pruning / 1D reg. grid search|' ...
	    'Pruning / 2D reg. grid search' ...
	    ], ...
	  'Style','popupmenu',... 
	  'Value', 1,... 
	  'Tag','popupGenOptim',... 
	  'UserData','');          

      textValidation = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''textValidation'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 w2 ButtonHeight ],... 
	  'String','Validation:',... 
	  'Style','text',... 
	  'Tag','textValidation',... 
	  'UserData',''); 
      popupValidation = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''popupValidation'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row5 w4 ButtonHeight ],... 
	  'String','In-basis single blocked|Off-basis single blocked',... 
	  'Style','popupmenu',... 
	  'Value', 1,... 
	  'Tag','popupValidation',... 
	  'UserData','');          


      textRegularization = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''textRegularization'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row4 w2 ButtonHeight ],... 
	  'String','Regularization parameter:',... 
	  'Style','text',... 
	  'Tag','textRegularization',... 
	  'UserData',''); 
      editRegularization = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''editRegularization'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row4 w4 ButtonHeight ],... 
	  'String','11',... 
	  'Style','edit',... 
	  'Tag','editRegularization',... 
	  'UserData','',...
	  'String', 0); 
      
      textHiddenUnits = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''textHiddenUnits'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row3 w2 ButtonHeight ],... 
	  'String','Hidden units:',... 
	  'Style','text',... 
	  'Tag','textHiddenUnits',... 
	  'UserData',''); 
      editHiddenUnits = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''editHiddenUnits'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row3 w3 ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editHiddenUnits',... 
	  'UserData','',...
	  'String', 3); 

      textInformation = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''textInformation'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row2 w2 ButtonHeight ],... 
	  'String','Running information:',... 
	  'Style','text',... 
	  'Tag','textInformation',... 
	  'UserData',''); 
      popupInformation = uicontrol(... 
	  'CallBack','lyngby_ui_nns_init(''popupInformation'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row2 w3 ButtonHeight ],... 
	  'Style','popupmenu',... 
	  'Tag','popupInformation',... 
	  'UserData', '', ...
	  'String', 'On|Off', ...
	  'Value', 1); 

      
      if strcmp(lower(NNS_TYPE), 'ls')
	set(popupType, 'value', 1);
      elseif strcmp(lower(NNS_TYPE), 'lssecondorder')
	set(popupType, 'value', 2);
      elseif strcmp(lower(NNS_TYPE), 'entropy')
	set(popupType, 'value', 3);
      elseif strcmp(lower(NNS_TYPE), 'entropysecondorder')
	set(popupType, 'value', 4);
      else
	error(sprintf('Wrong value for NNS_TYPE: %s', NNS_TYPE));
      end

      set(editSVDComponents, 'String', num2str(NNS_SVDCOMPONENTS));

      if strcmp(lower(NNS_NNINPUT), 'direct')
	set(popupNNInput, 'value', 1);
      elseif strcmp(lower(NNS_NNINPUT), 'svd')
	set(popupNNInput, 'value', 2);
      elseif strcmp(lower(NNS_NNINPUT), 'svdnormalized')
	set(popupNNInput, 'value', 3);
      elseif strcmp(lower(NNS_NNINPUT), 'sop')
	set(popupNNInput, 'value', 4);
      elseif strcmp(lower(NNS_NNINPUT), 'sopnormalized')
	set(popupNNInput, 'value', 5);
      elseif strcmp(lower(NNS_NNINPUT), 'sopressvd')
	set(popupNNInput, 'value', 6);
      else
	error(sprintf('Wrong value for NNS_NNINPUT: %s', NNS_NNINPUT));
      end
     
      if strcmp(lower(NNS_GENOPTIM), 'free')
	set(popupGenOptim, 'value', 1);
      elseif strcmp(lower(NNS_GENOPTIM), 'earlystop')
	set(popupGenOptim, 'value', 2);
      elseif strcmp(lower(NNS_GENOPTIM), 'hiddenunitsearlystop')
	set(popupGenOptim, 'value', 3);
      elseif strcmp(lower(NNS_GENOPTIM), 'pruning')
	set(popupGenOptim, 'value', 4);
      elseif strcmp(lower(NNS_GENOPTIM), 'pruning1dreggridsearch')
	set(popupGenOptim, 'value', 5);
      elseif strcmp(lower(NNS_GENOPTIM), 'pruning2dreggridsearch')
	set(popupGenOptim, 'value', 6);
      else
	error(sprintf('Wrong value for NNS_GENOPTIM', NNS_GENOPTIM));
      end

      if strcmp(lower(NNS_VALIDATION), 'inbasissingleblocked')
	set(popupValidation, 'value', 1);
      elseif strcmp(lower(NNS_VALIDATION), 'offbasissingleblocked')
	set(popupValidation, 'value', 2);
      else
	error(sprintf('Wrong value for NNS_VALIDATION: %s', ...
	    NNS_VALIDATION));
      end

      set(editRegularization, 'String', sprintf('%g ', NNS_REGULARIZATION));
      set(editHiddenUnits, 'String', num2str(NNS_HIDDENUNITS));

      if NNS_INFORMATION == 0
	set(popupInformation, 'Value', 2);
      end
            
      handle_list = [ ...
	  frameEdit frameControl textTitle ...
	  fig ... 
	  buttonHelp buttonApply buttonClose ...
	  textType popupType ...
	  textSVDComponents editSVDComponents ...
	  textNNInput popupNNInput ...
	  textValidation popupValidation ...
	  textGenOptim popupGenOptim ...
	  textRegularization editRegularization ...
	  textHiddenUnits editHiddenUnits ...
	  textInformation popupInformation
		    ];

      set(fig, 'userdata', handle_list); 
      drawnow;pause(.1); 
      set(fig,'visible','on'); 

    elseif command == 1 
      %disp('buttonApply selected.') 
      
      nns_type = get(popupType, 'value');
      if nns_type == 1
	NNS_TYPE = 'LS';
      elseif nns_type == 2
	NNS_TYPE = 'LSSecondOrder';
      elseif nns_type == 3
	NNS_TYPE = 'Entropy';
      elseif nns_type == 4
	NNS_TYPE = 'EntropySecondOrder';
      end

      [nns_svdcomponents, count] = sscanf(get(editSVDComponents, ...
	  'String'), '%d');  
      if (count==1 & nns_svdcomponents>0) 
	NNS_SVDCOMPONENTS = nns_svdcomponents;
      else 
	error('SVD Components must be an integer (>0)'); 
      end 

      nns_nninput = get(popupNNInput, 'value');
      if nns_nninput == 1
	NNS_NNINPUT = 'Direct';
      elseif nns_nninput == 2
	NNS_NNINPUT = 'SVD';
      elseif nns_nninput == 3
	NNS_NNINPUT = 'SVDNormalized';
      elseif nns_nninput == 4
	NNS_NNINPUT = 'SOP';
      elseif nns_nninput == 5
	NNS_NNINPUT = 'SOPNormalized';
      elseif nns_nninput == 6
	NNS_NNINPUT = 'SOPResSVD';
      end

      nns_genoptim = get(popupGenOptim, 'value');
      if nns_genoptim == 1
	NNS_GENOPTIM = 'Free';
      elseif nns_genoptim == 2
	NNS_GENOPTIM = 'EarlyStop';
      elseif nns_genoptim == 3
	NNS_GENOPTIM = 'HiddenUnitsEarlyStop';
      elseif nns_genoptim == 4
	NNS_GENOPTIM = 'Pruning';
      elseif nns_genoptim == 5
	NNS_GENOPTIM = 'Pruning1DRegGridSearch';
      elseif nns_genoptim == 6
	NNS_GENOPTIM = 'Pruning2DRegGridSearch';
      end
      nns_validation = get(popupValidation, 'value');
      if nns_validation == 1
	NNS_VALIDATION = 'InBasisSingleBlocked';
      elseif nns_validation == 2
	NNS_VALIDATION = 'OffBasisSingleBlocked';
      end
      
      [nns_regularization, count] = sscanf(get(editRegularization, ...
	  'String'), '%f'); 
      if count == 0
	error('Could not read ''Regularization'' property')
      elseif count ~= 1 & any(nns_genoptim == [1 2 3 4])
	error('''Regularization'' should contain one value.');
      elseif count ~= 2 & nns_genoptim == 5
	error(['if ''Generalization optimization'' is ' ...
	      '''Pruning 1D Reg Grid Search'' \nthen ', ...
	      '''Regularization'' should have 2 value']);
      elseif count ~= 4 & nns_genoptim == 6
	error(['if ''Generalization optimization'' is ' ...
	      '''Pruning 2D Reg Grid Search'' then', ...
	      '''Regularization'' should have 4 value']);
      end
      if all(nns_regularization >= 0)  
	NNS_REGULARIZATION = nns_regularization; 
      else 
	error([ 'Regularization should contain positive floats' ...
	      'or zero (>=0).']);
      end 
      [nns_hiddenunits, count] = sscanf(get(editHiddenUnits, 'String'), '%d');  
      if (count==1 &  nns_hiddenunits >= 1) 
	NNS_HIDDENUNITS = nns_hiddenunits;
      else 
	error('Hidden units must be an integer (>0).'); 
      end 

      nns_information = get(popupInformation, 'value');
      if nns_information == 1
	NNS_INFORMATION = 1;
      else
	NNS_INFORMATION = 0;
      end

      lyngby_log('New parameters updated');
      
    elseif command == 2 
      %disp('buttonHelp selected.') 

      s1 = [ ...
	    'This window allows you to setup the ' ...
	    'parameters of the neural network saliency analysis. ' ...
	    ];
      s2 = [ ...
	    '* ''Type'': Choose between LS (least square or '...
	    'quadratic) and entropic neural network. '...
	    ];
      s3 = [ ...
	    '* ''SVD Components'': The number of inputs into the ' ...
	    'neural network from the SVD/SOP projection. '...
	    ];
      s4 = [ ...
	    '* ''Neural network input'': Indicates how the SVD '...
	    'should be projected onto the input of the neural '...
	    'network. This will influence the effect of the '...
	    'regularization parameter. ' ...
	    ];
      s5 = [ ...
	    '* ''Generalization Optimization'': Specifies how the ' ...
	    'architecture and the hyperparameters of the neural '...
	    'network should be optimized to get the lowest '...
	    'generalization error. '...
	    ];
      s6 = [ ...
	    '* ''Validation'': Specifies how the generalization should be '...
	    'assessed.' ...
	    ];

      s7 = [ ...
	    '* ''Regularization parameter'': The weight decay (ridge parameter).' ...   
	    ];
      s8 = [ ...
	    '* ''Hidden Units'': The number of hidden units in the '...
	    'neural network. ' ...   
	    ];
      s10 = [ ...
	    'Function: lyngby_ui_nns_init' ...
	    ];
      s11 = [ ...
	    'See also: lyngby_nns_main' ...
	    ];

      helpdlg(sprintf('%s\n\n%s\n\n%s\n\n%s\n\n%s\n\n%s\n\n%s\n\n%s\n\n%s\n%s', ...
	  s1, s2, s3, s4, s5, s6, s7, s8, s10, s11), ...
	  'Initialization of Neural network saliency');
      
      
    elseif command == 3 
      %disp('buttonClose selected.') 

      close(gcf);
      
    elseif command == 4 
      %disp('popupType selected.') 

      lyngby_log('Parameters edited');

    elseif command == 5 
      %disp('editRegularization selected.') 

      lyngby_log('Parameters edited');

    elseif command == 6 
      %disp('popupNNInput selected.') 

      if get(popupNNInput, 'value') == 1
	set(editSVDComponents, 'string', num2str(size(X,2)));
      else
	[nns_svdcomponents, count] = sscanf(get(editSVDComponents, ...
	    'String'), '%d');  
	if (count==1 & nns_svdcomponents == size(X,2)) 
	  NNS_SVDCOMPONENTS = nns_svdcomponents;
	  set(editSVDComponents, 'string', 50);
	end 
      end

      lyngby_log('Parameters edited');
      
    elseif command == 7 

      lyngby_log('Parameters edited');
      
    elseif command == 8
      %disp('editHiddenUnits selected.') 

      lyngby_log('Parameters edited');

    elseif command == 9

      lyngby_log('Parameters edited');
    
    elseif command == 10 

      lyngby_log('Parameters edited');
    
    elseif command == 10 

      lyngby_log('Parameters edited');
      
    elseif command == 11

      lyngby_log('Parameters edited');
      
    else 
      error('Error: lyngby_ui_nns_init.m called with incorrect command.') 
    end 














