function lyngby_ui_para_draw(command,parameter1) 

% lyngby_ui_para_draw  - User interface for paradigm viewing (and specification)
%
%       function lyngby_ui_para_draw(command,parameter1) 
%       function lyngby_ui_para_draw
%
%       This function controls the window where you can setup the
%       PARADIGM global variable, - the activation or stimulus
%       function.  
%
%       When you click on the graph the individual time bins will
%       change between on and off states. 
%
%       See also LYNGBY, LYNGBY_PARADIGM, LYNGBY_UI_MAIN,
%                LYNGBY_UI_EXTERNALS, LYNGBY_UI_GLOBAL. 
%
% $Id: lyngby_ui_para_draw.m,v 1.7 2003/09/15 10:28:07 fnielsen Exp $

%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 
%
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


    lyngby_global
    lyngby_ui_global
    lyngby_ui_option
    
    
    Update = [ ...
	  'axes(axesParadigm);', ...
	  'imagesc(get(dataParadigm, ''UserData'')'');', ...
	  'set(gca, ''YTick'', []);', ...
	  'colormap(1-gray);',...
	  'xlabel(''Sample/Scan Number'');', ...
	  'ylabel('''');', ...
	  'title(''Paradigm Function'');', ...
	  'hImage = findobj(axesParadigm, ''type'', ''image'');',...
	  'if hImage,',...
	  '  set(hImage, ''ButtonDownFcn'', ''lyngby_ui_para_draw(100)'');',...
	  'else,',...
	  '  error(''Ups, could not find a handle for the image'');',...
	  'end,',...
	  ];
	   
     
    if nargin == 0 
      command = 'new'; 
    end 


    if isstr(command) 
      
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 2; 
      elseif strcmp(lower(command),lower('axesParadigm')) 
	command = 6; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 7; 
      elseif strcmp(lower(command), 'close') 
	command = 1000; 

      end 
    end 

    if command ~= 0 & command ~= 1000
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_para_draw'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_para_draw.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameControl = handle_list(1);
	textLabel = handle_list(2);
	buttonApply = handle_list(3); 
	buttonClose = handle_list(4); 
	buttonHelp = handle_list(5);
	axesParadigm = handle_list(6); 
      	dataParadigm = handle_list(7); 
      end 
    end 


    if command == 0 
      
      fig = figure('position',[ 218 100 500 230 ],... 
	  'resize','on','tag','lyngby_ui_para_draw',... 
	  'visible','off',...
	  'name', 'lyngby - Paradigm draw',...
	  'numbertitle', 'off',...
	  'color', UI_COLOUR_FRAME); 

      ButtonHeight = 0.1;
      ButtonRow1 = 0.05;
  
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_WINBACK,...
          'Position',[ 0.08 0.025 0.84 0.15 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textLabel = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textLabel'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.095 ButtonRow1-0.005 0.33 0.11 ],... 
	  'String','Click on the graph to alter the function',... 
	  'Style','text',... 
	  'Tag','textLabel',... 
	  'UserData',''); 
      
      
      buttonApply = uicontrol(... 
	  'Callback', 'lyngby_ui_para_draw(''buttonApply'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.44 ButtonRow1 0.15 ButtonHeight ],...
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'Callback', 'lyngby_ui_para_draw(''buttonClose'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.6 ButtonRow1 0.15 ButtonHeight ],...
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'Callback', 'lyngby_ui_para_draw(''buttonHelp'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.76 ButtonRow1 0.15 ButtonHeight ],...
	  'Tag','buttonHelp');

	  
  
      %  Axes and Text Object Creation 
      
      axesParadigm = axes(... 
	  'Units','normalized', ... 
	  'Position',[ 0.08 0.38 0.84 0.54 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesParadigm', ... 
	  'UserData',''); 

      dataParadigm = uicontrol('Visible', 'off');
      
      handle_list = [ ... 
	    frameControl ...
            textLabel ...
	    buttonApply buttonClose ...
	    buttonHelp ...
	    axesParadigm ... 
	    dataParadigm ...
	    ]; 

      if isempty(PARADIGM)
	set(dataParadigm, 'UserData', zeros(NUM_SCANS,1));
      else
	set(dataParadigm, 'UserData', PARADIGM);
      end

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 

      eval(Update);
	
    elseif command == 1 
      
      close(gcf)
      
    elseif command == 2

      PARADIGM = get(dataParadigm, 'UserData');      
      lyngby_ui_paradigm('Update');

    elseif command == 7
      %disp('buttonHelp')
      
      helpwin('lyngby_ui_para_draw');
      
    elseif command == 100

      Point = round(get(gca, 'currentPoint'));
      scan = Point(1,1);
      paradigm = get(dataParadigm, 'UserData');
      if paradigm(round(scan)) 
	paradigm(scan) = 0;
      else
	paradigm(scan) = 1;
      end
      
      set(dataParadigm, 'UserData', paradigm);
      eval(Update);
      
    elseif command == 1000
      
      fig = findobj('tag','lyngby_ui_para_draw');
      if fig == 1
	close(fig);
      elseif fig > 1
	for f = 1:length(fig)
	  close(fig(f));
	end
      end
      
    else 
      error('Error: lyngby_ui_para_draw.m called with incorrect command.') 
    end 






