function lyngby_ui_paradigm(command,parameter1) 

% lyngby_ui_paradigm	- User interface for paradigm viewing and editing 
%
%       function lyngby_ui_paradigm(command,parameter1) 
%       function lyngby_ui_paradigm
%
%       This function is used to set up, view, save and load the
%       PARADIGM global variable. 
%
%       There are several ways in which the PARADIGM can be set up:
%       It might be set up in the data_paradigm function (provided by
%       the user), drawn by the user, or loaded in from a data file.
%       Select the appropriate command with the popup menu and press
%       "Go!". 
% 
%       See also LYNGBY, LYNGBY_PARADIGM, LYNGBY_UI_MAIN,
%                LYNGBY_UI_GLOBAL. 
%
% $Id: lyngby_ui_paradigm.m,v 1.21 2003/05/23 17:14:00 fnielsen Exp $


%       Made with: Gui Maker Ver 2.1 by Patrick Marchand 
%
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


    lyngby_global
    lyngby_ui_global
    lyngby_ui_option
    global RUN
    
    
    Update = [ ...
	  'axes(axesParadigm);', ...
	  'if (exist(''PARADIGM'') ~= 1) | isempty(PARADIGM),', ...
	  '  if (exist(''RUN'') == 1) & ~isempty(RUN),', ...
	  '    axis([1 length(RUN) 0 1]);',...
	  '  end,',...
	  '  title(''No paradigm defined'');', ...
	  'else,', ...
	  '  plot(1:length(PARADIGM),PARADIGM, ''-'', 1:length(PARADIGM),PARADIGM, ''o'');', ...
	  '  axis([1 length(PARADIGM) min(PARADIGM)-0.1 max(PARADIGM)+0.1]);', ...
	  '  xlabel(''Sample/Scan Number'');', ...
	  '  ylabel(''Activation Level'');', ...
	  '  title(''Paradigm Function'');', ...
	  'end,', ...
	  ];
	   
     
    if nargin == 0 
      command = 'new'; 
    end 


    if isstr(command) 
      
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonLoad')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonSaveAs')) 
	command = 3; 
      elseif strcmp(lower(command),lower('buttonSavePara')) 
	command = 4; 
      elseif strcmp(lower(command),lower('buttonAction')) 
	command = 5; 
      elseif strcmp(lower(command),lower('axesParadigm')) 
	command = 6; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 7; 
      elseif strcmp(lower(command),lower('buttonReread')) 
	command = 8; 
      elseif strcmp(lower(command),lower('buttonLoadPara')) 
	command = 9; 
      elseif strcmp(lower(command),lower('popupType')) 
	command = 10; 
      elseif strcmp(lower(command),'update') 
	command = 1000; 
      end 
    end 
    


    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_paradigm'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_paradigm.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
        frameControl = handle_list(1);
	buttonClose = handle_list(2); 
	buttonLoad = handle_list(3); 
	buttonSaveAs = handle_list(4); 
	buttonSavePara = handle_list(5); 
	buttonAction = handle_list(6); 
	axesParadigm = handle_list(7); 
	buttonHelp = handle_list(8);
	buttonAction = handle_list(9);
	popupType = handle_list(10);
	buttonReread = handle_list(11);
      	buttonLoadPara = handle_list(12);
      end 
    end 


    if command == 0 
      
      fig = figure('position',[ 218 55 500 230 ],... 
	  'resize','on','tag','lyngby_ui_paradigm',... 
	  'visible','off',...
	  'name', 'lyngby - Paradigm setup',...
	  'numbertitle', 'off',...
	  'color', UI_COLOUR_FRAME); 

      ButtonHeight = 0.1;
      ButtonRow1 = 0.05;
      yHigh = 0.17;
 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_WINBACK,...
          'Position',[ 0.08 0.025 0.84 0.15 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 
            
      buttonClose = uicontrol(... 
	  'Callback', 'lyngby_ui_paradigm(''buttonClose'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.62 ButtonRow1 0.14 ButtonHeight ],...
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'Callback', 'lyngby_ui_paradigm(''buttonHelp'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.77 ButtonRow1 0.14 ButtonHeight ],...
	  'Tag','buttonHelp');

	  
      buttonLoad = uicontrol(... 
	  'Callback', 'lyngby_ui_paradigm(''buttonLoad'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Load ...',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 yHigh 0.1 ButtonHeight ],...
	  'Tag','buttonLoad',... 
	  'visible', 'off',...
	  'UserData',''); 
      buttonSaveAs = uicontrol(... 
	  'Callback', 'lyngby_ui_paradigm(''buttonSaveAs'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Save as ...',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.16 yHigh 0.13 ButtonHeight ],...
	  'Tag','buttonSaveAs',... 
	  'visible', 'off',...
	  'UserData',''); 
      buttonReread = uicontrol(... 
	  'Callback', 'lyngby_ui_paradigm(''buttonReread'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Reread lyngby_paradigm',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.31 yHigh 0.25 ButtonHeight ],...
	  'visible', 'off',...
	  'Tag','buttonReread');
      buttonLoadPara = uicontrol(... 
	  'Callback', 'lyngby_ui_paradigm(''buttonLoadPara'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Read data_paradigm.m',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.050 ButtonRow1 0.25 ButtonHeight ],...
	  'visible', 'off',...
	  'Tag','buttonLoadPara'); 
      buttonSavePara = uicontrol(... 
	  'Callback', 'lyngby_ui_paradigm(''buttonSavePara'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Save to data_paradigm.mat',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.31 ButtonRow1 0.27 ButtonHeight ],...
	  'Tag','buttonSavePara',... 
	  'visible', 'off',...
	  'UserData',''); 
      
      buttonAction = uicontrol(... 
	  'Callback', 'lyngby_ui_paradigm(''buttonAction'')',...
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,...
	  'String','Go!',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.49 ButtonRow1 0.07 ButtonHeight ],...
	  'Tag','buttonAction',... 
	  'UserData',''); 
      popupType = uicontrol(... 
	  'CallBack','lyngby_ui_paradigm(''popupType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ 0.09 ButtonRow1 0.39 ButtonHeight ],... 
	  'HorizontalAlignment','left',... 
	  'String',[...
	    'Choose a command, then press Go!|',...
	    'Reset|', ...
	    'Draw|',... 
	    'Load (.mat) ...|',...
	    'Load (.txt) ...|', ...
	    'Load from data_paradigm.m|',...
	    'Reread lyngby_paradigm.m|',...
	    'Save As (.mat) ...|',...
	    'Save to data_paradigm.mat',...
	    ],...
	  'Style','popupmenu',... 
	  'Tag','popupType',... 
	  'UserData',''); 

  
      %  Axes and Text Object Creation 
      
      axesParadigm = axes(... 
	  'Units','normalized', ... 
	  'Position',[ 0.08 0.34 0.84 0.56 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesParadigm', ... 
	  'UserData',''); 

      handle_list = [ ...  
          frameControl ...
	  buttonClose buttonLoad buttonSaveAs buttonSavePara buttonAction ...
	  axesParadigm ... 
	  buttonHelp ...
	  buttonAction popupType ...
	  buttonReread buttonLoadPara ...
	]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


      eval(Update);
      

    elseif command == 1 
      
      lyngby_ui_para_draw('Close');
      close(gcf)
      
    elseif command == 2
      [file, path] = uigetfile('*', 'Load paradigm file');
      if file ~= 0, 
	file = [ path file ];
	eval(['load ' file]);
	eval(Update);
      end

    elseif command == 3 
      if exist('PARADIGM') & ~isempty(PARADIGM)
	[file, path] = uiputfile('*.mat', 'Save paradigm As');
	if file ~= 0, 
	  file = [ path file ];
	  ver = version;
	  if str2num(ver(1)) >= 5
	    eval(['save ' file ' PARADIGM -v4']);
	  else
	    eval(['save ' file ' PARADIGM']);
	  end
	end
      else
	error('There is no paradigm defined');
      end

      
    elseif command == 4 
      if ~isempty(PARADIGM)
	ver = version;
	if str2num(ver(1)) >= 5
	  save data_paradigm PARADIGM -v4
	else
	  save data_paradigm PARADIGM
	end

      else
	error('There is no paradigm defined');
      end
    elseif command == 5

      actionType = get(popupType, 'value');

      if actionType == 1
	% Dummy entry acting as an instruction - do nothing
	
      elseif actionType == 2
	% Reset
	PARADIGM = zeros(NUM_SCANS, 1);
	eval(Update);
	
      elseif actionType == 3
	% Call-up window to draw Paradigm
	lyngby_ui_para_draw
	
      elseif actionType == 4
	% Load PARADIGM from *.mat file
	[file, path] = uigetfile('*.mat', 'Load paradigm file');
	if file ~= 0, 
	  file = [ path file ];

	  % !!! It should be tested if the file contains PARADIGM 
	  eval(['load ' file]);
	  eval(Update);
	end
	
      elseif actionType == 5
	% Load PARADIGM from *.txt file
	[file, path] = uigetfile('*.txt', 'Load paradigm file');
	if file ~= 0, 
	  file = [ path file ];

	  try 
	    S = load(file);
	  catch 
	    lyngby_ui_message('Could not read file')
	  end
	  if isnumeric(S)
	    PARADIGM = S;
	  else
	    lyngby_ui_message('Could not read values from file')
	  end
	  eval(Update);
	end
      
      elseif actionType == 6
	% Load PARADIGM from data_paradigm.m
	clear data_paradigm
	if exist('data_paradigm') == 2
	  eval('paradigm = data_paradigm;');
	  if ~length(paradigm)
	    lyngby_ui_message([...
		  '''data_paradigm.m'' function did not give any values. ' ...
		  ]);
	  else
	    PARADIGM = paradigm;
	  end
	else
	  lyngby_ui_message([...
		'''data_paradigm.m'' function does not exists. ' ...
		'The user should define this.' ...
		]);
	end
      
	eval(Update);
	
      elseif actionType == 7
	% Re-read PARADIGM from lyngby_paradigm.m
	PARADIGM = lyngby_paradigm;

	 if isempty(PARADIGM) 
	    lyngby_ui_message([...
		  'lyngby_paradigm.m did not return anything' ...
		  ]);
	  end

	  eval(Update);
	
      elseif actionType == 8
	% Save PARADIGM as *.mat
	if exist('PARADIGM') & ~isempty(PARADIGM)
	  [file, path] = uiputfile('*.mat', 'Save paradigm As');
	  if file ~= 0, 
	    file = [ path file ];
	    ver = version;
	    if str2num(ver(1)) >= 5
	      eval(['save ' file ' PARADIGM -v4']);
	    else
	      eval(['save ' file ' PARADIGM']);
	    end
	  end
	else
	  lyngby_ui_message([...
		'There is no paradigm. '...
		'Please use ''draw'' or write a file where '...
		'it is defined.'...
		]);
	end
	
      elseif actionType == 9
	% Save PARADIGM as data_paradigm.mat
	if ~isempty(PARADIGM)
	  ver = version;
	  if str2num(ver(1)) >= 5
	    save data_paradigm PARADIGM -v4
	  else
	    save data_paradigm PARADIGM
	  end
	else
	  lyngby_ui_message([...
		  'There is no paradigm. '...
		  'Please use ''draw'' or write a file where '...
		  'it is defined.'...
		  ]);
	end

	
      else
	error('Internal error: actionType unknown');
      end
      
      
    elseif command == 7
      %disp('buttonHelp')

      helpwin('lyngby_ui_paradigm');
      

    elseif command == 8
      %disp('buttonReread')
      
    elseif command == 9
      %disp('buttonLoadPara')

      
    elseif command == 10
      %disp('popupType')

    elseif command == 1000
      
      eval(Update);
      
    else 
      error('Error: lyngby_ui_paradigm.m called with incorrect command.') 
    end 






