function lyngby_ui_pois_init(command,parameter1) 

% lyngby_ui_pois_init  - GUI, Poisson filter, initialization
%
%	function lyngby_ui_pois_init.m(command,parameter1)
%
%       Function to control the window with the graphical user
%       interface for initialization of the parameters to the Poisson
%       filter analysis.  
% 
%       - 'Kernel width' is the size of the kernel. It should a least
%       be twice as large as the poisson parameter. 
%
%       - 'Convolution type' determines how the first samples should
%       be handled. 
%
%       - 'Spatial type' determines whether the Poisson (shape)
%       parameter should be common or distinct for each voxel. The
%       amplitude parameter will always independently determined for
%       each voxel. 
%
%       See also LYNGBY, LYNGBY_POIS_MAIN, LYNGBY_UI_MAIN.
%
% $Id: lyngby_ui_pois_init.m,v 1.4 2003/05/23 09:44:01 fnielsen Exp $

%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 



    lyngby_ui_option;
    lyngby_pois_global;

    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editKernelWidth')) 
	command = 4; 
      elseif strcmp(lower(command),lower('popupConvType')) 
	command = 5; 
      elseif strcmp(lower(command),lower('popupSpatialType')) 
	command = 6; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_pois_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_pois_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonApply = handle_list(4); 
	buttonHelp = handle_list(5); 
	buttonClose = handle_list(6); 
	editKernelWidth = handle_list(7); 
	textKernelWidth = handle_list(8); 
	popupConvType = handle_list(9); 
	textConvType = handle_list(10); 
	popupSpatialType = handle_list(11); 
      	textSpatialType = handle_list(12); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 400 350 200 ],... 
	  'resize','On','tag','lyngby_ui_pois_init',... 
	  'menubar','Figure','name','lyngby - Poisson filter analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      ButtonWidth = 0.25;
      ButtonHeight = 0.12;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row2 = 0.28; % Lower buttons
      Row3 = 0.42; % Middle buttons
      Row4 = 0.56; % Upper buttons
      Row5 = 0.68; % Lower title
      Row6 = 0.75; % Upper title
      Column1 = 0.07; % Left window button
      Column2 = 0.38; % Middle window button
      Column3 = 0.69; % Right window button
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width

      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_pois_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the Poisson filter can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row6 0.9 0.18 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
            
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_pois_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_pois_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_pois_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textKernelWidth = uicontrol(... 
	  'CallBack','lyngby_ui_pois_init(''textKernelWidth'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment', 'right',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row4 LabelWidth ButtonHeight ],... 
	  'String','Kernel width:',... 
	  'Style','text',... 
	  'Tag','textKernelWidth',... 
	  'UserData',''); 
      editKernelWidth = uicontrol(... 
	  'CallBack','lyngby_ui_pois_init(''editKernelWidth'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row4 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editKernelWidth',... 
	  'UserData',''); 
      textConvType = uicontrol(... 
	  'CallBack','lyngby_ui_pois_init(''textConvType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row3 LabelWidth ButtonHeight ],... 
	  'String','Convolution type:',... 
	  'Style','text',... 
	  'Tag','textConvType',... 
	  'UserData',''); 
      popupConvType = uicontrol(... 
	  'CallBack','lyngby_ui_pois_init(''popupConvType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row3 EditWidth ButtonHeight ],... 
	  'Style','popup',...
	  'String', 'Skip|Zeropad|Extend|Wrap',...
	  'Tag','popupConvType',... 
	  'UserData',''); 

      textSpatialType = uicontrol(... 
	  'CallBack','lyngby_ui_pois_init(''textSpatialType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row2 LabelWidth ButtonHeight ],... 
	  'String','Spatial type:',... 
	  'Style','text',... 
	  'Tag','textSpatialType',... 
	  'UserData',''); 
      popupSpatialType = uicontrol(... 
	  'CallBack','lyngby_ui_pois_init(''popupSpatialType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row2 EditWidth ButtonHeight ],... 
	  'Style','popup',...
	  'String', 'Voxel|Global',...
	  'Tag','popupSpatialType',... 
	  'UserData',''); 

      
      set(editKernelWidth, 'String', num2str(POIS_KERNELWIDTH));
      if strcmp('skip', lower(POIS_CONVTYPE))
	set(popupConvType, 'value', 1);
      elseif strcmp('zeropad', lower(POIS_CONVTYPE))
	set(popupConvType, 'value', 2);
      elseif strcmp('extend', lower(POIS_CONVTYPE))
	set(popupConvType, 'value', 3);
      elseif strcmp('wrap', lower(POIS_CONVTYPE))
	set(popupConvType, 'value', 4);
      end

      if strcmp('voxel', lower(POIS_SPATIALTYPE))
	set(popupSpatialType, 'value', 1);
      elseif strcmp('global', lower(POIS_SPATIALTYPE))
	set(popupSpatialType, 'value', 2);
      end
      
      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonApply buttonHelp buttonClose ... 
	  editKernelWidth textKernelWidth ... 
	  popupConvType textConvType ... 
	  popupSpatialType textSpatialType ... 
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [pois_kernelwidth, count1] = sscanf(get(editKernelWidth, 'String'), '%d'); 
      pois_convtype = get(popupConvType, 'Value'); 
      pois_spatialtype = get(popupSpatialType, 'Value'); 
      if (count1==1 & pois_kernelwidth > 0) 
	POIS_KERNELWIDTH = pois_kernelwidth; 
	if pois_convtype == 1 
	  POIS_CONVTYPE = 'Skip'; 
	elseif pois_convtype == 2 
	  POIS_CONVTYPE = 'Zeropad'; 
	elseif pois_convtype == 3 
	  POIS_CONVTYPE = 'Extend'; 
	else pois_convtype == 4 
	  POIS_CONVTYPE = 'Wrap'; 
	end 
	if pois_spatialtype == 1 
	  POIS_SPATIALTYPE = 'Voxel'; 
	elseif pois_convtype == 2 
	  POIS_SPATIALTYPE = 'Global'; 
	end 
      else 
	error('Kernel width should be a positive integer.'); 
      end 

      lyngby_log('New parameters updated')
      
    elseif command == 2 

      helpwin('lyngby_ui_pois_init')

      
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command == 4 
      %disp('editKernelWidth selected.') 

      lyngby_log('Parameters edited');
      
    elseif command == 5         
      %disp('popupConvType selected.') 

      lyngby_log('Parameters edited');
      
    elseif command == 6      
      %disp('popupSpatialType selected.') 

      lyngby_log('Parameters edited');
      
    else 
      error('Error: lyngby_ui_pois_init.m called with incorrect command.') 
    end 

















