function lyngby_ui_preproc(command,parameter1) 

% lyngby_ui_preproc    - UI for setting up preprocessing parameters
%
%       function lyngby_ui_preproc(command,parameter1) 
%
%       This is the function that controls the user interface for the
%       setup of the pre-processing algorithms. The function is
%       automatically called from lyngby_ui_main when the user presses
%       the 'Data Setup...' button. 
%
%       The actual computations for the pre-processing are handled by
%       other files, such as lyngby_normalize.  
%
%       The window handles the choice of pre-preprocessing algorithm.
%       The left column lists the available algorithms - selecting
%       one with the mouse by a single-click results in a
%       description of that algorithm appearing in the middle column.
%       If you want to use this algorithm, double-click on it in
%       the list box, or click on the 'Setup and Run' button. This
%       will bring up a window that's specific to that particular
%       algorithm, allowing choice of parameters etc...and control
%       of the execution of the pre-processing routine. Help for a
%       particular algorithm is provided from within it's respective 
%       window. After a particular algorithm has finished and its 
%       window has closed, a log entry will appear in the right
%       column. This allows you to keep track of several
%       pre-processing stages, including the parameters used and
%       the order in which they were performed. The log can be
%       saved to a file by selecting the 'Save Log' menu item from
%       the 'Options' menu (or via the 'Ctrl-L' shortcut). In
%       addition, you can clear the log record by selecting the
%       'Clear Log' item from the same menu.       
%
%       To view the results of a pre-processing algorithm, press
%       the 'View Data' button. This will call up the standard
%       triple-set of windows normally used for viewing the analyzed
%       data at the next stage. You can then explore the dataset
%       thoroughly. Once you have finished, just use the 'Close
%       all' button and they will disappear. You can do this after
%       each stage of pre-processing if you so wish, keeping
%       several sets of windows open at once, allowing you
%       to examine how the different algorithms modify the data.
%       
%       After you have finished all of the pre-processing, click on the 
%       'Done' button to close the window.
%
%       You can then move on to the analysis of the your
%       pre-processed data.  
%  
%       Tooltips are available from the 'Options' menu, or via the
%       'Ctrl-T' shortcut  
%
%       See also: LYNGBY_NORMALIZE, LYNGBY_PREP_GLOBAL
%
%       Your own routines can be easily added-in here. Within the
%       code for this window are 3 sections where you need to
%       add-in the callbacks for your own code. These sections are
%       marked by the lines:-
%       % <<<<<<<<<< help text in here >>>>>>>>>>
%       with text telling you what you need to do. This will then
%       allow you to put your algorithm title in the list box,
%       along with its description, and will call the window
%       interface for your routine (which I'm afraid you'll need to
%       write yourself!). As an example, a dummy pre-processing
%       algorithm is included to guide you.
%
%       Made with Gui Maker Ver 2.1 by Patrick Marchand

%  Created: 27-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_preproc.m,v 1.21 2001/07/19 08:20:45 mgl Exp $
%       $Revision: 1.21 $    


    lyngby_ui_global;
    lyngby_ui_option;
    lyngby_prep_global;

    % Added this to enable access to PARADIGM etc..
    lyngby_global;

    global RUN          % Workaround for the RUN run.m problem in Windows. 

    
    % --- Tooltips ---

    % This function toggles the state of the tooltips help.
    ToggleTooltips = [ ...
	  'ver = (version);', ...
	  'ver = str2num(ver(1:3));', ...
	  'if ver >= 5.2 & strcmp(get(menuTooltips, ''Checked''), ''on''),',...
	  '  UI_TOOLTIPS = 0;',...
	  '  set(menuTooltips, ''Checked'',''off'');',...
	  '  set(buttonClose, ''TooltipString'','''');',...
	  '  set(buttonHelp, ''TooltipString'','''');',...
	  '  set(buttonViewData, ''TooltipString'','''');',...
	  '  set(buttonSetup, ''TooltipString'','''');',...
	  '  set(listAlgListBox, ''TooltipString'','''');',...
	  '  set(textAlgTextBox, ''TooltipString'','''');',...
	  '  set(listLogTextBox, ''TooltipString'','''');',...
	  'elseif ver >= 5.2,',...
	  '  UI_TOOLTIPS = 1;',...
	  '  set(menuTooltips, ''Checked'',''on'');',...
	  '  set(buttonClose, ''TooltipString'',''Close window, keeping any pre-processing already done'');',...
	  '  set(buttonHelp, ''TooltipString'',''Bring up the Help for this window'');',...
	  '  set(buttonViewData, ''TooltipString'',''Use to examine the results of preprocessing'');',...
	  '  set(buttonSetup, ''TooltipString'',''Parameter-choice and execute-control for the chosen method'');',...
	  '  set(listAlgListBox, ''TooltipString'',''List of preprocessing methods available'');',...
	  '  set(textAlgTextBox, ''TooltipString'',''Description of the selected method'');',...
	  '  set(listLogTextBox, ''TooltipString'',''Log of the methods applied so far'');',...
	  'end,',...
	  ];

    % Create Algorithm List
    % <<<<<<<<<< The title of your algorithm should be added here, >>>>>>>>>>
    % <<<<<<<<<< exactly as you want it to appear in the list box. >>>>>>>>>>
    AlgorithmList = ['Normalization|Detrending|Dummy'...
		    ]; 
    
    % UpdateList
    % Creates the list of methods to put into the List Box
    UpdateList = [ ...
	'set(listAlgListBox, ''String'', AlgorithmList);',...
		 ];
    
    
    % UpdateDescriptions
    % <<<<<<<<<< The description of your algorithm should be added here, >>>>>>>>>>
    % <<<<<<<<<< exactly as you want it to appear in the middle box.     >>>>>>>>>>
    % <<<<<<<<<< Use the algorithm title from the list box in the string >>>>>>>>>>
    % <<<<<<<<<< comparison.                                             >>>>>>>>>>
    % This changes the text in the description box to match the chosen method.
    % It decodes the value of the selected item to an algorithm name.
    UpdateDescriptions = [ ...
	'current_value = get(listAlgListBox, ''Value'');',...
	'indices = [ 0 findstr(AlgorithmList, ''|'') length(AlgorithmList)+1 ];',...
	'SelectedAlgorithm = AlgorithmList(indices(current_value)+1:indices(current_value+1)-1);',...
	'if strcmpi(SelectedAlgorithm, ''Normalization''),',...
	'  set(textAlgTextBox, ''String'', ''This allows removal of unwanted scans from the paradigm and run variables, centering of the paradigm, time-series, run and the volume, and variance normalization'');',...
	' elseif strcmpi(SelectedAlgorithm, ''Detrending''), ',...
	'  set(textAlgTextBox, ''String'', ''This removes a (different) linear trend from each run of the dataset. The trend is calculated using the frames before activation and those at the end of the run, so that effects from the activation are not included.'');',...
	' elseif strcmpi(SelectedAlgorithm, ''Dummy''), ',...
	'  set(textAlgTextBox, ''String'', ''This is a description for the dummy pre-processing algorithm. It is here to allow you to see how your own algorithms can be added into the pre-processing section of Lyngby...'');',...
	' else, ',...
	'  set(textAlgTextBox, ''String'', ''Error - no description for this choice!!'');',...
	'end,',...
		   ];
	  
    % UpdateLog
    % Adds the latest entry to the log box
    UpdateLog = [ ...
	'oldlogfilestring = strvcat(get(listLogTextBox, ''String''));',...
	'newlogfilestring = strvcat(oldlogfilestring,NEW_LOG_STRING);',...
	'PREPROC_LOG=newlogfilestring;',...
	'set(listLogTextBox, ''String'',newlogfilestring);',...
		];

% Code from 'UpdateLog' to determine if log text was longer than
% the box....    
% $$$   'textextent=get(listLogTextBox, ''Extent'');',...
% $$$ 	'if (textextent(4)>0.31);',...
% $$$ 	'  set(textLogTextTitle, ''String'', ''Pre-Processing Log (Top...)'');',...
% $$$ 	'else,',...
% $$$ 	'  set(textLogTextTitle, ''String'', ''Pre-Processing Log'');',...
% $$$ 	'end,',...

    
    if nargin == 0 
      command = 'new'; 
    end 

      if isstr(command) 
	if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	  command = 0; 
	elseif strcmp(lower(command),lower('buttonClose')) 
	  command = 1; 
	elseif strcmp(lower(command),lower('buttonViewData')) 
	  command = 2; 
	elseif strcmp(lower(command),lower('buttonHelp')) 
	  command = 3; 
	elseif strcmp(lower(command),lower('buttonSetup')) 
	  command = 10; 
	elseif strcmp(lower(command),lower('listAlgListBox')) 
	  command = 15;       
	elseif strcmp(lower(command),lower('UpdateLog')) 
	  command = 30; 
	  if isstr(parameter1)
	    NEW_LOG_STRING = parameter1;
	  else
	    % UpdateLog requires a string paramter
	    error('UpdateLog called with invalid (non-string) parameter!');
	  end	  
	elseif strcmp(lower(command),lower('savelog')) 
	  command = 40; 
	elseif strcmp(lower(command),lower('clearlog')) 
	  command = 50; 
	elseif strcmp(lower(command),lower('ToggleTooltips'))
	  command = 100;
	end 
      end 


    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_preproc'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_preproc.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameTop = handle_list (1);
	frameBottom = handle_list(2);
	textAlgListTitle = handle_list(3); 
	textAlgTextTitle = handle_list(4);
	textLogTextTitle = handle_list(5);
	textAlgTextBox = handle_list(6);
	listLogTextBox = handle_list(7);
	listAlgListBox = handle_list(8);
	buttonSetup = handle_list(9);
	buttonViewData = handle_list(10);
	buttonClose = handle_list(11); 
	buttonHelp = handle_list(12); 	
	menuOptions = handle_list(13);
	menuTooltips = handle_list(14);
	menuSaveLog = handle_list(15);
	menuClearLog = handle_list(16);
      end 
    end 


    if command == 0 

      fig = figure('position',[ 280 270 485 225 ],... 
	  'resize','On','tag','lyngby_ui_preproc',... 
	  'menubar','None','name','Lyngby - Data setup',... 
	  'numbertitle','Off','visible','off', ...
	  'color', UI_COLOUR_WINBACK); 
      
      frameleft = 0.015;
      framewidth = 0.97;
      framebottom = 0.015;
      frametop = 0.1693;

      h1 = 0.1;  % Setup button
      h2 = 0.09;  % Bottom row buttons
      h3 = 0.07; % Title heights
      h4 = 0.45; % AlgTextBox height 
      h5 = 0.65; % LogTextBox and AlgListBox height
      
      space = 0.015; % Spacing between columns and edges
      columnwidth = (framewidth-4*space)/3; % Width of the 3 columns
      buttonwidth = columnwidth*0.9; % Make lower buttons narrower
                                     % than the columns...
      
      x1 = frameleft+space;       % Column 1 (left)
      x1a = x1+(columnwidth-buttonwidth)/2; % Left lower button anchor
      x2 = x1+columnwidth+space;  % Column 2 (middle)
      x2a = x2+(columnwidth-buttonwidth)/2; % Middle lower button anchor
      x3 = x2+columnwidth+space;  % Column 3 (right)
      x3a = x3+(columnwidth-buttonwidth)/2; % Right lower button anchor

      y1 = framebottom+0.03; % Bottom buttons
      y2 = 0.20; % AlgListBox and LogTextBox 
      y3 = 0.25; % Setup button
      y4 = 0.40; % AlgTextBox
      y5 = 0.88; % Titles
      
      % Frames
      frameTop = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ frameleft frametop framewidth 0.8124 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameTop',... 
	  'UserData',''); 
      frameBottom = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ frameleft framebottom framewidth 0.15 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameBottom',... 
	  'UserData',''); 

      % Titles etc
      textAlgListTitle = uicontrol(... 
	  'CallBack','lyngby_ui_preproc(''textAlgListTitle'');',...  
	  'Units','normalized',... 
	  'Position',[ x1 y5 columnwidth h3 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','Select an Algorithm:',... 
	  'Style','text',... 
	  'Tag','textAlgListTitle',... 
	  'UserData',''); 
      textAlgTextTitle = uicontrol(... 
	  'CallBack','lyngby_ui_preproc(''textAlgTextTitle'');',...  
	  'Units','normalized',... 
	  'Position',[ x2 y5 columnwidth h3 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','Algorithm Description',... 
	  'Style','text',... 
	  'Tag','textAlgTextTitle',... 
	  'UserData',''); 
      textLogTextTitle = uicontrol(... 
	  'CallBack','lyngby_ui_preproc(''textLogTextTitle'');',...  
	  'Units','normalized',... 
	  'Position',[ x3 y5 columnwidth h3 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'FontSize',10,...
	  'String','Pre-Processing Log',... 
	  'Style','text',... 
	  'Tag','textLogTextTitle',... 
	  'UserData',''); 

      textAlgTextBox = uicontrol(... 
	  'CallBack','lyngby_ui_preproc(''textAlgTextBox'');',...  
	  'Units','normalized',... 
	  'Position',[ x2 y4 columnwidth h4 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'FontSize',10,...
	  'String','A description of each of the algorithms in the box to the left will appear here when you select each algorithm in turn...',... 
	  'Style','text',... 
	  'Tag','textAlgTextBox',... 
	  'UserData',''); 

% Log box was previously just a text box....      
% $$$       textLogTextBox = uicontrol(... 
% $$$ 	  'CallBack','lyngby_ui_preproc(''textLogTextBox'');',...  
% $$$ 	  'Units','normalized',... 
% $$$ 	  'Position',[ x3 y2 columnwidth h5 ],... 
% $$$ 	  'ForegroundColor', UI_COLOR_FRONT,...
% $$$ 	  'BackgroundColor', UI_COLOUR_STATUS,... 
% $$$ 	  'FontSize',10,...
% $$$ 	  'HorizontalAlignment','left',...
% $$$ 	  'String','',... 
% $$$ 	  'Style','text',... 
% $$$ 	  'Tag','textLogTextBox',... 
% $$$ 	  'UserData',''); 

      listLogTextBox = uicontrol(... 
	  'CallBack','lyngby_ui_preproc(''listLogTextBox'');',...  
	  'Units','normalized',... 
	  'Position',[ x3 y2 columnwidth h5 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'FontSize',10,...
	  'HorizontalAlignment','left',...
	  'String','',... 
	  'Style','list',... 
	  'Tag','listLogTextBox',... 
	  'UserData',''); 
      listAlgListBox = uicontrol(... 
	  'CallBack','lyngby_ui_preproc(''listAlgListBox'');',...  
	  'Units','normalized',... 
	  'Position',[ x1 y2 columnwidth h5 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'FontSize',10,...
	  'Max',1,...
	  'Min',1,...
	  'String','List of algorithms will be created here',... 
	  'Style','list',... 
	  'Tag','listAlgListBox',... 
	  'UserData',''); 

      buttonSetup = uicontrol(... 
	  'CallBack','lyngby_ui_preproc(''buttonSetup'');',... 
	  'Units','normalized',... 
	  'Position',[ x2a y3 buttonwidth h1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Setup and Run Algorithm...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSetup',... 
	  'UserData',''); 
      
      
      buttonViewData = uicontrol(... 
	  'CallBack','lyngby_ui_preproc(''buttonViewData'');',... 
	  'Units','normalized',... 
	  'Position',[ x1a y1 buttonwidth h2 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','View Data',... 
	  'Style','pushbutton',... 
	  'Tag','buttonViewData',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_preproc(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ x2a y1 buttonwidth h2 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Done',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_preproc(''buttonHelp'');',... 
	  'Units','normalized',... 
	  'Position',[ x3a y1 buttonwidth h2 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData','');
      


      % -- Menu Definitions etc --
      % Setup Menu controls
      ver = (version);
      ver = str2num(ver(1:3));
      if ver >= 5.2 
	menuOptions = uimenu( ...
	    'Parent',fig,...
	    'Label','Options',...
	    'Tag','TagMenuOptions',...
	    'Visible','on');
	menuTooltips = uimenu(...
	    'Parent',menuOptions,...
	    'Label','&Toggle Tooltips',...
	    'Checked','on',...
	    'Callback','lyngby_ui_preproc(''ToggleTooltips'');',...
	    'Tag','TagMenuTooltips',...
	    'Accelerator','T',...
	    'Visible','on');
	menuSaveLog = uimenu(...
	    'Parent',menuOptions,...
	    'Label','Save Log to File...',...
	    'Checked','off',...
	    'Callback','lyngby_ui_preproc(''SaveLog'');',...
	    'Tag','TagMenuSaveLog',...
	    'Accelerator','L',...
	    'Visible','on');
	menuClearLog = uimenu(...
	    'Parent',menuOptions,...
	    'Label','Clear the Log',...
	    'Checked','off',...
	    'Callback','lyngby_ui_preproc(''ClearLog'');',...
	    'Tag','TagMenuclearLog',...
	    'Accelerator','',...
	    'Visible','on');
      else
	menuOptions = 0;
	menuTooltips = 0;
      end
      
      % Test global Tooltips settings and set this window to the same
      if UI_TOOLTIPS == 0  
	eval(ToggleTooltips);
      end


      handle_list = [ ...  
	  frameTop frameBottom ...
	  textAlgListTitle textAlgTextTitle textLogTextTitle textAlgTextBox ...
	  listLogTextBox listAlgListBox buttonSetup buttonViewData ...
	  buttonClose buttonHelp menuOptions menuTooltips menuSaveLog menuClearLog ...
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 

      % Initialise algorithm list %
      eval(UpdateList);  % Create list of methods
      chosenmethod = 1;  % Set default to first on list....

      % If PREPROC_LOG isn't empty, then put it into the log-box
      if length(PREPROC_LOG) ~= 0
	NEW_LOG_STRING=PREPROC_LOG;
	eval(UpdateLog);
      end
      
    
    
    elseif command == 1 
      %%%%% buttonDone selected %%%%%

      % 'Done' button
      close(gcf);

      %%%%%%%  Need to close 'View Data' windows as well? %%%%%%%%

      % Update button accessibility in main window
      lyngby_ui_main('UpdateButtonEnabling');
      
    elseif command == 2 
      %%%%% buttonViewData selected %%%%%
      
      % Call the resultview triple set with the %
      % current preprocessed data here.         %

       if exist('X_MEAN') & ~isempty(X_MEAN) 	
 	lyngby_uis_none_v;
       else
 	lyngby_ui_message(['The data has not been preprocessed. You need to ' ...
 			   'at least ''normalize'' the data before you ' ...
 			   'can view it. ']);
       end

    elseif command == 3 
      %%%%% buttonHelp selected %%%%%

      helpwin('lyngby_ui_preproc')
         
    elseif command == 10 
      %%%%% buttonSetup (Call algorithm window) selected %%%%%
      
      % Evaluate the selected algorithm %
      % <<<<<<<<<< Again using the algorithm name from the list box, >>>>>>>>>>
      % <<<<<<<<<< add-in the code here to call your own window      >>>>>>>>>>
      % <<<<<<<<<< containing the interface to your pre-processing   >>>>>>>>>>
      % <<<<<<<<<< routine.                                          >>>>>>>>>>
      % <<<<<<<<<< Remember to add-in the following code at the end  >>>>>>>>>>
      % <<<<<<<<<< just before your code returns. This updates the   >>>>>>>>>>
      % <<<<<<<<<< log with the latest changes to the data performed >>>>>>>>>>
      % <<<<<<<<<< by your routine. Remember not to add-in a log     >>>>>>>>>>
      % <<<<<<<<<< entry if the routine is cancelled. Use a cell     >>>>>>>>>>
      % <<<<<<<<<< array string if you want multi-line entries.      >>>>>>>>>>      
      % <<<<<<<<<<  local_log_string=' # Algorithm X completed. Param 1 param 2 param 3'; >>>>>>>>>>
      % <<<<<<<<<<  lyngby_ui_preproc('UpdateLog', local_log_string);                     >>>>>>>>>>
      %
      selected_alg_num = get(listAlgListBox, 'Value');
      indices = [ 0 findstr(AlgorithmList, '|') length(AlgorithmList)+1 ];
      SELECTED_ALGORITHM = AlgorithmList(indices(selected_alg_num)+1:indices(selected_alg_num+1)-1);

      % Now call relevant window %
      if strcmp(lower(SELECTED_ALGORITHM), lower('Normalization'))
	% Algorithm 1 chosen (' ')
        Chosen_method = 'Normalization';
        lyngby_ui_preproc_normalize;
      
      elseif strcmp(lower(SELECTED_ALGORITHM), lower('Detrending'))
	% Algorithm 2 chosen (' ')
        Chosen_method = 'Detrending';
	% Check whether data has had the time-mask applied first
	if ((exist('R')==1)&(isempty(R)~=1)), % If R exists, and is non-zero then
					      %  the Time Mask has been applied to the data
	  lyngby_ui_preproc_detrend;
	else
	  lyngby_ui_message(['The R variable does not seem to exist. This' ...
			     ' is required in order to calculate the location' ...
			     ' of the detrend frames. Maybe you haven''t' ...
			     ' applied the Time Mask to the RUN variable' ...
			     ' yet - goto the Normalization window (from' ...
			     ' the main ''Data Setup'' window), and press' ...
			     ' the ''Setup Design'' button. (Remember to' ...
			     ' DESELECT the centering options in the right' ...
			     '-hand frame, as these will invalidate the detrending' ...
			     ' process.) Press the ''Process Design'' button' ...
			     ' if you want the PARADIGM variable to be' ...
			     ' normalised too, and then press the ''Apply''' ...
			     ' button to close the window. If you haven''t' ...
			     ' loaded the RUN variable at all, or you want' ...
			     ' to check it, use the ''Create/Edit External' ...
			     ' Influences'' button in the main window to' ...
			     ' bring up the Run and Paradigm interface.']);
	  % Close any already opened detrend windows...
	  close(findobj(get(0,'children'),'flat','tag','lyngby_ui_preproc_detrend'));
	end
	
	      
      elseif strcmp(lower(SELECTED_ALGORITHM), lower('Dummy'))
	% Algorithm ? chosen (' ')
        Chosen_method = 'Dummy';
	lyngby_ui_preproc_dummy;
      	
      else
	% Error - Unknown selection
      end

    elseif command == 15
      %%%%% listAlgListBox item selected %%%%%
      %%%%% (Event on the Algorithm list) %%%%%
      
      %%%%%%%% Evaluate which item has been chosen and set   %%%%%%%%%
      %%%%%%%% description field. If double click, then also %%%%%%%%%
      %%%%%%%% open relevant setup window %%%%%%%
      	
      chosenmethod = get(listAlgListBox, 'Value'); % Extract index of chosen method
      eval(UpdateDescriptions);  % Put relevant description in box
      
      if strcmp(get(gcf, 'SelectionType'), 'normal')
	% single click on item
	singleclick=1;
	doubleclick=0;
      elseif strcmp(get(gcf, 'SelectionType'), 'open')
	% double click on item
	singleclick=0;
	doubleclick=1;
	lyngby_ui_preproc('buttonSetup');
      end
            
    elseif command == 30 
      %%%%% UpdateLog callback selected (Internal callback from spawned
      %%%%%   preprocessing windows 
    
    eval(UpdateLog);
      
    elseif command == 40 
      %%%%% savelog selected %%%%%
      
      % Testing for updatelog callback - this is to eventually be
      % called within each called-algorithm just before it returns...      
      %    teststring='# Algorithm X Param 1 param 2 param 3',
      %    lyngby_ui_preproc('UpdateLog', teststring);
      
    
      % Open file browser
      [sfile,spath] = uiputfile('lyngby_preproc_logfile.txt', 'Save your Preprocessing Logfile as: '); 
	if sfile ~= 0, 
	  sfilename = [ spath sfile ];
	  PREPROC_LOG;
	  filestatus=0;
	  Outputstring='';
	  fhandle=fopen(sfilename, 'wt');
	  [fmessage, ferrnum]=ferror(fhandle);
	  if ferrnum ~= 0 
	    error(sprintf('Could not open file!! Error Message:- %s', fmessage));
	  else
	    % Header info for the file
	    fprintf(fhandle, 'Pre-Processing Log File \n');
	    fprintf(fhandle, '======================= \n');
	    fprintf(fhandle, '\n');
	    % Write out the log
	    OutputCell=cellstr(PREPROC_LOG);
%	    OutputString=strcat(PREPROC_LOG);
%	    entries=length(strmatch('#',PREPROC_LOG));
	    entries=length(OutputCell);
	    if entries ~= 0
	      for count=1:entries
		fprintf(fhandle, OutputCell{count, 1});
		fprintf(fhandle, '\n');
	      end
	    else
	      % Log string has no entries
	      fprintf(fhandle, 'Empty log record!');
	    end
	    status=fclose(fhandle);
	    if status ~= 0, 
	      error('File not closed!!!');
	      lyngby_ui_message(sprintf('Preprocessing Logfile not saved!'));
	    else
	      lyngby_ui_message(sprintf('Preprocessing Logfile saved as  %s !', sfile));
	    end
	  end
	end  
	    
    elseif command == 50 
      %%%%% clearlog selected %%%%%
      set(listLogTextBox, 'String','');
      PREPROC_LOG='';
      NEW_LOG_STRING='';
      eval(UpdateLog);
          
    elseif command == 100
      %%%%% Toggle the state of the Tooltips help (on/off) %%%%%
      eval(ToggleTooltips);

    else 
      error('Error: lyngby_ui_preproc.m called with incorrect command.') 
    end
    
    
