function lyngby_ui_preproc_dtplot(command,parameter1)

% lyngby_ui_preproc_dtplot       - User interface for time mask specification
%
%	function lyngby_ui_preproc_dtplot(command,parameter1) 
%	function lyngby_ui_preproc_dtplot
%
%       Used to plot the frames used in Cyril's detrend alg.
%       This function is called be lyngby_ui_preproc_detrend.
%
%       See also: lyngby_ui_preproc_detrend, lyngby_global
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Created: 26-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_preproc_dtplot.m,v 1.1 2001/05/31 15:32:23 mgl Exp $
%       $Revision: 1.1 $    
	
    lyngby_global
    lyngby_ui_global
    lyngby_ui_option

    global FULL_INDEX_DETREND % So it's accessible from the plot, and easy to update

    UpdateAxesRun = [ ...
	  'S = transpose(R);',...
	  'axes(AxesRun);',...
	  'imagesc(S);',...
	  'set(AxesRun,''YTickMode'',''manual'');',...
	  'set(AxesRun,''XTickMode'',''manual'');',...
	  'title(''Run Function (Each run is a different colour)'');',...
	  ];
%	  'colormap([[0 0 0];[1 1 1]]);',...

    UpdateAxesDetrend = [ ...
	  'S = FULL_INDEX_DETREND;',...
	  'onI = find(S);',...
	  'offI = find(S==0);',...
	  'axes(AxesDetrend);',...
	  'cla reset;',...
	  'hold on;',...
	  'numscans=length(P);',...
	  'if ~isempty(P) & length(R) == length(P),',...
	  '  plot(1:numscans,P, ''-'');'...
	  '  plot(onI,P(onI), ''xr'');',...
	  '  plot(offI,P(offI), ''og'');',...
	  '  if numscans > 1,', ...
	  '    axis([1 numscans min(P)-0.1 '...
	    '    max(P)+0.1]);',...
	  '  end,',...
	  'elseif numscans > 1,',...
	  '  axis([1 numscans 0 1]);',...
	  'end,',...
	  'xlabel(''Sample/Scan Number'');',...
	  'ylabel(''Activation Level'');',...
	  'title(''Paradigm Function, With Detrend Frames in Red'');', ...
	  'hold off;',...
	  ];

    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonUpdate')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 3; 
      elseif strcmp(lower(command), 'update') 
	command = 1000; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_preproc_dtplot');
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_preproc_dtplot.'); 
      end  
      handle_list = get(h_fig_list,'userdata');
      if length(handle_list) > 0 
	frameControl = handle_list(1);
	buttonClose = handle_list(2); 
	buttonUpdate = handle_list(3); 
	buttonHelp = handle_list(4); 
	AxesRun = handle_list(5); 
	AxesDetrend = handle_list(6); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 218 55 500 230 ],... 
	  'resize','On','tag','lyngby_ui_preproc_dtplot',... 
	  'menubar','None','name','Lyngby - Detrend Frames Plot',... 
	  'numbertitle','Off','visible','off', ...
	  'Color', UI_COLOUR_FRAME); 

      ButtonHeight = 0.1;
      ButtonRow1 = 0.05;

      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_WINBACK,...
          'Position',[ 0.08 0.025 0.84 0.15 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 
            
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_dtplot(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.39 ButtonRow1 0.22 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
     
      buttonUpdate = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_dtplot(''buttonUpdate'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.12 ButtonRow1 0.22 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Update plot',... 
	  'Style','pushbutton',... 
	  'Tag','buttonUpdate',...
	  'Visible','on',...
	  'Enable','on',...
	  'UserData',''); 

      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_dtplot(''buttonHelp'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.66 ButtonRow1 0.22 ButtonHeight ],... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
       

      %  Menu Object Creation 


      %  Axes and Text Object Creation 

      AxesRun = axes(... 
	  'Units','normalized', ... 
	  'Position',[ 0.08 0.24 0.84 0.02 ],... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],...
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Clipping','on', ... 
	  'Tag','AxesRun', ... 
	  'Box','off',...
	  'UserData',''); 
      AxesDetrend = axes(... 
	  'Units','normalized', ... 
	  'Position',[ 0.08 0.50 0.84 0.39 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],...                
	  'Clipping','on', ... 
	  'Tag','AxesDetrend', ... 
	  'UserData',''); 

      % Create initial variables

      startIndex = 1;
      stopIndex = length(P);
      
      
      handle_list = [frameControl buttonClose buttonUpdate buttonHelp ... 
	  AxesRun AxesDetrend ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 

      eval(UpdateAxesDetrend);
      eval(UpdateAxesRun);


    elseif command == 1 
      %disp('buttonClose selected.') 

      close(gcf);

    elseif command == 2 
      %disp('buttonUpdate selected.') 

      % Load new variables from main window, and then update the plots.
      
      % Update plots
      eval(UpdateAxesRun);
      eval(UpdateAxesDetrend);
      
    elseif command == 3 
      %disp('buttonHelp selected.') 
      
      s1 = [...
            'In this window you can view the detrend ', ...
            'frames and their relationship to the RUN and ',...
            'PARADIGM variables. ',...
            ];
      s2 = [...
            ];
      s3 = [...
            ];
      s4 = [...
            ];
      s10 = [...
            'Function: lyngby_ui_preproc_dtplot' ...
            ];
      s11 = [...
            'See also: lyngby_global' ...
            ];
      
      helpdlg(sprintf('%s\n\n%s\n%s', s1, s10, s11),...
      'Viewing of the detrend frames')   
      
      
    elseif command == 1000
      %disp('Update.') 

      eval(UpdateAxesRun);
      eval(UpdateAxesDetrend);
      
    else 
      error('Error: lyngby_ui_preproc_dtplot.m called with incorrect command.') 
    end 







