function lyngby_ui_preproc_dummy(command,parameter1) 

% lyngby_ui_preproc_dummy    - UI for setting up preprocessing parameters
%
%       function lyngby_ui_preproc_dummy(command,parameter1) 
%
%       This is the function that controls the user interface for the
%       setup of the preprocessing parameters. The function is
%       automatically called from lyngby_ui_preproc when the user
%       chooses the 'Dummy' algorithm from the list box. 
%       The actual computations for the preprocessing is handle by
%       lyngby_dummy.  
%
%
%       See also: LYNGBY_NORMALIZE, LYNGBY_PREP_GLOBAL
%
%       Made with Gui Maker Ver 2.1 by Patrick Marchand

%  Created: 27-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_preproc_dummy.m,v 1.1 2000/10/03 14:49:12 mgl Exp $
%       $Revision: 1.1 $    


    lyngby_ui_global;
    lyngby_ui_option;
    lyngby_prep_global;

    % Added this to enable access to PARADIGM etc..
    lyngby_global;

    global RUN            % Workaround for the RUN run.m problem in Windows. 
    global DUMMY_LOG      % Local log record
    % --- Tooltips ---

    % This function toggles the state of the tooltips help.
    ToggleTooltips = [ ...
	  'ver = (version);', ...
	  'ver = str2num(ver(1:3));', ...
	  'if ver >= 5.2 & strcmp(get(menuTooltips, ''Checked''), ''on''),',...
	  '  UI_TOOLTIPS = 0;',...
	  '  set(menuTooltips, ''Checked'',''off'');',...
	  '  set(buttonClose, ''TooltipString'','''');',...
	  '  set(buttonApply, ''TooltipString'','''');',...
	  '  set(buttonHelp, ''TooltipString'','''');',...
	  '  set(checkCentering, ''TooltipString'','''');',...
	  'elseif ver >= 5.2,',...
	  '  UI_TOOLTIPS = 1;',...
	  '  set(menuTooltips, ''Checked'',''on'');',...
	  '  set(buttonClose, ''TooltipString'',''Close window without doing pre-processing'');',...
	  '  set(buttonApply, ''TooltipString'',''Close window and do the selected pre-processing'');',...
	  '  set(buttonHelp, ''TooltipString'',''Help for this window'');',...
	  '  set(checkCentering, ''TooltipString'',''Dummmy pre-processing command - no action taken'');',...
	  'end,',...
	  ];
    


    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 3; 
      elseif strcmp(lower(command),lower('checkCentering')) 
	command = 8; 
      elseif strcmp(lower(command),lower('checkNormalize')) 
	command = 9; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 17; 
      elseif strcmp(lower(command),lower('ToggleTooltips'))
	command = 100;

      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_preproc_dummy'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_preproc_dummy.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameTop = handle_list(1);
	frameBottom = handle_list(2);
	textTopTitle = handle_list(3);

	buttonClose = handle_list(4); 
	buttonApply = handle_list(5); 
	buttonHelp = handle_list(6); 

	checkCentering = handle_list(7); 
	checkNormalize = handle_list(8); 
	
	menuOptions = handle_list(9);
	menuTooltips = handle_list(10);
      end 
    end 


    if command == 0 

      fig = figure('position',[ 230 188 450 250 ],... 
	  'resize','On','tag','lyngby_ui_preproc_dummy',... 
	  'menubar','None','name','Lyngby - Pre-Processing - Normalization',... 
	  'numbertitle','Off','visible','off', ...
	  'color', UI_COLOUR_WINBACK); 

      h1 = 0.1;  % Standard buttons
      h2 = 0.1; % Bottom row buttons
      h3 = 0.16; % Main Title height
      h4 = 0.25; % Minor Title height 

      x1 = 0.04;
      x2 = 0.3;
      x3 = 0.76;

      w1 = 0.3;
      w2 = 0.4;
      w3 = 0.1;
      w4 = 0.44; % Minor Title width

      y1 = 0.015;    % Bottom frame
      y2 = 0.025+y1; % Bottom row buttons
      y3 = 0.20;
      y4 = 0.35;
      y5 = 0.50;
      y6 = 0.65;
      y7 = 0.80;
      y8 = 0.57;
      y9 = 0.27;

      % Frames
      frameTop = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.0172 0.1693 0.9655 0.8124 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameTop',... 
	  'UserData',''); 
      frameBottom = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.0172 y1 0.9655 0.15 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameBottom',... 
	  'UserData',''); 

      % Titles etc
      textTopTitle = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_dummy(''textTopTitle'');',...  
	  'Units','normalized',... 
	  'Position',[ x2 0.5 w2 0.4 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','This pane controls the (dummy) preprocessing applied to the data. Select those which are required for your analysis, then press the ''Apply and Close'' button below to effect the pre-processing. Otherwise, just press ''Cancel'' to close and return to the main pre-processing control window.',... 
	  'Style','text',... 
	  'Tag','textTopTitle',... 
	  'UserData',''); 

      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_dummy(''buttonApply'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 y2 0.4 h2 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Apply Pre-Processing and Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_dummy(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ x1 y2 0.2 h2 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Cancel',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_dummy(''buttonHelp'');',... 
	  'Units','normalized',... 
	  'Position',[ x3 y2 0.2 h2 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData','');
      
      checkCentering = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_dummy(''checkCentering'');',... 
	  'HorizontalAlignment','left',... 
	  'Units','normalized',... 
	  'Position',[ 0.3 0.35 w2 h1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Dummy pre-processing alg. 1',... 
	  'Style','checkbox',... 
	  'Value',[ 1 ],... 
	  'Tag','checkCentering',... 
	  'UserData',''); 
      checkNormalize = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_dummy(''checkNormalize'');',... 
	  'HorizontalAlignment','left',... 
	  'Units','normalized',... 
	  'Position',[ 0.3 0.2 w2 h1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Dummy pre-processing alg. 2',... 
	  'Style','checkbox',... 
	  'Value',[ 1 ],... 
	  'Tag','checkNormalize',... 
	  'UserData',''); 

      % -- Menu Definitions etc --
      % Setup Menu controls
      ver = (version);
      ver = str2num(ver(1:3));
      if ver >= 5.2 
	menuOptions = uimenu( ...
	    'Parent',fig,...
	    'Label','Options',...
	    'Tag','TagMenuOptions',...
	    'Visible','on');
	menuTooltips = uimenu(...
	    'Parent',menuOptions,...
	    'Label','&Toggle Tooltips',...
	    'Checked','on',...
	    'Callback','lyngby_ui_preproc_dummy(''ToggleTooltips'');',...
	    'Tag','TagMenuTooltips',...
	    'Accelerator','T',...
	    'Visible','on');
      else
	menuOptions = 0;
	menuTooltips = 0;
      end
      
      % Test global Tooltips settings and set this window to the same
      if UI_TOOLTIPS == 0  
	eval(ToggleTooltips);
      end


      handle_list = [ ...  
	    frameTop frameBottom ...
	    textTopTitle ...
	    buttonClose buttonApply buttonHelp ... 
	    checkCentering  checkNormalize ... 
	    menuOptions ...
	    menuTooltips ...
	    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 

      % Initialize local log string...
      DUMMY_LOG = '# Dummy normalizing routines:';

    elseif command == 1 
      %disp('buttonClose selected.') 

      % 'Cancel' button
      close(gcf);

    elseif command == 2 
      %disp('buttonApply selected.') 
      % This 'applies' the dummy pre-processing if it is selected.
      % The log string is updated respectively. 
      % The window is then closed, and the logstring written into
      % the main pre-processing window's log-box.
      
      if get(checkCentering, 'Value'),
	% Selected dummy algorithm 1 for processing....
	% So, set log string in main preprocessing window...
	DUMMY_LOG = strvcat(DUMMY_LOG, ' - Alg 1 selected.');	
      else
	% Dummy pre-proc algorithm not selected
	DUMMY_LOG = strvcat(DUMMY_LOG, ' - Alg 1 NOT selected.');		
      end

      if get(checkNormalize, 'Value'),
	% Selected dummy algorithm 2 for processing....
	% So, set log string in main preprocessing window...
	DUMMY_LOG = strvcat(DUMMY_LOG, ' - Alg 2 selected.');	
      else
	% Dummy pre-proc algorithm not selected
	DUMMY_LOG = strvcat(DUMMY_LOG, ' - Alg 2 NOT selected.');		
      end
      
      % Update the log-box in the main pre-processing window
      DUMMY_LOG = strvcat(DUMMY_LOG, ' Dummy pre-proc. finished.');		
      lyngby_ui_preproc('UpdateLog', DUMMY_LOG); 
      
      % Now close window...
      close(gcf);
	

    elseif command == 3 
      %disp('buttonHelp selected.') 

      helpwin('lyngby_ui_preproc_dummy')
      
    elseif command == 8 
      %disp('checkCentering selected.') 
      
    elseif command == 9 
      %disp('checkNormalize selected.') 

    elseif command == 100
      % Toggle the state of the Tooltips help (on/off)
      eval(ToggleTooltips);

    else 
      error('Error: lyngby_ui_preproc_dummy.m called with incorrect command.') 
    end
    
    
