function lyngby_ui_preproc_normalize(command,parameter1) 

% lyngby_ui_preproc_normalize    - UI for setting up preprocessing parameters
%
%       function lyngby_ui_preproc_normalize(command,parameter1) 
%
%       This is the function that controls the user interface for the
%       setup of the preprocessing parameters. The function is
%       automatically called from lyngby_ui_main when the user presses
%       the Preprocessing button. 
%
%       The actual computations for the preprocessing is handle by
%       lyngby_normalize.  
%
%       The mean for each voxel over its entire time-series can be
%       removed. The voxel time-series can also be scale to unit
%       variance. The final two choices remove the mean in each run
%       and removes the mean in each image.
%
%       Normalization of the design variables is controlled by the
%       lyngby_ui_externals functions.
%
%       See also LYNGBY, LYNGBY_NORMALIZE, LYNGBY_PREP_GLOBAL,
%                LYNGBY_UI_MAIN, LYNGBY_UI_EXTERNALS.
%
% $Id: lyngby_ui_preproc_normalize.m,v 1.3 2003/05/23 16:54:32 fnielsen Exp $
      
% Made with Gui Maker Ver 2.1 by Patrick Marchand
%
%  Created: 27-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


    lyngby_ui_global;
    lyngby_ui_option;
    lyngby_prep_global;

    % Added this to enable access to PARADIGM etc..
    lyngby_global;

    global RUN            % Workaround for the RUN run.m problem in Windows. 
    global NORMALIZE_LOG  % Local log record
    % --- Tooltips ---

    % This function toggles the state of the tooltips help.
    ToggleTooltips = [ ...
	  'ver = (version);', ...
	  'ver = str2num(ver(1:3));', ...
	  'if ver >= 5.2 & strcmp(get(menuTooltips, ''Checked''), ''on''),',...
	  '  UI_TOOLTIPS = 0;',...
	  '  set(menuTooltips, ''Checked'',''off'');',...
	  '  set(buttonClose, ''TooltipString'','''');',...
	  '  set(buttonApply, ''TooltipString'','''');',...
	  '  set(buttonHelp, ''TooltipString'','''');',...
	  '  set(checkCentering, ''TooltipString'','''');',...
	  '  set(checkNormalization, ''TooltipString'','''');',...
	  '  set(checkRunCentering, ''TooltipString'','''');',...
	  '  set(checkImageCentering, ''TooltipString'','''');',...
	  '  set(buttonSetupDesign, ''TooltipString'','''');',...
	  '  set(buttonHSetupDesign, ''TooltipString'','''');',...
	  '  set(buttonProcessDesign, ''TooltipString'','''');',...
	  '  set(buttonHProcessDesign, ''TooltipString'','''');',...
	  'elseif ver >= 5.2,',...
	  '  UI_TOOLTIPS = 1;',...
	  '  set(menuTooltips, ''Checked'',''on'');',...
	  '  set(buttonClose, ''TooltipString'',''Close window without doing pre-processing'');',...
	  '  set(buttonApply, ''TooltipString'',''Close window and do the selected pre-processing'');',...
	  '  set(buttonHelp, ''TooltipString'',''Help for this window'');',...
	  '  set(checkCentering, ''TooltipString'',''Removes the mean from the entire time-series (i.e. for one voxel)'');',...
	  '  set(checkNormalization, ''TooltipString'',''Normalization to the unit variance per voxel (use only when required)'');',...
	  '  set(checkRunCentering, ''TooltipString'',''Removes the mean of each run for each voxel'');',...
	  '  set(checkImageCentering, ''TooltipString'',''Removes the mean of each scan'');',...
	  '  set(buttonSetupDesign, ''TooltipString'',''Applies TIME MASK to PARADIGM and RUN, resulting in P and R'');',...
	  '  set(buttonHSetupDesign, ''TooltipString'',''Help for Setup Design'');',...
	  '  set(buttonProcessDesign, ''TooltipString'',''Centres P, resulting in PN'');',...
	  '  set(buttonHProcessDesign, ''TooltipString'',''Help for Process Design'');',...
	  'end,',...
	  ];
    
    ReadFields = [ ...
	  'bOk = 0;',...
	  '[TempGaussWidth, count1] = sscanf(get(editTempGaussWidth, ''String''), ''%f'');',...
	  '[SVDComponents, count2] = sscanf(get(editSVDComponents , ''String''), ''%d'');',...
	  '[SpatGaussWidth, count3] = sscanf(get(editSpatGaussWidth, ''String''), ''%f'');',...
	  'if count1 ~= 1,',...
	  '  error(''The width for the temporal gaussian filter must be a single float'');',...
	  'elseif count2 ~= 1,',...
	  '  error(''The components for the SVD filter must be a single integer'');',...
	  'elseif count3 ~= 1,',...
	  '  error(''The width for the spatial gaussian filter must be a single float'');',...
	  'elseif TempGaussWidth<0,',...
	  '  error(''The width of the gaussian filter should be larger than 0'');',...
	  'elseif SVDComponents<0,',...
	  '  error(''The number of SVD components should be larger than 0'');',...
	  'else,',...
	  '  PREP_CENTERING	= get(checkCentering, ''Value'');', ...
	  '  PREP_RUNCENTERING = get(checkRunCentering, ''Value'');', ...
	  '  PREP_IMAGECENTERING = get(checkImageCentering, ''Value'');',...
	  '  PREP_NORMALIZATION = get(checkNormalization, ''Value'');', ...
	  '  PREP_TEMPGAUSS = get(checkTempGauss, ''Value'');', ...
	  '  PREP_SVDFILTER = get(checkSVDFilter, ''Value'');', ...
	  '  PREP_SPATGAUSS = get(checkSpatGauss, ''Value'');', ...
	  '  PREP_SVDCOMPONENTS = SVDComponents;',...
	  '  bOk = 1;',...
	  'end,',...
	  ];


    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 3; 
      elseif strcmp(lower(command),lower('checkSVDFilter')) 
	command = 4; 
      elseif strcmp(lower(command),lower('checkSpatGauss')) 
	command = 5; 
      elseif strcmp(lower(command),lower('checkTempGauss')) 
	command = 7; 
      elseif strcmp(lower(command),lower('checkCentering')) 
	command = 8; 
      elseif strcmp(lower(command),lower('checkNormalization')) 
	command = 9; 
      elseif strcmp(lower(command),lower('editSVDComponents')) 
	command = 10; 
      elseif strcmp(lower(command),lower('editSpatGaussWidth')) 
	command = 11; 
      elseif strcmp(lower(command),lower('editTempGaussWidth')) 
	command = 13; 
      elseif strcmp(lower(command),lower('checkRunCentering')) 
	command = 15; 
      elseif strcmp(lower(command),lower('checkImageCentering')) 
	command = 16; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 17; 
	% New buttons...
      elseif strcmp(lower(command),lower('buttonSetupDesign')) 
	command = 18; 
      elseif strcmp(lower(command),lower('buttonHSetupDesign')) 
	command = 19; 
      elseif strcmp(lower(command),lower('buttonProcessDesign')) 
	command = 20; 
      elseif strcmp(lower(command),lower('buttonHProcessDesign')) 
	command = 21; 

      elseif strcmp(lower(command),lower('ToggleTooltips'))
	command = 100;

      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_preproc_normalize'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_preproc_normalize.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameLeft = handle_list (1);
	frameRight = handle_list(2);
	frameBottom = handle_list(3);
	textLeftTitle = handle_list(4); 
	textRightTitle = handle_list(5);
	textSetupTitle = handle_list(6);
	textProcessTitle = handle_list(7);
	buttonClose = handle_list(8); 
	buttonApply = handle_list(9); 
	buttonHelp = handle_list(10); 
	checkSVDFilter = handle_list(11); 
	checkSpatGauss = handle_list(12); 
	checkTempGauss = handle_list(13); 
	checkCentering = handle_list(14); 
	checkNormalization = handle_list(15); 
	editSVDComponents = handle_list(16); 
	editSpatGaussWidth = handle_list(17); 
	editTempGaussWidth = handle_list(18); 
	textSVDComponents = handle_list(19); 
	textSpatGaussWidth = handle_list(20); 
	textTempGaussWidth = handle_list(21); 
	checkRunCentering = handle_list(22);
	checkImageCentering = handle_list(23);
	buttonSetupDesign = handle_list(24);
	buttonHSetupDesign = handle_list(25);
	buttonProcessDesign = handle_list(26);
	buttonHProcessDesign = handle_list(27);
	
	menuOptions = handle_list(28);
	menuTooltips = handle_list(29);
      end 
    end 


    if command == 0 

      fig = figure('position',[ 230 188 450 250 ],... 
	  'resize','On','tag','lyngby_ui_preproc_normalize',... 
	  'menubar','None','name','Lyngby - Pre-Processing - Normalization',... 
	  'numbertitle','Off','visible','off', ...
	  'color', UI_COLOUR_WINBACK); 

      h1 = 0.1;  % Standard buttons
      h2 = 0.1; % Bottom row buttons
      h3 = 0.16; % Main Title height
      h4 = 0.25; % Minor Title height 

      x1 = 0.04;
      x2 = 0.54;
      x3 = 0.37;

      w1 = 0.3;
      w2 = 0.4;
      w3 = 0.1;
      w4 = 0.44; % Minor Title width

      y1 = 0.015;    % Bottom frame
      y2 = 0.025+y1; % Bottom row buttons
      y3 = 0.20;
      y4 = 0.35;
      y5 = 0.50;
      y6 = 0.65;
      y7 = 0.80;
      y8 = 0.57;
      y9 = 0.27;

      % Frames
      frameLeft = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.019 0.1693 0.4879 0.8124 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameLeft',... 
	  'visible', 'off', ...
	  'UserData',''); 
      frameRight = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.02 0.1693 0.96 0.8124 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameRight',... 
	  'UserData',''); 
      frameBottom = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.0172 y1 0.9655 0.15 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameBottom',... 
	  'UserData',''); 

      % Titles etc
      textLeftTitle = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''textLeftTitle'');',...  
	  'Units','normalized',... 
	  'Position',[ x1 y7 w4 h3 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String', [ ...
	    'This pane removes any unwanted scans from the paradigm ' ...
	    'and run variables, and any vertical offset from the ' ...
	    'paradigm.' ],... 
	  'Style','text',... 
	  'Tag','textLeftTitle',... 
	  'visible', 'off', ...
	  'UserData',''); 
      textRightTitle = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''textRightTitle'');',...  
	  'Units','normalized',... 
	  'Position',[ 0.05 0.76 0.9 0.2 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String', [ ...
	    'This pane controls the preprocessing applied to the ' ...
	    'data. Select those which are required for your ' ...
	    'analysis, then press the ''Apply'' button below.' ...
	    ],... 
	  'Style','text',... 
	  'Tag','textRightTitle',... 
	  'UserData',''); 
      textSetupTitle = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''textSetupTitle'');',...  
	  'Units','normalized',... 
	  'Position',[ x1 y5 w4 h4 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'FontSize',10,...
	  'String','Setup the design for the data',... 
	  'Style','text',... 
	  'Tag','textSetupTitle',... 
	  'visible', 'off', ...
	  'UserData',''); 
      textProcessTitle = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''textProcessTitle'');',...  
	  'Units','normalized',... 
	  'Position',[ x1 y3 w4 h4 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'FontSize',10,...
	  'String','Process the design for the data',... 
	  'Style','text',... 
	  'Tag','textProcessTitle',... 
	  'visible', 'off', ...
	  'UserData',''); 

      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''buttonApply'');',... 
	  'Units','normalized',... 
	  'Position',[ x1 y2 0.43 h2 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Apply Pre-Processing and Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 y2 0.18 h2 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Cancel',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''buttonHelp'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.76 y2 0.18 h2 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData','');
      
      % New 'Design' buttons
      buttonSetupDesign = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''buttonSetupDesign'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ x1 y8 w1 h1 ],... 
	  'String','Setup design!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSetupDesign',... 
	  'Visible', 'off', ...
	  'UserData',''); 
      buttonHSetupDesign = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''buttonHSetupDesign'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ x3 y8 w3 h1 ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHSetupDesign',... 
  	  'Visible', 'off', ...
	  'UserData',''); 
      buttonProcessDesign = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''buttonProcessDesign'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ x1 y9 w1 h1 ],... 
	  'String','Process design!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonProcessDesign',... 
	  'Visible', 'off', ...
	  'UserData',''); 
      buttonHProcessDesign = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''buttonHProcessDesign'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ x3 y9 w3 h1 ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHProcessDesign',... 
	  'Visible', 'off', ...
	  'UserData',''); 

      checkSVDFilter = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''checkSVDFilter'');',... 
	  'HorizontalAlignment','left',... 
	  'Units','normalized',... 
	  'Position',[ 0.04 0.36 0.29 0.07 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','SVD filtering',... 
	  'Style','checkbox',... 
	  'Value',[ 1 ],... 
	  'Tag','checkSVDFilter',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      checkSpatGauss = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''checkSpatGauss'');',... 
	  'HorizontalAlignment','left',... 
	  'Units','normalized',... 
	  'Position',[ 0.04 0.44 0.29 0.07 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Spatial gaussian filtering',... 
	  'Style','checkbox',... 
	  'Tag','checkSpatGauss',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      checkTempGauss = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''checkTempGauss'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.04 0.64 0.29 0.07 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Temporal Gaussian Filtering',... 
	  'Style','checkbox',... 
	  'Value',[ 1 ],... 
	  'Tag','checkTempGauss',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      checkCentering = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''checkCentering'');',... 
	  'HorizontalAlignment','left',... 
	  'Units','normalized',... 
	  'Position',[ 0.3 y6 w2 h1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Removal of mean per time series',... 
	  'Style','checkbox',... 
	  'Value',[ 1 ],... 
	  'Tag','checkCentering',... 
	  'UserData',''); 
      checkNormalization = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''checkNormalization'');',... 
	  'Units','normalized',... 
	  'HorizontalAlignment','left',... 
	  'Position',[ 0.3 y5 w2 h1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Variance normalization',... 
	  'Style','checkbox',... 
	  'Tag','checkNormalization',... 
	  'UserData',''); 
      editSVDComponents = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''editSVDComponents'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.51 0.36 0.5 0.1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editSVDComponents',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      editSpatGaussWidth = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''editSpatGaussWidth'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.51 0.44 0.5 0.1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editSpatGaussWidth',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      editTempGaussWidth = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''editTempGaussWidth'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.51 0.64 0.5 0.1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editTempGaussWidth',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      textSVDComponents = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''textSVDComponents'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.35 0.36 0.5 0.1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Components:',... 
	  'Style','text',... 
	  'Tag','textSVDComponents',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      textSpatGaussWidth = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''textSpatGaussWidth'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.35 0.44 0.5 0.1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Width:',... 
	  'Style','text',... 
	  'Tag','textSpatGaussWidth',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      textTempGaussWidth = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''textTempGaussWidth'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.35 0.64 0.15 0.07 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Width:',... 
	  'Style','text',... 
	  'Tag','textTempGaussWidth',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      checkRunCentering = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''checkRunCentering'');',... 
	  'HorizontalAlignment','left',... 
	  'Units','normalized',... 
	  'Position',[ 0.3 y4 w2 h1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Removal of mean per run',... 
	  'Style','checkbox',... 
	  'Value',[ 1 ],... 
	  'Tag','checkRunCentering',... 
	  'UserData',''); 
      checkImageCentering = uicontrol(... 
	  'CallBack','lyngby_ui_preproc_normalize(''checkImageCentering'');',... 
	  'HorizontalAlignment','left',... 
	  'Units','normalized',... 
	  'Position',[ 0.3 y3 w2 h1 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Removal of volume mean',... 
	  'Style','checkbox',... 
	  'Value',[ 1 ],... 
	  'Tag','checkImageCentering',... 
	  'UserData',''); 


      % -- Menu Definitions etc --
      % Setup Menu controls
      ver = (version);
      ver = str2num(ver(1:3));
      if ver >= 5.2 
	menuOptions = uimenu( ...
	    'Parent',fig,...
	    'Label','Options',...
	    'Tag','TagMenuOptions',...
	    'Visible','on');
	menuTooltips = uimenu(...
	    'Parent',menuOptions,...
	    'Label','&Toggle Tooltips',...
	    'Checked','on',...
	    'Callback','lyngby_ui_preproc_normalize(''ToggleTooltips'');',...
	    'Tag','TagMenuTooltips',...
	    'Accelerator','T',...
	    'Visible','on');
      else
	menuOptions = 0;
	menuTooltips = 0;
      end
      
      % Test global Tooltips settings and set this window to the same
      if UI_TOOLTIPS == 0  
	eval(ToggleTooltips);
      end

      set(checkCentering, 'Value', PREP_CENTERING);
      set(checkRunCentering, 'Value', PREP_RUNCENTERING);
      set(checkImageCentering, 'Value', PREP_IMAGECENTERING);
      set(checkNormalization, 'Value', PREP_NORMALIZATION);
      set(checkTempGauss, 'Value', PREP_TEMPGAUSS);
      set(checkSVDFilter, 'Value', PREP_SVDFILTER);
      set(checkSpatGauss, 'Value', PREP_SPATGAUSS);

      set(editTempGaussWidth, 'String', num2str(PREP_TEMPGAUSSWIDTH));
      set(editSVDComponents, 'String', num2str(PREP_SVDCOMPONENTS));
      set(editSpatGaussWidth, 'String', num2str(PREP_SPATGAUSSWIDTH));

      handle_list = [ ...  
	    frameLeft frameRight frameBottom ...
	    textLeftTitle textRightTitle textSetupTitle textProcessTitle ...
	    buttonClose buttonApply buttonHelp ... 
	    checkSVDFilter checkSpatGauss checkTempGauss ... 
	    checkCentering checkNormalization editSVDComponents editSpatGaussWidth ... 
	    editSVDComponents editTempGaussWidth textSpatGaussWidth ... 
	    textTempGaussWidth checkRunCentering checkImageCentering ... 
	    buttonSetupDesign buttonHSetupDesign buttonProcessDesign buttonHProcessDesign ...
	    menuOptions ...
	    menuTooltips ...
	    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 

      % Initialize local log string...
      NORMALIZE_LOG = '# Normalizing routines:';

    elseif command == 1 
      %disp('buttonClose selected.') 

      % 'Cancel' button
      close(gcf);

    elseif command == 2 
      %disp('buttonApply selected.') 
      % This 'applies' pre-processing variables, and then runs the pre-processing routine. 
      % The window is then closed.
      
      % Read pre-processing variables...
      eval(ReadFields);
      
      % Now run the Preprocess routine ('PreProcess Go!' button) from the original main window...
      
      if (size(X,1)==0)
	lyngby_ui_message('The data has not been loaded. Press: Load data!');
      elseif PREP_RUNCENTERING & isempty(R)

	lyngby_ui_message([...
	      'You have switched on run-centering ',...
	      '(removal of mean in each run) ',...
	      'for the data, ',...
	      'But the run specification ''R'' is not set up. ',...
	      'Press: ''Setup design!'' or disable run-centering']);
      else

	% Preprocess
	lyngby_log('Preprocessing beginning ...');
	[XN, X_MEAN, X_STD, X_SEQMEAN, X_SEQSTD] = ...
	    lyngby_normalize(X,...
	    'Centering', PREP_CENTERING,...
	    'RunCentering', PREP_RUNCENTERING,...
	    'Run', R,...
	    'ImageCentering', PREP_IMAGECENTERING, ...
	    'Normalization', PREP_NORMALIZATION);

	if PREP_SVDFILTER
	  lyngby_log('SVD filtering beginning ...');
	  XN = lyngby_svdfilter(XN, 'FilterComp', PREP_SVDCOMPONENTS);
	  lyngby_log('SVD filtering completed!');
	  NORMALIZE_LOG = strvcat(NORMALIZE_LOG, ' SVD Filtering completed.');
	end

	% Work out log-file string
	if PREP_CENTERING | PREP_RUNCENTERING | PREP_IMAGECENTERING ...
	      | PREP_NORMALIZATION,
	  NORMALIZE_LOG = strvcat(NORMALIZE_LOG, ' Performed these methods:- ');
	end
	if PREP_CENTERING, 
	  NORMALIZE_LOG = strvcat(NORMALIZE_LOG, '  - Removed mean/time series.');
	end
	if PREP_RUNCENTERING, 
	  NORMALIZE_LOG = strvcat(NORMALIZE_LOG, '  - Removed mean/run.');
	end
	if PREP_IMAGECENTERING, 
	  NORMALIZE_LOG = strvcat(NORMALIZE_LOG, '  - Removed volume mean.');
	end
	if PREP_NORMALIZATION, 
	  NORMALIZE_LOG = strvcat(NORMALIZE_LOG, '  - Variance normalization.');
	end
	lyngby_log('Preprocessing completed!');

	% Set log string in main preprocessing window...
	NORMALIZE_LOG = strvcat(NORMALIZE_LOG, ' Normalizing completed.');	
	lyngby_ui_preproc('UpdateLog', NORMALIZE_LOG); 
	
	% Now close window...
	close(gcf);
	
      end

      lyngby_ui_main('UpdateButtonEnabling');
      

    elseif command == 3 
      %disp('buttonHelp selected.') 

      helpwin('lyngby_ui_preproc_normalize')
      
    elseif command == 4 
      %disp('checkSVDFilter selected.') 

    elseif command == 5 
      %disp('checkSpatGauss selected.') 

    elseif command == 7 
      %disp('checkTempGauss selected.') 

    elseif command == 8 
      %disp('checkCentering selected.') 

    elseif command == 9 
      %disp('checkNormalization selected.') 

    elseif command == 10 
      %disp('editSVDComponents selected.') 

    elseif command == 11 
      %disp('editSpatGaussWidth selected.') 


    elseif command == 13 
      %disp('editTempGaussWidth selected.') 

    elseif command == 15 
      %disp('checkRunCentering selected.') 

    elseif command == 16
      %disp('checkImageCentering selected.') 

      % New buttons...

    elseif command == 18
      % Setup Design
      % NORMALIZE_LOG = strvcat(NORMALIZE_LOG, ' Design setup completed.');

    elseif command == 19
      % Help for Setup Design
      S1 = [...
	    'This applies the TIME MASK variable to the PARADIGM ',...
	    'and RUN variables, resulting in modified versions, ',...
	    'P and R, from which any unwanted scans will have been removed.', ...
	    ];
      helpdlg(sprintf('%s', S1), 'Setup design!');

    elseif command == 20
      % Process Design

    elseif command == 21
      % Help for Process Design
      S1 = [...
	    'This will centre the P design variable (i.e. ',...
	    'remove the vertical offset, or "DC", component), resulting in PN. This ',...
	    'is a necessary step for those analysis algorithms ',...
	    'that require a zero-mean paradigm.',...
	    ];
      helpdlg(sprintf('%s\n%s', S1), 'Process design!');

    elseif command == 100
      % Toggle the state of the Tooltips help (on/off)
      eval(ToggleTooltips);

    else 
      error('Error: lyngby_ui_preproc_normalize.m called with incorrect command.') 
    end
    
    
