function lyngby_ui_run(command,parameter1) 

% lyngby_ui_run        - User interface for run viewing/specification 
%
%       function lyngby_ui_run(command,parameter1) 
%       function lyngby_ui_run
%
%       This function controls the window for the RUN global variable.
%
%       The window enables you to view and edit the RUN global
%       variable, which defines the run specification. You can also
%       load in an existing RUN variable in .m or .mat format. If the
%       RUN variable is to be specified purely by typing in the number
%       of runs, note that this number must be exactly divisible into
%       the total number of scans. 
%
%       Choose the method of defining the run from the pop-up list,
%       then hit the 'Go' button.
%
%       See also LYNGBY, LYNGBY_UI_RUN_NO, LYNGBY_RUN, LYNGBY_UI_GLOBAL.
%
% $Id: lyngby_ui_run.m,v 1.15 2002/05/08 13:14:28 fnielsen Exp $

%  Made with: Gui Maker Ver 2.1 by Patrick Marchand 
%
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


    lyngby_global
    lyngby_ui_global
    lyngby_ui_option
    global RUN      % Workaround for problem with RUN run.m in Windows.
    
    Update = [ ...
	  'axes(axesRun);', ...
	  'if (exist(''RUN'') ~= 1) | isempty(RUN),', ...
	  '  title(''No run defined'');', ...
	  'else,', ...
	  '  plot(1:length(RUN),RUN, ''-'', 1:length(RUN),RUN, ''o'');', ...
	  '  axis([1 length(RUN) min(RUN)-0.1 max(RUN)+0.1]);', ...
	  '  xlabel(''Sample/Scan Number'');', ...
	  '  ylabel(''Run Number'');', ...
	  '  title(''Run Function'');', ...
	  'end,', ...
	  ];
	   
     
     if nargin == 0 
       command = 'new'; 
     end 


     if isstr(command) 

       if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	 command = 0; 
       elseif strcmp(lower(command),lower('buttonClose')) 
	 command = 1; 
       elseif strcmp(lower(command),lower('buttonHelp')) 
	 command = 2; 
       elseif strcmp(lower(command),lower('buttonAction')) 
	 command = 3; 
       elseif strcmp(lower(command),lower('popupType')) 
	 command = 4; 
       elseif strcmp(lower(command),lower('axesRun')) 
	 command = 5; 
       elseif strcmp(lower(command), 'update') 
	command = 1000; 
       end 
     end 
     


     if command ~= 0 
       h_fig_list = findobj(get(0,'children'),'flat',... 
	   'tag','lyngby_ui_run'); 
       if length(h_fig_list) > 1 
	 h_fig_list = gcf; 
       elseif length(h_fig_list) == 0 
	 error('There are no figures with Tag = lyngby_ui_run.'); 
       end 
       handle_list = get(h_fig_list,'userdata'); 
       if length(handle_list) > 0 
         frameControl = handle_list(1);
	 buttonAction = handle_list(2);
	 popupType = handle_list(3);
	 buttonClose = handle_list(4);
	 buttonHelp = handle_list(5);
	 axesRun = handle_list(6); 
	end 
      end 


      if command == 0 
	
	fig = figure('position',[ 218 55 500 230 ],... 
	    'resize','on','tag','lyngby_ui_run',... 
	    'visible','off',...
	    'name', 'lyngby - Run setup',...
	    'numbertitle', 'off',...
	    'color', UI_COLOUR_FRAME); 
	
	ButtonHeight = 0.1;
	ButtonRow1 = 0.05;
	yHigh = 0.17;
	
	frameControl = uicontrol(...
	    'Units','normalized',... 
	    'ForegroundColor',UI_COLOR_FRONT,... 
	    'BackgroundColor',UI_COLOUR_WINBACK,...
	    'Position',[ 0.08 0.025 0.84 0.15 ],... 
	    'String','',... 
	    'Style','frame',... 
	    'Tag','framecontrol',... 
	    'UserData',''); 


	buttonClose = uicontrol(... 
	    'Callback', 'lyngby_ui_run(''buttonClose'')',...
	    'ForegroundColor', UI_COLOR_FRONT,...
	    'BackgroundColor', UI_COLOUR_BUTTON,...
	    'String','Close',... 
	    'Style','pushbutton',... 
	    'Units','normalized',... 
	    'Position',[ 0.62 ButtonRow1 0.14 ButtonHeight ],...
	    'Tag','buttonClose',... 
	    'UserData',''); 
	buttonHelp = uicontrol(... 
	    'Callback', 'lyngby_ui_run(''buttonHelp'')',...
	    'ForegroundColor', UI_COLOR_FRONT,...
	    'BackgroundColor', UI_COLOUR_BUTTON,...
	    'String','Help',... 
	    'Style','pushbutton',... 
	    'Units','normalized',... 
	    'Position',[ 0.77 ButtonRow1 0.14 ButtonHeight ],...
	    'Tag','buttonHelp');

	
	buttonAction = uicontrol(... 
	    'Callback', 'lyngby_ui_run(''buttonAction'')',...
	    'ForegroundColor', UI_COLOR_FRONT,...
	    'BackgroundColor', UI_COLOUR_BUTTON,...
	    'String','Go!',... 
	    'Style','pushbutton',... 
	    'Units','normalized',... 
	    'Position',[ 0.49 ButtonRow1 0.07 ButtonHeight ],...
	    'Tag','buttonAction',... 
	    'UserData',''); 
	popupType = uicontrol(... 
	    'CallBack','lyngby_ui_run(''popupType'');',... 
	    'ForegroundColor',UI_COLOR_FRONT,... 
	    'BackgroundColor',UI_COLOUR_BUTTON,...
	    'Units','normalized',... 
	    'Position',[ 0.09 ButtonRow1 0.39 ButtonHeight ],... 
	    'HorizontalAlignment','left',... 
	    'String',[...
	      'Choose a command, then press Go!|',...
	      'Reset|', ...
	      'Specify a run by hand...|',...
              'Load (.mat) ...|',...
	      'Load from data_run.m|',...
	      'Reread lyngby_run.m|',...
	      'Save As (.mat) ...|',...
	      'Save to data_run.mat',...
	      ],...
	    'Style','popupmenu',... 
	    'Tag','popupType',... 
	    'UserData',''); 


	
		
	%  Axes and Text Object Creation 
	
	axesRun = axes(... 
	    'Units','normalized', ... 
	    'Position',[ 0.08 0.34 0.84 0.56 ],... 
	    'Xgrid','off', ... 
	    'Ygrid','off', ... 
	    'Xlim',[ 0 1 ],... 
	    'Ylim',[ 0 1 ],... 
	    'Clipping','on', ... 
	    'Tag','axesRun', ... 
	    'UserData',''); 

	handle_list = [ ...  
              frameControl ...
	      buttonAction popupType ...
	      buttonClose buttonHelp ...
	      axesRun ... 
	      ]; 

	set(gcf,'userdata',handle_list); 
	drawnow;pause(.1); 
	set(gcf,'visible','on'); 


	eval(Update);
	

      elseif command == 1 
	%disp('buttonClose selected.') 

	lyngby_ui_run_no('Close');
	close(gcf)
      
      elseif command == 2 	

	helpwin('lyngby_ui_run');
	
	
      elseif command == 3 

	
	actionType = get(popupType, 'Value');
	
	if actionType == 1
	  % Dummy entry acting as an instruction - do nothing
	
	elseif actionType == 2
          % Reset
	  RUN = ones(NUM_SCANS,1);
	  eval(Update);
	  
	elseif actionType == 3
          % Specify the RUN by hand
	  lyngby_ui_run_no;
	  
	elseif actionType == 4
          % Load a RUN variable from a *.mat file
	  [file, path] = uigetfile('*', 'Load run file');
	  if file ~= 0, 
	    file = [ path file ];
	    eval(['load ' file]);
	    eval(Update);
	  end
	  
	elseif actionType == 5
          % Load a RUN variable from the data_run.m file
	  clear data_run
	  if exist('data_run') == 2
	    eval('r = data_run;');
	    if ~length(r)
	      lyngby_ui_message([...
		    '''data_run.m'' function did not return any values. ' ...
		    ]);
	    else
	      RUN = r(:);
	    end
	  else 
	    lyngby_ui_message([...
		  '''data_run.m'' function does not exists. ' ...
		  'The user should define this.' ...
	      ]);
	  end

	  eval(Update);
	  
	elseif actionType == 6
          % Re-specify the RUN variable from lyngby_run.m
	  RUN = lyngby_run;
	  
	  if isempty(RUN) 
	    lyngby_ui_message([...
		  'lyngby_run.m did not return anything' ...
		  ]);
	  end

	  eval(Update);
	  
	elseif actionType == 7
	  % Save the current RUN variable as a *.mat file
	  if exist('RUN') & ~isempty(RUN)
	    [file, path] = uiputfile('*.mat', 'Save run As');
	    if file ~= 0, 
	      file = [ path file ];
	      ver = version;
	      if str2num(ver(1)) >= 5
		eval(['save ' file ' RUN -v4']);
	      else
		eval(['save ' file ' RUN']);
	      end
	    end
	  else
	    lyngby_ui_message([...
		  'There is no run specification. '...
		  'Please use ''specify'' or write a file where '...
		  'it is defined.'...
		  ]);
	  end
	  
	elseif actionType == 8
          % Save the current RUN variable to the data_run.mat file
	  if ~isempty(RUN)
	    ver = version;
	    if str2num(ver(1)) >= 5
	      save data_run RUN -v4
	    else
	      save data_run RUN
	    end
	  else
	    lyngby_ui_message([...
		  'There is no run specification. '...
		  'Please use ''specify'' or write a file where '...
		  'it is defined.'...
		  ]);
	  end

	else
	  
	  error('Ops, wrong actionType');
	  
	end
	  
      elseif command == 4 
      
      elseif command == 5

      
      elseif command == 1000
	%disp('Update.') 
	
	eval(Update);

      
      else 
	error('Error: lyngby_ui_run.m called with incorrect command.') 
      end 

