function lyngby_ui_run_no(command,parameter1) 

% lyngby_ui_run_no       - User interface for run specification
%
%       function lyngby_ui_run_no(command,parameter1) 
%       function lyngby_ui_run_no
%
%       Simple user interface for setting up the RUN global variable. 
%
%       Only designs with an equal number of scans in each run can be
%       set up with this interface. Thus there should be no remainder
%       after dividing the number of scans with the number of runs.
%
%       Pressing 'Apply' will update RUN global variable from
%       lyngby_global.
%
%       See also LYNGBY, LYNGBY_UI_RUN, LYNGBY_GLOBAL. 
%
% $Id: lyngby_ui_run_no.m,v 1.7 2002/05/08 13:13:28 fnielsen Exp $

%	Made with: Gui Maker Ver 2.1 by Patrick Marchand 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


    lyngby_global
    lyngby_ui_global
    lyngby_ui_option

    global RUN   % Workaround for the RUN run.m problem in Windows.

    % get startIndex and stopIndex
    ReadFields = [ ...
	  '[noScans, countNoScans] = sscanf(get(editNoScans, ''String''),''%d'');',...
	  '[noRuns, countNoRuns] = sscanf(get(editNoRuns, ''String''),''%d'');',...
	  'if countNoScans ~= 1,',...
	  '  error(''Number of scans must be a single integer'');',...
	  'elseif countNoRuns ~= 1,',...
	  '  error(''Number of runs must be a single integer'');',...
	  'else,',...
	  '  if noScans<1,',... 
	  '    noScans = 1;',...
	  '    set(editNoScans, ''String'', ''1'');',...
	  '  end,',...
	  '  rest = lyngby_mod(noScans, noRuns);',...
	  '  if rest,',... 
	  '    noRuns = 1;',...
	  '    set(editNoRuns, ''String'', num2str(noRuns));',...
	  '  end,',...
	  'end,'... 
	  ];


    Update = [ ...
	  'NUM_SCANS = noScans;',...
	  'RUN = lyngby_kronadd((0:(noRuns-1))'', ones(noScans/noRuns,1));',...
	  ];
	  
	  
    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editNoRuns')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editNoScans')) 
	command = 5; 
      elseif strcmp(lower(command),lower('Close')) 
	command = 1000; 
      end 
    end 

    if command ~= 0 & command ~= 1000
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_run_no'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_run_no.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonClose = handle_list(4); 
	buttonApply = handle_list(5); 
	buttonHelp = handle_list(6); 
	editNoRuns = handle_list(7); 
	editNoScans = handle_list(8); 
	textNoRuns = handle_list(9); 
	textNoScans = handle_list(10); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 200 250 300 200 ],... 
	  'resize','On','tag','lyngby_ui_run_no',... 
	  'menubar','None','name','lyngby - Run - Specify run',... 
	  'numbertitle','Off','visible','off', ...
	  'Color', UI_COLOUR_WINBACK); 

      ButtonHeight = 0.12;
      ButtonWidth = 0.20;
      ControlHeight = ButtonHeight;
      ButtonColumn1 = 0.15;
      ButtonColumn2 = 0.40;
      ButtonColumn3 = 0.65;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.73;
      Row2 = 0.55;
      Row3 = 0.35;
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_run_no(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String', [ ...
	    'Specify the number of scans and runs for ' ...
	    'this dataset. Note that the number of scans ' ...
	    'must be divisible by the number of runs.' ...
	    ],... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.1 Row1 0.8 0.20 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
      
      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_run_no(''buttonApply'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.15 0.06 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_run_no(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.40 0.06 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_run_no(''buttonHelp'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.65 0.06 ButtonWidth ButtonHeight ],... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
      
      textNoScans = uicontrol(... 
	  'CallBack','lyngby_ui_run_no(''textNoScans'');',... 
	  'HorizontalAlignment','right',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Total number of scans:',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row2 0.43 ControlHeight ],... 
	  'Tag','textNoScans',... 
	  'UserData',''); 
      editNoScans = uicontrol(... 
	  'CallBack','lyngby_ui_run_no(''editNoScans'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Units','normalized',... 
	  'Position',[ 0.5 Row2 0.3 ControlHeight ],... 
	  'Tag','editNoScans',... 
	  'UserData',''); 

      textNoRuns = uicontrol(... 
	  'CallBack','lyngby_ui_run_no(''textNoRuns'');',... 
	  'HorizontalAlignment','right',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Total number of runs:',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row3 0.43 ControlHeight ],... 
	  'Tag','textNoRuns',... 
	  'UserData',''); 
      editNoRuns = uicontrol(... 
	  'CallBack','lyngby_ui_run_no(''editNoRuns'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.5 Row3 0.3 ControlHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editNoRuns',... 
	  'UserData',''); 


      [Runs, ScansPerRun] = lyngby_runinfo(RUN);
      if isempty(Runs)
	Runs = 1;
      end
      
      set(editNoScans, 'String', num2str(NUM_SCANS));
      set(editNoRuns, 'String', num2str(Runs));

      handle_list = [ ...  
	    frameEdit frameControl textTitle ...
	    buttonClose buttonApply  buttonHelp ... 
	    editNoRuns editNoScans textNoRuns textNoScans ... 
	    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonClose selected.') 

      close(gcf);

    elseif command == 2 
      %disp('buttonApply selected.') 

      eval(ReadFields);
      eval(Update);
      lyngby_ui_run('Update');
      
      
    elseif command == 3
      %disp('buttonHelp selected.') 

      helpwin('lyngby_ui_run_no')
  
    elseif command == 4 
      %disp('editNoRuns selected.') 

    elseif command == 5 
      %disp('editNoScans selected.') 
    
    elseif command == 1000
      
      fig = findobj('tag','lyngby_ui_run_no');
      if fig == 1
	close(fig);
      elseif fig > 1
	for f = 1:length(fig)
	  close(fig(f));
	end
      end
      
    else 
      error('Error: lyngby_ui_run_no.m called with incorrect command.') 
    end 






