function lyngby_ui_saveresult(command,parameter1) 

% lyngby_ui_saveresult	- Opens a window for specifying file parameters. 
%
%	function lyngby_ui_saveresult(command,parameter1)
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand

%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_saveresult.m,v 1.4 2001/07/02 13:26:44 mgl Exp $
%       $Revision: 1.4 $    


    lyngby_global;
    lyngby_ui_global;
    lyngby_ui_option;


    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('popupVariable')) 
	command = 1; 
      elseif strcmp(lower(command),lower('popupFileType')) 
	command = 2; 
      elseif strcmp(lower(command),lower('editFileName')) 
	command = 3; 
      elseif strcmp(lower(command),lower('buttonBrowse')) 
	command = 4; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 5; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 6; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 7; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_saveresult'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_saveresult.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	textVariable = handle_list(1);
	popupVariable = handle_list(2);
	textFileType = handle_list(3);
	popupFileType = handle_list(4);
	textFileName = handle_list(5);
	editFileName = handle_list(6);
	buttonBrowse = handle_list(7); 
	buttonApply = handle_list(8); 
	buttonClose = handle_list(9); 
	buttonHelp = handle_list(10);
      end 
    end 


    if command == 0 

      fig = findobj(get(0,'children'),'flat','tag','lyngby_ui_saveresult'); 
      if length(fig) > 0 
	set(fig,'visible','on'); 
	figure(fig); 
	return; 
      end 
      fig = figure('position',[ 300 450 400 200 ],... 
	  'resize','On','tag','lyngby_ui_saveresult',... 
	  'menubar','None','name', 'lyngby - Save Results',... 
	  'numbertitle','Off','visible','off','color',UI_COLOR_BACK); 

      %  Uicontrol Object Creation 

      x1 = 0.02;
      x2 = 0.15;
      w1 = 0.12;
      w2 = 0.8;
      
      h1 = 0.12;     % Height of controls
      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_saveresult(''buttonApply'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.15 0.1 0.2 h1 ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 	    	    
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_saveresult(''buttonClose'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.4 0.1 0.2 h1 ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_saveresult(''buttonHelp'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.65 0.1 0.2 h1 ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textVariable = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'CallBack','lyngby_ui_saveresult(''textVariable'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 0.80 w1 h1],... 
	  'String','Variable:',... 
	  'Style','text',... 
	  'Tag','textVariable',... 
	  'UserData',''); 
      popupVariable = uicontrol(... 
	  'CallBack','lyngby_ui_saveresult(''popupVariable'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'HorizontalAlignment','left',... 
	  'Position',[ x2 0.80 w2 h1 ],... 
	  'String', ...
	  [ 'All|', ...
	    'RESULT_FIR       FIR filter coefficients|', ...
	    'RESULT_KS        Kolmogorov-Smirnov', ...
	    ], ...
	  'Style','popupmenu',... 
	  'Tag','popupVariable',... 
	  'UserData',''); 

      textFileType = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'CallBack','lyngby_ui_saveresult(''textFileType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 0.62 w1 h1 ],... 
	  'String','Filetype:',... 
	  'Style','text',... 
	  'Tag','textFilePath',... 
	  'UserData',''); 
      popupFileType = uicontrol(... 
	  'CallBack','lyngby_ui_saveresult(''popupFileType'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'HorizontalAlignment','left',... 
	  'Units','normalized',... 
	  'Position',[ x2 0.62 w2 h1 ],... 
	  'String', [...
	    'Matlab binary|', ...
	    'Matlab ascii|', ...
	    'ANALYZE|',...
	    'SDT|',...
	    'VAPET Volume'],...
	  'Style','popupmenu',... 
	  'Tag','popupFileType',... 
	  'UserData',''); 

      textFileName = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'CallBack','lyngby_ui_saveresult(''textFileName'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 0.44 w1 h1 ],... 
	  'String','Filename:',... 
	  'Style','text',... 
	  'Tag','textFileName',... 
	  'UserData',''); 
      editFileName = uicontrol(... 
	  'CallBack','lyngby_ui_saveresult(''editFileName'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'HorizontalAlignment','left',... 
	  'Units','normalized',... 
	  'Position',[ x2 0.44 0.64 h1 ],... 
	  'String','lyngby_RESULTS.mat',... 
	  'Style','edit',... 
	  'Tag','editFileName',... 
	  'UserData',''); 
      buttonBrowse = uicontrol(... 
	  'CallBack','lyngby_ui_saveresult(''buttonBrowse'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.80 0.44 0.15 h1 ],... 
	  'String','Browse...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonBrowse',... 
	  'UserData','');
      

      handle_list = [ ...  
	    textVariable popupVariable ...
	    textFileType popupFileType  ...
	    textFileName editFileName buttonBrowse ... 
	    buttonApply buttonClose buttonHelp ...
	    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 
      
      
      
    elseif command == 1 
      % popupVariable

      filetype = get(popupFileType, 'value');
      if filetype == 1 
	% Matlab binary
	filename = 'lyngby_RESULTS.mat';
        set(popupFileType, 'value', 1);
      else
	sVariable = get(popupVariable, 'string');
	sVariable = sVariable(get(popupVariable, 'value'));
	indexBlank = findstr(sVariable, ' ');
	sVariable = sVariable(1:indexBlank-1);

	filename = sVariable;
      end


      set(editFileName, 'string', filename);
      
    elseif command == 2 
      % popupFileType
      
      filename = get(editFileName, 'string');
      if isempty(filename)
	filename = 'lyngby_RESULT';
      end
      
      dots = findstr(filename, '.');
      if dots
	ldot = dots(length(dots));
	if ldot > 1
	  filename = filename(1:ldot-1);
	else
	  filename = '';
	end
      end

      filetype = get(popupFileType, 'value');
      if filetype == 1 
	% Matlab binary
	filename = [filename '.mat'];
      elseif filetype == 2 
	% Matlab ascii
	filename = [filename '.asc'];
      elseif filetype == 3
	% ANALYZE
	filename = [filename '.img'];
      elseif filetype == 4
	% SDT
	filename = [filename '.sdt'];
      elseif filetype == 5
	% VAPET 
	filename = [filename '.vap'];
      else
	error('Ops, unknown filetype');
      end

      set(editFileName, 'string', filename);
      
    elseif command == 3 
      % editFileName

    elseif command == 4

      % buttonBrowse
      [file,path] = uigetfile('*','Choose a file');
      if file ~= 0, 
	set(editFileName, 'string', file);
      end
      
    elseif command == 5 
      % buttonApply

      variable = get(popupVariable, 'value');
      filetype = get(popupFileType, 'value');
      filename = get(editFileName, 'string');
      
      if variable == 1
	if filetype == 1 
	  % Matlab

	  lyngby_log('Saving all results ...');
	  eval(['save ' filename ...
		' RESULT_CC  RESULT_FIR RESULT_FIR_CONV ' ...
		'RESULT_LZ RESULT_LZGS RESULT_LZIT ',...
		'RESULT_KM_CENTER RESULT_KM_ASSIGN ',... 
		'RESULT_BAT RESULT_BAF ',...
		'RESULT_TS PROB_TS ',...
		'RESULT_MKM_CENTER RESULT_MKM_ASSIGN ',...
		'RESULT_KS PROB_KS ',...
		'RESULT_NNR_E RESULT_NNR_Y ',...
		'RESULT ',...
		'-v4']);
	  lyngby_log('All results saved!');
	  
	else
	  errordlg(['Only filetypes ''Matlab binary'' ', ...
		'can save all results']);
	end
      else	
	if filetype == 1
	  % Matlab binary

	elseif filetype == 2
	  % Matlab ascii

	
	elseif filetype == 3
	  % ANALYZE
	  
	elseif filetype == 4
	  % SDT
	  
	elseif filetype == 5
	  % VAPET 
	  
	else
	  error('Ops, unknown filetype');
	end
      end

      
    elseif command == 6 
      % buttonClose

      close(h_fig_list);
      
    elseif command == 7 
      % buttonHelp

      helpdlg('Nothing here yet', 'Help to save result');
      
    else 
      error('Error: lyngby_ui_saveresult.m called with incorrect command.') 
    end 





















































