function lyngby_ui_scva_init(command,parameter1) 

% lyngby_ui_scva_init  - GUI for init of Strother CVA
%
%	function lyngby_ui_scva_init(command,parameter1)
%       function lyngby_ui_scva_init
%       
%       See also: lyngby_scva_main, lyngby_ui_main
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Created: 5-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_scva_init.m,v 1.4 2001/07/02 13:26:44 mgl Exp $ 
%       $Revision: 1.4 $

    lyngby_scva_global;
    lyngby_ui_option;
    
    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editRidgeX')) 
	command = 5; 
      elseif strcmp(lower(command),lower('editComponents')) 
	command = 6; 

      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_scva_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_scva_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonApply = handle_list(4); 
	buttonClose = handle_list(5); 
	editRidgeX = handle_list(6); 
	textRidgeX = handle_list(7); 
	buttonHelp = handle_list(8); 
	textComponents = handle_list(9);
	editComponents = handle_list(10);
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 400 350 200 ],... 
	  'resize','On','tag','lyngby_ui_scva_init',... 
	  'menubar','Figure','name','lyngby - Strother CVA',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.12;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row2 = 0.32; % Lower buttons
      Row3 = 0.48; % Middle buttons
      Row4 = 0.54; % Upper buttons
      Row5 = 0.68; % Lower title
      Row6 = 0.82; % Upper title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_scva_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the Strother CVA algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 0.9 0.25 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 

      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_scva_init(''buttonApply'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_scva_init(''buttonClose'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_scva_init(''buttonHelp'');',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textRidgeX = uicontrol(... 
	  'CallBack','lyngby_ui_scva_init(''textRidgeX'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_BACK,... 
	  'HorizontalAlignment','center',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row3 LabelWidth ButtonHeight ],... 
	  'String','Canonical ridge parameter:',... 
	  'Style','text',... 
	  'Tag','textRidgeX',... 
	  'UserData',''); 
      editRidgeX = uicontrol(... 
	  'CallBack','lyngby_ui_scva_init(''editRidgeX'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column5 Row3 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editRidgeX',... 
	  'UserData',''); 

      textComponents = uicontrol(... 
	  'CallBack','lyngby_ui_scva_init(''textComponents'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_BACK,... 
	  'HorizontalAlignment','center',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row2 LabelWidth ButtonHeight ],... 
	  'String','No of Components:',... 
	  'Style','text',... 
	  'Tag','textComponents',... 
	  'UserData',''); 
      editComponents = uicontrol(... 
	  'CallBack','lyngby_ui_scva_init(''editComponents'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column5 Row2 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editComponents',... 
	  'UserData',''); 
      

      set(editRidgeX, 'String', sprintf('%g', SCVA_RIDGEX));
      set(editComponents, 'String', num2str(SCVA_COMPONENTS));


      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonApply buttonClose ... 
	  editRidgeX textRidgeX buttonHelp ... 
	  textComponents editComponents ...
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [scva_RidgeX, count1] = sscanf(get(editRidgeX, 'String'), '%f'); 
      if (count1==1 & scva_RidgeX >= 0 & scva_RidgeX <= 1) 
	SCVA_RIDGEX = scva_RidgeX; 
      else 
	error('RidgeX must be integer and in the interval [0;1].'); 
      end 

      [scva_components, count1] = sscanf(get(editComponents, 'String'), '%d'); 
      if (count1==1 & scva_components > 0) 
	SCVA_COMPONENTS = scva_components; 
      else 
	error('Components must be integer and larger than 0.'); 
      end 

      lyngby_log('New parameters updated')
      
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command == 4
      %disp('buttonHelp selected.') 
      s1 = [...
            'This window allows you to set the parameters used for ' ...
            'the Strother CVA algorithm: '...
            ];
      s2 = [...
            '* ''No. of Components:''  Number of canonical values ' ...
	    'maintained. ',...
            ];
      s3 = [...
            '* ''Canonical ridge parameter:''  Canonical ridge ',...
	    'parameter for the datamatrix. ', ...
            ];

      s10 = [...
            'Function: lyngby_ui_scva_init' ...
            ];

      helpdlg(sprintf('%s\n\n%s\n\n%s\n\n%s', s1, s2, s3, s10),...
      'Initialization of Strother CVA parameters')   
      
    elseif command == 5 
      %disp('editRidgeX selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 6 
      %disp('editComponents selected.') 

      lyngby_log('Parameters edited')
      
    else 
      error('Error: lyngby_ui_scva_init.m called with incorrect command.') 
    end 





