function lyngby_ui_sop_init(command,parameter1) 

% lyngby_ui_sop_init   - GUI of init. of SOP model
%
%       function lyngby_ui_sop_init(command,parameter1)
%       function lyngby_ui_sop_init
%       
%       This function controls the window that sets up the parameters
%       for the 'SOP' analysis (Strother Orthonormalized PLS).
%
%       The 'number of components' are the number of canonic values
%       that is to be returned from the computing function.
%
%       See also LYNGBY, LYNGBY_SOP_MAIN, LYNGBY_UI_MAIN.
%
% $Id: lyngby_ui_sop_init.m,v 1.5 2002/12/17 23:33:41 fnielsen Exp $ 

%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 
%
%  Created: 5-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


    lyngby_sop_global;
    lyngby_ui_option;
    
    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editComponents')) 
	command = 4; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 5; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_sop_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_sop_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonApply = handle_list(4); 
	buttonClose = handle_list(5); 
	editComponents = handle_list(6); 
	textComponents = handle_list(7); 
	buttonHelp = handle_list(8); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 400 350 200 ],... 
	  'resize','On','tag','lyngby_ui_sop_init',... 
	  'menubar','Figure','name','lyngby - SOP analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.12;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row2 = 0.26; % Lower buttons
      Row3 = 0.40; % Middle buttons
      Row4 = 0.54; % Upper buttons
      Row5 = 0.68; % Lower title
      Row6 = 0.82; % Upper title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_sop_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the Strother Orthonormalized PLS algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 0.9 0.25 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 

      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_sop_init(''buttonApply'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_sop_init(''buttonClose'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_sop_init(''buttonHelp'');',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textComponents = uicontrol(... 
	  'CallBack','lyngby_ui_sop_init(''textComponents'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_FRAME,... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row3 0.43 ButtonHeight ],... 
	  'String','No of Components:',... 
	  'Style','text',... 
	  'Tag','textComponents',... 
	  'UserData',''); 
      editComponents = uicontrol(... 
	  'CallBack','lyngby_ui_sop_init(''editComponents'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column5 Row3 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editComponents',... 
	  'UserData',''); 
      
      set(editComponents, 'String', num2str(SOP_COMPONENTS));


      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonApply buttonClose ... 
	  editComponents textComponents buttonHelp ... 
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonApply selected.') 
      
      sop_components = str2num(get(editComponents, 'String')); 
      if length(sop_components)==1 & sop_components > 0
	SOP_COMPONENTS = sop_components; 
      else 
	error('Components must be integer and larger than 0.'); 
      end 
      
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command == 4 
      %disp('editComponents selected.') 

    elseif command == 5

      helpwin('lyngby_ui_sop_init')
      
    else 
      error('Error: lyngby_ui_sop_init.m called with incorrect command.') 
    end 





