function lyngby_ui_time(command,parameter1) 

% lyngby_ui_time       - User interface for time mask specification
%
%	function lyngby_ui_time(command,parameter1) 
%	function lyngby_ui_time
%
%       Used to set up the TIME_MASK global variable.
%       This function is called be lyngby_ui_main.
%
%       See also: lyngby_ui_main, lyngby_global
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Created: 26-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_time.m,v 1.14 2001/07/02 13:26:45 mgl Exp $
%       $Revision: 1.14 $    
	
    lyngby_global
    lyngby_ui_global
    lyngby_ui_option

    UpdateAxesMask = [ ...
	  'S = full(any(TIME_MASK));',...
	  'axes(axesMask);',...
	  'image(-S+2);',...
	  'colormap([[0 0 0];[1 1 1]]);',...
	  'set(axesMask,''YTickMode'',''manual'');',...
	  'set(axesMask,''XTickMode'',''manual'');',...
	  'title(''Time Mask Function (White = Scan excluded, Black = Scan included)'');',...
	  ];

    UpdateAxesParadigm = [ ...
	  'S = full(any(TIME_MASK));',...
	  'onI = find(S);',...
	  'offI = find(S==0);',...
	  'axes(axesParadigm);',...
	  'cla reset;',...
	  'hold on;',...
	  'if ~isempty(PARADIGM) & NUM_SCANS == length(PARADIGM),',...
	  '  plot(1:NUM_SCANS,PARADIGM, ''-'');'...
	  '  plot(onI,PARADIGM(onI), ''og'');',...
	  '  plot(offI,PARADIGM(offI), ''xr'');',...
	  '  if NUM_SCANS > 1,', ...
	  '    axis([1 NUM_SCANS min(PARADIGM)-0.1 '...
	    '    max(PARADIGM)+0.1]);',...
	  '  end,',...
	  'elseif NUM_SCANS > 1,',...
	  '  axis([1 NUM_SCANS 0 1]);',...
	  'end,',...
	  'xlabel(''Sample/Scan Number'');',...
	  'ylabel(''Activation Level'');',...
	  'title(''Paradigm Function'');', ...
	  'hold off;',...
	  ];

    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonSetup')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 3; 
      elseif strcmp(lower(command),lower('popupType')) 
	command = 4; 
      elseif strcmp(lower(command), 'update') 
	command = 1000; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_time'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_time.'); 
      end  
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameControl = handle_list(1);
	buttonClose = handle_list(2); 
	buttonSetup = handle_list(3); 
	buttonHelp = handle_list(4); 
	axesMask = handle_list(5); 
	axesParadigm = handle_list(6); 
	popupType = handle_list(7);
      end 
    end 


    if command == 0 

      fig = figure('position',[ 218 55 500 230 ],... 
	  'resize','On','tag','lyngby_ui_time',... 
	  'menubar','None','name','lyngby - Time - View time mask',... 
	  'numbertitle','Off','visible','off', ...
	  'Color', UI_COLOUR_FRAME); 

      ButtonHeight = 0.1;
      ButtonRow1 = 0.05;

      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_WINBACK,...
          'Position',[ 0.08 0.025 0.84 0.15 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 
            
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_time(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.62 ButtonRow1 0.14 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_time(''buttonHelp'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ 0.77 ButtonRow1 0.14 ButtonHeight ],... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
      
      buttonSetup = uicontrol(... 
	  'CallBack','lyngby_ui_time(''buttonSetup'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.49 ButtonRow1 0.07 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Go!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSetup',... 
	  'UserData',''); 
      popupType = uicontrol(... 
	  'CallBack','lyngby_ui_time(''popupType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ 0.09 ButtonRow1 0.39 ButtonHeight ],... 
	  'String','Setup begin and end|Reset',... 
	  'Style','popupmenu',... 
	  'Tag','popupType',... 
	  'UserData',''); 

      

      %  Menu Object Creation 


      %  Axes and Text Object Creation 

      axesMask = axes(... 
	  'Units','normalized', ... 
	  'Position',[ 0.08 0.24 0.84 0.02 ],... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],...
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Clipping','on', ... 
	  'Tag','axesMask', ... 
	  'Box','off',...
	  'UserData',''); 
      axesParadigm = axes(... 
	  'Units','normalized', ... 
	  'Position',[ 0.08 0.50 0.84 0.39 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],...                
	  'Clipping','on', ... 
	  'Tag','axesParadigm', ... 
	  'UserData',''); 

      if issparse(TIME_MASK)
	[fullIndex, maskIndex] = find(TIME_MASK);
	startIndex = min(maskIndex);
	stopIndex = max(maskIndex);
	if size(TIME_MASK,2) ~= NUM_SCANS
	  warning('TIME_MASK and NUM_SCANS is different')
	end
      else
	startIndex = 1;
	stopIndex = NUM_SCANS;
      end

      handle_list = [ ...  
          frameControl ...
	  buttonClose buttonSetup buttonHelp ... 
	  axesMask axesParadigm ... 
	  popupType ...
	  ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 

      eval(UpdateAxesParadigm);
      eval(UpdateAxesMask);


    elseif command == 1 
      %disp('buttonClose selected.') 

      lyngby_ui_time_be('close');
      close(gcf);

    elseif command == 2 
      %disp('buttonSetup selected.') 

      setupType = get(popupType, 'value');
      if setupType == 1
	lyngby_ui_time_be;
      elseif setupType == 2
	TIME_MASK = 1;
	eval(UpdateAxesParadigm);
	eval(UpdateAxesMask);
      else
	error('Internal error:, setupType not known');
      end
      
    elseif command == 3 
      %disp('buttonHelp selected.') 

      s1 = [...
            'In this window you can view the TIME_MASK global ', ...
	    'variable that is to restrict the scans that should ', ...
	    'go into the datamatrix.'...
            ];
      s2 = [...
            ];
      s3 = [...
            ];
      s4 = [...
            ];
      s10 = [...
            'Function: lyngby_ui_time' ...
            ];
      s11 = [...
            'See also: lyngby_global' ...
            ];
      
      helpdlg(sprintf('%s\n\n%s\n%s', s1, s10, s11),...
      'Viewing of the time mask')   
      
    elseif command == 4 
      %disp('popupType.') 
      
    elseif command == 1000
      %disp('Update.') 

      eval(UpdateAxesMask);
      eval(UpdateAxesParadigm);
      
    else 
      error('Error: lyngby_ui_time.m called with incorrect command.') 
    end 







