function lyngby_ui_time_be(command,parameter1) 

% lyngby_ui_time_be       - User interface for time mask specification
%
%	function lyngby_ui_time_be(command,parameter1) 
%	function lyngby_ui_time_be
%
%       Used to set up the TIME_MASK global variable.
%       This function is called be lyngby_ui_time.
%
%       See also: lyngby_ui_time, lyngby_global
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_time_be.m,v 1.4 2001/07/02 13:26:44 mgl Exp $
%       $Revision: 1.4 $    
	
    lyngby_global
    lyngby_ui_option


    % get startIndex and stopIndex
    ReadFields = [ ...
	  'bOk = 0;',...
	  '[startIndex, countStartIndex] = sscanf(get(editStartIndex, ''String''),''%d'');',...
	  '[stopIndex, countStopIndex] = sscanf(get(editStopIndex, ''String''),''%d'');',...
	  'if countStartIndex ~= 1,',...
	  '  error(''Start index must be a single integer'');',...
	  'elseif countStopIndex ~= 1,',...
	  '  error(''Stop index must be a single integer'');',...
	  'else,',...
	  '  if startIndex<1,',... 
	  '    startIndex = 1;',...
	  '    set(editStartIndex, ''String'', ''1'');',...
	  '  end,',...
	  '  if stopIndex>NUM_SCANS,',... 
	  '    stopIndex = NUM_SCANS;',...
	  '    set(editStopIndex, ''String'', num2str(stopIndex));',...
	  '  end,',...
	  '  if startIndex > stopIndex,',... 
	  '    startIndex = stopIndex;',...
	  '    set(editStartIndex, ''String'', num2str(startIndex));',...
	  '  end,',...
	  '  bOk = 1;',...
	  'end,'... 
	  ];

    AndMask = [ ...
	  'if startIndex ~= 1 | stopIndex ~= NUM_SCANS,',...
	  '  if issparse(TIME_MASK),',...
	  '    [dummy,indexTimeMask] = find(TIME_MASK);',...
	  '    andTimeMask = lyngby_set_and(indexTimeMask, ',...
	  '           startIndex:stopIndex);',...
	  '    nIndex = length(andTimeMask);',...
	  '    TIME_MASK = sparse(1:nIndex,', ...
	  '           andTimeMask, ones(nIndex,1),', ...
	  '           nIndex,NUM_SCANS);',...
	  '  else,',...
	  '    andTimeMask = startIndex:stopIndex;',...
	  '    nIndex = length(andTimeMask);',...
	  '    TIME_MASK = sparse(1:nIndex,', ...
	  '           andTimeMask, ones(nIndex,1),', ...
	  '           nIndex,NUM_SCANS);',...
	  '  end,',...
	  'end,',...
	  ];

    OverwriteMask = [ ...
	  'if startIndex == 1 & stopIndex == NUM_SCANS,',...
	  '  TIME_MASK = 1;',...
	  'else,',...
	  '  nIndex = stopIndex - startIndex + 1;',...
	  '  TIME_MASK = sparse(1:nIndex,', ...
	  '         startIndex:stopIndex,ones(nIndex,1),', ...
	  '         nIndex,NUM_SCANS);',...
	  'end,',...
	  ];
	  
	  
    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonAnd')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonOverwrite')) 
	command = 3; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editStopIndex')) 
	command = 5; 
      elseif strcmp(lower(command),lower('editStartIndex')) 
	command = 6; 
      elseif strcmp(lower(command),lower('Close')) 
	command = 1000; 
      end 
    end 

    if command ~= 0 & command ~= 1000
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_time_be'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_time_be.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	frameWindow = handle_list(3);
	textTitle = handle_list(4);
	buttonClose = handle_list(5); 
	textAnd = handle_list(6);
	textOverwrite = handle_list(7);
	buttonAnd = handle_list(8); 
	buttonOverwrite = handle_list(9); 
	buttonHelp = handle_list(10); 
	editStopIndex = handle_list(11); 
	editStartIndex = handle_list(12); 
	textStopIndex = handle_list(13); 
	textStartIndex = handle_list(14); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 200 250 210 275 ],... 
	  'resize','On','tag','lyngby_ui_time_be',... 
	  'menubar','None','name','lyngby - Time - Specify time mask',... 
	  'numbertitle','Off','visible','off', ...
	  'Color', UI_COLOUR_WINBACK); 

      ButtonHeight = 0.09;
      ControlHeight = ButtonHeight;
      ButtonWidth = 0.37;
      EditboxWidth = 0.40;
      Column4 = 0.50;
      Column3 = 0.53;
      Column2 = 0.1;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.04; % Bottom row, window controls
      Row2 = 0.20; % 'Overwrite' & 'And' controls
      Row3 = 0.30; % 'Overwrite' & 'And' text
      Row4 = 0.52; % 'Stop' index
      Row5 = 0.64; % 'Start' index
      Row6 = 0.77; % Window title
      Row7 = 0.90;
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.48 FrameWidth 0.50 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.18 FrameWidth 0.28 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 
       frameWindow = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.14 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framewindow',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','Specify the start and end values, then use the ''And'' or ''Overwrite'' button to create the desired function.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.10 Row6 0.80 0.18 ],... 
	  'Tag','textTitle',... 
	  'UserData','');        

      textAnd = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''textAnd'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','AND the above fn with the existing one',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row3 ButtonWidth 0.1325 ],... 
	  'Tag','textAnd',... 
	  'UserData','');        
      textOverwrite = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''textOverwrite'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','Overwrite the existing fn with the one above',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row3 ButtonWidth 0.1325 ],... 
	  'Tag','textOverwrite',... 
	  'UserData','');        
      
      
      buttonAnd = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''buttonAnd'');',... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row2 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','And',... 
	  'Style','pushbutton',... 
	  'Tag','buttonAnd',... 
	  'UserData',''); 
      buttonOverwrite = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''buttonOverwrite'');',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row2 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Overwrite',... 
	  'Style','pushbutton',... 
	  'Tag','buttonOverwrite',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''buttonHelp'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
      
      textStartIndex = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''textStartIndex'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'String','Start index:',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row5 ButtonWidth+0.06 ControlHeight ],... 
	  'Tag','textStartIndex',... 
	  'UserData',''); 
      editStartIndex = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''editStartIndex'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row5 ButtonWidth ControlHeight ],... 
	  'Tag','editStartIndex',... 
	  'UserData',''); 

      textStopIndex = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''textStopIndex'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'String','Stop index:',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row4 ButtonWidth+0.06 ControlHeight ],... 
	  'Tag','textStopIndex',... 
	  'UserData',''); 
      editStopIndex = uicontrol(... 
	  'CallBack','lyngby_ui_time_be(''editStopIndex'');',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row4 ButtonWidth ControlHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editStopIndex',... 
	  'UserData',''); 


      %  Menu Object Creation 


      %  Axes and Text Object Creation 


      if issparse(TIME_MASK)
	[fullIndex, maskIndex] = find(TIME_MASK);
	startIndex = min(maskIndex);
	stopIndex = max(maskIndex);
      else
	startIndex = 1;
	stopIndex = NUM_SCANS;
      end

      set(editStartIndex, 'String', num2str(startIndex));
      set(editStopIndex, 'String', num2str(stopIndex));

      handle_list = [ ...  
	  frameEdit frameControl frameWindow textTitle ...
	  buttonClose textAnd textOverwrite buttonAnd buttonOverwrite ...
	  buttonHelp ...
	  editStopIndex editStartIndex textStopIndex textStartIndex ... 
	    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonClose selected.') 

      close(gcf);

    elseif command == 2 
      %disp('buttonAnd selected.') 

      eval(ReadFields);
      eval(AndMask);
      lyngby_ui_time('Update');
      
    elseif command == 3
      %disp('buttonOverwrite selected.') 

      eval(ReadFields);
      eval(OverwriteMask);
      lyngby_ui_time('Update');
      
    elseif command == 4 
      %disp('buttonHelp selected.') 

      s1 = [...
            'This window is used to set up the TIME_MASK global ', ...
	    'variable. The current TIME_MASK can be seen in the ', ...
	    '''Time - View Time Mask'' window as a ',...
	    'black and white line.'...
            ];
      s2 = [...
	    '   * ''And'' will logically AND the indices from ' ,...
	    '''Start index'' to ''Stop index'' with the ', ...
	    'values of the present mask.', ...
            ];
      s3 = [...
	    '   * ''Overwrite'' will just use the indices ',...
	    'from ''Start index'' to ''Stop index'' as the ', ...
	    ' new mask. ',...
            ];
      s4 = [...
            ];
      s10 = [...
            'Function: lyngby_ui_time_be' ...
            ];
      s11 = [...
            'See also: lyngby_ui_time' ...
            ];
      
      helpdlg(sprintf('%s\n\n%s\n\n%s\n\n%s\n%s', s1, s2, s3, s10, s11),...
      'Set up the time mask');   

  
    elseif command == 5 
      %disp('editStopIndex selected.') 

    elseif command == 6 
      %disp('editStartIndex selected.') 
    
    elseif command == 1000
      
      fig = findobj('tag','lyngby_ui_time_be');
      if fig == 1
	close(fig);
      elseif fig > 1
	for f = 1:length(fig)
	  close(fig(f));
	end
      end
      
    else 
      error('Error: lyngby_ui_time_be.m called with incorrect command.') 
    end 






