function lyngby_ui_ts_init(command,parameter1) 

% lyngby_ui_ts_init    - Initialization of t-test
%
%       function lyngby_ui_ts_init(command,parameter1)
%
%       Graphical user interface for initialization of parameters for
%       the ordinary t-test.
%
%       'Edgedrop' is the number of scans discarded at the paradigm
%       shifts. 
% 
%       'Test error-level' is cut-off of the p-value. 
%
%       See also LYNGBY, LYNGBY_TS_MAIN, LYNGBY_UI_MAIN.
%
% $Id: lyngby_ui_ts_init.m,v 1.10 2002/05/08 14:50:37 fnielsen Exp $

%  Made with:	GUI Maker Ver 2.1 by Patrick Marchand 
%
%  Created: 5-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


    lyngby_ts_global;
    lyngby_ui_option;
    
    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editEdgedrop')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editErrorlevel')) 
	command = 5; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_ts_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_ts_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonApply = handle_list(4); 
	buttonHelp = handle_list(5); 
	buttonClose = handle_list(6); 
	editEdgedrop = handle_list(7); 
	textEdgedrop = handle_list(8); 
	editErrorlevel = handle_list(9); 
	textErrorlevel = handle_list(10); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 400 350 200 ],... 
	  'resize','Off','tag','lyngby_ui_ts_init',... 
	  'menubar','Figure','name','lyngby - t-test analysis setup',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.12;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row2 = 0.32; % Lower buttons
      Row3 = 0.48; % Middle buttons
      Row4 = 0.54; % Upper buttons
      Row5 = 0.68; % Lower title
      Row6 = 0.82; % Upper title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_ts_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String', [ ...
	    'The parameters of the Ordinary t-test ' ...
	    'algorithm can be specified in this window.' ...
	    ],... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 0.9 0.25 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 

      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_ts_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_ts_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_ts_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textEdgedrop = uicontrol(... 
	  'CallBack','lyngby_ui_ts_init(''textEdgedrop'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Units','normalized',... 
	  'HorizontalAlignment','right',... 
	  'Position',[ 0.05 Row3 0.43 ButtonHeight ],... 
	  'String','Edgedrop:',... 
	  'Style','text',... 
	  'Tag','textEdgedrop',... 
	  'UserData',''); 
      editEdgedrop = uicontrol(... 
	  'CallBack','lyngby_ui_ts_init(''editEdgedrop'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row3 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editEdgedrop',... 
	  'UserData',''); 
      textErrorlevel = uicontrol(... 
	  'CallBack','lyngby_ui_ts_init(''textErrorlevel'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row2 0.43 ButtonHeight ],... 
	  'String','Test errorlevel:',... 
	  'Style','text',... 
	  'Tag','textErrorlevel',... 
	  'UserData','');
      editErrorlevel = uicontrol(... 
	  'CallBack','lyngby_ui_ts_init(''editErrorlevel'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row2 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editErrorlevel',... 
	  'UserData',''); 
 
      set(editEdgedrop, 'String', num2str(TS_EDGEDROP));
      set(editErrorlevel, 'String', num2str(TS_ERRORLEVEL));


      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonApply buttonHelp buttonClose ... 
	  editEdgedrop textEdgedrop ... 
	  editErrorlevel textErrorlevel ... 
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [edgedrop, count1] = sscanf(get(editEdgedrop, 'String'), '%d'); 
      [errorlevel, count2] = sscanf(get(editErrorlevel, 'String'), '%f'); 
      if (count1==1 & edgedrop >= 0) 
	TS_EDGEDROP = edgedrop; 
      else 
	error('The number of scans to drop around transitions must be integer and non-negative.'); 
      end 
      if (count2==1 & errorlevel >= 0) 
	TS_ERRORLEVEL = errorlevel; 
      else 
	error('The Errorlevel must be non-negative.'); 
      end 
      
    elseif command == 2 
      %disp('buttonHelp selected.') 

      helpwin('lyngby_ui_ts_init')
      
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command == 4 
      %disp('editEdgedrop selected.') 
    elseif command == 5 
      %disp('editErrorlevel selected.') 

    else 
      error('Error: lyngby_ui_ts_init.m called with incorrect command.') 
    end 





