function lyngby_ui_view(arg1, arg2, arg3, arg4, arg5, arg6, arg7, ...
    arg8, arg9, arg10) 

% lyngby_ui_view       - User interface for viewing results
%
%       function lyngby_ui_view(command,parameter1)
%       function lyngby_ui_view(Volumes, String, ...
%                   'PropertyName', 'PropertyValue')
%
%       Input:    Volumes       Result volumes
%                 Strings       String describing the result volumes
%
%       Property: Callback      Function used as callback for the
%                               right figure
%                 CallbackType  String describing the types of
%                               plot on the right figure
%                 Title         Title on the figure
%
%       This function controls the display of the analysis
%       results. Three windows are opened: The volume data is in the
%       left window, the time dependent data in the right, and the
%       controls in the lower window. Clicking on a voxel
%       in the left window updates the information in the right
%       window. Press the lower right button, ''More..'', to EXPAND
%       the window and show controls for additional layers.
%
%       The function also enables saving of volumes and time
%       series. When ANALYZE volumes are written the ORIGIN global
%       variable is used. 
%
%       The user will usually call the function by pressing a button
%       in the main Lyngby window. However, if the function is called
%       directly the number of rows in 'Volumes' should be the same as the
%       of descriptions in 'String'. The descriptions in 'Strings'
%       should be separated by a vertical bar: '|'.        
%
%       Button description in the control window:
%         Row 4: Defines the contour overlay and background display.
%           Contour Overlay:-
%             * Button 1: Toggles the Contour Overlay on/off.
%             * Button 2: Data to be used for the Contour overlay.
%             * Button 3: Specifies what each datapoint represents.
%           Background layer (usually an anatomical slice):-
%             * Button 1: Toggles the Background layer on/off.
%             * Button 2: Data to be used for the Background layer.
%             * Button 3: Specifies what each datapoint represents.;
%         Row 3: Masking Layer. Defines the mask which is then applied to the data.
%             * Button 1: Data to be used to define the mask.
%             * Button 2: Specifies the function applied to the mask data.
%             * Button 3: The masking threshold.
%             * Button 4: Slider defining the masking threshold.
%             * Button 5: Specifies masking threshold as fractional or absolute
%         Row 2: Data Layer. This defines how the main data is displayed.
%             * Button 1: The data source.
%             * Button 2: Specifies the direction of depth collapsing (3D data only)
%             * Button 3: Slice control (for 3D datasets).
%             * Button 4: Specifies what each datapoint represents. 
%             * Button 5: The colourmap used for the dataset.
%             * Button 6: Toggle control for the colourbar in the volume window.
%         Row 1: Time Layer and System layers.
%           Time Layer. Defines how the time-dependent data is displayed:-
%             * Button 1: The data source.
%             * Button 2: Time axis scaling/zooming control.
%             * Button 3: Axis control.
%             * Button 4: Slider to scroll along the time axis.
%           System Layer. General control buttons:-
%             * Button 1: Close all three result view windows.
%             * Button 2: Display this window.
%             * Button 3: Toggle the control window between 2 and 4 layers.
%
%       Example (with a direct call):
%         lyngby_ui_view([X_MEAN ; X_STD], 'Mean|Std', ...
%            'Callback', 'lyngby_ui_view_fir', ...
%            'CallbackType', 'Time|Filter');
%
%       See also LYNGBY, LYNGBY_UI_MAIN, LYNGBY_UI_VIEW_DFL,
%                LYNGBY_VIEW_FIR, LYNGBY_WRITE_ANA.
%
% $Id: lyngby_ui_view.m,v 1.46 2002/12/18 00:12:50 fnielsen Exp $

%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 
%
%  Created: 8-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 



    lyngby_global
    lyngby_ui_global
    lyngby_ui_option

    % Initial settings
    TContour = 0;
    TBackground = 0;


    % This function toggles the state of the tooltips help.
    ToggleTooltips = [ ...
	  'ver = (version);', ...
	  'ver = str2num(ver(1:3));', ...
	  'if ver >= 5.2 & strcmp(get(menuTooltips, ''Checked''), ''on''),',...
	  '  UI_TOOLTIPS = 0;',...
	  '  set(menuTooltips, ''Checked'',''off'');',...
	  '  set(frameContour, ''TooltipString'','''');',...
	  '  set(frameBackground, ''TooltipString'','''');',...
	  '  set(frameMask, ''TooltipString'','''');',...
	  '  set(frameData, ''TooltipString'','''');',...
	  '  set(frameTime, ''TooltipString'','''');',...
	  '  set(frameSystem, ''TooltipString'','''');',...
	  '  set(textContourLabel, ''TooltipString'','''');',...
	  '  set(textBackgroundLabel, ''TooltipString'','''');',...
	  '  set(radioContour, ''TooltipString'','''');',...
	  '  set(radioBackground, ''TooltipString'','''');',...
	  '  set(textMaskLabel, ''TooltipString'','''');',...
	  '  set(textDataLabel, ''TooltipString'','''');',...
	  '  set(textTimeLabel, ''TooltipString'','''');',...
	  '  set(buttonClose, ''TooltipString'','''');',...
	  '  set(buttonHelp, ''TooltipString'','''');',...
	  '  set(buttonExpand, ''TooltipString'','''');',...
	  '  set(popupContour, ''TooltipString'','''');',...
	  '  set(popupContourRay, ''TooltipString'','''');',...
	  '  set(popupBackground, ''TooltipString'','''');',...
	  '  set(popupBackgroundRay, ''TooltipString'','''');',...
	  '  set(popupMask, ''TooltipString'','''');',...
	  '  set(popupMaskType, ''TooltipString'','''');',...
	  '  set(editMaskLevel, ''TooltipString'','''');',...
	  '  set(sliderMaskLevel, ''TooltipString'','''');',...
	  '  set(popupMaskLevelType, ''TooltipString'','''');',...
	  '  set(popupVolume, ''TooltipString'','''');',...
	  '  set(popupPlane, ''TooltipString'','''');',...
	  '  set(sliderSlice, ''TooltipString'','''');',...
	  '  set(popupRay, ''TooltipString'','''');',...
	  '  set(popupColormap, ''TooltipString'','''');',...
	  '  set(popupColorbar, ''TooltipString'','''');',...
	  '  set(popupTime, ''TooltipString'','''');',...
	  '  set(popupZoom, ''TooltipString'','''');',...
	  '  set(popupAmplitude, ''TooltipString'','''');',...
	  '  set(sliderScroll, ''TooltipString'','''');',...
	  '  set(buttonSaveLeftImage, ''TooltipString'','''');',...
	  '  set(buttonAspect, ''TooltipString'','''');',...
	  '  set(popupColormapCtrl, ''TooltipString'','''');',...
	  '  set(popupScale, ''TooltipString'','''');',...
	  '  set(frameFile, ''TooltipString'','''');',...
	  '  set(textFile, ''TooltipString'','''');',...
	  '  set(popupSavetype, ''TooltipString'','''');',...
	  '  set(popupFiletype, ''TooltipString'','''');',...
	  '  set(buttonOption, ''TooltipString'','''');',...
	  '  set(popupCompress, ''TooltipString'','''');',...
	  '  set(editFilename, ''TooltipString'','''');',...
	  '  set(buttonBrowse, ''TooltipString'','''');',...
	  '  set(buttonSave, ''TooltipString'','''');',...
	  '  set(buttonSaveExpand, ''TooltipString'','''');',...
	  'elseif ver >= 5.2,',...
	  '  UI_TOOLTIPS = 1;',...
	  '  set(menuTooltips, ''Checked'',''on'');',...
	  '  set(frameContour, ''TooltipString'', ''This layer controls the contour overlay added on top of the dataset'');',...
	  '  set(frameBackground, ''TooltipString'',''This layer controls the background layer added below the dataset'');',...
	  '  set(frameMask, ''TooltipString'', ''This layer controls the masking function that then acts upon the dataset'');',...
	  '  set(frameData, ''TooltipString'', ''This layer controls the dataset, shown in the left-hand window'');',...
	  '  set(frameTime, ''TooltipString'', ''This layer controls the Time display, shown in the right-hand window'');',...
	  '  set(frameSystem, ''TooltipString'', ''This layer contains system control buttons'');',...
	  '  set(textContourLabel, ''TooltipString'', ''This layer controls the contour overlay added on top of the dataset'');',...
	  '  set(textBackgroundLabel, ''TooltipString'', ''This layer controls the background layer added below the dataset'');',...
	  '  set(textMaskLabel, ''TooltipString'', ''This layer controls the masking function that then acts upon the dataset'');',...
	  '  set(textDataLabel, ''TooltipString'', ''This layer controls the dataset, shown in the left-hand window'');',...
	  '  set(textTimeLabel, ''TooltipString'', ''This layer controls the Time display, shown in the right-hand window'');',...
	  '  set(radioContour, ''TooltipString'',''This toggles the Contour layer on/off'');',...
	  '  set(radioBackground, ''TooltipString'',''This toggles the Background layer on/off'');',...
	  '  set(buttonClose, ''TooltipString'', ''Close all three windows'');',...
	  '  set(buttonHelp, ''TooltipString'', ''Call the general help window'');',...
	  '  set(buttonExpand, ''TooltipString'', ''Toggle the window between 2 and 4 layers'');',...
	  '  set(popupContour, ''TooltipString'', ''Choose the dataset to use for the Contour overlay'');',...
	  '  set(popupContourRay, ''TooltipString'', ''Specify what each datapoint represents'');',...
	  '  set(popupBackground, ''TooltipString'', ''Choose the dataset to use for the Background layer'');',...
	  '  set(popupBackgroundRay, ''TooltipString'', ''Specify what each datapoint represents'');',...
	  '  set(popupMask, ''TooltipString'', ''Choose which dataset to use to define the mask'');',...
	  '  set(popupMaskType, ''TooltipString'', ''Specify the type of mask to use'');',...
	  '  set(editMaskLevel, ''TooltipString'',''Specify the threshold of the mask'');',...
	  '  set(sliderMaskLevel, ''TooltipString'',''Specify the threshold of the mask'');',...
	  '  set(popupMaskLevelType, ''TooltipString'',''Specify the threshold as a percentage or absolute measure'');',...
	  '  set(popupVolume, ''TooltipString'',''Choose the main dataset to be viewed'');',...
	  '  set(popupPlane, ''TooltipString'',''Specify the direction for depth-collapsing'');',...
	  '  set(sliderSlice, ''TooltipString'',''Slice control slider'');',...
	  '  set(popupRay, ''TooltipString'',''Specify what each datapoint represents'');',...
	  '  set(popupColormap, ''TooltipString'',''Colormap used for the main dataset'');',...
	  '  set(popupColorbar, ''TooltipString'',''Toggle the colorbar on/off'');',...
	  '  set(popupTime, ''TooltipString'',''Choose the dataset to display in the time window'');',...
	  '  set(popupZoom, ''TooltipString'',''Specify the extent of the time axis to display'');',...
	  '  set(popupAmplitude, ''TooltipString'',''Specify the axis scaling'');',...
	  '  set(sliderScroll, ''TooltipString'',''Scroll control for the time window'');',...
	  '  set(buttonSaveLeftImage, ''TooltipString'',''Save Left Image'');',...
	  '  set(buttonAspect, ''TooltipString'',''Aspect control'');',...
	  '  set(popupColormapCtrl, ''TooltipString'',''Colormap control'');',...
	  '  set(popupScale, ''TooltipString'',''Scale control'');',...
	  '  set(frameFile, ''TooltipString'',''This layer controls the saving of data from the layers below'');',...
	  '  set(textFile, ''TooltipString'',''This layer controls the saving of data from the layers below'');',...
	  '  set(popupSavetype, ''TooltipString'',''What data to save? The whole volume (with no temporal info), or the time sequence for this voxel? Layers to be saved are indicated in red'');',...
	  '  set(popupFiletype, ''TooltipString'',''The format in which to save the data'');',...
	  '  set(buttonOption, ''TooltipString'',''Options specific for each format'');',...
	  '  set(popupCompress, ''TooltipString'',''Which file compression to use'');',...
	  '  set(editFilename, ''TooltipString'',''The filename for the saved data'');',...
	  '  set(buttonBrowse, ''TooltipString'',''File browser to save the data in a different directory than the one where lyngby was started'');',...
	  '  set(buttonSave, ''TooltipString'',''Save the data with this filename and in the current directory'');',...
	  '  set(buttonSaveExpand, ''TooltipString'',''Show/hide the save layer'');',...
	  'end,',...
	  ];

% This function toggles the buttons in the Overlay layers between 'contour' and 'background'.
    ToggleOverlayButtons = [ ...
	  'Con_tour = get(popupContourType, ''Value'');',...
	  'if Con_tour == 1,',...  				       
	  '  set(popupContourRay, ''Enable'', ''off'');',...
	  '  set(popupContour, ''Enable'', ''off'');',...
	  'else,',...						      
	  '  set(popupContourRay, ''Enable'', ''on'');',...
	  '  set(popupContour, ''Enable'', ''on'');',...
	  'end,',...
	  ];

    % This function toggles the buttons in the Mask layer between 'active' and 'greyed-out'.
    ToggleMaskButtons = [ ...
	  'MaskType = get(popupMaskType, ''Value'');',...
	  'if MaskType == 1,',...  					% Mask set to 'None'
	  '  set(editMaskLevel, ''Enable'', ''off'');',...
	  '  set(sliderMaskLevel, ''Enable'', ''off'');',...
	  '  set(popupMaskLevelType, ''Enable'', ''off'');',...
	  '  set(popupMask, ''Enable'', ''off'');',...
	  'else,',...
	  '  set(editMaskLevel, ''Enable'', ''on'');',...
	  '  set(sliderMaskLevel, ''Enable'', ''on'');',...
	  '  set(popupMaskLevelType, ''Enable'', ''on'');',...
	  '  set(popupMask, ''Enable'', ''on'');',...
	  'end,',...
	  ];
    
    UpdateZoom = [ ...
	  'endIndex = size(XN,1);',...
	  'scroll = get(sliderScroll, ''value'');',...
	  'popupValue = get(popupZoom, ''value'');',...
	  'if popupValue == 1,',...
	  '  zoom = 1;',...
	  '  set(sliderScroll, ''Visible'', ''on'');',...
	  '  set(sliderScroll, ''Enable'', ''off'');',...
	  'else,',...
	  '  set(sliderScroll, ''Visible'', ''on'');',...
	  '  set(sliderScroll, ''Enable'', ''on'');',...
	  '  if popupValue == 2,',...
	  '    zoom = 0.5;',...
	  '  elseif popupValue == 3;',...
	  '    zoom = 0.3;',...
	  '  elseif popupValue == 4;',...
	  '    zoom = 0.2;',...
	  '  elseif popupValue == 5;',...
	  '    zoom = 0.1;',...
	  '  elseif popupValue == 6;',...
	  '    zoom = 0.05;',...
	  '  elseif popupValue == 7;',...
	  '    zoom = 0.01;',...
	  '  end,',...
	  'end,',...
	  'window = max([ceil(zoom*endIndex) 2]);',...
	  'if scroll == 0,',...
	  '  axisIndices = [1 window];',...
	  'elseif scroll == 1,',...
	  '  axisIndices = [endIndex-window+1 endIndex];',...
	  'else,',...
	  '  beginIndex = round(scroll*(endIndex-window));',...
	  '  axisIndices = [beginIndex beginIndex+window];',...
	  'end,',...
	  ];
    
    UpdateRight = [...
	  'eval(UpdateZoom);',...
	  'figure(figTime);',...
	  'slices = get(sliderSlice, ''UserData'');',...
	  'set(figTime, ''color'', UI_COLOR_BACK);',...
          'ver = (version);',...
          'ver = str2num(ver(1:3));',...
	  'if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '  ActiveTileValues = get(menuMosaic, ''UserData'');',...
	  '  voxel3 = ActiveTileValues(:,3);',...
	  'else,',...
	  '  voxel3 = slices(:,3);',...
	  'end,',...	
	  'voxel = lyngby_full2mask(voxel3);',...
	  'if ~isempty(voxel)',...
	  '  callbackfn = get(popupTime, ''UserData'');',...
	  '  if ~isempty(callbackfn);',...
	  '    timetype = get(popupTime, ''String'');',...
	  '    timetype = deblank(timetype(get(popupTime, ''Value''),:));',...
	  '    VolumeType = get(popupVolume, ''Value'');',...
	  '    V = get(popupVolume, ''UserData'');',...
	  '    value = V(VolumeType,voxel);',...
	  '    amplitudetype = get(popupAmplitude, ''String'');',...
	  '    amplitudetype = deblank(amplitudetype(get(popupAmplitude, ''Value''),:));',...
	  'eval(sprintf(''%s(''''Type'''', ''''%s'''', ''''Voxel'''', %d, ''''Amplitude'''', ''''%s'''', ''''Value'''', %f, ''''Index'''', [%d %d])'', callbackfn, timetype, voxel, amplitudetype, value, axisIndices));',...
	  '  end,',...
	  'else,',...
	  '  cla;',...
	  '  title(sprintf(''[%d, %d, %d], no voxel here'', voxel3));',...
	  'end,',...
	  ];

    VoxelClick = [ ...
	  'Point = round(get(gca, ''currentPoint''));',...
          'ver = (version);',...
          'ver = str2num(ver(1:3));',...
	  'if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '  TileValues = get(gca, ''UserData'');',...
	  '  SliceParams = TileValues;',...
	  'else,',...
	  '  oldslice = get(sliderSlice, ''UserData'');',...
	  '  SliceParams = oldslice;',...
	  'end,',...
	  'if get(popupPlane, ''Value'') == 3,',...
	  '  slice = [SliceParams(:,1:2) [Point(1,1) ; Point(1,2) ; SliceParams(3,3)]];',...
	  'elseif get(popupPlane, ''Value'') == 2,',...
	  '  slice = [SliceParams(:,1:2) [Point(1,1) ; SliceParams(2,3) ; Point(1,2)]];',...
	  'else,',...
	  '  slice = [SliceParams(:,1:2) [SliceParams(1,3) ; Point(1,1) ; Point(1,2)]];',...
	  'end,',...
	  'if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '  set(menuMosaic, ''UserData'', slice);',...
	  'else,',...
	  '  set(sliderSlice, ''UserData'', slice);',...
	  'end,',...
	  'eval(UpdateRight);'...
	  ];

    
    UpdateSliderMaskLevel = [ ...
	  '[maskLevel, count] = sscanf(get(editMaskLevel,',...
	  '    ''String''), ''%f'', 1);',...
	  'if count == 1,',...
	  '  minLevel = get(sliderMaskLevel, ''Min'');',...
	  '  maxLevel = get(sliderMaskLevel, ''Max'');',...
	  '  if maskLevel < minLevel,',...
	  '    maskLevel = minLevel;',...
	  '  elseif maskLevel > maxLevel,',...
	  '    maskLevel = maxLevel;',...
	  '  end,',...
	  '  set(editMaskLevel, ''String'', num2str(maskLevel));',...
	  '  set(sliderMaskLevel, ''Value'', maskLevel);',...
	  'else,',...
	  '  maskLevel = get(sliderMaskLevel, ''Value'');',...	  
	  '  set(editMaskLevel, ''String'', num2str(maskLevel));',...
	  'end,',...
	  ];
    
    
    UpdateEditMaskLevel = [ ...
	  'set(editMaskLevel, ''String'', ',...
	  '    sprintf(''%g'', get(sliderMaskLevel, ''Value'')));',...
	  ];

    UpdatePopupMaskLevelType = [ ...
	  'maskLevelType = get(popupMaskLevelType, ''Value'');',...
	  'previousType = get(popupMaskLevelType, ''UserData'');',... 
	  'if maskLevelType ~= previousType,',...
	  '  minSlider = get(sliderMaskLevel, ''Min'');',...
	  '  maxSlider = get(sliderMaskLevel, ''Max'');',...
	  '  maskLevel = get(sliderMaskLevel, ''Value'');',...
	  '  V = get(popupVolume, ''UserData'');',...
	  '  volumeType = get(popupMask, ''Value'');',...
	  '  MaxV = max(V(volumeType, :));',...
	  '  MinV = min(V(volumeType, :));',...
	  '  if maskLevelType == 1 & previousType == 2,',...
	  '    Max = 1;',...
	  '    Min = 0;',...
	  '    newmaskLevel = 1-mean(V(volumeType,:)>maskLevel);',...
	  '  elseif maskLevelType == 2 & previousType == 1,',...
	  '    Max = MaxV;',...
	  '    Min = MinV;',...
	  '    Vsort = sort(V(volumeType,:));',...
	  '    newmaskLevel = Vsort(round(maskLevel*length(Vsort)));',...
	  '  end,',...
	  '  maskLevel = max([maskLevel Min]);',...
	  '  maskLevel = min([maskLevel Max]);',...
	  '  set(sliderMaskLevel, ''Max'', Max, ''Min'', Min, ',...
	  '      ''Value'', newmaskLevel);',...
	  '  set(popupMaskLevelType, ''UserData'', maskLevelType);',...
	  '  eval(UpdateEditMaskLevel);',...
	  'end;',...
	  ];

    
    
    % Should be run with the control figure is expanded
    % 'Less..' should contain the volumes.
    UpdateLeftImageExpand = [ ...
	  'if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '  PassedTile=n;',...
	  '  PassedSliceType=sliceType+PassedTile-1;',...
	  'end,',...
	  'figure(figVolume);',...
	  'planeType = get(popupPlane, ''Value'');',...
	  'ContourRayType = get(popupContourRay, ''Value'');',...
	  'BackRayType = get(popupBackgroundRay, ''Value'');',...
	  'ContourVolumeType = get(popupContour, ''Value'');',...
	  'BackVolumeType = get(popupBackground, ''Value'');',...
          'TBackground = get(radioBackground, ''value'');',...
          'TContour = get(radioContour, ''value'');',...
          'if TContour == 0,',...
          '  if TBackground == 0,',...
          '    backType = 1;',...
          '  else,',...
          '    backType = 3;',...
          '  end,',...
          'else,',...
          '  if TBackground == 0,',...
          '    backType = 2;',...
          '  else,',...
          '    backType = 4;',...
          '  end,',...
          'end,',...
	  'if ContourRayType == 1,',...
	  '  if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '    ContoursliceType = PassedSliceType;',... 
	  '  else,',...
	  '    S = get(sliderSlice, ''UserData'');',...
	  '    ContoursliceType = S(planeType, 3);',... 
	  '  end,',...
	  'elseif ContourRayType == 2,',...
	  '  ContoursliceType = ''mean'';',...
	  'else,',...
	  '  ContoursliceType = ''max'';',...
	  'end,',...
	  'if BackRayType == 1,',...
	  '  if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '    BacksliceType = PassedSliceType;',... 
	  '  else,',...
	  '    S = get(sliderSlice, ''UserData'');',...
	  '    BacksliceType = S(planeType, 3);',... 
	  '  end,',...
	  'elseif BackRayType == 2,',...
	  '  BacksliceType = ''mean'';',...
	  'else,',...
	  '  BacksliceType = ''max'';',...
	  'end,',...
	  'if planeType == 1,',...
	  '  Back = lyngby_getslice(V(BackVolumeType,:), ''s'', BacksliceType);',...
	  '  Con_tour = lyngby_getslice(V(ContourVolumeType,:), ''s'', ContoursliceType);',...
	  'elseif planeType == 2,',...
	  '  Back = lyngby_getslice(V(BackVolumeType,:), ''c'', BacksliceType);',...
	  '  Con_tour = lyngby_getslice(V(ContourVolumeType,:), ''c'', ContoursliceType);',...
	  'elseif planeType == 3,',...
	  '  Back = lyngby_getslice(V(BackVolumeType,:), ''t'', BacksliceType);',...
	  '  Con_tour = lyngby_getslice(V(ContourVolumeType,:), ''t'', ContoursliceType);',...
	  'end,',...
	  'if backType == 1,',...
	  '  sBackType = ''None'';',...
	  'elseif backType == 2,',...
	  '  sBackType = ''Contour'';',...
	  'elseif backType == 3,',...
	  '  sBackType = ''Overwrite'';',...
	  'elseif backType == 4,',...
	  '  sBackType = ''Both'';',...
	  'end,',...
	  'planeType = get(popupPlane, ''Value'');',...
	  'RayType = get(popupRay, ''Value'');',...
	  'VolumeType = get(popupMask, ''Value'');',...
	  'maskType = get(popupMaskType, ''Value'');',...
	  'if RayType == 1,',...
	  '  if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '    CSliceType=PassedSliceType;',...
	  '  else,',...
	  '    S = get(sliderSlice, ''UserData'');',...
	  '    CSliceType = S(planeType, 3);',... 
	  '  end,',...
	  'elseif RayType == 2,',...
	  '  CSliceType = ''mean'';',...
	  'else,',...
	  '  CSliceType = ''max'';',...
	  'end,',...
	  'if planeType == 1,',...
	  '  Mask = lyngby_getslice(V(VolumeType,:), ''s'', CSliceType);',...
	  'elseif planeType == 2,',...
	  '  Mask = lyngby_getslice(V(VolumeType,:), ''c'', CSliceType);',...
	  'elseif planeType == 3,',...
	  '  Mask = lyngby_getslice(V(VolumeType,:), ''t'', CSliceType);',...
	  'end,',...
	  'if maskType == 1,',...
	  '  sMaskType = ''None'';' ...
	  'elseif maskType == 2,' ...
	  '  sMaskType = ''>'';'  ...
	  'elseif maskType == 3,' ...
	  '  sMaskType = ''><'';' ...
	  'elseif maskType == 4,' ...
	  '  sMaskType = ''=='';' ...
	  'elseif maskType == 5,' ...
	  '  sMaskType = ''<'';'  ...
	  'end,',...
	  'maskLevel = get(sliderMaskLevel, ''Value'');',...
	  'maskLevelType = get(popupMaskLevelType, ''Value'');',...
	  'sMaskLevelType = ''Absolute'';',...  % default initial setting
	  'passed_mask_level = maskLevel;',... % default initial setting
	  'if (maskType ~=1),',... % If there is a mask...
	  '  if maskLevelType == 1,',...    % Then if it's fractile, need to convert to absolute
	  '    V_tmp = get(popupVolume, ''UserData'');',... % Create variables for calcs
	  '    maskdata_index_tmp = get(popupMask, ''Value'');',...
	  '    maskdataset_tmp = V_tmp(maskdata_index_tmp,:) * VOXEL_MASK'';',...
	  '    if (maskType == 2),',...  % > masking
	  '      sortedmaskdataset_tmp = sort(maskdataset_tmp(:));',... 
	  '      levelindex_tmp = round((length(sortedmaskdataset_tmp)-1) * maskLevel)+1;',... 
	  '      abs_equiv = sortedmaskdataset_tmp(levelindex_tmp);',... 
	  '    elseif (maskType == 3),',...  % >< masking
	  '      sortedmaskdataset_tmp = sort(abs(maskdataset_tmp(:)));',...
	  '      levelindex_tmp = round((length(sortedmaskdataset_tmp)-1) * maskLevel)+1;',...
	  '      abs_equiv = sortedmaskdataset_tmp(levelindex_tmp);',...
	  '    elseif (maskType == 4),',...  % == masking
	  '      abs_equiv = maskLevel;',...
	  '    elseif (maskType == 5),',...  % < masking
	  '      sortedmaskdataset_tmp = sort(maskdataset_tmp(:));',... 
	  '      levelindex_tmp = round((length(sortedmaskdataset_tmp)-1) * maskLevel)+1;',... 
	  '      abs_equiv = sortedmaskdataset_tmp(levelindex_tmp);',... 
	  '    end,'...
	  '    passed_mask_level = abs_equiv;',... % Switch callbacks to abs 
	  '    sMaskLevelType = ''Absolute'';',...
	  '  elseif any(maskLevelType == [2]),',...  % Absolute-level masking
	  '    sMaskLevelType = ''Absolute'';',...
      '    if (maskType == 2),',...  % Normal (>) absolute masking
      '      passed_mask_level = maskLevel;',... 
      '    elseif (maskType == 3),',...   % Abs (><) absolute masking
      '      passed_mask_level = abs(maskLevel);',... 
      '    elseif (maskType == 4),',...  % Equality (==) absolute masking
      '      passed_mask_level = maskLevel;',... 
      '    elseif (maskType == 5),',...  % Equality (<) absolute masking
      '      passed_mask_level = maskLevel;',... 
      '    end,',...
	  '  end,',...
      'else,',...
      '  sMaskLevelType = ''Absolute'';',...  % No mask, set default
	  'end,',...
	  ];
    
  UpdateMaskSliderStep = [ ...
      'mslidermax = get(sliderMaskLevel, ''Max'');',...
      'mslidermin = get(sliderMaskLevel, ''Min'');',...
      'maskType = get(popupMaskType, ''Value'');',...
      'maskLevelType = get(popupMaskLevelType, ''Value'');',...
      'if (maskType == 4),',...  % '==' masking, so set both stepsizes to single integer
      '  if (maskLevelType == 2),',... % Absolute mask
      '    set(sliderMaskLevel, ''sliderstep'', [1/(mslidermax-mslidermin) 1/(mslidermax-mslidermin)]);',...
      '  else,',...  % Fractile, so set to defaults (otherwise we get a single-step slider)
      '    set(sliderMaskLevel, ''sliderstep'', [0.01 0.1]);',...      
      '  end;',...
      'else,',...  % Other masking, therefore set stepsizes to 1 and 10 percent
      '  set(sliderMaskLevel, ''sliderstep'', [0.01 0.1]);',...
      'end;',...
      ];  
  
    UpdateLeftImage = [ ...
          'ver = (version);',...
          'ver = str2num(ver(1:3));',...
	  'S = get(sliderSlice, ''UserData'');',...
	  'figure(figVolume);',...
	  'dim = lyngby_roi;',...
	  'planeType = get(popupPlane, ''Value'');',...
	  'RayType = get(popupRay, ''Value'');',...
	  'VolumeType = get(popupVolume, ''Value'');',...
	  'SliceMax=S(planeType,2);',...
	  'SliceMin=S(planeType,1);',...
	  'NumTiles=2;',...  
	  'MaxTile=20;',...  
	  'for m=1:20,',...
	  '  axislist{m}=([''axesMosaic'' int2str(m)]);',...
	  'end,',...
	  'if RayType == 1,',...
	  '    S = get(sliderSlice, ''UserData'');',...
	  '    sliceType = S(planeType, 3);',... 
	  '    NumTiles=SliceMax-sliceType+1;',...  
	  '    if NumTiles>20, NumTiles=20; end,', ...
	  'elseif RayType == 2,',...
	  '  if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '    error(''Cannot do mosaic with mean images''),',...  
	  '  else,',...
	  '    sliceType = ''mean'';',...
	  '  end,',...
	  'else,',...
	  '  if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '    error(''Cannot do mosaic with max images''),',...  
	  '  else,',...
	  '    sliceType = ''max'';',...
	  '  end,',...
	  'end,',...
	  'V = get(popupVolume, ''UserData'');',...
	  'DataVolMax = max(V(VolumeType,:));',...
	  'DataVolMin = min(V(VolumeType,:));',...
	  'if planeType == 1,',...
	  '  if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '      for n=1:NumTiles,',...
	  '        I(:,:,n)=lyngby_getslice(V(VolumeType,:), ''s'', sliceType+n-1);',...
	  '      end,',...
	  '  else,',...
	  '    I = lyngby_getslice(V(VolumeType,:), ''s'', sliceType);',...
	  '  end,',...
	  '  firstCoords = dim(2,1):dim(2,2);',...
	  '  secondCoords = dim(3,1):dim(3,2);',...
	  '  planeString = ''Sagittal'';',...
	  '  xlabelString = ''y'';',...
	  '  ylabelString = ''z'';',...
	  'elseif planeType == 2,',...
	  '  if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '      for n=1:NumTiles,',...
	  '        I(:,:,n)=lyngby_getslice(V(VolumeType,:), ''c'', sliceType+n-1);',...
	  '      end,',...
	  '  else,',...
	  '    I = lyngby_getslice(V(VolumeType,:), ''c'', sliceType);',...
	  '  end,',...
	  '  firstCoords = dim(1,1):dim(1,2);',...
	  '  secondCoords = dim(3,1):dim(3,2);',...
	  '  planeString = ''Coronal'';',...
	  '  xlabelString = ''x'';',...
	  '  ylabelString = ''z'';',...
	  'elseif planeType == 3,',...
	  '  if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '      for n=1:NumTiles,',...
	  '        I(:,:,n)=lyngby_getslice(V(VolumeType,:), ''t'', sliceType+n-1);',...
	  '      end,',...
	  '  else,',...
	  '    I = lyngby_getslice(V(VolumeType,:), ''t'', sliceType);',...
	  '  end,',...
	  '  firstCoords = dim(1,1):dim(1,2);',...
	  '  secondCoords = dim(2,1):dim(2,2);',...
	  '  planeString = ''Transversal'';',...
	  '  xlabelString = ''x'';',...
	  '  ylabelString = ''y'';',...
	  'end,',...
	  'col = get(popupColormap,''value'');',...
	  'if (col==1),',...
	  '  colmap = UI_IMAGECOLORMAP;',...
	  'elseif (col==2),',...
	  '  colmap = hot(64);',...
	  'elseif (col==3),',...
	  '  colmap = gray(64);',...
	  'elseif (col==4),',...
	  '  colmap = 1-gray(64);',...
	  'elseif (col==5),',...
	  '  colmap = jet(64);',...
	  'elseif (col==6),',...
	  '  colmap = bone(64);',...
	  'elseif (col==7),',...
	  '  colmap = cool(64);',...
	  'elseif (col==8),',...
	  '  colmap = copper(64);',...
	  'elseif (col==9),',...
	  '  colmap = hsv(64);',...
	  'else,',...
	  '  colmap = UI_IMAGECOLORMAP;',...
	  'end,',...
	  'if get(popupColorbar, ''Value'') == 1, ',...
	  '  bColorbar = 1;',...
	  'else,',...
	  '  bColorbar = 0;',...
	  'end;',...
	  'FTileValue = get(sliderSlice, ''UserData'');',...
	  'TileValue = FTileValue;',...
	  'if strcmp(get(buttonExpand, ''String''), ''More..''),',...
	  '  if (ver >= 5.2) & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '    for n=1:NumTiles,',...
   	  '      axes(eval(axislist{n}));',...
          '      set(eval(axislist{n}), ''Visible'', ''on'');' ...
	  '      lyngby_image(I(:,:,n), ''XLabel'', firstCoords, '...
	  '        ''YLabel'', secondCoords, ''Colormap'', colmap,'...
	  '        ''Colorbar'', bColorbar,'...
	  '        ''Range'', [ DataVolMin DataVolMax ]);',...
	  '      title([''Slice '', num2str(sliceType+n-1)]);',...  
	  '      TileValue(planeType,3)=FTileValue(planeType,3)+n-1;',...
	  '      set(eval(axislist{n}), ''UserData'',  TileValue);',...
          '     end,',...
	  '     for n=NumTiles+1:MaxTile,',...
   	  '      axes(eval(axislist{n}));',...
          '      set(eval(axislist{n}), ''Visible'', ''off'');',...
	  '      cla;',...
	  '     end,',...
	  '  else,',...
	  '    axes(axesNormal);',...
	  '    lyngby_image(I, ''XLabel'', firstCoords, ',...
	  '      ''YLabel'', secondCoords, ''Colormap'', colmap,'...
	  '      ''Colorbar'', bColorbar,'...
          '      ''range'', [ DataVolMin DataVolMax ]);'...
	  '  end,',...
	  'else,',...
	  '  if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''on''),',...
	  '     for n=1:NumTiles,',...
   	  '      axes(eval(axislist{n}));',...
          '      set(eval(axislist{n}), ''Visible'', ''on'');',...
	  '      eval(UpdateLeftImageExpand);', ...
	  '      lyngby_image(I(:,:,n), ''XLabel'', firstCoords, ''YLabel'', secondCoords, ',...
	  '                             ''Colormap'', colmap, ',...
          '                             ''Contour'', Con_tour, ',...
	  '                             ''Back'', Back, ''BackType'', sBackType, ',...
	  '                             ''Mask'', Mask, ''MaskType'', sMaskType, ',...
	  '                             ''MaskLevel'', passed_mask_level, ',...
	  '                             ''MaskLevelType'', sMaskLevelType, ',...
	  '                             ''Colorbar'', bColorbar, ',...
	  '                             ''Range'', [ DataVolMin DataVolMax]);',...
	  '      title([''Slice '', num2str(sliceType+n-1)]);',...  
	  '      TileValue(planeType,3)=FTileValue(planeType,3)+n-1;',...
	  '      set(eval(axislist{n}), ''UserData'',  TileValue);',...
          '     end,',...
	  '     for n=NumTiles+1:MaxTile,',...
   	  '      axes(eval(axislist{n}));',...
          '      set(eval(axislist{n}), ''Visible'', ''off'');',...
	  '      cla;',...
	  '     end,',...
	  '  else,',...
	  '    eval(UpdateLeftImageExpand);', ...
	  '    axes(axesNormal);',...
	  '    lyngby_image(I, ''XLabel'', firstCoords, ',...
	  '      ''YLabel'', secondCoords, ''Colormap'', colmap, ',...
          '      ''Contour'', Con_tour, ',...
	  '      ''Back'', Back, ''BackType'', sBackType, ',...
	  '      ''Mask'', Mask, ''MaskType'', sMaskType, ',...
	  '      ''MaskLevel'', passed_mask_level, ',...
	  '      ''MaskLevelType'', sMaskLevelType, ',...
	  '      ''Colorbar'', bColorbar, ',...
	  '      ''Range'', [ DataVolMin DataVolMax]);',...
	  '  end,',...
	  'end,', ...
	  'set(findobj(figVolume, ''Type'', ''image''), ''ButtonDownFcn'', ''lyngby_ui_view(1000)'');',...
	  'if ver >= 5.2 & strcmp(get(menuMosaic, ''Checked''), ''off''),',...
	  '  if ~isstr(sliceType),',...
	  '    sliceType = [''slice '' num2str(sliceType)];',...
	  '  end,',...
	  '  s = get(popupVolume, ''String'');',...
	  '  v = get(popupVolume, ''Value'');'...
	  '  volumeString = s(v,:);',...
	  '  title([planeString '', '' sliceType '', '' ' ...
	  '      volumeString]);',...
	  '  xlabel(xlabelString);',...
	  '  ylabel(ylabelString);',...
	  'else,',...
	  '  s = get(popupVolume, ''String'');',...
	  '  v = get(popupVolume, ''Value'');'...
	  '  volumeString = s(v,:);',...
	  '  labelString = [planeString '', '' volumeString];',...
	  '  set(textMosaicLabel, ''String'', labelString);',...
	  'end;',...
	  ];


    UpdateLeft = [ ...
	  'eval(UpdateLeftImage);',...
	  ];

    UpdateSlider = [ ...
	  'plane = get(popupPlane, ''Value'');',...
	  'S = get(sliderSlice, ''UserData'');',...
	  'set(sliderSlice, ''Min'', S(plane, 1)-eps);',...
	  'set(sliderSlice, ''Max'', S(plane, 2)+eps);',...
	  'set(sliderSlice, ''Value'', S(plane, 3));',...
	  'if S(plane, 1) == S(plane, 2),',...
	  '  set(sliderSlice, ''Visible'', ''on'');',...
	  '  set(sliderSlice, ''Enable'', ''off'');',...
	  'else,',...
	  '  set(sliderSlice, ''Visible'', ''on'');',...
	  '  set(sliderSlice, ''Enable'', ''on'');',...
	  'end,',...
	  ];
    
    UpdatePosition = [ ...
	  'pos = get(figControl, ''position'');',...
	  'if strcmp(get(buttonExpand, ''string''), ''More..''),',...
	  '  TButtonHeight = 0.3;',...
	  '  TButtonRow2 = 0.6;',...
	  '  TButtonRow1 = 0.1;',...
	  '  TButtonColumn1 = 0.15;',...
	  '  TButtonColumn2 = 0.36;',...
	  '  TButtonColumn3 = 0.44;',...
	  '  TButtonColumn4 = 0.52;',...
	  '  TButtonColumn5 = 0.68;',...
	  '  TButtonColumn6 = 0.80;',...
	  '  TButtonColumn7 = 0.89;',...
          '  TButtonColumn8 = 0.94;',...
	  '  TButtonWidth1 = 0.200;',...
	  '  TButtonWidth2 = 0.150;',...
	  '  TButtonWidth3 = 0.110;',...
	  '  TButtonWidth4 = 0.100;',...
	  '  TButtonWidth5 = 0.080;',...
	  '  TButtonWidth6 = 0.075;',...
	  '  TButtonWidth7 = 0.070;',...
	  '  TButtonWidth8 = 0.069;',...
          '  TButtonWidth9 = 0.050;',...
          '  TButtonWidth10= 0.045;',...
	  '  TFrameColumn1 = 0.004;',...
	  '  TFrameColumn2 = 0.675;',...
	  '  TFrameColumn3 = 0.004;',...
	  '  TFrameRow2 = 0.525;',...
	  '  TFrameRow1 = 0.025;',...
	  '  TFrameWidth3 = 0.321;',...
	  '  TFrameWidth2 = 0.675;',...
	  '  TFrameWidth1 = 0.992;',...
	  '  TFrameHeight = 0.450;',...
	  '  TFrameLabelColumn = 0.027;',...
	  '  TFrameLabelRow1 = 0.1375;',...
	  '  TFrameLabelRow2 = 0.6375;',...
	  '  TFrameLabelWidth = 0.1;',...
	  '  TFrameLabelHeight = 0.2;',...
	  '  pos(4) = 80;',...
	  '  set(figControl, ''position'', pos);',... 
	  '  set(radioContour, ''Visible'', ''off'');',...
	  '  set(radioBackground, ''Visible'', ''off'');',...
	  '  set(popupContour, ''Visible'', ''off'');',...
	  '  set(popupBackground, ''Visible'', ''off'');',...
	  '  set(popupContourRay, ''Visible'', ''off'');',...
	  '  set(popupBackgroundRay, ''Visible'', ''off'');',...
	  '  set(popupMask, ''Visible'', ''off'');',...
	  '  set(popupMaskType, ''Visible'', ''off'');',...
	  '  set(sliderMaskLevel, ''Visible'', ''off'');',...
	  '  set(editMaskLevel, ''Visible'', ''off'');',...
	  '  set(popupMaskLevelType, ''Visible'', ''off'');',...
	  '  set(frameContour, ''Visible'', ''off'');',...
	  '  set(frameBackground, ''Visible'', ''off'');',...
	  '  set(frameMask, ''Visible'', ''off'');',...
	  '  set(textContourLabel, ''Visible'', ''off'');',...
	  '  set(textBackgroundLabel, ''Visible'', ''off'');',...
	  '  set(textMaskLabel, ''Visible'', ''off'');',...
	  '  set(frameData, ''Position'',    [ TFrameColumn1 TFrameRow2 TFrameWidth1 TFrameHeight ]);',... 
	  '  set(frameTime, ''Position'',    [ TFrameColumn1 TFrameRow1 TFrameWidth2 TFrameHeight ]);',... 
	  '  set(frameSystem, ''Position'',  [ TFrameColumn2 TFrameRow1 TFrameWidth3 TFrameHeight ]);',... 
	  '  set(textDataLabel, ''Position'',[ TFrameLabelColumn TFrameLabelRow2 TFrameLabelWidth TFrameLabelHeight ]);',... 
	  '  set(textTimeLabel, ''Position'',[ TFrameLabelColumn TFrameLabelRow1 TFrameLabelWidth TFrameLabelHeight ]);',... 
	  '  set(popupVolume, ''Position'',        [ TButtonColumn1 TButtonRow2 TButtonWidth1  TButtonHeight ]);',... 
	  '  set(popupPlane, ''Position'',         [ TButtonColumn2 TButtonRow2 TButtonWidth2  TButtonHeight ]);',... 
	  '  set(popupRay, ''Position'',           [ TButtonColumn5 TButtonRow2 TButtonWidth3  TButtonHeight ]);',... 
	  '  set(sliderSlice, ''Position'',        [ TButtonColumn4 TButtonRow2 TButtonWidth2  TButtonHeight ]);',... 
	  '  set(popupColormap, ''Position'',      [ TButtonColumn6 TButtonRow2 TButtonWidth5  TButtonHeight ]);',... 
	  '  set(popupColorbar, ''Position'',      [ TButtonColumn7 TButtonRow2 TButtonWidth4  TButtonHeight ]);',... 
	  '  set(popupScale, ''Position'',         [ TButtonColumn6 TButtonRow2 TButtonWidth4  TButtonHeight ]);',... 
	  '  set(popupColormapCtrl, ''Position'',  [ TButtonColumn7 TButtonRow2 TButtonWidth5  TButtonHeight ]);',... 
	  '  set(buttonAspect, ''Position'',       [ TButtonColumn5 TButtonRow2 TButtonWidth2  TButtonHeight ]);',... 
	  '  set(popupTime, ''Position'',          [ TButtonColumn1 TButtonRow1 TButtonWidth1  TButtonHeight ]);',... 
	  '  set(popupZoom, ''Position'',          [ TButtonColumn2 TButtonRow1 TButtonWidth8  TButtonHeight ]);',... 
	  '  set(sliderScroll, ''Position'',       [ TButtonColumn4 TButtonRow1 TButtonWidth2  TButtonHeight ]);',... 
	  '  set(popupAmplitude, ''Position'',     [ TButtonColumn3 TButtonRow1 TButtonWidth7  TButtonHeight ]);',... 
	  '  set(buttonHelp, ''Position'',         [ TButtonColumn7 TButtonRow1 TButtonWidth10 TButtonHeight ]);',... 
	  '  set(buttonClose, ''Position'',        [ TButtonColumn5 TButtonRow1 TButtonWidth3  TButtonHeight ]);',... 
	  '  set(buttonExpand, ''Position'',       [ TButtonColumn8 TButtonRow1 TButtonWidth9  TButtonHeight ]);',... 
	  '  set(buttonSaveLeftImage, ''Position'',[ TButtonColumn7 TButtonRow2 TButtonWidth3  TButtonHeight ]);',... 
	  '  set(buttonSaveExpand, ''Position'',   [ TButtonColumn6 TButtonRow1 TButtonWidth5  TButtonHeight ]);',... 
	  'else',...
	  '  ButtonHeight = 0.16;',...
	  '  ButtonRow4 = 0.79;',...
	  '  ButtonRow3 = 0.54;',...
	  '  ButtonRow2 = 0.29;',...
	  '  ButtonRow1 = 0.05;',...
	  '  ButtonColumn1 = 0.15;',...
	  '  ButtonColumn2 = 0.36;',...
	  '  ButtonColumn3 = 0.44;',...
	  '  ButtonColumn4 = 0.52;',...
	  '  ButtonColumn5 = 0.68;',...
	  '  ButtonColumn6 = 0.80;',...
	  '  ButtonColumn7 = 0.89;',...
          '  ButtonColumn8 = 0.94;',...
	  '  ButtonWidth1 = 0.200;',...
	  '  ButtonWidth2 = 0.150;',...
	  '  ButtonWidth3 = 0.110;',...
	  '  ButtonWidth4 = 0.100;',...
	  '  ButtonWidth5 = 0.080;',...
	  '  ButtonWidth6 = 0.075;',...
	  '  ButtonWidth7 = 0.070;',...
	  '  ButtonWidth8 = 0.069;',...
          '  ButtonWidth9 = 0.050;',...
          '  ButtonWidth10= 0.045;',...
	  '  FrameColumn1 = 0.004;',...
	  '  FrameColumn2 = 0.675;',...
	  '  FrameColumn3 = 0.004;',...
	  '  FrameRow4 = 0.765;',...
	  '  FrameRow3 = 0.515;',...
	  '  FrameRow2 = 0.265;',...
	  '  FrameRow1 = 0.025;',...
	  '  FrameWidth3 = 0.321;',...
	  '  FrameWidth2 = 0.675;',...
	  '  FrameWidth1 = 0.992;',...
	  '  FrameHeight = 0.210;',...
	  '  FrameLabelColumn = 0.027;',...
	  '  FrameLabelRow1 = 0.100;',...
	  '  FrameLabelRow2 = 0.340;',...
	  '  FrameLabelRow3 = 0.570;',...
	  '  FrameLabelRow4 = 0.815;',...
	  '  FrameLabelWidth = 0.1;',...
	  '  FrameLabelHeight = 0.1;',...
	  '  pos(4) = 120;',...
	  '  set(figControl, ''position'', pos);',... 
	  '  set(radioContour, ''Visible'', ''on'');',...
	  '  set(radioBackground, ''Visible'', ''on'');',...
	  '  set(popupContour, ''Visible'', ''on'');',...
	  '  set(popupContourRay, ''Visible'', ''on'');',...
	  '  set(popupBackground, ''Visible'', ''on'');',...
	  '  set(popupBackgroundRay, ''Visible'', ''on'');',...
	  '  set(popupMask, ''Visible'', ''on'');',...
	  '  set(popupMaskType, ''Visible'', ''on'');',...
	  '  set(sliderMaskLevel, ''Visible'', ''on'');',...
	  '  set(editMaskLevel, ''Visible'', ''on'');',...
	  '  set(popupMaskLevelType, ''Visible'', ''on'');',...
	  '  set(frameContour, ''Visible'', ''on'');',...
	  '  set(frameBackground, ''Visible'', ''on'');',...
	  '  set(frameMask, ''Visible'', ''on'');',...
	  '  set(frameData, ''Visible'', ''on'');',...
	  '  set(frameTime, ''Visible'', ''on'');',...
	  '  set(frameSystem, ''Visible'', ''on'');',...
	  '  set(textContourLabel, ''Visible'', ''on'');',...
	  '  set(textBackgroundLabel, ''Visible'', ''on'');',...
	  '  set(textMaskLabel, ''Visible'', ''on'');',...
	  '  set(textDataLabel, ''Visible'', ''on'');',...
	  '  set(textTimeLabel, ''Visible'', ''on'');',...
	  '  set(frameContour, ''Position'',    [ FrameColumn1 FrameRow4 0.513      FrameHeight ]);',... 
	  '  set(frameBackground, ''Position'', [ 0.519        FrameRow4 0.477      FrameHeight ]);',... 
	  '  set(frameMask, ''Position'',       [ FrameColumn1 FrameRow3 FrameWidth1 FrameHeight ]);',... 
	  '  set(frameData, ''Position'',       [ FrameColumn1 FrameRow2 FrameWidth1 FrameHeight ]);',... 
	  '  set(frameTime, ''Position'',       [ FrameColumn1 FrameRow1 FrameWidth2 FrameHeight ]);',... 
	  '  set(frameSystem, ''Position'',     [ FrameColumn2 FrameRow1 FrameWidth3 FrameHeight ]);',... 
	  '  set(textContourLabel, ''Position'',    [FrameLabelColumn FrameLabelRow4 FrameLabelWidth FrameLabelHeight ]);',... 
	  '  set(textBackgroundLabel, ''Position'', [    0.5437       FrameLabelRow4 FrameLabelWidth FrameLabelHeight ]);',... 
	  '  set(textMaskLabel, ''Position'',       [FrameLabelColumn FrameLabelRow3 FrameLabelWidth FrameLabelHeight ]);',... 
	  '  set(textDataLabel, ''Position'',       [FrameLabelColumn FrameLabelRow2 FrameLabelWidth FrameLabelHeight ]);',... 
	  '  set(textTimeLabel, ''Position'',       [FrameLabelColumn FrameLabelRow1 FrameLabelWidth FrameLabelHeight ]);',... 
	  '  set(popupVolume, ''Position'',        [ ButtonColumn1 ButtonRow2 ButtonWidth1  ButtonHeight ]);',... 
	  '  set(popupPlane, ''Position'',         [ ButtonColumn2 ButtonRow2 ButtonWidth2  ButtonHeight ]);',... 
	  '  set(popupRay, ''Position'',           [ ButtonColumn5 ButtonRow2 ButtonWidth3  ButtonHeight ]);',... 
	  '  set(sliderSlice, ''Position'',        [ ButtonColumn4 ButtonRow2 ButtonWidth2  ButtonHeight ]);',... 
	  '  set(popupColormap, ''Position'',      [ ButtonColumn6 ButtonRow2 ButtonWidth5  ButtonHeight ]);',... 
	  '  set(popupColorbar, ''Position'',      [ ButtonColumn7 ButtonRow2 ButtonWidth4  ButtonHeight ]);',... 
	  '  set(popupScale, ''Position'',         [ ButtonColumn6 ButtonRow2 ButtonWidth4  ButtonHeight ]);',... 
	  '  set(popupColormapCtrl, ''Position'',  [ ButtonColumn7 ButtonRow2 ButtonWidth5  ButtonHeight ]);',... 
	  '  set(buttonAspect, ''Position'',       [ ButtonColumn5 ButtonRow2 ButtonWidth4  ButtonHeight ]);',... 
	  '  set(popupTime, ''Position'',          [ ButtonColumn1 ButtonRow1 ButtonWidth1  ButtonHeight ]);',... 
	  '  set(popupZoom, ''Position'',          [ ButtonColumn2 ButtonRow1 ButtonWidth8  ButtonHeight ]);',... 
	  '  set(sliderScroll, ''Position'',       [ ButtonColumn4 ButtonRow1 ButtonWidth2  ButtonHeight ]);',... 
	  '  set(popupAmplitude, ''Position'',     [ ButtonColumn3 ButtonRow1 ButtonWidth7  ButtonHeight ]);',... 
	  '  set(radioContour, ''Position'',          [ ButtonColumn1 ButtonRow4   0.0213     ButtonHeight ]);',...
	  '  set(radioBackground, ''Position'',       [ ButtonColumn5 ButtonRow4   0.0213     ButtonHeight ]);',...
	  '  set(popupContour, ''Position'',          [   0.1738      ButtonRow4   0.1762     ButtonHeight ]);',...
	  '  set(popupContourRay, ''Position'',       [ ButtonColumn2 ButtonRow4 ButtonWidth2 ButtonHeight ]);',...
	  '  set(popupBackground, ''Position'',       [   0.7050      ButtonRow4   0.1750     ButtonHeight ]);',...
	  '  set(popupBackgroundRay, ''Position'',    [ ButtonColumn7 ButtonRow4 ButtonWidth4 ButtonHeight ]);',...
	  '  set(popupMask, ''Position'',             [ ButtonColumn1 ButtonRow3 ButtonWidth1 ButtonHeight ]);',...
	  '  set(popupMaskType, ''Position'',         [ ButtonColumn2 ButtonRow3 ButtonWidth6 ButtonHeight ]);',...
	  '  set(sliderMaskLevel, ''Position'',       [ ButtonColumn4 ButtonRow3 ButtonWidth2 ButtonHeight ]);',...
	  '  set(editMaskLevel, ''Position'',         [ ButtonColumn3 ButtonRow3 ButtonWidth7 ButtonHeight ]);',...
	  '  set(popupMaskLevelType, ''Position'',    [ ButtonColumn5 ButtonRow3 ButtonWidth1 ButtonHeight ]);',...
	  '  set(buttonHelp, ''Position'',         [ ButtonColumn7 ButtonRow1 ButtonWidth10 ButtonHeight ]);',... 
	  '  set(buttonClose, ''Position'',        [ ButtonColumn5 ButtonRow1 ButtonWidth3  ButtonHeight ]);',... 
	  '  set(buttonExpand, ''Position'',       [ ButtonColumn8 ButtonRow1 ButtonWidth9  ButtonHeight ]);',... 
	  '  set(buttonSaveLeftImage, ''Position'',[ ButtonColumn7 ButtonRow2 ButtonWidth3  ButtonHeight ]);',... 
	  '  set(buttonSaveExpand, ''Position'',   [ ButtonColumn6 ButtonRow1 ButtonWidth5  ButtonHeight ]);',... 
	  'end',...
	  ];

    UpdateSaveDataPosition = [ ...
          'SButtonRow1 = 0.0387;',...
          'SButtonRow2 = 0.2245;',...
          'SButtonRow3 = 0.4181;',...
          'SButtonRow4 = 0.6116;',...
          'SButtonRow5 = 0.8051;',...
          'SFrameRow1 = 0.0194;',...
          'SFrameRow2 = 0.2052;',...
          'SFrameRow3 = 0.3987;',...
          'SFrameRow4 = 0.5923;',...
          'SFrameRow5 = 0.7859;',...
          'SFrameLabelRow1 = 0.0774;',...
          'SFrameLabelRow2 = 0.2632;',...
          'SFrameLabelRow3 = 0.4413;',...
          'SFrameLabelRow4 = 0.6310;',...
          'SFrameLabelRow5 = 0.8246;',...
          'SFrameHeight = 0.1626;',...
          'SFrameLabelHeight = 0.0774;',...
          'SButtonHeight = 0.1239;',...
	  'ButtonColumn1 = 0.15;',...
	  'ButtonColumn2 = 0.36;',...
	  'ButtonColumn3 = 0.44;',...
	  'ButtonColumn4 = 0.52;',...
	  'ButtonColumn5 = 0.68;',...
	  'ButtonColumn6 = 0.80;',...
	  'ButtonColumn7 = 0.89;',...
          'ButtonColumn8 = 0.94;',...
	  'ButtonWidth1 = 0.200;',...
	  'ButtonWidth2 = 0.150;',...
	  'ButtonWidth3 = 0.110;',...
	  'ButtonWidth4 = 0.100;',...
	  'ButtonWidth5 = 0.080;',...
	  'ButtonWidth6 = 0.075;',...
	  'ButtonWidth7 = 0.070;',...
	  'ButtonWidth8 = 0.069;',...
          'ButtonWidth9 = 0.050;',...
          'ButtonWidth10= 0.045;',...
	  'FrameColumn1 = 0.004;',...
	  'FrameColumn2 = 0.675;',...
	  'FrameColumn3 = 0.004;',...
	  'FrameWidth3 = 0.321;',...
	  'FrameWidth2 = 0.675;',...
	  'FrameWidth1 = 0.992;',...
	  'FrameLabelColumn = 0.027;',...
	  'FrameLabelWidth = 0.1;',...
	  'pos = get(figControl, ''position'');',...
	  'if strcmp(get(buttonSaveExpand, ''string''), ''Close Save''),',...   % ==========Save Layer Active=========
	  '  pos(4) = 155;',...                                                       % ====== Set window to 5 layers ======
	  '  set(figControl, ''position'', pos);',... 
	  '  set(frameFile, ''Visible'', ''on'');',...
	  '  set(textFile, ''Visible'', ''on'');',...
	  '  set(popupSavetype, ''Visible'', ''on'');',...
	  '  set(popupFiletype, ''Visible'', ''on'');',...
	  '  set(buttonOption, ''Visible'', ''on'');',...
	  '  set(popupCompress, ''Visible'', ''on'');',...
	  '  set(editFilename, ''Visible'', ''on'');',...
	  '  set(buttonBrowse, ''Visible'', ''on'');',...
	  '  set(buttonSave, ''Visible'', ''on'');',...
	  '  set(radioContour, ''Visible'', ''on'');',...
	  '  set(radioBackground, ''Visible'', ''on'');',...
	  '  set(popupContour, ''Visible'', ''on'');',...
	  '  set(popupContourRay, ''Visible'', ''on'');',...
	  '  set(popupBackground, ''Visible'', ''on'');',...
	  '  set(popupBackgroundRay, ''Visible'', ''on'');',...
	  '  set(popupMask, ''Visible'', ''on'');',...
	  '  set(popupMaskType, ''Visible'', ''on'');',...
	  '  set(sliderMaskLevel, ''Visible'', ''on'');',...
	  '  set(editMaskLevel, ''Visible'', ''on'');',...
	  '  set(popupMaskLevelType, ''Visible'', ''on'');',...
	  '  set(frameContour, ''Visible'', ''on'');',...
	  '  set(frameBackground, ''Visible'', ''on'');',...
	  '  set(frameMask, ''Visible'', ''on'');',...
	  '  set(frameData, ''Visible'', ''on'');',...
	  '  set(frameTime, ''Visible'', ''on'');',...
	  '  set(frameSystem, ''Visible'', ''on'');',...
	  '  set(textContourLabel, ''Visible'', ''on'');',...
	  '  set(textBackgroundLabel, ''Visible'', ''on'');',...
	  '  set(textMaskLabel, ''Visible'', ''on'');',...
	  '  set(textDataLabel, ''Visible'', ''on'');',...
	  '  set(textTimeLabel, ''Visible'', ''on'');',...
	  '  set(frameContour, ''Position'',    [ FrameColumn1 SFrameRow4 0.513      SFrameHeight ]);',... 
	  '  set(frameBackground, ''Position'', [ 0.519        SFrameRow4 0.477      SFrameHeight ]);',... 
	  '  set(frameMask, ''Position'',       [ FrameColumn1 SFrameRow3 FrameWidth1 SFrameHeight ]);',... 
	  '  set(frameData, ''Position'',       [ FrameColumn1 SFrameRow2 FrameWidth1 SFrameHeight ]);',... 
	  '  set(frameTime, ''Position'',       [ FrameColumn1 SFrameRow1 FrameWidth2 SFrameHeight ]);',... 
	  '  set(frameSystem, ''Position'',     [ FrameColumn2 SFrameRow1 FrameWidth3 SFrameHeight ]);',... 
	  '  set(textContourLabel, ''Position'',    [ FrameLabelColumn SFrameLabelRow4 FrameLabelWidth SFrameLabelHeight ]);',... 
	  '  set(textBackgroundLabel, ''Position'', [     0.5437       SFrameLabelRow4 FrameLabelWidth SFrameLabelHeight ]);',... 
	  '  set(textMaskLabel, ''Position'',       [ FrameLabelColumn SFrameLabelRow3 FrameLabelWidth SFrameLabelHeight ]);',... 
	  '  set(textDataLabel, ''Position'',       [ FrameLabelColumn SFrameLabelRow2 FrameLabelWidth SFrameLabelHeight ]);',... 
	  '  set(textTimeLabel, ''Position'',       [ FrameLabelColumn SFrameLabelRow1 FrameLabelWidth SFrameLabelHeight ]);',... 
	  '  set(popupVolume, ''Position'',        [ ButtonColumn1 SButtonRow2 ButtonWidth1  SButtonHeight ]);',... 
	  '  set(popupPlane, ''Position'',         [ ButtonColumn2 SButtonRow2 ButtonWidth2  SButtonHeight ]);',... 
	  '  set(popupRay, ''Position'',           [ ButtonColumn5 SButtonRow2 ButtonWidth3  SButtonHeight ]);',... 
	  '  set(sliderSlice, ''Position'',        [ ButtonColumn4 SButtonRow2 ButtonWidth2  SButtonHeight ]);',... 
	  '  set(popupColormap, ''Position'',      [ ButtonColumn6 SButtonRow2 ButtonWidth5  SButtonHeight ]);',... 
	  '  set(popupColorbar, ''Position'',      [ ButtonColumn7 SButtonRow2 ButtonWidth4  SButtonHeight ]);',... 
	  '  set(popupScale, ''Position'',         [ ButtonColumn6 SButtonRow2 ButtonWidth4  SButtonHeight ]);',... 
	  '  set(popupColormapCtrl, ''Position'',  [ ButtonColumn7 SButtonRow2 ButtonWidth5  SButtonHeight ]);',... 
	  '  set(buttonAspect, ''Position'',       [ ButtonColumn5 SButtonRow2 ButtonWidth4  SButtonHeight ]);',... 
	  '  set(popupTime, ''Position'',          [ ButtonColumn1 SButtonRow1 ButtonWidth1  SButtonHeight ]);',... 
	  '  set(popupZoom, ''Position'',          [ ButtonColumn2 SButtonRow1 ButtonWidth6  SButtonHeight ]);',... 
	  '  set(sliderScroll, ''Position'',       [ ButtonColumn4 SButtonRow1 ButtonWidth2  SButtonHeight ]);',... 
	  '  set(popupAmplitude, ''Position'',     [ ButtonColumn3 SButtonRow1 ButtonWidth7  SButtonHeight ]);',... 
	  '  set(radioContour, ''Position'',          [ ButtonColumn1 SButtonRow4   0.0213     SButtonHeight ]);',...
	  '  set(radioBackground, ''Position'',       [ ButtonColumn5 SButtonRow4   0.0213     SButtonHeight ]);',...
	  '  set(popupContour, ''Position'',          [   0.1738      SButtonRow4   0.1762     SButtonHeight ]);',...
	  '  set(popupContourRay, ''Position'',       [ ButtonColumn2 SButtonRow4 ButtonWidth2 SButtonHeight ]);',...
	  '  set(popupBackground, ''Position'',       [   0.7050      SButtonRow4   0.1750     SButtonHeight ]);',...
	  '  set(popupBackgroundRay, ''Position'',    [ ButtonColumn7 SButtonRow4 ButtonWidth4 SButtonHeight ]);',...
	  '  set(popupMask, ''Position'',             [ ButtonColumn1 SButtonRow3 ButtonWidth1 SButtonHeight ]);',...
	  '  set(popupMaskType, ''Position'',         [ ButtonColumn2 SButtonRow3 ButtonWidth6 SButtonHeight ]);',...
	  '  set(sliderMaskLevel, ''Position'',       [ ButtonColumn4 SButtonRow3 ButtonWidth2 SButtonHeight ]);',...
	  '  set(editMaskLevel, ''Position'',         [ ButtonColumn3 SButtonRow3 ButtonWidth7 SButtonHeight ]);',...
	  '  set(popupMaskLevelType, ''Position'',    [ ButtonColumn5 SButtonRow3 ButtonWidth1 SButtonHeight ]);',...
	  '  set(buttonHelp, ''Position'',         [ ButtonColumn7 SButtonRow1 ButtonWidth10 SButtonHeight ]);',... 
	  '  set(buttonClose, ''Position'',        [ ButtonColumn5 SButtonRow1 ButtonWidth3  SButtonHeight ]);',... 
	  '  set(buttonExpand, ''Position'',       [ ButtonColumn8 SButtonRow1 ButtonWidth9  SButtonHeight ]);',... 
	  '  set(buttonSaveLeftImage, ''Position'',[ ButtonColumn7 SButtonRow2 ButtonWidth3  SButtonHeight ]);',... 
	  '  set(buttonSaveExpand, ''Position'',   [ ButtonColumn6 SButtonRow1 ButtonWidth5  SButtonHeight ]);',... 
      '  eval(UpdateFiletype);',...
  'else',...                                                                  % ==========Save Layer InActive=======
	  '  set(frameFile, ''Visible'', ''off'');',...
	  '  set(textFile, ''Visible'', ''off'');',...
	  '  set(popupSavetype, ''Visible'', ''off'');',...
	  '  set(popupFiletype, ''Visible'', ''off'');',...
	  '  set(buttonOption, ''Visible'', ''off'');',...
	  '  set(popupCompress, ''Visible'', ''off'');',...
	  '  set(editFilename, ''Visible'', ''off'');',...
	  '  set(buttonBrowse, ''Visible'', ''off'');',...
	  '  set(buttonSave, ''Visible'', ''off'');',...
          '  eval(UpdatePosition);',...
	  'end',...
	  ];

    % Save Layer function
    UpdateFiletype = [ ...
	  'savetype = get(popupSavetype, ''value'');',...
	  'if savetype == 1,',...
	  '  set(popupFiletype, ''String'', ',...
	  '     ''ASCII|ANALYZE|Matlab binary|SDT|VAPET|Voxel Mask'');',... 
          '  set(popupFiletype, ''Value'', [ 1 ]);',... 
          '  set(frameTime, ''BackgroundColor'', [ 0.105 0.538 1 ]);',... 
          '  set(frameData, ''BackgroundColor'', [ 1 0.193 0.215 ]);',... 
          '  set(frameMask, ''BackgroundColor'', [ 1 0.193 0.215 ]);',... 
          '  set(textTimeLabel, ''BackgroundColor'', [ 0.105 0.538 1 ]);',... 
          '  set(textDataLabel, ''BackgroundColor'', [ 1 0.193 0.215 ]);',... 
          '  set(textMaskLabel, ''BackgroundColor'', [ 1 0.193 0.215 ]);',... 
	  'elseif savetype == 2,', ...
	  '  set(popupFiletype, ''String'', ', ...
	  '     ''ASCII|Matlab binary|Matlab4 binary'');',...
          '  set(popupFiletype, ''Value'', [ 1 ]);',... 
          '  set(frameTime, ''BackgroundColor'', [ 1 0.193 0.215 ]);',... 
          '  set(frameData, ''BackgroundColor'', [ 0.105 0.538 1 ]);',... 
          '  set(frameMask, ''BackgroundColor'', [ 0.105 0.538 1 ]);',... 
          '  set(textTimeLabel, ''BackgroundColor'', [ 1 0.193 0.215 ]);',... 
          '  set(textDataLabel, ''BackgroundColor'', [ 0.105 0.538 1 ]);',... 
          '  set(textMaskLabel, ''BackgroundColor'', [ 0.105 0.538 1 ]);',... 
	  'end,',...
	  ];

    % 'elseif savetype == 2,', ...
    % '  set(popupFiletype, ''String'', ',...
    % '     ''ASCII|ANALYZE|Matlab binary|SDT|VAPET'');',... 
    % '  set(popupFiletype, ''Value'', [ 1 ]);',... 
    % '  set(frameTime, ''BackgroundColor'', [ 0.105 0.538 1 ]);',... 
    % '  set(frameData, ''BackgroundColor'', [ 1 0.193 0.215 ]);',... 
    % '  set(frameMask, ''BackgroundColor'', [ 1 0.193 0.215 ]);',... 
    % '  set(textTimeLabel, ''BackgroundColor'', [ 0.105 0.538 1 ]);',... 
    % '  set(textDataLabel, ''BackgroundColor'', [ 1 0.193 0.215 ]);',... 
    % '  set(textMaskLabel, ''BackgroundColor'', [ 1 0.193 0.215 ]);',... 
    
    
    
    % Save Layer function
    UpdateFilename = [ ...
	  'savetype = get(popupSavetype, ''value'');',...
	  'filetype = get(popupFiletype, ''value'');',...
	  'compresstype = get(popupCompress, ''Value'');',...
	  'filename = get(editFilename, ''String'');',...
	  'index = findstr(lower(filename), ''.z'');',...
	  'if ~isempty(index) & length(filename) == index+1,',...
	  '  filename = filename(1:end-2);',...
	  'end,',...
	  'index = findstr(lower(filename), ''.gz'');',...
	  'if ~isempty(index) & length(filename) == index+2,',...
	  '  filename = filename(1:end-3);',...
	  'end,',...
	  'if compresstype == 2,',...
	  '  filename = [ filename ''.gz'' ];',...
	  'elseif compresstype == 3,',...
	  '  filename = [ filename ''.Z'' ];',...
	  'end,',...
	  'set(editFilename, ''String'', filename);',...
	  ];
     
    
    if isstr(arg1) 
      if strcmp(lower(arg1),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(arg1),lower('sliderSlice')) 
	command = 2; 
      elseif strcmp(lower(arg1),lower('popupRay')) 
	command = 3; 
      elseif strcmp(lower(arg1),lower('popupVolume')) 
	command = 4; 
      elseif strcmp(lower(arg1),lower('popupPlane')) 
	command = 5; 
      elseif strcmp(lower(arg1),lower('popupTime')) 
	command = 6; 
      elseif strcmp(lower(arg1),lower('buttonAspect')) 
	command = 7; 
      elseif strcmp(lower(arg1),lower('popupZoom')) 
	command = 8; 
      elseif strcmp(lower(arg1),lower('sliderScroll')) 
	command = 9; 
      elseif strcmp(lower(arg1),lower('popupAmplitude')) 
	command = 10; 
      elseif strcmp(lower(arg1),lower('buttonSaveLeftImage')) 
	command = 12; 
      elseif strcmp(lower(arg1),lower('popupScale')) 
	command = 140;
      elseif strcmp(lower(arg1),lower('popupColormap')) 
	command = 150; 
      elseif strcmp(lower(arg1),lower('popupColorbar')) 
	command = 155; 
      elseif strcmp(lower(arg1),lower('popupColormapCtrl')) 
	command = 160; 
      elseif strcmp(lower(arg1),lower('popupContour')) 
	command = 300;
      elseif strcmp(lower(arg1),lower('radioContour')) 
	command = 310;
      elseif strcmp(lower(arg1),lower('popupContourRay')) 
	command = 320;
      elseif strcmp(lower(arg1),lower('radioBackground')) 
	command = 330;
      elseif strcmp(lower(arg1),lower('popupBackground')) 
	command = 340;
      elseif strcmp(lower(arg1),lower('popupBackgroundRay')) 
	command = 350;
      elseif strcmp(lower(arg1),lower('popupMask')) 
	command = 400;
      elseif strcmp(lower(arg1),lower('popupMaskType')) 
	command = 410;
      elseif strcmp(lower(arg1),lower('sliderMaskLevel')) 
	command = 420;
      elseif strcmp(lower(arg1),lower('editMaskLevel')) 
	command = 430;
      elseif strcmp(lower(arg1),lower('popupMaskLevelType')) 
	command = 440;
      elseif strcmp(lower(arg1),lower('buttonHelp')) 
	command = 500; 
      elseif strcmp(lower(arg1),lower('ToggleTooltips'))
	command = 600;
      elseif strcmp(lower(arg1),lower('buttonSave')) 
	command = 700; 
      elseif strcmp(lower(arg1),lower('popupSavetype')) 
	command = 710;
      elseif strcmp(lower(arg1),lower('popupFiletype')) 
	command = 720;
      elseif strcmp(lower(arg1),lower('buttonOption')) 
	command = 730;
      elseif strcmp(lower(arg1),lower('popupCompress')) 
	command = 740;
      elseif strcmp(lower(arg1),lower('editFilename')) 
	command = 750;
      elseif strcmp(lower(arg1),lower('editBrowse')) 
	command = 760;
      elseif strcmp(lower(arg1),lower('buttonBrowse')) 
	command = 770; 
      elseif strcmp(lower(arg1),lower('ToggleMosaic'))
	command = 900;	

      elseif strcmp(lower(arg1),lower('buttonExpand')) 
	command = 10000; 
      elseif strcmp(lower(arg1),lower('buttonSaveExpand')) 
	command = 20000; 
      end 
    else
      if ~all(size(arg1) == [1 1])
	if nargin >= 2 
	  command = 0;
	else
	  error('Wrong number of arguments');
	end
      else
	command = arg1;
      end
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_view', ...
	  'UserData', get(gcf, 'UserData')); 
      if length(h_fig_list) > 1 
	if strcmp(get(gcf, 'tag'), 'lyngby_ui_view')
	  h_fig_list = gcf;
	else
	  error('Ops, Can''t get a unique figure identifier');
	end
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_view.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	figControl = handle_list(1);
	figVolume = handle_list(2);
	figTime = handle_list(3);
	buttonClose = handle_list(4); 
	sliderSlice = handle_list(5); 
	popupRay = handle_list(6); 
	popupVolume = handle_list(7); 
	popupPlane = handle_list(8); 
	popupTime = handle_list(9);
	buttonAspect = handle_list(10);
	popupZoom = handle_list(11);
	sliderScroll = handle_list(12);
	popupAmplitude = handle_list(13);
	popupColormap = handle_list(14);
	buttonSaveLeftImage = handle_list(15);
	buttonHelp = handle_list(16);
	buttonExpand = handle_list(17);
	popupContour = handle_list(18); 

	popupContourRay = handle_list(19);
	popupMask = handle_list(20);
	popupMaskType = handle_list(21);
	sliderMaskLevel = handle_list(22);
	editMaskLevel = handle_list(23);
	popupMaskLevelType = handle_list(24);
	popupScale = handle_list(25);
	popupColormapCtrl = handle_list(26);
	popupColorbar = handle_list(27);
	frameContour = handle_list(28);
        frameBackground = handle_list(29);
	frameMask = handle_list(30);
	frameData = handle_list(31);
	frameTime = handle_list(32);
	frameSystem = handle_list(33);
	textContourLabel = handle_list(34);
        textBackgroundLabel = handle_list(35);
	textMaskLabel = handle_list(36);
	textDataLabel = handle_list(37);
	textTimeLabel = handle_list(38);
        radioContour = handle_list(39);
        radioBackground = handle_list(40);
        popupBackground = handle_list(41);
        popupBackgroundRay = handle_list(42);
	menuOptions = handle_list(43);
	menuTooltips = handle_list(44);
        frameFile = handle_list(45);
        textFile = handle_list(46);
        popupSavetype = handle_list(47);
        popupFiletype = handle_list(48);
        buttonOption = handle_list(49);
        popupCompress = handle_list(50);
        editFilename = handle_list(51);
        buttonBrowse = handle_list(52);
        buttonSave = handle_list(53);
        buttonSaveExpand = handle_list(54);
        menuMosaic = handle_list(55);
	axesNormal = handle_list(56);
	axesMosaic1 = handle_list(57);
	axesMosaic2 = handle_list(58);
	axesMosaic3 = handle_list(59);
	axesMosaic4 = handle_list(60);
	axesMosaic5 = handle_list(61);
	axesMosaic6 = handle_list(62);
	axesMosaic7 = handle_list(63);
	axesMosaic8 = handle_list(64);
	axesMosaic9 = handle_list(65);
	axesMosaic10 = handle_list(66);
	axesMosaic11 = handle_list(67);
	axesMosaic12 = handle_list(68);
	axesMosaic13 = handle_list(69);
	axesMosaic14 = handle_list(70);
	axesMosaic15 = handle_list(71);
	axesMosaic16 = handle_list(72);
	axesMosaic17 = handle_list(73);
	axesMosaic18 = handle_list(74);
	axesMosaic19 = handle_list(75);
	axesMosaic20 = handle_list(76);
	textMosaicLabel = handle_list(77);
        menuViewOptions = handle_list(78);
      end 
    end 

    
    

    if command == 0 

      figControl = figure('position',[ 10 40 800 120 ],... 
	  'resize','on',...
	  'tag','lyngby_ui_view',... 
	  'menubar','Figure',...
	  'name','lyngby - Result view',... 
	  'numbertitle','off',...
	  'visible','off',...
	  'BackingStore', 'off', ...
	  'Color', UI_COLOR_BACK); 

      figVolume = figure('position',[ 10 220 300 300 ],... 
	  'resize','on',...
	  'tag','lyngby_ui_view_Volume',... 
	  'menubar','Figure',...
	  'name','lyngby - Result view - Volume',... 
	  'numbertitle','off',...
	  'visible','off', ...
	  'Color', UI_COLOR_BACK); 
      
      figTime = figure('position',[ 350 220 360 300 ],... 
	  'resize','on',...
	  'tag','lyngby_ui_view_Time',... 
	  'menubar','Figure',...
	  'name','lyngby - Result view - Time',... 
	  'numbertitle','off',...
	  'visible','off'); 
      
      figure(figControl);
      
      
      %  Uicontrol Object Creation 

      % Initial Settings for 4-row window....
      FrameColumn1 = 0.004;
      FrameColumn2 = 0.675;
      FrameRow1 = 0.025;
      FrameRow2 = 0.265;
      FrameRow3 = 0.515;
      FrameRow4 = 0.765;
      FrameHeight = 0.210;
      FrameWidth1 = 0.992;
      FrameWidth2 = 0.675;
      FrameWidth3 = 0.321;
      FrameLabelColumn = 0.027;
      FrameLabelRow1 = 0.100;
      FrameLabelRow2 = 0.340;
      FrameLabelRow3 = 0.570;
      FrameLabelRow4 = 0.815;
      FrameLabelWidth = 0.1;
      FrameLabelHeight = 0.1;
      
      ButtonColumn1 = 0.15;
      ButtonColumn2 = 0.36;
      ButtonColumn3 = 0.44;
      ButtonColumn4 = 0.52;
      ButtonColumn5 = 0.68;
      ButtonColumn6 = 0.80;
      ButtonColumn7 = 0.89;
      ButtonRow1 = 0.05;
      ButtonRow2 = 0.29;
      ButtonRow3 = 0.54;
      ButtonRow4 = 0.79;
      ButtonHeight = 0.16;
      ButtonWidth1 = 0.200;
      ButtonWidth2 = 0.150;
      ButtonWidth3 = 0.110;
      ButtonWidth4 = 0.100;
      ButtonWidth5 = 0.080;
      ButtonWidth6 = 0.075;
      ButtonWidth7 = 0.070;
      ButtonWidth8 = 0.069;
      
      % Initial settings for 2-row window...
      TButtonHeight = 0.3;
      TButtonRow2 = 0.29;
      TButtonRow1 = 0.05;
      TButtonColumn1 = 0.15;
      TButtonColumn2 = 0.36;
      TButtonColumn3 = 0.44;
      TButtonColumn4 = 0.52;
      TButtonColumn5 = 0.68;
      TButtonColumn6 = 0.80;
      TButtonColumn7 = 0.89;
      TButtonWidth1 = 0.200;
      TButtonWidth2 = 0.150;
      TButtonWidth3 = 0.110;
      TButtonWidth4 = 0.100;
      TButtonWidth5 = 0.080;
      TButtonWidth6 = 0.075;
      TButtonWidth7 = 0.070;
      TButtonWidth8 = 0.069;

      TFrameColumn1 = 0.004;
      TFrameColumn2 = 0.671;
      TFrameColumn3 = 0.004;
      TFrameRow2 = 0.450;
      TFrameRow1 = 0.025;
      TFrameWidth3 = 0.321;
      TFrameWidth2 = 0.675;
      TFrameWidth1 = 0.992;
      TFrameHeight = 0.410;
      TFrameLabelColumn = 0.027;
      TFrameLabelRow1 = 0.1375;
      TFrameLabelRow2 = 0.5625;
      TFrameLabelWidth = 0.1;
      TFrameLabelHeight = 0.1;

      % Settings for 5-row window (4 layers plus Save layer)
      SButtonRow1 = 0.0387;
      SButtonRow2 = 0.2245;
      SButtonRow3 = 0.4181;
      SButtonRow4 = 0.6116;
      SButtonRow5 = 0.8051;
      SFrameRow1 = 0.0194;
      SFrameRow2 = 0.2052;
      SFrameRow3 = 0.3987;
      SFrameRow4 = 0.5923;
      SFrameRow5 = 0.7859;
      SFrameLabelRow1 = 0.0774;
      SFrameLabelRow2 = 0.2632;
      SFrameLabelRow3 = 0.4413;
      SFrameLabelRow4 = 0.6310;
      SFrameLabelRow5 = 0.8246;

      SFrameHeight = 0.1626;
      SFrameLabelHeight = 0.0774;
      SButtonHeight = 0.1239;
      
      % Added background frames and labels to each 
      % of the rows in the control window (mgl, 091098)
      frameContour = uicontrol(...
	  'CallBack','lyngby_ui_view(''frameContour'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[ FrameColumn1 FrameRow4 0.51 FrameHeight ],... 
	  'Style','frame',... 
	  'Tag','frameContour',...
	  'UserData',''); 
      frameBackground = uicontrol(...
	  'CallBack','lyngby_ui_view(''frameBackground'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.522 FrameRow4 0.474 FrameHeight ],... 
	  'Style','frame',... 
	  'Tag','frameBackground',...
	  'UserData',''); 
      frameMask = uicontrol(...
	  'CallBack','lyngby_ui_view(''frameMask'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[ FrameColumn1 FrameRow3 FrameWidth1 FrameHeight ],... 
	  'Style','frame',... 
	  'Tag','frameMask',... 
	  'UserData',''); 
      frameData = uicontrol(...
	  'CallBack','lyngby_ui_view(''frameData'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[ TFrameColumn1 TFrameRow2 TFrameWidth1 TFrameHeight ],... 
	  'Style','frame',... 
	  'Tag','frameData',... 
	  'UserData',''); 
      frameTime = uicontrol(...
	  'CallBack','lyngby_ui_view(''frameTime'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[ TFrameColumn1 TFrameRow1 TFrameWidth2 TFrameHeight ],... 
	  'Style','frame',... 
	  'Tag','frameTime',... 
	  'UserData',''); 
      frameSystem = uicontrol(...
	  'CallBack','lyngby_ui_view(''frameSystem'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', [ 0.1942 0.3319 0.7020 ],... 
	  'Units','normalized',... 
	  'Position',[ TFrameColumn2 TFrameRow1 TFrameWidth3 TFrameHeight ],... 
	  'Style','frame',... 
	  'Tag','frameSystem',... 
	  'UserData',''); 
      textContourLabel = uicontrol(...
	  'CallBack','lyngby_ui_view(''textContourLabel'');',... 
	  'ForegroundColor', [ 0 0 0 ],...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[FrameLabelColumn FrameLabelRow4 FrameLabelWidth FrameLabelHeight ],... 
	  'String','Contour Overlay',...
	  'Style','text',... 
	  'Tag','textContourLabel',... 
	  'UserData',''); 
      textBackgroundLabel = uicontrol(...
	  'CallBack','lyngby_ui_view(''textBackgroundLabel'');',... 
	  'ForegroundColor', [ 0 0 0 ],...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[0.5437 FrameLabelRow4 FrameLabelWidth FrameLabelHeight ],... 
	  'String','Background Layer',...
	  'Style','text',... 
	  'Tag','textBackgroundLabel',... 
	  'UserData',''); 
      textMaskLabel = uicontrol(...
	  'CallBack','lyngby_ui_view(''textMaskLabel'');',... 
	  'ForegroundColor', [ 0 0 0 ],...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[FrameLabelColumn FrameLabelRow3 FrameLabelWidth FrameLabelHeight ],... 
	  'String','Masking Layer',...
	  'Style','text',... 
	  'Tag','textMaskLabel',... 
	  'UserData',''); 
      textDataLabel = uicontrol(...
	  'CallBack','lyngby_ui_view(''textDataLabel'');',... 
	  'ForegroundColor', [ 0 0 0 ],...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[TFrameLabelColumn TFrameLabelRow2 TFrameLabelWidth TFrameLabelHeight ],... 
	  'String','Data Layer',...
	  'Style','text',... 
	  'Tag','textDataLabel',... 
	  'UserData',''); 
      textTimeLabel = uicontrol(...
	  'CallBack','lyngby_ui_view(''textTimeLabel'');',... 
	  'ForegroundColor', [ 0 0 0 ],...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[TFrameLabelColumn TFrameLabelRow1 TFrameLabelWidth TFrameLabelHeight ],... 
	  'String','Time Display',...
	  'Style','text',... 
	  'Tag','textTimeLabel',... 
	  'UserData',''); 

% In UserData is kept the result volumes

% Overlay/Contour layer

      % Data source

       radioContour = uicontrol(...
	  'CallBack','lyngby_ui_view(''radioContour'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Units','normalized',... 
	  'Position',[ ButtonColumn1 ButtonRow4 0.0213 ButtonHeight ],... 
	  'String','',... 
	  'Style','radiobutton',... 
	  'Value',[ 0 ],... 
	  'Tag','radioContour',... 
	  'UserData',''); 

      popupContour = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupContour'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Units','normalized',... 
	  'Position',[ 0.1738 ButtonRow4 0.1762 ButtonHeight ],... 
	  'String','---',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupContour',... 
	  'UserData',''); 

%      popupBackType = uicontrol(... 
%	  'CallBack','lyngby_ui_view(''popupBackType'');',... 
%	  'ForegroundColor', UI_COLOR_FRONT,...
%	  'BackgroundColor', UI_COLOUR_BUTTON,... 
%	  'Units','normalized',... 
%	  'Position',[ ButtonColumn2 ButtonRow4 ButtonWidth2 ButtonHeight ],... 
%	  'String','None|Contour|Overwrite',... 
%	  'Style','popupmenu',... 
%	  'Value',[ 1 ],... 
%	  'Tag','popupBackType',... 
%	  'UserData',''); 

      % 'Mean in ray' etc.
      popupContourRay = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupContourRay'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Max',[ 3 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ ButtonColumn2 ButtonRow4 ButtonWidth2 ButtonHeight ],... 
	  'String','Slice|Mean in ray|Max in ray',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupContourRay',... 
	  'UserData',''); 

% Background layer

       radioBackground = uicontrol(...
	  'CallBack','lyngby_ui_view(''radioBackground'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Units','normalized',... 
	  'Position',[ ButtonColumn5 ButtonRow4 0.0213 ButtonHeight ],... 
	  'String','',... 
	  'Style','radiobutton',... 
	  'Value',[ 0 ],... 
	  'Tag','radioBackground',... 
	  'UserData',''); 

      popupBackground = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupBackground'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Units','normalized',... 
	  'Position',[ 0.7050 ButtonRow4 0.1750 ButtonHeight ],... 
	  'String','---',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupBackground',... 
	  'UserData',''); 

      % 'Mean in ray' etc.
      popupBackgroundRay = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupBackgroundRay'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Max',[ 3 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ ButtonColumn7 ButtonRow4 ButtonWidth4 ButtonHeight ],... 
	  'String','Slice|Mean in ray|Max in ray',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupBackgroundRay',... 
	  'UserData',''); 

% Mask Layer

      popupMask = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupMask'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ ButtonColumn1 ButtonRow3 ButtonWidth1 ButtonHeight ],... 
	  'String','---',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupMask',... 
	  'UserData',''); 
      popupMaskType = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupMaskType'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ ButtonColumn2 ButtonRow3 ButtonWidth6 ButtonHeight ],... 
	  'String','None|>|><|==|<',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupMaskType',... 
	  'UserData',''); 
      sliderMaskLevel = uicontrol(... 
	  'CallBack','lyngby_ui_view(''sliderMaskLevel'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ ButtonColumn4 ButtonRow3 ButtonWidth2 ButtonHeight ],... 
	  'Style','slider',... 
	  'Value',[ 0.95 ],...
	  'Min', 0,...
	  'Max', 1,...
	  'Tag','sliderMaskLevel',... 
	  'UserData',''); 
      editMaskLevel = uicontrol(... 
	  'CallBack','lyngby_ui_view(''editMaskLevel'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ ButtonColumn3 ButtonRow3 ButtonWidth7 ButtonHeight ],... 
	  'String','0.95',... 
	  'Style','edit',... 
	  'Value',[ 1 ],... 
	  'Tag','editMaskLevel',... 
	  'UserData',''); 
      popupMaskLevelType = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupMaskLevelType'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ ButtonColumn5 ButtonRow3 ButtonWidth1 ButtonHeight ],... 
	  'String','Fractile, Slice|Absolute',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupMaskLevelType',... 
	  'UserData', 1); 

      popupVolume = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupVolume'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn1 TButtonRow2 TButtonWidth1 TButtonHeight ],... 
	  'String','---',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupVolume',... 
	  'UserData',''); 
      popupPlane = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupPlane'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Max',[ 3 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn2 TButtonRow2 TButtonWidth2 TButtonHeight ],... 
	  'String','Sagittal|Coronal|Transversal',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupPlane',... 
	  'UserData','');
      popupRay = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupRay'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Max',[ 3 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn5 TButtonRow2 TButtonWidth3 TButtonHeight ],... 
	  'String','Slice|Mean in ray|Max in ray',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupRay',... 
	  'UserData',''); 
      % In Userdata is kept the min, max and current slice values 
      sliderSlice = uicontrol(... 
	  'CallBack','lyngby_ui_view(''sliderSlice'');',... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn4 TButtonRow2 TButtonWidth2 TButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','slider',... 
	  'Value',[ 0.1 ],... 
	  'Min',0,...
	  'Max',1,...
	  'Tag','sliderSlice',... 
	  'UserData',''); 

      popupColormap = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupColormap'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn6 TButtonRow2 TButtonWidth5 TButtonHeight ],... 
	  'String','Default|Hot|Gray|Inv Gray|Jet|Bone|Cool|Copper|Hsv',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupColormap',... 
	  'UserData',''); 

      popupColorbar = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupColorbar'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn7 TButtonRow2 TButtonWidth4 TButtonHeight ],... 
	  'String','Colorbar|off',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupColorbar',... 
	  'UserData',''); 

      popupScale = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupScale'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn5 TButtonRow2 TButtonWidth4 TButtonHeight ],... 
	  'String','Linear|log|sqrt',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupScale',... 
	  'UserData','', ...
	  'Visible', 'off'); 

      popupColormapCtrl = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupColormapCtrl'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn5 TButtonRow2 TButtonWidth4 TButtonHeight ],... 
	  'String','Free|Keep',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupColormapCtrl',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      
      
      % In Userdata is kept the string of the callback function
      popupTime = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupTime'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn1 TButtonRow1 TButtonWidth1 TButtonHeight ],... 
	  'String','---',... 
	  'Style','popupmenu',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Value',[ 1 ],... 
	  'Tag','popupTime',... 
	  'UserData',''); 
      popupZoom = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupZoom'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn2 TButtonRow1 TButtonWidth8 TButtonHeight ],... 
	  'String','Full|50%|30%|20%|10%|5%|1%',... 
	  'Style','popupmenu',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Value',[ 1 ],... 
	  'Tag','popupZoom',... 
	  'UserData',''); 
      sliderScroll = uicontrol(... 
	  'CallBack','lyngby_ui_view(''sliderScroll'');',... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn4 TButtonRow1 TButtonWidth2 TButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','slider',... 
	  'Value',[ 0.1 ],... 
	  'Min',0,...
	  'Max',1,...
	  'Tag','sliderScroll',... 
	  'UserData',''); 
      popupAmplitude = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupAmplitude'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn3 TButtonRow1 TButtonWidth7 TButtonHeight ],... 
	  'String','Free|Keep',... 
	  'Style','popupmenu',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Value',[ 1 ],... 
	  'Tag','popupAmplitude',... 
	  'UserData',''); 

      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_view(''buttonClose'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn5 TButtonRow1 TButtonWidth3 TButtonHeight ],... 
	  'String','Close all',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_view(''buttonHelp'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn6 TButtonRow1 TButtonWidth5 TButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
      buttonExpand = uicontrol(... 
	  'CallBack','lyngby_ui_view(''buttonExpand'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn7 TButtonRow1 TButtonWidth4 TButtonHeight ],... 
	  'String','More..',... 
	  'Style','pushbutton',... 
	  'Tag','buttonExpand',... 
	  'UserData',''); 

      % These buttons are not used
      buttonSaveLeftImage = uicontrol(... 
	  'CallBack','lyngby_ui_view(''buttonSaveLeftImage'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn7 ButtonRow4 TButtonWidth3 TButtonHeight ],... 
	  'String','SaveImage',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSaveLeftImage',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      buttonAspect = uicontrol(... 
	  'CallBack','lyngby_ui_view(''buttonAspect'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn5 ButtonRow4 TButtonWidth4 TButtonHeight ],... 
	  'String','Aspect',... 
	  'Style','pushbutton',... 
	  'Tag','buttonAspect',... 
	  'UserData','', ...
	  'Visible', 'off');


      % UI Controls for the Save Layer
      frameFile = uicontrol(...
	  'CallBack','lyngby_ui_view(''frameFile'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', [ 1 0.193 0.215 ],... 
	  'Units','normalized',... 
	  'Position',[ FrameColumn1 SFrameRow5 FrameWidth1 SFrameHeight ],... 
	  'Style','frame',... 
	  'Tag','frameFile',...
          'Visible', 'off',...
	  'UserData',''); 
      textFile = uicontrol(...
	  'CallBack','lyngby_ui_view(''textFile'');',... 
	  'ForegroundColor', [ 0 0 0 ],...
	  'BackgroundColor', [ 1 0.193 0.215 ],... 
	  'Units','normalized',... 
	  'Position',[ FrameLabelColumn SFrameLabelRow5 FrameLabelWidth SFrameLabelHeight ],... 
	  'String','File layer',...
	  'Style','text',... 
	  'Tag','textFile',... 
          'Visible', 'off',...
	  'UserData',''); 
      popupSavetype = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupSavetype'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Units','normalized',... 
	  'Position',[ ButtonColumn1 SButtonRow5 ButtonWidth1 SButtonHeight ],... 
	  'String','Volume|Sequence (XN)',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupSavetype',... 
          'Visible', 'off',...
	  'UserData',''); 
      popupFiletype = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupFiletype'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Max',[ 3 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ ButtonColumn2 SButtonRow5 ButtonWidth2 SButtonHeight ],... 
	  'String','...',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupFiletype',... 
          'Visible', 'off',...
	  'UserData',''); 
      buttonOption = uicontrol(...
	  'CallBack','lyngby_ui_view(''buttonOption'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ ButtonColumn4 SButtonRow5 ButtonWidth6 SButtonHeight ],... 
	  'String','Option ...',... 
	  'Style','pushbutton',... 
	  'Value',[ 0 ],... 
	  'Tag','buttonOption',... 
          'Visible', 'off',...
	  'UserData',''); 
      popupCompress = uicontrol(... 
	  'CallBack','lyngby_ui_view(''popupCompress'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Units','normalized',... 
	  'Position',[ 0.6  SButtonRow5 ButtonWidth7 SButtonHeight ],... 
	  'String','None|gzip|Z',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupCompress',... 
          'Visible', 'off',...
	  'UserData',''); 
      editFilename = uicontrol(... 
	  'CallBack','lyngby_ui_view(''editFilename'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Units','normalized',... 
	  'Position',[ ButtonColumn5 SButtonRow5 ButtonWidth3 SButtonHeight ],... 
	  'HorizontalAlignment','left',... 
	  'String','Filename.mat',... 
	  'Style','edit',... 
	  'Tag','editFilename',... 
          'Visible', 'off',...
	  'UserData',''); 
      buttonBrowse = uicontrol(...
	  'CallBack','lyngby_ui_view(''buttonBrowse'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Enable','on',...
	  'Units','normalized',... 
	  'Position',[ ButtonColumn7 SButtonRow5 ButtonWidth4 SButtonHeight ],... 
	  'String','Save in dir...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonBrowse',... 
          'Visible', 'off',...
	  'UserData',''); 
      buttonSave = uicontrol(... 
	  'CallBack','lyngby_ui_view(''buttonSave'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ ButtonColumn6 SButtonRow5 ButtonWidth5 SButtonHeight ],... 
	  'String','Save here!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSave',... 
          'Visible', 'off',...
	  'UserData',''); 
      buttonSaveExpand = uicontrol(... 
	  'CallBack','lyngby_ui_view(''buttonSaveExpand'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ TButtonColumn6 TButtonRow1 TButtonWidth4 TButtonHeight ],... 
	  'String','Save data...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSave',... 
          'Visible', 'on',...
	  'UserData',''); 

      axesNormal = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesNormal', ... 
          'Visible','on', ...
	  'UserData',''); 

      %	  'Position',[ 0.13 0.11 0.6626 0.8150 ],... 
      rowA = 0.76;
      rowB = 0.52;
      rowC = 0.28;
      rowD = 0.04;
      colA = 0.05;
      colB = 0.24;
      colC = 0.43;
      colD = 0.62;
      colE = 0.81;
      axW  = 0.15;
      axH  = 0.20;
      
      axesMosaic1 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colA rowA axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic1', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic2 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colB rowA axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic2', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic3 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colC rowA axW axH],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic3', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic4 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colD rowA axW axH],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic4', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic5 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colE rowA axW axH],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic5', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic6 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colA rowB axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic6', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic7 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colB rowB axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic7', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic8 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colC rowB axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic8', ... 
          'Visible','off', ...
	  'UserData',''); 
       axesMosaic9 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colD rowB axW axH],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic9', ... 
          'Visible','off', ...
	  'UserData',''); 

      axesMosaic10 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colE rowB axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic10', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic11 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colA rowC axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic11', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic12 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colB rowC axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic12', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic13 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colC rowC axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic13', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic14 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colD rowC axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic14', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic15 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colE rowC axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic15', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic16 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colA rowD axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic16', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic17 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colB rowD axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic17', ... 
          'Visible','off', ...
	  'UserData',''); 
       axesMosaic18 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colC rowD axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic18', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic19 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colD rowD axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic19', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesMosaic20 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ colE rowD axW axH ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesMosaic20', ... 
          'Visible','off', ...
	  'UserData','');      
       
       textMosaicLabel = uicontrol(...
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_view(''textMosaicLabel'');',... 
	  'ForegroundColor', [ 0 0 0 ],...
	  'BackgroundColor', [ 0.105 0.538 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.05 0.007 0.91 0.03],... 
	  'String','Title of mosaic tiles to go here',...
	  'Style','text',... 
	  'Tag','textMosaicLabel',... 
	  'UserData','',...
          'Visible','off'); 
      
      % Setup Menu controls
      ver = (version);
      ver = str2num(ver(1:3));
      if ver >= 5.2 
	menuOptions = uimenu( ...
	    'Parent',figControl,...
	    'Label','Options',...
	    'Tag','TagMenuOptions',...
	    'Visible','on');
	menuTooltips = uimenu(...
	    'Parent',menuOptions,...
	    'Label','&Toggle Tooltips',...
	    'Checked','on',...
	    'Callback','lyngby_ui_view(''ToggleTooltips'');',...
	    'Tag','TagMenuTooltips',...
	    'Accelerator','T',...
	    'Visible','on');
	menuViewOptions = uimenu( ...
	    'Parent',figVolume,...
	    'Label','Lyngby View Options',...
	    'Tag','TagMenuViewOptions',...
	    'Visible','on');
	menuMosaic = uimenu(...
	    'Parent',menuViewOptions,...
	    'Label','&Toggle Mosaic View',...
	    'Checked','off',...
	    'Callback','lyngby_ui_view(''ToggleMosaic'');',...
	    'Tag','TagMenuMosaic',...
	    'Accelerator','M',...
	    'UserData','',... 
	    'Visible','on');
      else
	menuOptions = 0;
	menuTooltips = 0;
	menuMosaic = 0;
      end
      
      % Test global Tooltips settings and set this window to the same
      if UI_TOOLTIPS == 0  
	eval(ToggleTooltips);
      end

      % Result datamatrix in popupVolume 'UserData'
      set(popupVolume, 'UserData', arg1)
      set(popupVolume, 'String', arg2)
      set(popupContour, 'String', arg2)
      set(popupBackground, 'String', arg2)
      set(popupMask, 'String', arg2)


      % Default values for properties
      set(popupTime, 'UserData', 'lyngby_ui_view_dfl');
      set(popupTime, 'String', 'Time')
      
      % Parse
      n = 3;
      while n < nargin
	eval(sprintf('arg = lower(arg%d);', n)); 
	if strcmp(arg, 'callback')
	  n = n + 1;
	  eval(sprintf('arg = lower(arg%d);', n));
	  if isstr(arg)
	    set(popupTime, 'UserData', arg)
	  else	  
	    error('Argument to ''Callback'' should be a functionname');
	  end
	elseif strcmp(arg, 'callbacktype')
	  n = n + 1;
	  eval(sprintf('arg = arg%d;', n));
	  if isstr(arg)
	    set(popupTime, 'String', arg)
	  else
	    error(['Argument to ''CallbackType'' should ' ...
		  'be the menu strings']);
	  end
	elseif strcmp(arg, 'title')
	  n = n + 1;
	  eval(sprintf('arg = arg%d;', n));
	  if isstr(arg)
	    set(figControl, 'Name', sprintf('%s - Control', arg));
	    set(figVolume, 'Name', sprintf('%s - Volume', arg));
	    set(figTime, 'Name', sprintf('%s - Time', arg));
	  else
	    error(['Argument to ''Title'' should be a string']);
	  end

	else
	  error(sprintf('Invalid property: %s', arg));
	end
	n = n + 1;
      end

      roi = lyngby_roi;
      if roi(3,1) - roi(3,2) == 0
	set(popupPlane, 'Value', 3);
      elseif roi(2,1) - roi(2,2) == 0
	set(popupPlane, 'Value', 2);
      elseif roi(1,1) - roi(1,2) == 0
	set(popupPlane, 'Value', 1);
      else
	set(popupPlane, 'Value', 3);
      end

      roi = lyngby_roi;
      if roi(3,1) - roi(3,2) == 0
	set(popupPlane, 'Value', 3);
      elseif roi(2,1) - roi(2,2) == 0
	set(popupPlane, 'Value', 2);
      elseif roi(1,1) - roi(1,2) == 0
	set(popupPlane, 'Value', 1);
      else
	set(popupPlane, 'Value', 3);
      end

      % The leftslider 'UserData' contains max, min and position values for the
      % slider 
      set(sliderSlice, 'UserData', [roi round(mean(roi')') ])
      eval(UpdateSlider);

      eval(UpdatePosition);
      
      % Initialize to the first voxel. Should be initialized to something else

      handle_list = [ ...  
	    figControl ...
	    figVolume figTime ...
	    buttonClose sliderSlice ... 
	    popupRay popupVolume popupPlane ... 
	    popupTime ...
	    buttonAspect popupZoom sliderScroll ...
	    popupAmplitude popupColormap buttonSaveLeftImage ...
	    buttonHelp ...
	    buttonExpand ...
	    popupContour popupContourRay ...
	    popupMask popupMaskType sliderMaskLevel editMaskLevel ...
	    popupMaskLevelType ...
	    popupScale popupColormapCtrl ...
	    popupColorbar ...
	    frameContour frameBackground frameMask frameData frameTime frameSystem ...
	    textContourLabel textBackgroundLabel textMaskLabel textDataLabel textTimeLabel ...
            radioContour radioBackground popupBackground popupBackgroundRay ...
	    menuOptions menuTooltips ...
            frameFile textFile popupSavetype popupFiletype buttonOption ...
            popupCompress editFilename buttonBrowse buttonSave ...
            buttonSaveExpand menuMosaic ...
	    axesNormal axesMosaic1 axesMosaic2 axesMosaic3 axesMosaic4 axesMosaic5 ...
	    axesMosaic6 axesMosaic7 axesMosaic8 axesMosaic9 axesMosaic10 axesMosaic11 ...
	    axesMosaic12 axesMosaic13 axesMosaic14 axesMosaic15 axesMosaic16 axesMosaic17 ...
	    axesMosaic18 axesMosaic19 axesMosaic20 ...
	    textMosaicLabel menuViewOptions ...
		    ]; 


      set(figControl,'userdata',handle_list); 
      set(figVolume,'userdata',handle_list); 
      set(figTime,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(figControl,'visible','on'); 
      drawnow;pause(.1); 
      set(figVolume,'visible','on'); 
      drawnow;pause(.1); 
      set(figTime,'visible','on'); 

      eval(UpdateZoom);
      eval(UpdateLeft);
      eval(UpdateRight);


    elseif command == 1 
      %disp('buttonClose selected.') 
      close(gcf);
      close(figVolume);
      close(figTime);
      
    elseif command == 2 
      %disp('sliderSlice selected.') 

      S = get(sliderSlice, 'UserData');
      S(get(popupPlane, 'Value'), 3) = round(get(sliderSlice, 'Value'));
      set(sliderSlice, 'UserData', S);

      % Turn axes-colourbars off to enable re-positioning...
      hlist =  findobj(figVolume,'Tag','colorbar');
      if length(hlist) ~= 0
          for i=1:length(hlist)
              axes(hlist(i));
              cla;
          end;
      end
      
      eval(UpdateLeftImage);

    elseif command == 3 
      %disp('popupRay selected.') 
      ver = (version);
      ver = str2num(ver(1:3));
      if ver >= 5.2 & strcmp(get(menuMosaic, 'Checked'), 'on')
	if (get(popupRay, 'Value')~=1)
	% Popup warning box saying cannot do mosaic with mean or max
        % And set button back to 'Slice'....
	lyngby_ui_message(['Can''t do ''Mean'' or ''Max'' images in' ...
			   ' mosaic view']);
	set(popupRay, 'Value', 1);
	end
      else
	% Carry on as normal
	eval(UpdateLeftImage);
      end

    elseif command == 4 
      %disp('popupVolume selected.') 

      eval(UpdateLeft);

    elseif command == 5 
      %disp('popupPlane selected.') 

      % Turn axes-colourbars off to enable re-positioning...
      hlist =  findobj(figVolume,'Tag','colorbar');
      if length(hlist) ~= 0
	for i=1:length(hlist)
	  axes(hlist(i));
	  cla;
	end;
      end

      eval(UpdateSlider);
      eval(UpdateLeftImage);
      
    elseif command == 6
      %disp('popupTime selected.');
      eval(UpdateLeftImage);
      eval(UpdateRight);
      
    elseif command == 7
      %disp('buttonAspect');	

    elseif command == 8
      %disp('popupZoom');
      eval(UpdateRight);
      
    elseif command == 9
      %disp(sprintf('sliderScroll: %f', get(sliderScroll, 'value')));
      eval(UpdateRight);
      
    elseif command == 10
      %disp('popupAmplitude');
      
      eval(UpdateRight);

    elseif any(command == [140 150 155 160])
      
      eval(UpdateLeft);

    elseif command == 12
      %disp('buttonSaveLeftImage');
      
      [nam,pat] = uiputfile('~/*.eps',...
	  'Choose eps filename to store Left image');
      if nam
	figure(figVolume);
	drawnow;
	eval(sprintf('print -depsc %s%s',pat,nam));
	pause(0.1);
      end
      
    elseif command == 300
      % popupContour
      eval(UpdateLeft);
      
    elseif command == 310
      % radioContour
      % eval(ToggleOverlayButtons);
      % set(radioContour,'value', 1);
      % set(radioBackground,'value', 0);
      eval(UpdateLeft);

    elseif command == 320
      % popupContourRay
      eval(UpdateLeft);

    elseif command == 330
      % radioBackground
      % eval(ToggleOverlayButtons);
      % set(radioContour,'value', 0);
      % set(radioBackground,'value', 1);
      eval(UpdateLeft);

    elseif command == 340
      % popupBackground
      eval(UpdateLeft);

    elseif command == 350
      % popupBackgroundRay
      eval(UpdateLeft);

    elseif command == 400
      
      eval(UpdatePopupMaskLevelType);
      eval(UpdateLeft);
      
      
    elseif command == 410
      eval(ToggleMaskButtons);
      eval(UpdateLeft);
      eval(UpdateMaskSliderStep);
      
    elseif command == 420
      
      eval(UpdateEditMaskLevel);
      eval(UpdateLeft);
      
    elseif command == 430

      eval(UpdateSliderMaskLevel);
      eval(UpdateLeft);
      
    elseif command == 440
      eval(UpdatePopupMaskLevelType);
      eval(UpdateLeft);
      eval(UpdateMaskSliderStep);

      
    elseif command == 500
      
      helpwin('lyngby_ui_view')
      
    elseif command == 600
      % Toggle the state of the Tooltips help (on/off)
      eval(ToggleTooltips);


    elseif command == 700
      % Save 

      % Get settings
      savetype = get(popupSavetype, 'Value');
      filetype = get(popupFiletype, 'Value');
      compresstype = get(popupCompress, 'Value');
      filename = deblank(get(editFilename, 'String'));
      
      index = findstr(lower(filename), '.z');
      if ~isempty(index) & length(filename) == index+1
          filename = filename(1:end-2);
      end
      index = findstr(lower(filename), '.gz');
      if ~isempty(index) & length(filename) == index+2
          filename = filename(1:end-3);
      end
      
	
	
      if savetype == 1
          % Volume - saves *SPATIAL* info only - no temporal info.
	
          % Get volume
          %	VolumeType = get(popupMask, 'Value'); % BUG?
          VolumeType = get(popupVolume, 'Value');
          V = get(popupVolume, 'UserData');

          masktype = get(popupMaskType, 'Value'); % 1) None   2) > 
                                                  % 3)  ><    4) ==
      if (masktype ~= 1)  % Mask is being used
	% Need to account for the case where the data is masked....
	maskdata_index = get(popupMask, 'Value'); % Which dataset?
	maskdataset = V(maskdata_index,:) * VOXEL_MASK; % Create mask
	% data set for
	% entire volume
	masklevel = get(sliderMaskLevel, 'Value'); % Threshold, either
	% fractile or abs
	maskleveltype = get(popupMaskLevelType, 'Value'); %  1) Fractile
	%  2) Absolute
	% Need to create mask of entire volume...
	if masktype == 2
	  % '>' masking
	  if maskleveltype == 1
	    % Fractile masking
	    sortedmaskdataset = sort(maskdataset(:));  % Order data
	    % Calc. threshold level as an index
	    levelindex = round((length(sortedmaskdataset)-1) * masklevel)+1;
	    % Generates 0,1 matrix indicating locations of above-threshold points
	    maskdataset = (sortedmaskdataset(levelindex)<maskdataset);
	  elseif maskleveltype == 2
	    % Absolute masking
	    % Generates 0,1 matrix indicating locations of above-threshold points
	    maskdataset = (masklevel<maskdataset);
	  end
	elseif masktype == 3
	  % '><' masking (absolute '>' masking)
	  if maskleveltype == 1
	    % Fractile masking
	    sortedmaskdataset = sort(abs(maskdataset(:)));  % Order data
	    % Calc. threshold level as an index
	    levelindex = round((length(sortedmaskdataset)-1) * masklevel)+1;
	    % Generates 0,1 matrix indicating locations of above-abs-threshold points
	    maskdataset = (sortedmaskdataset(levelindex)<abs(maskdataset)); ...
	  elseif maskleveltype == 2
	    % Absolute masking
	    % Generates 0,1 matrix indicating locations of above-abs-threshold points
	    maskdataset = (masklevel<abs(maskdataset));
	  end	    
	elseif masktype == 4
	  % '==' masking (Used for clusters etc)
	  if maskleveltype == 1
	    % Fractile masking - not valid. Operate as for absolute...
	    % Generates 0,1 matrix indicating locations of equal-to-threshold points
	    maskdataset = (masklevel == maskdataset);
	  elseif maskleveltype == 2
	    % Absolute masking
	    % Generates 0,1 matrix indicating locations of equal-to-threshold points
	    maskdataset = (masklevel == maskdataset);
	  end	    	    
	elseif masktype == 2
	  % '<' masking
	  if maskleveltype == 5
	    % Fractile masking
	    sortedmaskdataset = sort(maskdataset(:));  % Order data
	    % Calc. threshold level as an index
	    levelindex = round((length(sortedmaskdataset)-1) * masklevel)+1;
	    % Generates 0,1 matrix indicating locations of above-threshold points
	    maskdataset = (sortedmaskdataset(levelindex)>maskdataset);
	  elseif maskleveltype == 2
	    % Absolute masking
	    % Generates 0,1 matrix indicating locations of above-threshold points
	    maskdataset = (masklevel>maskdataset);
	  end
	end

	% Now calculate the masked volume
	V = (V(VolumeType,:).* maskdataset) * VOXEL_MASK';
      else
	% No mask being used - calculate volume as normal
	V = V(VolumeType,:) * VOXEL_MASK';	  
      end

						
						
      % Parse file format to save in.
      if filetype == 1
          % ascii
          eval(sprintf('save %s V -ascii', filename));
	
      elseif filetype == 2
          % Analyze
          siz = diff(lyngby_roi')+1;
          lyngby_write_ana(filename, V, siz, 'Origin', ORIGIN);

      elseif filetype == 3
          % Matlab binary
          eval(sprintf('save %s V', filename));
	  
      elseif filetype == 4
          % SDT
          siz = diff(lyngby_roi')+1;
          lyngby_write_sdt(filename, V, siz);

      elseif filetype == 5
          % VAPET
          siz = diff(lyngby_roi')+1;
          lyngby_write_vapet(filename, V, siz);
	  
      elseif filetype == 6
          % Voxel Mask (Lyngby variable)
          % Correct? The volume V should be already masked, if one is set. 
          % Should then use the maskdataset variable as the voxel mask.
          % Need to find a better way of determining threshold for 
          % voxel mask for other (non-masked) conditions (default set to >0)....
          if (masktype ~= 1) % Mask is being used
              index = find(maskdataset>0);  % Locate all non-masked voxels
              size_vol = length(maskdataset);
              size_vm = length(index);
          else  % No mask set - need to determine a reasonable threshold for voxel_mask
              % Ask user for threshold value - change to Lyngby dialog box in future
              prompt={'Enter the threshold level to determine the cut-off for the voxel mask:'};
              default={'0'};
              dialogtitle='Input voxel mask threshold';
              lines=1;
              answer=inputdlg(prompt, dialogtitle, lines, default);
              vm_threshold=str2num(answer{1});
              % Calculate variables
              index = find(V>vm_threshold);  % Default threshold of volume taken as > 0
              size_vol = length(V);
              size_vm = length(index);
          end
          voxel_mask = sparse(1:size_vm, index, ones(size_vm,1), size_vm, size_vol)';
	  
          % Save as VOXEL_MASK - need to temporarily backup the 
          % existing VOXEL_MASK global variable, and reset it afterwards
          orig_VOXEL_MASK = VOXEL_MASK;
          VOXEL_MASK = voxel_mask;
          eval(sprintf('save %s VOXEL_MASK', filename));
          clear global VOXEL_MASK;
          global VOXEL_MASK;
          VOXEL_MASK = orig_VOXEL_MASK;
	  
      else
          error('Internal error');
      end
	
  elseif savetype == 2
      % Sequence (for a single voxel) i.e. saves *TEMPORAL* info only, for
      %  *ONE* voxel only - no spatial info
	
      % Get voxel
      slices = get(sliderSlice, 'UserData');
      voxel3 = slices(:,3);
      voxel = lyngby_full2mask(voxel3);
      if isempty(voxel)
          lyngby_ui_message('No voxel here to save');
          return
      end
	
      % Save data from XN
      if isempty(XN)
          lyngby_ui_message(['The variable ''XN'' is empty. '...
                  'Cannot save data from it']);
          return
      end
      t = XN(:,voxel);

      if filetype == 1
          % ascii saving
          eval(sprintf('save %s t -ascii', filename));
      elseif filetype == 2
          % matlab binary
          eval(sprintf('save %s t', filename));
      elseif filetype == 3
          % matlab 4 binary
          eval(sprintf('save %s t -v4', filename));
      else
          error('Internal error');
      end
	
  else
      error('Internal error');
  end

  if compresstype == 1
      % Do nothing
	
  elseif compresstype == 2
      % Gzip compression
      unix(sprintf('gzip %s', filename));
      filename = [filename '.gz'];
	
  elseif compresstype == 3
      % Z compression
      unix(sprintf('compress %s', filename));
      filename = [filename '.z'];
      
  else
      error('Internal error');
  end
  
  if savetype == 1,
      lyngby_log(sprintf('Volume saved in %s', filename));
  elseif savetype == 2,
      lyngby_log(sprintf('Sequence saved in %s', filename));      
  end

    elseif command == 710
      % popupSavetype
      eval(UpdateFiletype);
      
    elseif command == 720
      % popupFiletype

    elseif command == 730
      % buttonOption

    elseif command == 740
      % popupCompress

      eval(UpdateFilename);
      
    elseif command == 750
      % editFilename

    elseif command == 760
      % editBrowse

    elseif command == 770
        % buttonBrowse -> Should be called 'Save As' instead

        filename = deblank(get(editFilename, 'String'));
      
        [file, path] = uiputfile(filename, 'Save the data in a different location...');
        if file ~= 0, 
            filename = [ path file ];
            set(editFilename, 'String', filename);
	
            % Save the file
            lyngby_ui_view(700);
        end

    elseif command == 900
      % Toggle the state of the Mosaic slice view (on/off)
      % The slider 'user data' field contains details of the
      %  current active slice, along with the max/min/current
      %  values for the slice slider. The slice slider controls
      %  the FIRST tile in the mosaic view.
      % Each tile in the mosaic view has its own copy of the
      %  min/max/current valueset, used to indicate which slice
      %  of the dataset is currently shown in that axis
      % The menuMosaic 'user data' contains the values
      %  for the highlighted TILE in the mosaic view, to 
      %  prevent disrupting the slice slider value.
      % eval(ToggleMosaic);

      S = get(sliderSlice, 'UserData');
      plane = get(popupPlane, 'Value');
      dim = lyngby_roi;
      MinReqSlices = 3;  % Minimum number of slices required to
                         % show mosaic view of current plane

      % Check whether mean or max are requested - invalid for
      % mosaic view			 
      Valid=1;	 
      RayType = get(popupRay, 'Value');
      if (RayType ~=1),
	Valid=0;
      end

      volpos = get(figVolume, 'position');
      ver = (version);
      ver = str2num(ver(1:3));
      if ver >= 5.2 & strcmp(get(menuMosaic, 'Checked'), 'on')
	% Turn Mosaic Slice View OFF
	set(menuMosaic, 'Checked','off');

	set(textMosaicLabel, 'Visible','off');
	set(textMosaicLabel, 'String','Title to go here');

	
	% Turn ALL axes off and clear any remaining data from them
	for m=1:20,
	  axislist{m}=(['axesMosaic' int2str(m)]);
	end
	
	for n=1:20,
	  set(eval(axislist{n}), 'Visible', 'off');
	  axes(eval(axislist{n}));
	  cla;
	end
	
	set(axesNormal, 'Visible', 'on');
	
	% Turn axes-colourbars off to enable re-positioning...
	hlist =  findobj(figVolume,'Tag','colorbar');
	if length(hlist) ~= 0
	  for i=1:length(hlist)
	    axes(hlist(i));
	    cla;
	  end;
	end

	% Resize and move window
	set(figVolume, 'position', [ volpos(1) volpos(2) 300 300 ]);
	
	% Update window and slice
	eval(UpdateLeft);
	

      elseif (ver >= 5.2) & ( (dim(plane,2)-dim(plane,1) ) > MinReqSlices ) ...
	    & ( (dim(plane,2)-S(plane,3)) > 1 ) & (Valid==1)
	% Turn Mosaic Slice View ON
	% =========================

	% Check how many slices will be displayed from the current
        % to the final slice of the present plane.
	currentslice=S(plane,3);
	finalslice=dim(plane,2);
	NumberTiles=finalslice-currentslice+1;
	
	% Default for testing
	% NumberTiles=9;
	
	% Only allow a maximum of 20 tiles in mosaic view
	if NumberTiles>20, 
	  NumberTiles=20;
	end
	
	% Create correct number of axes
	for m=1:NumberTiles,
	  axislist{m}=(['axesMosaic' int2str(m)]);
	end
	
	for n=1:NumberTiles,
	  set(eval(axislist{n}), 'Visible', 'on');
	end
	
	% Setup other ui controls
	set(menuMosaic, 'Checked','on');
	set(textMosaicLabel, 'Visible','on');
	set(axesNormal, 'Visible', 'off');
	axes(axesNormal);
	cla;

	% Set initial variables to current slice as default
	SValues = get(sliderSlice, 'UserData');
	TileValues = SValues;

	
	% Turn axes-colourbars off to enable re-positioning...
	hlist =  findobj(figVolume,'Tag','colorbar');
	if length(hlist) ~= 0
	  for i=1:length(hlist)
	    axes(hlist(i));
	    cla;
	  end;
	end

	% Change size and position of volume window
	set(figVolume, 'position', [ volpos(1) volpos(2) 550 500 ]);

	% Update window and slices
	eval(UpdateLeft);

      else
	lyngby_ui_message(['You cannot show the mosaic view at the ' ...
			   'moment. This could be for two reasons: ' ...
			   '(1) You are trying to display the mosaic ' ...
			   'view of the Mean or Max data. ' ...
			   ' - OR - ' ...
			   '(2) There are not enough slices to show the ' ...
			   'mosaic view for this plane. You need ' ...
			   'at least 3 slices. If there are this ' ...
			   'many slices in the data, then you are ' ...
			   'probably trying to show a mosaic view ' ...
			   'from the final slice - choose an earlier ' ...
			   'slice (move the Slice Slider to the ' ...
			   'left) and try again.']);

      end

      
      
    elseif command == 1000
      
      eval(VoxelClick);

    elseif command == 10000
      % buttonExpand
      
      if strcmp(get(buttonExpand, 'String'), 'More..')
	set(buttonExpand, 'String', 'Less..');
      else
	set(buttonExpand, 'String', 'More..');
      end
      eval(UpdatePosition)

    elseif command == 20000
        % buttonSaveExpand
        % Opens/closes the fifth/save layer
      
        if strcmp(get(buttonSaveExpand, 'String'), 'Save data...')    % ========== Make Save Layer Active ============
            set(buttonSaveExpand, 'String', 'Close Save');
            set(buttonExpand, 'String', 'Less..');
            set(buttonExpand, 'Enable', 'off');
            set(frameData, 'BackgroundColor', [ 1 0.193 0.215 ]);        % Set frames to correct colour for initial savetype
            set(frameMask, 'BackgroundColor', [ 1 0.193 0.215 ]);
            set(textDataLabel, 'BackgroundColor', [ 1 0.193 0.215 ]);
            set(textMaskLabel, 'BackgroundColor', [ 1 0.193 0.215 ]);
        else
            set(buttonSaveExpand, 'String', 'Save data...');            % ========= Make Save Layer In-Active ==========
            set(buttonExpand, 'String', 'More..');
            set(buttonExpand, 'Enable', 'on');
            set(frameTime, 'BackgroundColor', [ 0.105 0.538 1 ]);        % Reset frames etc to the correct background colours
            set(frameData, 'BackgroundColor', [ 0.105 0.538 1 ]);
            set(frameMask, 'BackgroundColor', [ 0.105 0.538 1 ]);
            set(textTimeLabel, 'BackgroundColor', [ 0.105 0.538 1 ]);
            set(textDataLabel, 'BackgroundColor', [ 0.105 0.538 1 ]);
            set(textMaskLabel, 'BackgroundColor', [ 0.105 0.538 1 ]);
        end
        eval(UpdateSaveDataPosition)
        

    else 
      error('Error: lyngby_ui_view.m called with incorrect command.') 
    end 






