function lyngby_ui_view_fir(arg1, arg2, arg3, arg4, arg5, ...
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_cc    - Viewing Cross-correlation results
%
%	function lyngby_ui_view_cc(handle, parameter1)
%
%       Input:  Property
%                   type       [ {time} | correlation ]
%                   voxel      Voxel to be plotted
%                   index      Time indices to be shown
%                   amplitude  [ {free} | keep ] axis control
%                   value      Used in the title
%
%       This functions is automatically called from lyngby_ui_view
%
%       See also: lyngby_ui_view

% cvs:  $Id: lyngby_ui_view_cc.m,v 1.5 1999/07/09 13:45:51 fnielsen Exp $
%       $Revision: 1.5 $

    lyngby_global
    lyngby_ui_global
    
    plottype = 1;
    voxel = 1;
    indices = 1:size(RESULT_CC,1);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'time')
	    plottype = 1;
	  elseif strcmp(arg, 'correlation')
	    plottype = 2;
	  else
	    error('Argument to ''type'' not recognized');
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    previousPlottype = 0;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end
    
    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      if plottype == 1
	xn = XN(:,voxel);
	
	time = 1:length(PN);
      
        scal=max(abs(xn))/max(abs(PN));
	plot(time, xn, 'r-');
	hold on
	  plot(time, scal*PN, 'b:');
	  legend('Data', 'Paradigm');
	hold off;
	sTitle = 'Time series';
      
      elseif plottype == 2
	cc = RESULT_CC(:,voxel);

	components = size(cc,1);
	nFFT = 2^nextpow2(2*length(PN));
	time = 1:components;
	plot(time, cc, 'r-');
	hold on
	  cpn = xcorr(PN, PN);
	  cpn = cpn((-ceil(components/2-1):floor(components/2))+length(PN), 1); 
	  scal = max(abs(cc))/max(abs(cpn));
	  plot(time, scal*cpn, 'b:');
	hold off
	legend('Data/Paradigm', 'Paradigm');
	sTitle = 'Cross-correlation';
      end
      set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);
      
      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if plottype == 1
	ax(1:2) = [min(indices) max(indices)];
      end


      axis(ax);

      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      title(sTitle);
      
    end


    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);



