function lyngby_ui_view_detrend(arg1, arg2, arg3, arg4, arg5, ...
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_dfl   - Detrended data viewing function
%
%       function lyngby_ui_view_detrend(PrototypeName, PrototypeValue)
%
%       Input: PrototypeName:
%                  type       [ {time} | time, original | histogram |
%                             Mean sequence | Std sequence |
%%                            Mean & Std Sequence |
%                             Mean/std | Mean/Std, voxel ]
%                  voxel      Voxel to be plotted
%                  index      Time indices to be shown
%                  amplitude  [ {free} | keep ] axis control
%                  value      Used in the title
% 
%       This functions is automatically called from lyngby_ui_view
% 
%       See also: lyngby_ui_view

% cvs:  $ $
%       $ $

    lyngby_global
    lyngby_ui_global

    
    plottype = 1;
    voxel = 1;
    indices = 1:size(XN, 1);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'time')
	    plottype = 1;
	  elseif strcmp(arg, 'time, original');
	    plottype = 2;
	  elseif strcmp(arg, 'histogram')
	    plottype = 3;
	  elseif strcmp(arg, 'mean sequence')
	    plottype = 4;
	  elseif strcmp(arg, 'std sequence')
	    plottype = 5;
	  elseif strcmp(arg, 'mean & std sequence')
	    plottype = 6;
	  elseif strcmp(arg, 'mean/std')
	    plottype = 7;
	  elseif strcmp(arg, 'mean/std, voxel')
	    plottype = 8;
	  elseif strcmp(arg, 'detrended data')
	    plottype = 9;
	  else
	    error('Argument to ''type'' not recognized');
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    % 'keep' only if same type as old plot
    previousPlottype = 0;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end


    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      if plottype == 1
	% Time series plot with XN
	
	xn = XN(:,voxel);
	
	time = 1:length(xn);
	plot(time, xn, 'g-');
	
	if ~isempty(PN) & any(PN);
	  scal = max(abs(xn))/max(abs(PN));
	  hold on
	  plot(time, 0.95*scal*PN, 'b:');
	  legend('Data', 'Paradigm');
	  hold off;
	end

	sTitle = 'Time series';

      elseif plottype == 2
	% Time series plot, with X
	
	x = X(:,voxel);
	
	time = 1:length(x);
	plot(time, x, 'g-');
	
	if ~isempty(PN);
	  scal = max(abs(x))/max(abs(PN));
	  hold on
	  plot(time, 0.95*scal*PN, 'b:');
	  legend('Data', 'Paradigm');
	  hold off;
	end

	sTitle = 'Original time series';

	
      elseif plottype == 3
	% Histogram
	
	xn = XN(:,voxel);
	hist(xn,25);
	sTitle = 'Histogram of data';
      
      elseif plottype == 4
	% Mean Sequence
	
	plot(X_SEQMEAN)
	xlabel('Scan');
	ylabel('Mean of image');
	sTitle = 'Mean sequence';
      
      elseif plottype == 5
	% Std Sequence
	
	plot(X_SEQSTD)
	xlabel('Scan');
	ylabel('Standard deviation of image');
	sTitle = 'Std Sequence';
      
      elseif plottype == 6
	% Mean Sequence
	
	plot(1:length(X_SEQMEAN), X_SEQMEAN, '-', ...
	    1:length(X_SEQSTD),  X_SEQMEAN + X_SEQSTD, ':', ...
	    1:length(X_SEQSTD),  X_SEQMEAN - X_SEQSTD, ':')
	xlabel('Scan');
	ylabel('Mean & Standard deviation of image');
	sTitle = 'Mean & Std Sequence';
      
      elseif plottype == 7
	% mean/std
	
	plot(X_MEAN, X_STD, '.')
	xlabel('Mean of each voxel');
	ylabel('Standard deviation of each voxel');
	sTitle = 'std/mean';
	
	axis([min(X_MEAN) max(X_MEAN) 0 max(X_STD)])
	
      elseif plottype == 8
	% mean/std, voxel
	
	plot(X_MEAN, X_STD, '.')
	hold on
	plot(X_MEAN(voxel), X_STD(voxel), 'co', 'Markersize', 12, ...
	    'LineWidth', 5);
	plot(X_MEAN(voxel), X_STD(voxel), 'rx', 'Markersize', 20);
	hold off
	xlabel('Mean of each voxel');
	ylabel('Standard deviation of each voxel');
	sTitle = 'std/mean';

	axis([min(X_MEAN) max(X_MEAN) 0 max(X_STD)])
	
      elseif plottype == 9
	% Time series plot with detrended data

	xd = XN(:,voxel);   % Detrended data
	% Need to remove mean from undetrended data, as it is unlikely to be centered
	mean_udt=mean(PP_LDT_XN_pre_LDT,1);
	[rXdt,cXdt]=size(PP_LDT_XN_pre_LDT);
	PP_LDT_XN_pre_LDT=PP_LDT_XN_pre_LDT-ones(rXdt,1)*mean_udt;
	
	xn = PP_LDT_XN_pre_LDT(:,voxel); % Preproc data, before detrending was applied

	% Need to scale PP_LDT_RUN
	RunScale=max(abs(xn))/max(PP_LDT_RUN);
	PP_LDT_RUN=0.95*RunScale*PP_LDT_RUN;
	
	dt = PP_LDT_TREND_N(:,voxel);
	
	time = 1:length(xd);
	plot(time, xn, 'g-', time, dt, 'r-', time, PP_LDT_RUN, 'c*');
	
	if ~isempty(PN) & any(PN);
	  scal = max(abs(xn))/max(abs(PN));
	  hold on
	  plot(time, 0.95*scal*PN, 'b:');
	  legend('(Centered) Data Pre-Detrending', 'Removed Trend', 'Run', 'Paradigm');
	  hold off;
	end

	sTitle = 'Time series';

	
      else
	error('Wrong plottype')
      end

      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if any(plottype == [1 2])
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);

      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      title(sTitle);

      
    end

    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);








