function lyngby_ui_view_dfl(varargin)

% lyngby_ui_view_dfl   - Default viewing function
%
%       function lyngby_ui_view_dfl(PrototypeName, PrototypeValue)
%
%       Property: type       [ {time} | time, original | histogram |
%                            Mean sequence | Std sequence | Mean & Std Sequence |
%                            Mean/std | Mean/Std, voxel ]
%                 voxel      Voxel to be plotted
%                 index      Time indices to be shown
%                 amplitude  [ {free} | keep ] axis control
%                 value      Used in the title
% 
%       This functions is automatically called from lyngby_ui_view. It
%       is the default function for viewing time series from the data
%       matrix. 
% 
%       See also LYNGBY, LYNGBY_UI_VIEW.
%
% $Id: lyngby_ui_view_dfl.m,v 1.13 2002/11/18 17:47:04 fnielsen Exp $


    lyngby_global
    lyngby_ui_global
    
    plottype = 'time';
    voxel = 1;
    indices = 1:size(XN, 1);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      arg = lower(varargin{n});
      
      if strcmp(arg, 'type')
	n = n + 1;
	arg = deblank(lower(varargin{n}));
	if isstr(arg)
	  if ismember(arg, { 'time' 'time, original' 'histogram' ...
		'mean sequence' 'std sequence' 'mean & std sequence' ...
		'mean/std' 'mean/std, voxel'} )
	    plottype = arg;
	  else
	    error('Argument to ''type'' not recognized');
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	arg = varargin{n};
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	arg = varargin{n};
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	arg = lower(varargin{n});
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	arg = varargin{n};
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    % 'keep' only if same type as old plot
    previousPlottype = '';
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if ~strcmp(plottype, previousPlottype)
      amplitude = 1;
    end


    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      if strcmp(plottype, 'time')
	% Time series plot with XN
	
	xn = XN(:,voxel);
	
	time = 1:length(xn);
	plot(time, xn, 'g-');
	
	if ~isempty(PN) & any(PN);
	  scal = max(abs(xn))/max(abs(PN));
	  hold on
	  plot(time, 0.95*scal*PN, 'b:');
	  legend('Data', 'Paradigm');
	  hold off;
	end

	sTitle = 'Time series';

      elseif strcmp(plottype, 'time, original')
	% Time series plot, with X
	
	x = X(:,voxel);
	
	time = 1:length(x);
	plot(time, x, 'g-');
	
	if ~isempty(PN);
	  scal = max(abs(x))/max(abs(PN));
	  hold on
	  plot(time, 0.95*scal*PN, 'b:');
	  legend('Data', 'Paradigm');
	  hold off;
	end

	sTitle = 'Original time series';
	
      elseif strcmp(plottype, 'histogram')
	% Histogram
	
	xn = XN(:,voxel);
	hist(xn,25);
	sTitle = 'Histogram of data';

      elseif strcmp(plottype, 'mean sequence')
	% Mean Sequence
	
	plot(X_SEQMEAN)
	xlabel('Scan');
	ylabel('Mean of image');
	sTitle = 'Mean sequence';
      
      elseif strcmp(plottype, 'std sequence')
	% Std Sequence
	
	plot(X_SEQSTD)
	xlabel('Scan');
	ylabel('Standard deviation of image');
	sTitle = 'Std Sequence';
      
      elseif strcmp(plottype, 'mean & std sequence')
	
	plot(1:length(X_SEQMEAN), X_SEQMEAN, '-', ...
	    1:length(X_SEQSTD),  X_SEQMEAN + X_SEQSTD, ':', ...
	    1:length(X_SEQSTD),  X_SEQMEAN - X_SEQSTD, ':')
	xlabel('Scan');
	ylabel('Mean & Standard deviation of image');
	sTitle = 'Mean & Std Sequence';
      
      elseif strcmp(plottype, 'mean/std')
	
	plot(X_MEAN, X_STD, '.')
	xlabel('Mean of each voxel');
	ylabel('Standard deviation of each voxel');
	sTitle = 'std/mean';
	
	axis([min(X_MEAN) max(X_MEAN) 0 max(X_STD)])
	
      elseif strcmp(plottype, 'mean/std, voxel')
	% mean/std, voxel
	
	plot(X_MEAN, X_STD, '.')
	hold on
	plot(X_MEAN(voxel), X_STD(voxel), 'co', 'Markersize', 12, ...
	    'LineWidth', 5);
	plot(X_MEAN(voxel), X_STD(voxel), 'rx', 'Markersize', 20);
	hold off
	xlabel('Mean of each voxel');
	ylabel('Standard deviation of each voxel');
	sTitle = 'std/mean';

	axis([min(X_MEAN) max(X_MEAN) 0 max(X_STD)])
	
      else
	error(sprintf('Internal error: plottype=%s', plottype));
      end

      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if any(ismember(plottype, { 'time' 'time, original'}))
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);

      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      title(sTitle);

      
    end

    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);








