function lyngby_ui_view_ikm(arg1, arg2, arg3, arg4, arg5, ... 
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_ikm   - Viewing Iterative K-means filter results 
%
%	function lyngby_ui_view_ikm(handle, parameter1)
%
%       Global: RESULT_KM_CENTER
%               RESULT_KM_ASSIGN
%               RESULT_KM_WITHIN
%               RESULT_KM_PROPERTY
%
%       See also: lyngby_ui_view, lyngby_ikm_main

% cvs:  $Id: lyngby_ui_view_ikm.m,v 1.1 1999/09/03 14:52:13 fnielsen Exp $
%       $Revision: 1.1 $

    clf

    lyngby_global
    lyngby_ui_global
    
    plottype = 1;
    voxel = 1;
    indices = 1:size(RESULT_IKM_ASSIGN,2);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmpi(arg, 'time')
	    plottype = 1;
	  elseif strcmpi(arg, 'max value')
	    plottype = 2;
	  elseif strcmpi(arg, 'cluster members')
	    plottype = 3;
	  elseif strcmpi(arg, 'cluster mean seq.')
	    plottype = 4;
	  elseif strcmpi(arg, 'cluster center scattergram')
	    plottype = 5;
	  elseif strcmpi(arg, 'Within variance')
	    plottype = 6;
	  else
	    error('Argument to ''type'' not recognized');
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    % 'keep' only if same type as old plot
    previousPlottype = 1;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end
    
    components = size(RESULT_IKM_CENTER, 2);
    
    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      if plottype == 1
	xn = XN(:,voxel);
	
	time = 1:length(xn);
      

	plot(time, xn, 'g-');
	if any(PN)
	  hold on
	  scal = max(abs(xn))/max(abs(PN));
	  plot(time, scal*PN, 'b:');
	  legend('Data', 'Paradigm');
	  hold off;
	end
	sTitle = 'Time series';
      
      elseif plottype == 2
	% Max value

	c = RESULT_IKM_ASSIGN(voxel);
	if size(RESULT_IKM_CENTER,1) > 1
	  cmax = max(RESULT_IKM_CENTER);
	  plot(cmax);
	  hold on
	    plot(c, max(RESULT_IKM_CENTER(:,c)), 'o');
	  hold off
	  axis([1 components min(cmax) max(cmax)]);
	  sTitle = 'Max value';
	else
	  plot(RESULT_IKM_CENTER);
	  maxabs = max(abs(RESULT_IKM_CENTER));	  
	  hold on
	    plot(c, RESULT_IKM_CENTER(1,c), 'o');
	  hold off
	  axis([1 components min(RESULT_IKM_CENTER) ...
		max(RESULT_IKM_CENTER) ] );
	  sTitle = '(Max) value';
	end
	legend off;
	xlabel('Cluster number');

      elseif plottype == 3
	% Cluster members
	
    	N = length(RESULT_IKM_PROPERTY.Clusters);
	Rows = round(sqrt(N));
	Cols = ceil(N / Rows);
	for n = 1:N
	  subplot(Rows, Cols, n)
	  hist(RESULT_IKM_ASSIGN(n,:), 1:max(RESULT_IKM_ASSIGN(n,:)));
	  ax = axis;
	  axis([0.5 max(RESULT_IKM_ASSIGN(n,:))+0.5 ax(3) ax(4)]);
	  title(sprintf('K=%d', RESULT_IKM_PROPERTY.Clusters(n)));
	  legend off;
	end
	xlabel('Cluster number');

	%subplot(Rows, Cols, 
	%ylabel('No. cluster members');
	
	sTitle = '';

      
      elseif plottype == 4
	% Time with mean cluster
	
	xn = XN(:,voxel);

	time = 1:length(xn);

	N = length(RESULT_IKM_PROPERTY.Clusters);
	Rows = round(sqrt(N));
	Cols = ceil(N / Rows);
	for n = 1:N
	  subplot(Rows, Cols, n)
	  cluster = RESULT_IKM_ASSIGN(n,voxel);
	  Indices = find(cluster == RESULT_IKM_ASSIGN(n,:));
	  if length(Indices) > 1
	    meanSeq = mean(XN(:,Indices)')';
	  else
	    meanSeq = XN(:,Indices);
	  end
	
	
	  plot(time, xn, 'g-');
	  hold on
	  h = plot(time, meanSeq, 'r-.');
	  set(h, 'LineWidth', 2);
	  if any(PN)
	    scal = max(abs(xn))/max(abs(PN)); 
	    plot(time, scal*PN, 'b:');
	    %legend('Data', 'Cluster mean', 'Paradigm');
	  else
	    %legend('Data', 'Cluster mean');
	  end
	  hold off;
	  sTitle = '';

	  title(sprintf('K=%d, c=%d', ...
	      RESULT_IKM_PROPERTY.Clusters(n), cluster));

	  if amplitude == 2
	    ax = oldAxis;
	  else
	    ax = axis;
	  end
	  ax(1:2) = [min(indices) max(indices)];
	  axis(ax);

	  
	end
      
      elseif plottype == 5
	% cluster center scattergram
	
	[dim, K] = size(RESULT_IKM_CENTER);
	[U,S,V] = svd(RESULT_IKM_CENTER,0);

	subplot('position', [0.7 0.55 0.25 0.35]);
	plot(U(:,1))
	title('First principal component');
	axis([1 size(U,1) -1 1])

	subplot('position', [0.7 0.1 0.25 0.35]);
	plot(U(:,2))
	title('Second principal component');
	axis([1 size(U,1) -1 1])

	subplot('position',[ 0.1 0.1 0.55 0.8]);
	plot(V(:,1), V(:,2));
	ax = axis;
	cla
	offset = 0;
	for Clusters = 1:length(RESULT_IKM_PROPERTY.Clusters)
	  for cluster = 1:RESULT_IKM_PROPERTY.Clusters(Clusters)
	    r = cluster + offset;
	    s = sprintf('%d_{%d}', ...
		RESULT_IKM_PROPERTY.Clusters(Clusters), cluster); 
	    text(V(r, 1), V(r, 2), s);
	  end
	  offset = offset + RESULT_IKM_PROPERTY.Clusters(Clusters);
	end
	axis([ax(1) ax(2)*1.1 ax(3) ax(4)]);
	xlabel('First principal component');
	ylabel('Second principal component');
	sTitle = 'Scattergram of cluster centers';

      elseif plottype == 6

	lyngby_ikm_plot_w(RESULT_IKM_WITHIN, ...
	    RESULT_IKM_PROPERTY.Clusters) 
	sTitle = 'Within variance';
	
      end
      
      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if any(plottype == [1 4])
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);
      
      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      if ~any(plottype == [3 4])
	title(sTitle);
      end
    end

    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);











