function lyngby_ui_view_km(arg1, arg2, arg3, arg4, arg5, ...
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_km    - Viewing K-means filter results
%
%	function lyngby_ui_view_km(handle, parameter1)
%
%       See also LYNGBY, LYNGBY_UI_VIEW, LYNGBY_KM_GLOBAL,
%                LYNGBY_KM_INIT, LYNGBY_KM_MAIN.
%
% $Id: lyngby_ui_view_km.m,v 1.12 2004/09/06 10:20:12 fnielsen Exp $


    clf

    lyngby_global
    lyngby_ui_global
    
    plottype = 1;
    voxel = 1;
    indices = 1:size(RESULT_KM_ASSIGN,2);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'time')
	    plottype = 1;
	  elseif strcmp(arg, 'max value')
	    plottype = 2;
	  elseif strcmp(arg, 'cluster members')
	    plottype = 3;
	  elseif strcmp(arg, 'cluster mean seq.')
	    plottype = 4;
	  elseif strcmp(arg, 'cluster center scattergram')
	    plottype = 5;
	  elseif strcmp(arg, 'similarity summary')
	    plottype = 6;
	  elseif strcmp(arg, 'convergence')
	    plottype = 7;	  
	  elseif strcmp(arg, 'all cluster means')
	    plottype = 8;
	  else
	    error('Argument to ''type'' not recognized');
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    % 'keep' only if same type as old plot
    previousPlottype = 1;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end
    
    components = size(RESULT_KM_CENTER, 2);
    
    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      if plottype == 1
	xn = XN(:,voxel);
	
	time = 1:length(xn);
      

	plot(time, xn, 'g-');
	if any(PN)
	  hold on
	  scal = max(abs(xn))/max(abs(PN));
	  plot(time, scal*PN, 'b:');
	  legend('Data', 'Paradigm');
	  hold off;
	end
	sTitle = 'Time series';
      
      elseif plottype == 2
	% Max value

	c = RESULT_KM_ASSIGN(voxel);
	if size(RESULT_KM_CENTER,1) > 1
	  cmax = max(RESULT_KM_CENTER);
	  plot(cmax);
	  hold on
	    plot(c, max(RESULT_KM_CENTER(:,c)), 'o');
	  hold off
	  axis([1 components min(cmax) max(cmax)]);
	  sTitle = 'Max value';
	else
	  plot(RESULT_KM_CENTER);
	  maxabs = max(abs(RESULT_KM_CENTER));	  
	  hold on
	    plot(c, RESULT_KM_CENTER(1,c), 'o');
	  hold off
	  axis([1 components min(RESULT_KM_CENTER) ...
		max(RESULT_KM_CENTER) ] );
	  sTitle = '(Max) value';
	end
	legend off;
	xlabel('Cluster number');

      elseif plottype == 3
	% Cluster members
	
	c = RESULT_KM_ASSIGN(voxel);
	hist(RESULT_KM_ASSIGN, 1:components);
	legend off;
	xlabel('Cluster number');
	ylabel('No. cluster members');
	sTitle = 'Cluster members';
      
      elseif plottype == 4
	% Time with mean cluster
	
	xn = XN(:,voxel);

	
	time = 1:length(xn);

	Indices = find(RESULT_KM_ASSIGN(:,voxel) == RESULT_KM_ASSIGN);
	if length(Indices) > 1
	  meanSeq = mean(XN(:,Indices)')';
	else
	  meanSeq = XN(:,Indices);
	end
	

	plot(time, xn, 'g-');
	hold on
	  h = plot(time, meanSeq, 'r-.');
	  set(h, 'LineWidth', 2);
	  if any(PN)
	    scal = max(abs(xn))/max(abs(PN)); 
	    plot(time, scal*PN, 'b:');
	    legend('Data', 'Cluster mean', 'Paradigm');
	  else
	    legend('Data', 'Cluster mean');
	  end
	hold off;
	sTitle = 'Time series';
      
      
      elseif plottype == 5
	% cluster center scattergram
	
	[dim, K] = size(RESULT_KM_CENTER);
	[U,S,V] = svd(RESULT_KM_CENTER,0);

	subplot('position', [0.7 0.55 0.25 0.35]);
	plot(U(:,1))
	title('First principal component');
	axis([1 size(U,1) -1 1])

	subplot('position', [0.7 0.1 0.25 0.35]);
	plot(U(:,2))
	title('Second principal component');
	axis([1 size(U,1) -1 1])
	
	subplot('position',[ 0.1 0.1 0.55 0.8])
	plot(V(:,1), V(:,2));
	ax = axis;
	cla
	for k = 1:K
	  text(V(k, 1), V(k, 2), int2str(k));
	end
	axis(ax);
	xlabel('First principal component');
	ylabel('Second principal component');
	sTitle = 'Scattergram of cluster centers';

      elseif plottype == 6
	% Similarity summary
	
	if ~isempty(RESULT_KM_CENTERSIM)
	  lyngby_km_plot_dist(RESULT_KM_ASSIGN, RESULT_KM_CENTERSIM);
	  hold on
	  plot(RESULT_KM_ASSIGN(voxel), RESULT_KM_CENTERSIM(voxel), ...
	      'rx');
	  hold off
	  sTitle = 'Cluster center similarity summary';
	else
	  lyngby_ui_message('Not available');
	  sTitle = 'Not available';
	end
	
      elseif plottype == 7
	% convergence
	
	plot(RESULT_KM_INFO);
	
	xlabel('Iteration');
	ylabel('Change in cluster center');
	sTitle = 'Convergence';

      elseif plottype == 8
	% Time with ALL cluster means
	
	xn = XN(:,voxel);
	
	
	time = 1:length(xn);
	
	%Indices = find(RESULT_KM_ASSIGN(:,voxel) == RESULT_KM_ASSIGN);
	%if length(Indices) > 1
	%  meanSeq = mean(XN(:,Indices)')';
	%else
	%  meanSeq = XN(:,Indices);
	%end
	
	% Create Labels for legend
	numclusters=size(RESULT_KM_CENTER,2);
	clusterlabelindex=[1:numclusters];
	clusterlabels=cell(1,numclusters);
	for li=1:numclusters,
	  clusterlabels{1,li}=[sprintf('Mean of Cluster %i', li)];
	end
	
	% Find out current cluster no.
	clusterid = RESULT_KM_ASSIGN(:,voxel);
	
	if length(time) == size(RESULT_KM_CENTER, 1)
	  % Probably 'variable'='time'
	  hd = plot(time, xn, 'g--');
	  set(hd, 'LineWidth', 2);
	  hold on
	
	  h2 = plot(time, RESULT_KM_CENTER);
	  set(h2, 'LineWidth', 1);
	  set(h2(clusterid), 'LineWidth', 3);
	  if any(PN)
	    scal = max(abs(xn))/max(abs(PN)); 
	    plot(time, scal*PN, 'b:');
	    labels=cell(1,numclusters+2);
	    labels{1,1}=['Data'];
	    for ab=2:numclusters+1,
	      labels{1,ab}=clusterlabels{ab-1};
	    end
	    labels{1,numclusters+2}=['Paradigm'];
	    legend(labels);
	  else
	    legend('Data', 'Cluster mean');
	  end
	  hold off;
	  sTitle = 'Time series';
	else
	  % Probably 'variable'='xcorrelation'
	  h2 = plot(RESULT_KM_CENTER);

	  % Emphasize the center associated with the present voxel.
	  set(h2(clusterid), 'LineWidth', 3);

	  sTitle = 'Cross-correlation';
	end

	
      end
      
      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if any(plottype == [1 4])
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);
      
      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      title(sTitle);
      
    end

    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);
