function lyngby_ui_view_lzit(arg1, arg2, arg3, arg4, arg5, ...
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_lzit  - Viewing Lange Zeger results
%
%       function lyngby_ui_view_lzit(PropertyName, ProbertyValue)
%
%       Property:  Type        [ {Time} | Error | Error, abs | Filter
%                              | Histogram of data | Histogram of
%                              error | Histogram of error, bell ] 
%                              Type of plot
%                  Voxel       Voxel to be plotted
%                  Index       2 element with start and stop time index
%                  Amplitude   [ {free} | keep ]
%                  Value       Value used in title
%
%       'Time' type will plot the convoluted signal, 'Error' is the
%       difference between the data (XN) and the convoluted signal. 
%       'Filter' type will plot the kernel of the Lange-Zeger model. 
%       The value associated with 'Voxel' indices in the datamatrix.
%       XN, PN, and RESULT_LZIT is used in the plotting.
%
%       See also LYNGBY, LYNGBY_UI_VIEW, LYNGBY_LZIT_MAIN,
%                LYNGBY_UI_GLOBAL. 
%
% $Id: lyngby_ui_view_lzit.m,v 1.5 2004/09/06 09:10:58 fnielsen Exp $


    lyngby_global
    lyngby_ui_global

    % Default values
    plottype = 1;
    voxel = 1;
    indices = 1:3;
    amplitude = 1;
    value = NaN;
    
    % Parse properties
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'time')
	    plottype = 1;
  	  elseif strcmp(arg, 'error')
	    plottype = 2;
	  elseif strcmp(arg, 'error, abs')
	    plottype = 3;
	  elseif strcmp(arg, 'filter')
	    plottype = 4;
	  elseif strcmp(arg, 'histogram of data')
	    plottype = 5;
	  elseif strcmp(arg, 'histogram of error')
	    plottype = 6;
	  elseif strcmp(arg, 'histogram of error, bell')
	    plottype = 7;
	  else
	    error('Argument to ''type'' not recognized');
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    
    previousPlottype = 1;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end
    

    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      time = 1:length(PN);
      resp = lyngby_lz_lambda(RESULT_LZIT(2,voxel), RESULT_LZIT(3,voxel), time', 'ForceOne');
      resp = resp * RESULT_LZIT(1,voxel);
	
      if plottype == 1
	xn = XN(:,voxel);
	
	model = conv(PN, resp);
	scal=0.9*max(abs(xn))/max(abs(PN));
     
	plot(time, xn, 'g-');
	hold on
	  plot(time, scal*PN, 'b:');
	  h = plot(time, model(1:length(PN)), 'r-.');
	  set(h, 'LineWidth', 2);
	  legend('Data',  'Paradigm', 'Model');
	hold off;
	sTitle = 'Time series';
      
      elseif plottype == 2 | plottype == 3
	% Histogram of error
	
	xn = XN(:,voxel);

	model = conv(PN, resp);
	residual = xn - model(1:length(PN));
	time = 1:length(PN);
        scal = max(abs(residual))/max(abs(PN));
	if plottype == 2
	  plot(time, residual, 'g-');
	else 
	  plot(time, abs(residual), 'g-');
	end
	hold on
	  plot(time, scal*PN, 'b:');
	  legend('Error', 'Paradigm');
	hold off;
	sTitle = 'Error time series';
	
      elseif plottype == 4
	plot(resp);
	legend off;
	sTitle = 'Filter Coefficients';
      
      elseif plottype == 5
	% Histogram of data
	
	xn = XN(:,voxel);

	hist(xn,25);
	sTitle = 'Histogram of data';
      	legend off;
	
      elseif plottype == 6
	% Histogram of error
	
	xn = XN(:,voxel);

	model = conv(PN, resp);
	residual = xn - model(1:length(PN));
	hist(residual,25);
	sTitle = 'Histogram of error';
	legend off;
	
      elseif plottype == 7
	% Histogram of error
	
	xn = XN(:,voxel);

	model = conv(PN, resp);
	residual = xn - model(1:length(PN));
	hist(residual,25);
	[dummy, histCenters] = hist(residual,25);
	width = histCenters(2) - histCenters(1);
	if amplitude == 2
	  limits = oldAxis(1:2);
	else
	  ax = axis;
	  limits = ax(1:2);
	end
	x = (limits(1):(limits(2)-limits(1))/99:limits(2))';
	p = length(residual) * width * lyngby_pdf_gauss(x, 0, std(residual)^2);
	hold on;
	  plot(x,p,'r');
	hold off;
	sTitle = 'Histogram of error';
	legend off;
	
      else
	error('Wrong plottype')

      end
      
      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if any(plottype == [1 2 3])
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);

      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      title(sTitle);
      
    end

    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);

