function lyngby_ui_view_mkm(arg1, arg2, arg3, arg4, arg5, ...
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_mkm   - Viewing of meta K-means results
%
%	function lyngby_ui_view_mkm(handle, parameter1)
%
%       lyngby_ui_view_mkm is automatically called from lyngby_ui_view
%
%       See also: lyngby_ui_view

% cvs:  $Id: lyngby_ui_view_mkm.m,v 1.6 1999/05/03 15:04:38 fnielsen Exp $
%       $Revision: 1.6 $


    lyngby_global
    lyngby_ui_global
    
    plottype = 1;
    voxel = 1;
    indices = 1:size(RESULT_MKM_ASSIGN,1);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'time')
	    plottype = 1;
	  elseif strcmp(arg, 'max value')
	    plottype = 2;
	  elseif strcmp(arg, 'cluster members')
	    plottype = 3;
	  elseif strcmp(arg, 'cluster mean seq.')
	    plottype = 4;
	  elseif strcmp(arg, 'convergence')
	    plottype = 5;
	  else
	    error('Argument to ''type'' not recognized');
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

        % 'keep' only if same type as old plot
    previousPlottype = 0;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end

    components = size(RESULT_MKM_CENTER, 2);
    
    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      if plottype == 1
	xn = XN(:,voxel);
	
	time = 1:length(PN);
      
        scal = max(abs(xn))/max(abs(PN));
	plot(time, xn, 'g-');
	hold on
	  plot(time, scal*PN, 'b:');
	  legend('Data', 'Paradigm');
	hold off;
	sTitle = 'Time';
      
      elseif plottype == 2
	% Max value

	c = RESULT_MKM_ASSIGN(voxel);
	if size(RESULT_MKM_CENTER,1) > 1
	  cmax = max(RESULT_MKM_CENTER);
	  plot(cmax)
	  hold on
	    plot(c, max(RESULT_MKM_CENTER(:,c)), 'o');
	  hold off
	  axis([1 components min(cmax) max(cmax)]);
	  sTitle = 'Max value';
	else
	  plot(RESULT_MKM_CENTER);
	  maxabs = max(abs(RESULT_MKM_CENTER));	  
	  axis([1 components min(RESULT_MKM_CENTER) ...
		max(RESULT_MKM_CENTER) ] );
	  hold on
	    plot(c, RESULT_MKM_CENTER(1,c), 'o');
	  hold off
	  sTitle = '(Max) value';
	end
	legend off;
	xlabel('Cluster number');

      elseif plottype == 3
	% Cluster members
	
	c = RESULT_MKM_ASSIGN(voxel);
	hist(RESULT_MKM_ASSIGN, 1:components);
	legend off;
	xlabel('Cluster number');
	ylabel('No. cluster members');
	sTitle = 'Cluster members';
      
      elseif plottype == 4
	% Time with mean cluster

	xn = XN(:,voxel);

	time = 1:length(PN);

	Indices = find(RESULT_MKM_ASSIGN(:,voxel) == RESULT_MKM_ASSIGN);

	if length(Indices) > 1
	  meanSeq = mean(XN(:,Indices)')';
	else
	  meanSeq = XN(:,Indices);
	end

        scal = max(abs(xn))/max(abs(PN));
	plot(time, xn, 'g-');
	hold on
	  plot(time, scal*PN, 'b:');
	  h = plot(time, meanSeq, 'r-.');
	  set(h, 'LineWidth', 2);
	  legend('Data', 'Paradigm', 'Cluster mean');
	hold off;
	sTitle = 'Time series';
      
      elseif plottype == 5
	% convergence
	
	plot(RESULT_MKM_INFO);
	
	xlabel('Iteration');
	ylabel('Change in cluster center');
	sTitle = 'Convergence';
	
      end

      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if (plottype == 1) | (plottype == 4)
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);
      
      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      title(sTitle);
      
    end

    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', ...
	plottype);

