function lyngby_ui_view_nnr(arg1, arg2, arg3, arg4, arg5, ...
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_nnr   - Viewing NNR filter results
%
%	function lyngby_ui_view_nnr(PrototypeName, PrototypeValue)
%
%       Input: PrototypeName:
%                  type       [ {Time} | Error | Error, abs | Network |
%                             Histogram of data | Histogram of error |
%                             Histogram of error, bell ]
%                  voxel      Voxel to be plotted
%                  index      Time indices to be shown
%                  amplitude  [ {free} | keep ] axis control
%                  value      Used in the title
% 
%       This functions is automatically called from lyngby_ui_view
%
%       See also: lyngby_ui_view

% cvs:  $Id: lyngby_ui_view_nnr.m,v 1.4 1999/01/15 14:02:23 fnielsen Exp $
%       $Revision: 1.4 $

    lyngby_global
    lyngby_ui_global
    lyngby_nnr_global
    
    plottype = 1;
    voxel = 1;
    indices = 1:size(PN,1);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'time')
	    plottype = 1;
  	  elseif strcmp(arg, 'error')
	    plottype = 2;
	  elseif strcmp(arg, 'error, abs')
	    plottype = 3;
	  elseif strcmp(arg, 'network')
	    plottype = 4;
	  elseif strcmp(arg, 'histogram of data')
	    plottype = 5;
	  elseif strcmp(arg, 'histogram of error')
	    plottype = 6;
	  elseif strcmp(arg, 'histogram of error, bell')
	    plottype = 7;
	  else
	    error(sprintf('Argument to ''type'' not recognized: %s', ...
		arg));
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    
    previousPlottype = 1;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end
    
    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      if plottype == 1
	% time
	
	xn = XN(:,voxel);

	lengthModel = size(RESULT_NNR_Y,1);
	lengthData = length(PN);
	indexModel = (lengthData-lengthModel+1):lengthData;
	model = RESULT_NNR_Y(:,voxel);
	time = 1:lengthData;
	
        scal = max(abs(xn))/max(abs(PN));
	plot(time, xn, 'g-');
	hold on
	  plot(time, scal*PN, 'b:');
	  h = plot(time(indexModel), model, 'r-.');
	  set(h, 'LineWidth', 2);
	  legend('Data', 'Paradigm', 'Model');
	hold off;
	sTitle = 'Time series';
	
      elseif plottype == 2 | plottype == 3
	% Histogram of error
	
	xn = XN(:,voxel);

	lengthModel = size(RESULT_NNR_Y,1);
	lengthData = length(PN);
	indexModel = (lengthData-lengthModel+1):lengthData;
	model = RESULT_NNR_Y(:,voxel);
	time = 1:lengthData;
	
	error = xn(indexModel) - model;
	time = 1:length(PN);
        scal = max(abs(error))/max(abs(PN));
	if plottype == 2
	  plot(indexModel, error, 'g-');
	else 
	  plot(indexModel, abs(error), 'g-');
	end
	hold on
	  plot(time, scal*PN, 'b:');
	  legend('Error', 'Paradigm');
	hold off;
	sTitle = 'Error time series';
	
      elseif plottype == 4
	legend off;
	sTitle = 'Network architecture';

	N = [ NNR_LAG+1 NNR_HIDDENUNITS+1 1 ; NNR_LAG NNR_HIDDENUNITS 1]; 
	[V, W] = lyngby_nn_u2vw(RESULT_NNR_U(:,voxel), N);
	lyngby_nn_plotnet(V,W);
	
	
      elseif plottype == 5
	% Histogram of data
	
	xn = XN(:,voxel);
	hist(xn,25);
	sTitle = 'Histogram of data';
      	legend off;
	
      elseif plottype == 6
	% Histogram of error
	
	xn = XN(:,voxel);

	lengthModel = size(RESULT_NNR_Y,1);
	lengthData = length(PN);
	indexModel = (lengthData-lengthModel+1):lengthData;
	model = RESULT_NNR_Y(:,voxel);
	time = 1:lengthData;
	error = xn(indexModel) - model;
	hist(error,25);
	sTitle = 'Histogram of error';
	legend off;
	
      elseif plottype == 7
	% Histogram of error
	
	xn = XN(:,voxel);

	lengthModel = size(RESULT_NNR_Y,1);
	lengthData = length(PN);
	indexModel = (lengthData-lengthModel+1):lengthData;
	model = RESULT_NNR_Y(:,voxel);
	time = 1:lengthData;
	error = xn(indexModel) - model;
	[Hist, histCenters] = hist(error,25);
	hist(error, 25);                    % For Matlab4 combatibility!        
	% bar(histCenters, Hist, 'hist');   % 'hist' is internal (in Matlab5)!
	                                    % But otherwise there
	                                    % is aliasing in
	                                    % vertical lines.
	width = histCenters(2) - histCenters(1);
	if amplitude == 2
	  limits = oldAxis(1:2);
	else
	  ax = axis;
	  limits = ax(1:2);
	end
	x = (limits(1):(limits(2)-limits(1))/99:limits(2))';
	p = sum(Hist) * width * lyngby_pdf_gauss(x, 0, std(error)^2);
	hold on;
	  plot(x,p,'r');
	hold off;
	sTitle = 'Histogram of error';
	legend off;
	
      else
	error('Wrong plottype')

      
      end
      
      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if any(plottype == [1 2 3])
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);

      
      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      title(sTitle);
      
    end


    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);













