function lyngby_ui_view_nns(arg1, arg2, arg3, arg4, arg5, ...
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_nns   - Viewing of NNS results
%
%	function lyngby_ui_view_nns(PrototypeName, PrototypeValue)
%
%       Input: PrototypeName:
%                  type       [ {Time} | Prediction | Network (net) |
%                             Network (matrix) |
%                             Histogram of data  | 
%                             Histogram of Saliency | 
%                             Error evolution ]
%                  voxel      Voxel to be plotted
%                  index      Time indices to be shown
%                  amplitude  [ {free} | keep ] axis control
%                  value      Used in the title
% 
%       This functions is automatically called from lyngby_ui_view
%
%       See also: lyngby_ui_view, lyngby_nns_main

% cvs:  $Id: lyngby_ui_view_nns.m,v 1.14 1998/11/10 13:01:06 fnielsen Exp $
%       $Revision: 1.14 $

    lyngby_global
    lyngby_ui_global
    lyngby_nns_global;
    
    
    plottype = 1;
    voxel = 1;
    indices = 1:size(PN,1);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'time')
	    plottype = 1;
  	  elseif strcmp(arg, 'prediction')
	    plottype = 2;
	  elseif strcmp(arg, 'network (net)')
	    plottype = 3;
  	  elseif strcmp(arg, 'network (matrix)')
	    plottype = 4;
	  elseif strcmp(arg, 'histogram of data')
	    plottype = 5;
	  elseif strcmp(arg, 'histogram of saliency')
	    plottype = 6;
	  elseif strcmp(arg, 'error evolution')
	    plottype = 7;

	  else
	    error(sprintf('Argument to ''type'' not recognized: %s', ...
		arg));
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end


    previousPlottype = 0;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end
    
    oldAxis = axis;

    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      subplot(1,1,1);
      
      if plottype == 1 | plottype == 2
	% time
	
	xn = XN(:,voxel);

	if strcmp(lower(NNS_TYPE), 'ls') | ...
	      strcmp(lower(NNS_TYPE), 'lssecondorder')
	  T = PN;
	else
	  T = lyngby_nn_etarget(PN);
	end
	lengthData = length(T);
	time = (1:lengthData)';

        scal = max(abs(xn))/max(abs(T));
	plot(time, xn, 'g-');
	if plottype == 1
	  hold on
	    plot(time, scal*T, 'b:');
	    legend('Data', 'Paradigm');
	  hold off;
	  sTitle = 'Time series';
	else
	  hold on
	    plot(time, scal*T, 'b:');
	    h = plot(DISCRIM_TMASK*time, scal*RESULT_NNS_PRED, 'ro');
	    set(h, 'LineWidth', 2);
	    legend('Data', 'Paradigm', 'Prediction');
	  hold off;
	  sTitle = 'Time series';
	end

      elseif plottype == 3
	lyngby_nn_plotnet(RESULT_NNS_V, RESULT_NNS_W, 'Type', 'Net');

      	sTitle = 'Neural network';
      
      elseif plottype == 4
	lyngby_nn_plotnet(RESULT_NNS_V, RESULT_NNS_W, 'Type', 'Matrix');
	
      elseif plottype == 5
	% Histogram of data
	
	xn = XN(:,voxel);
	hist(xn,25);
	sTitle = 'Histogram of data';
	legend off;
	
      elseif plottype == 6
	% Histogram of saliency
	
	hist(RESULT_NNS,25);
	sTitle = 'Histogram of Saliency';
	legend off;
	
      elseif plottype == 7
	% Error evolution

	if strcmp(lower(NNS_GENOPTIM), 'free')
	  plot(RESULT_NNS_E);
	  ylabel('Training error');
	  xlabel('Iteration number');
	
	elseif strcmp(lower(NNS_GENOPTIM), 'earlystop')
	  plot(RESULT_NNS_E);
	  ylabel('Validation error');
	  xlabel('Iteration number');
	
	elseif strcmp(lower(NNS_GENOPTIM), 'hiddenunitsearlystop')
	  plot(RESULT_NNS_E);
	  ylabel('Validation error');
	  xlabel('Optimization iteration');
	  if length(RESULT_NNS_INFO) == size(RESULT_NNS_E,2)
	    for n = 1:size(RESULT_NNS_E,2)
	      if n == 1 
		sLegend = sprintf('legend(''%d hidden unit''', ...
		    RESULT_NNS_INFO(n));
	      else		
		sLegend = sprintf('%s, ''%d hidden units''', sLegend, ...
		    RESULT_NNS_INFO(n));
	      end
	    end
	    sLegend = sprintf('%s);', sLegend);
	    eval(sLegend);
	  else
	    lyngby_log('Initialization of NNS has changed')
	  end
	elseif strcmp(lower(NNS_GENOPTIM), 'pruning')
	  if size(RESULT_NNS_INFO,1) == size(RESULT_NNS_E,1)
	    plot(RESULT_NNS_INFO, RESULT_NNS_E)
	    ylabel('Validation error');
	    xlabel('Parameters');
	  else
	    lyngby_log('Initialization of NNS has changed')
	  end
	
	elseif strcmp(lower(NNS_GENOPTIM), 'pruning1dreggridsearch')
	  if size(RESULT_NNS_INFO,1) == size(RESULT_NNS_E,1)

	    semilogx(RESULT_NNS_INFO, RESULT_NNS_E);
	    
	    xlabel('Regularization')
	    ylabel('Test set error');

	  else
	    lyngby_log(['The size of RESULT_NNS_INFO and RESULT_NNS_E '...
		  'is different'])
	  end
	  
	elseif strcmp(lower(NNS_GENOPTIM), 'pruning2dreggridsearch')
	  if size(RESULT_NNS_INFO,1) == size(RESULT_NNS_E,1)
	    gridsize = sqrt(length(RESULT_NNS_E));
	    
	    x = RESULT_NNS_INFO(1+gridsize*(0:(gridsize-1)),1);
	    y = RESULT_NNS_INFO(1:gridsize,2); 
	    M = reshape(RESULT_NNS_E, gridsize, gridsize);
	    surf(x, y, M);
	    hold on
	    contour(x, y, M);
	    
	    % These labels do not position themselves properly.
	    xlabel('Input weight regularization', 'Units', ...
		'normalized', 'Position', [0.75 0]);
	    ylabel('Output weight regularization', 'Units', ...
		'normalized', 'Position', [0.25 0]);
	    zlabel('Error', 'Units', ...
		'normalized', 'Position', [-0.1 0.5]);

	    hold off
 	    set(gca, 'XScale', 'log');
	    set(gca, 'YScale', 'log');

	    axis([min(x) max(x) min(y) max(y) 0 max(max(M))]);
	  else
	    lyngby_log(['The size of RESULT_NNS_INFO and RESULT_NNS_E '...
		'is different'])
	  end

	end
	
	ax = axis;
	ax(3) = 0;
	axis(ax);
	
	sTitle = 'Error evolution';
	
      else
	error('Wrong plottype')
	
      end
      
      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if any(plottype == [1 2 ])
	ax(1:2) = [min(indices) max(indices)];
      elseif any(plottype == [1 2 ])
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);
      
      if plottype ~= 4
	sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
	sTitle = sprintf('%s (%d)', sTitle, voxel);
	if ~isnan(value)
	  sTitle = sprintf('%s, %f', sTitle, value);
	end
	t = title(sTitle);
      end
      
      if plottype == 6 & strcmp(lower(NNS_GENOPTIM), ...
	    'pruning2dreggridsearch')
	% Problems with position of the title!
	set(t, 'Units', 'normalized', 'Position', [0.5 1]);
      end
	
    end

    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);














