function lyngby_ui_view_sop(arg1, arg2, arg3, arg4, arg5, ...
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_sop   - Viewing for Strother OPLS
%
%       function lyngby_ui_view_sop(PropertyName, PropertyValue)
%
%       Property: Type       [ {time} | histogram ]
%                 Voxel      Voxel to be plotted
%                 Index      Time indices to be shown
%                 Amplitude  [ {free} | keep ] axis control
%                 Value      Used in the title
% 
%       Global:   RESULT_SOP_U    Canonic sequence
%                 XN              Preprocessed datamatrix
%                 PN              Preprocessed paradigm
%                 R               Run structure
%
%       This functions is automatically called from lyngby_ui_view to
%       plot the result of the SOP analysis in the right 'time'
%       window. 
% 
%       See also LYNGBY, LYNGBY_UI_VIEW, LYNGBY_SOP_MAIN.
%
% $Id: lyngby_ui_view_sop.m,v 1.16 2002/12/17 23:32:48 fnielsen Exp $


    lyngby_global
    lyngby_ui_global
    
    plottype = 1;
    voxel = 1;
    indices = 1:size(XN,1);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'time')
	    plottype = 1;
	  elseif strcmp(arg, 'histogram')
	    plottype = 2;
	  elseif strcmp(arg, 'canonicvalues')
	    plottype = 3;
	  elseif ~isempty(findstr(arg, 'canonicseq. & mean'))
	    plotparam = sscanf(arg, '%d');
	    plottype = 4;
	  elseif ~isempty(findstr(arg, 'canonicsequence'))
	    plotparam = sscanf(arg, '%d');
	    plottype = 5;
	  elseif ~isempty(findstr(arg, 'state-space'))
	    plotparam = sscanf(arg, '%d-%d');
	    plottype = 6;
	  else
	    error(sprintf('Argument to ''type'' not recognized: %s', arg));
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end
    
    % 'keep' only if same type as old plot
    previousPlottype = 1;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end
    
    
    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      if plottype == 1
	% Time series plot
	
	xn = XN(:,voxel);
	
	time = 1:length(PN);

        scal=max(abs(xn))/max(abs(PN));
	plot(time, xn, 'g-');
	hold on
        plot(time, 0.95*scal*PN, 'b:');
        
        legend('Data', 'Paradigm');
	hold off;
	sTitle = 'Time series';
	
      elseif plottype == 2
	% Histogram
	
	xn = XN(:,voxel);

	hist(xn,25);
	sTitle = 'Histogram of data';

	
      elseif plottype == 3
	% Canonical spectrum
	
	plot(RESULT_SOP_S)
	ylabel('Canonical correlation coefficient');
	xlabel('Canonical component');
	sTitle = 'Canonical spectrum';
	
      elseif plottype == 4
	% Canonical sequence & mean
	
	% Get time sequence for voxel
	xn = XN(:,voxel);


	Y = lyngby_sdesign(R);
	xnr = (xn' * Y) ./ sum(Y);
	
	comp = plotparam;

	pn = PN(find(R==R(1)));
	time = 1:length(pn);

	scalU = max(abs(xnr)) / max(abs(RESULT_SOP_U(:,comp)));
	scalP = max(abs(xnr)) / max(abs(pn));
	plot(time, xnr, 'g-');
	hold on

	plot(time, scalU*RESULT_SOP_U(:,comp), 'r--');
        plot(time, scalP*pn, 'b:');
        
        legend('Voxel run mean', 'Canonical sequence', 'Paradigm');
	hold off;
	sTitle = sprintf('%d Canonical sequence and mean', comp);

      
      elseif plottype == 5
	% Canonical sequence
	
	comp = plotparam;
	
	time = 1:size(RESULT_SOP_U, 1);

	plot(time, RESULT_SOP_U(:,comp), 'g-');
	
	if exist('PN') & ~isempty(PN)
	  pn = PN(find(R==R(1)));
	  maxpn = max(abs(pn));
	  if maxpn ~= 0
	    hold on
	    scal = max(abs(RESULT_SOP_U(:,comp)))/maxpn;
	    plot(time, 0.95*scal*pn, 'b:');
	  end
	  legend('Canonical sequence', 'Paradigm');
	  hold off;
	end
	
	sTitle = sprintf('%d Canonical sequence', comp);
	
      elseif plottype == 6
	% State-space
	
	comp1 = plotparam(1);
	comp2 = plotparam(2);

	plot(RESULT_SOP_U(:,comp1), RESULT_SOP_U(:,comp2), 'g-');
	
	if ~isempty(PN)
	  hold on
	  pn = PN(find(R==R(1)));
	  pnOn = find(pn==pn(1));
	  pnOff = find(pn~=pn(1));
	  plot(RESULT_SOP_U(pnOn,comp1), RESULT_SOP_U(pnOn,comp2), 'rx');
	  plot(RESULT_SOP_U(pnOff,comp1), RESULT_SOP_U(pnOff,comp2), 'bo');
	  hold off
	end

 	xlabel(sprintf('%d. canonical sequence', comp1));
 	ylabel(sprintf('%d. canonical sequence', comp2));
	sTitle = 'State-Space';
	legend off
	
      else
	error('Wrong plottype')
      end

      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if plottype == 1
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);

      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      title(sTitle);
      
    end

    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);












