function lyngby_ui_view_svd(arg1, arg2, arg3, arg4, arg5, ...
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_svd   - Viewing for Strother OPLS
%
%       function lyngby_ui_view_svd(PrototypeName, PrototypeValue)
%
%       Input: PrototypeName:
%                  type       [ {time} | histogram | singular values |
%                             eigenseq. & time | eigensequence |
%                             state-space ]
%                  voxel      Voxel to be plotted
%                  index      Time indices to be shown
%                  amplitude  [ {free} | keep ] axis control
%                  value      Used in the title
% 
%       This functions is automatically called from lyngby_ui_view
% 
%       See also: lyngby_ui_view, lyngby_svd_main

% cvs:  $Id: lyngby_ui_view_svd.m,v 1.3 1999/07/09 14:40:38 fnielsen Exp $
%       $Revision: 1.3 $

    lyngby_global
    lyngby_ui_global
    
    plottype = 1;
    voxel = 1;
    indices = 1:size(XN,1);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'time')
	    plottype = 1;
	  elseif strcmp(arg, 'histogram')
	    plottype = 2;
	  elseif strcmp(arg, 'singular values')
	    plottype = 3;
	  elseif ~isempty(findstr(arg, 'eigenseq. & time'))
	    plotparam = sscanf(arg, '%d');
	    plottype = 4;
	  elseif ~isempty(findstr(arg, 'eigensequence'))
	    plotparam = sscanf(arg, '%d');
	    plottype = 5;
	  elseif ~isempty(findstr(arg, 'state-space'))
	    plotparam = sscanf(arg, '%d-%d');
	    plottype = 6;
	  else
	    error(sprintf('Argument to ''type'' not recognized: %s', arg));
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end
    
    % 'keep' only if same type as old plot
    previousPlottype = 1;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end
    
    
    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      if plottype == 1
	% Time series plot
	
	xn = XN(:,voxel);
	
	time = 1:length(xn);


	plot(time, xn, 'g-');
	if any(PN)
	  hold on
	  scal = max(abs(xn))/max(abs(PN));
	  plot(time, 0.95*scal*PN, 'b:');
	  legend('Data', 'Paradigm');
	  hold off;
	end
	sTitle = 'Time series';
	
      elseif plottype == 2
	% Histogram
	
	hist(XN(:,voxel),25);
	sTitle = 'Histogram of data';
	ylabel('Absolute frequency');
	
      elseif plottype == 3
	% Singluar values
	
	plot(RESULT_SVD_S)
	ylabel('Amplitude');
	xlabel('Eigensequence number');
	sTitle = 'Singular values';
	
      elseif plottype == 4

	% Get time sequence for voxel
	xn = XN(:,voxel);
	pn = PN;
	time = 1:length(xn);

	comp = plotparam;

	scalU = max(abs(xn)) / max(abs(RESULT_SVD_U(:, comp)));

	plot(time, xn, 'g-');
	hold on
	plot(time, scalU*RESULT_SVD_U(:,comp), 'r--');
	if any(PN)
	  scalP = max(abs(xn)) / max(abs(pn));
	  plot(time, scalP*pn, 'b:');
	  legend('Voxel sequence', 'Eigensequence', 'Paradigm');
	else
	  legend('Voxel sequence', 'Eigensequence');
	end
	hold off;
	sTitle = sprintf('%d Eigensequence and time', comp);

      
      elseif plottype == 5

	comp = plotparam;
	time = 1:length(PN);
	
	plot(time, RESULT_SVD_U(:,comp), 'g-');
	
	if exist('PN')
	  pn = PN;
	  time = 1:length(pn);
	  maxpn = max(abs(pn));
	  if maxpn ~= 0
	    hold on
	    scal = max(abs(RESULT_SVD_U(:,comp)))/maxpn;
	    plot(time, 0.95*scal*pn, 'b:');
	  end
	  legend('Eigensequence', 'Paradigm');
	  hold off;
	end
	
	sTitle = sprintf('%d Eigensequence', comp);
	
      elseif plottype == 6

	comp1 = plotparam(1);
	comp2 = plotparam(2);

	plot(RESULT_SVD_U(:,comp1), RESULT_SVD_U(:,comp2), 'g-');
	
	if ~isempty(PN)
	  hold on
	  pn = PN(find(R==R(1)));
	  pnOn = find(pn==pn(1));
	  pnOff = find(pn~=pn(1));
	  plot(RESULT_SVD_U(pnOn,comp1), RESULT_SVD_U(pnOn,comp2), 'rx');
	  plot(RESULT_SVD_U(pnOff,comp1), RESULT_SVD_U(pnOff,comp2), 'bo');
	  hold off
	end

 	xlabel(sprintf('%d. eigensequence', comp1));
 	ylabel(sprintf('%d. eigensequence', comp2));
	sTitle = 'State-Space';
	legend off
	
      else
	error('Wrong plottype')
      end

      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if any(plottype == [1 4 5])
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);

      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      title(sTitle);
      
    end

    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);












