function lyngby_ui_view_ts(arg1, arg2, arg3, arg4, arg5, ...
    arg6, arg7, arg8, arg9, arg10, arg11, arg12) 

% lyngby_ui_view_ts    - t-test viewing function
%
%       function lyngby_ui_view_ts(PrototypeName, PrototypeValue)
%
%       Input: PrototypeName:
%                  type       [ {Time} | Histogram | Estimated pdfs]
%                  voxel      Voxel to be plotted
%                  index      Time indices to be shown
%                  amplitude  [ {free} | keep ] axis control
%                  value      Used in the title
% 
%       This functions is automatically called from lyngby_ui_view
%
%       TS_EDGEDROP from lyngby_ts_global is used in connection with
%       the 'Estimated pdfs' type of plot.
% 
%       See also: lyngby_ui_view, lyngby_ts_global

% cvs:  $Id: lyngby_ui_view_ts.m,v 1.4 1999/07/09 14:33:09 fnielsen Exp $
%       $Revision: 1.4 $

    lyngby_global
    lyngby_ui_global
    lyngby_ts_global
    
    plottype = 1;
    voxel = 1;
    indices = 1:size(XN,1);
    amplitude = 1;
    value = NaN;
    
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'time')
	    plottype = 1;
	  elseif strcmp(arg, 'histogram')
	    plottype = 2;
	  elseif strcmp(arg, 'estimated pdfs')
	    plottype = 3;
	  else
	    error('Argument to ''type'' not recognized');
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      elseif strcmp(arg, 'voxel')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(voxel) == 1
	  voxel = arg;
	else
	  error(['''voxel'' PropertyName should be followed by a ' ...
	      'a single value']);
	end
      elseif strcmp(arg, 'index')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if length(arg) == 2
	  indices = arg(1):arg(2);
	else
	  error('')
	end

      elseif strcmp(arg, 'amplitude')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'free')
	  amplitude = 1;
	elseif strcmp(arg, 'keep')
	  amplitude = 2;
	else
	  % disp('Warning: ''Amplitude'' PropertyName not recognized');
	end
      elseif strcmp(arg, 'value')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	value = arg;
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    % 'keep' only if same type as old plot
    previousPlottype = 1;
    h = findobj(gcf, 'tag', 'previousPlottype');
    if h
      previousPlottype = get(h, 'Userdata');
    end
    if plottype ~= previousPlottype
      amplitude = 1;
    end

    oldAxis = axis;
    
    if ~isempty(voxel)
      voxel3 = lyngby_mask2full(voxel);

      if plottype == 1
	% Time series plot
	
	xn = XN(:,voxel);
	
	time = 1:length(PN);

        scal=max(abs(xn))/max(abs(PN));
	plot(time, xn, 'g-');
	hold on
        plot(time, 0.95*scal*PN, 'b:');
        
        legend('Data', 'Paradigm');
	hold off;
	sTitle = 'Time series';
	
      elseif plottype == 2
	% Histogram
	
	xn = XN(:,voxel);
	hist(xn,25);
	sTitle = 'Histogram of data';

      elseif plottype == 3
	% Bells

	xn = XN(:,voxel);

	[indexOn, indexOff] = lyngby_splitonoff(PN, TS_EDGEDROP);
	meanOn = mean(xn(indexOn));
	meanOff = mean(xn(indexOff));
	stdOnOff = std(xn);
	
	minLimit = min([meanOn meanOff]) - 5 * stdOnOff;
	maxLimit = max([meanOn meanOff]) + 5 * stdOnOff;
	x = (minLimit:(maxLimit-minLimit)/99:maxLimit)';
	pOn = lyngby_pdf_gauss(x, meanOn, stdOnOff^2);
	pOff = lyngby_pdf_gauss(x, meanOff, stdOnOff^2);

	plot(x, pOn, 'r', x, pOff, 'b');
	
	legend('On', 'Off');
	sTitle = 'Estimated pdfs';

	
      else
	error('Wrong plottype')
      end

      if amplitude == 2
	ax = oldAxis;
      else
	ax = axis;
      end
      if plottype == 1
	ax(1:2) = [min(indices) max(indices)];
      end
      axis(ax);

      sTitle = sprintf('%s, [%d, %d, %d]', sTitle, voxel3);
      sTitle = sprintf('%s (%d)', sTitle, voxel);
      if ~isnan(value)
	sTitle = sprintf('%s, %f', sTitle, value);
      end
      title(sTitle);
      
    end

    h = findobj(gcf, 'tag', 'previousPlottype');
    if isempty(h)
      uicontrol(gcf, 'Tag', 'previousPlottype', 'Visible', 'off');
    end
    set(findobj(gcf, 'Tag', 'previousPlottype'), 'UserData', plottype);















