function lyngby_ui_viewvol(arg1, arg2, arg3, arg4, arg5, arg6) 

% lyngby_ui_viewvol    - View full volume timeserie and specify ROI and voxelmask 
%
%       function lyngby_ui_viewvol(V) 
%       function lyngby_ui_viewvol(command,parameter1) 
%
%       Input:  V   A Volume
%
%       This function is not finished. It should sometime in the
%       future substitute lyngby_ui_volume.
%
%	Made with GUI Maker Ver 2.1 by Patrick Marchand

%  Created: 15-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_viewvol.m,v 1.2 1997/08/28 12:34:29 fnielsen Exp $ 
%       $Revision: 1.2 $

    lyngby_global;
    lyngby_ui_option;
	
    UpdateSagittal = [ ...
	  'figure(figVolume);',...
	  'subplot(2,2,2);',...
	  'slice = get(sliderSagittal, ''Value'');',...
	  'PopupVolume = get(popupVolume, ''value'');'...
	  'if PopupVolume == 1,',...
	  '  lyngby_image(lyngby_getslice(get(popupVolume, ''UserData''), ''s'', slice));',...
	  '  title(sprintf(''Sagittal, Slice %d, Volume'', slice));',...
	  'elseif PopupVolume == 2,',...
	  '  lyngby_image(lyngby_getslice(get(buttonClose, ''UserData''), ''s'', slice));',...
	  '  title(sprintf(''Sagittal, Slice %d, Mask'', slice));',...
	  'else,',...
	  '  lyngby_ui_message(''Not implemented yet'');',...  
	  'end,',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  ];

    UpdateCoronal = [ ...
	  'figure(figVolume);',...
	  'subplot(2,2,1);',...
	  'slice = get(sliderCoronal, ''Value'');',...
	  'PopupVolume = get(popupVolume, ''value'');'...
	  'if PopupVolume == 1,',...
	  '  slice = get(sliderCoronal, ''Value'');',...
	  '  lyngby_image(lyngby_getslice(get(popupVolume, ''UserData''), ''c'', slice));',...
	  '  title(sprintf(''Coronal, Slice %d, Volume'', slice));',...
	  'elseif PopupVolume == 2,',...
	  '  lyngby_image(lyngby_getslice(get(buttonClose, ''UserData''), ''c'', slice));',...
	  '  title(sprintf(''Coronal, Slice %d, Mask'', slice));',...
	  'end,',...
	  'xlabel(''x'');',...
	  'ylabel(''z'');',...
	  ];
    
    UpdateTransversal = [ ...
	  'figure(figVolume);',...
	  'subplot(2,2,3);',...
	  'slice = get(sliderTransversal, ''Value'');',...
	  'PopupVolume = get(popupVolume, ''value'');'...
	  'if PopupVolume == 1,',...
	  '  lyngby_image(lyngby_getslice(get(popupVolume,' ...
	  '      ''UserData''), ''t'', slice));',...
	  '  title(sprintf(''Transversal, slice %d, Volume'', slice));',...
	  'elseif PopupVolume == 2,',...
	  '  lyngby_image(lyngby_getslice(get(buttonClose, ''UserData''), ''t'', slice));',...
	  '  title(sprintf(''Transversal, Slice %d, Mask'', slice));',...
	  'end,',...
	  'xlabel(''x'');',...
	  'ylabel(''y'');',...
	  ];
    
    UpdateFullVolume = [ ...
	  'eval(UpdateSagittal);',...
	  'eval(UpdateCoronal);',...
	  'eval(UpdateTransversal);',...
	  ];

    UpdateMask = [ ...
	  'if get(checkRoiMask, ''value''),',...
	  '  eval(UpdateNewVolume);',...
	  'elseif get(checkVoxelMask, ''value''),',...
	  '  if issparse(VOXEL_MASK),',...
	  '    eval(UpdateFullVolume);',...
	  '  else,',...
	  '    eval(UpdateNewVolume);',...
	  '  end,',...
	  'else,',...
	  '  set(buttonClose, ''UserData'', ',...
	  '         ones(1, size(get(popupVolume, ''UserData''),2)));',...
	  'end,',...
	  ];
   
   
   
    ReadFields = [ ...
	  'bOk = 0;',...
	  'if get(checkROI, ''value''),',...
	  '[XBegin, count1] = sscanf(get(editROIXBegin, ''String''), ''%d'');',...
	  '[XEnd, count2] = sscanf(get(editROIXEnd, ''String''), ''%d'');',...
	  '[YBegin, count3] = sscanf(get(editROIYBegin, ''String''), ''%d'');',...
	  '[YEnd, count4] = sscanf(get(editROIYEnd, ''String''), ''%d'');',...
	  '[ZBegin, count5] = sscanf(get(editROIZBegin, ''String''), ''%d'');',...
	  '[ZEnd, count6] = sscanf(get(editROIZEnd, ''String''), ''%d'');',...
	  'if count1 ~= 1,',...
	  'error(''Cannot read left X ROI value as an integer'');',...
	  'elseif count2 ~= 1,',...
	  'error(''Cannot read right X ROI value as an integer'');',...
	  'elseif count3 ~= 1,',...
	  'error(''Cannot read left Y ROI value as an integer'');',...
	  'elseif count4 ~= 1,',...
	  'error(''Cannot read right Y ROI value as an integer'');',...
	  'elseif count5 ~= 1,',...
	  'error(''Cannot read left Z ROI value as an integer'');',...
	  'elseif count6 ~= 1,',...
	  'error(''Cannot read right Z ROI value as an integer'');',...
	  'else,',... 
	  'Xlimit = [min([XBegin XEnd]) max([XBegin XEnd])];',...
	  'Ylimit = [min([YBegin YEnd]) max([YBegin YEnd])];',...
	  'Zlimit = [min([ZBegin ZEnd]) max([ZBegin ZEnd])];',...
	  'if Xlimit(1)<1 | Xlimit(2)>NUM_VOXELS(1),',...
	  'error([''The X ROI must be within 1 and '' num2str(NUM_VOXELS(1))]);',...
	  'elseif Ylimit(1)<1 | Ylimit(2)>NUM_VOXELS(2),',...
	  'error([''The Y ROI must be within 1 and '' num2str(NUM_VOXELS(2))]);',...
	  'elseif Zlimit(1)<1 | Zlimit(2)>NUM_VOXELS(1),',...
	  'error([''The Z ROI must be within 1 and '' num2str(NUM_VOXELS(3))]);',...
	  'else,',...
	  'ROI_VOXELS = [Xlimit ; Ylimit ; Zlimit];',...
	  'bOk = 1;',...
	  'end,',...
	  'end,',...
	  'else,',...
	  'ROI_VOXELS = [];',...
	  'bOk = 1;',...
	  'end',...
	  ];


    if isstr(arg1) 
      if strcmp(lower(arg1),lower('sliderTransversal')) 
	command = 101; 
      elseif strcmp(lower(arg1),lower('sliderSagittal')) 
	command = 102; 
      elseif strcmp(lower(arg1),lower('sliderCoronal')) 
	command = 103; 
      elseif strcmp(lower(arg1),lower('popupVolume')) 
	command = 200; 
      elseif strcmp(lower(arg1),lower('popupEditMask')) 
	command = 300; 
      elseif strcmp(lower(arg1),lower('buttonApply')) 
	command = 301; 
      elseif strcmp(lower(arg1),lower('checkRoiMask')) 
	command = 600; 
      elseif strcmp(lower(arg1),lower('checkVoxelMask')) 
	command = 601; 
      elseif strcmp(lower(arg1),lower('popupRoiMask')) 
	command = 700; 
      elseif strcmp(lower(arg1),lower('popupVoxelMask')) 
	command = 701; 
      elseif strcmp(lower(arg1),lower('buttonClose')) 
	command = 900; 
      end
    else
      if (size(arg1,2) > 1)             % A matrix
	command = 0;
      elseif all(size(arg1) ~= [1 1])  % A command
	command = arg1;
      else
	error('Wrong number of arguments');
      end
    end 


    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_viewvol'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_viewvol.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	figVolume = handle_list(1);
	textSliderX = handle_list(2); 
	textSliderY = handle_list(3); 
	textSliderZ = handle_list(4); 
	sliderTransversal = handle_list(5); 
	sliderSagittal = handle_list(6); 
	sliderCoronal = handle_list(7); 

	popupVolume = handle_list(8); 
	popupEditMask = handle_list(9); 
	buttonApply = handle_list(10); 
	
	checkRoiMask = handle_list(11); 
	checkVoxelMask = handle_list(12); 
	popupRoiMask = handle_list(13); 
	popupVoxelMask = handle_list(14); 

	buttonClose = handle_list(15); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 50 50 600 100 ],... 
	  'resize','on','tag','lyngby_ui_viewvol',... 
	  'visible','off',...
	  'name', 'lyngby - View full volume and specify volume mask',...
	  'numbertitle', 'off',...
	  'color', UI_COLOR_BACK); 
      
      figVolume = figure('position',[ 50 200 600 500 ],... 
          'resize','on',...
          'tag','lyngby_ui_viewvol_Volume',... 
          'menubar','Figure',...
          'name','lyngby - View volume',... 
          'numbertitle','off',...
          'visible','off', ...
          'Color', UI_COLOR_BACK); 
      
      %  Uicontrol Object Creation 

      hControl = 0.30;	% Height of controls
      yTop = 0.67;
      yMiddle = 0.35;
      yBottom = 0.03;
      
      wButton = 0.1;    % Width of buttons
      wSlider = 0.25;    % Width of sliders 

      figure(fig);

      textSliderX = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''textSliderX'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.02 yTop 0.05 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','text',... 
	  'Tag','textSliderX',... 
	  'String', 'X:',...
	  'UserData',''); 
      textSliderY = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''textSliderY'');',... 
	  'Units','normalized',...
	  'Position',[ 0.02 yMiddle 0.05 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','text',... 
	  'Tag','textSliderY',... 
	  'String', 'Y:',...
	  'UserData',''); 
      textSliderZ = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''textSliderZ'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.02 yBottom 0.05 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','text',... 
	  'Tag','textSliderZ',... 
	  'String', 'Z:',...
	  'UserData',''); 
      sliderCoronal = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''sliderCoronal'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.08 yMiddle wSlider hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','slider',... 
	  'Tag','sliderCoronal',... 
	  'UserData',''); 
      sliderSagittal = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''sliderSagittal'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.08 yTop wSlider hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','slider',... 
	  'Tag','sliderSagittal',... 
	  'UserData',''); 
      sliderTransversal = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''sliderTransversal'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.08 yBottom wSlider hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','slider',... 
	  'Tag','sliderTransversal',... 
	  'UserData',''); 

	  
      popupVolume = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''popupVolume'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.35 yTop  0.2 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Volume|Mask|Volume and Mask',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupVolume',... 
	  'UserData',''); 
      popupEditMask = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''popupEditMask'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.35 yBottom  0.2 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','-|Set ROI|Set Voxelmask|Delete Voxelmask',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],...
	  'Tag','popupEditMask',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      buttonApply = uicontrol(... 
	  'CallBack', 'lyngby_ui_viewvol(''buttonApply'');',... 
	  'Units', 'normalized',... 
	  'Position', [ 0.56 yBottom 0.07 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style', 'pushbutton',... 
	  'Tag', 'buttonClose',... 
	  'String', 'Apply',...
	  'UserData','', ...
	  'Visible', 'off'); 

      
      checkRoiMask = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''checkRoiMask'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.65 yTop 0.15 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','ROI Mask',... 
	  'Style','checkbox',... 
	  'Tag','checkRoiMask',... 
	  'UserData',''); 
      checkVoxelMask = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''checkVoxelMask'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.65 yMiddle  0.15 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Voxel mask',... 
	  'Style','checkbox',... 
	  'Value',[ 1 ],... 
	  'Tag','checkVoxelMask',... 
	  'UserData',''); 
      popupRoiMask = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''popupRoiMask'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.81 yTop 0.17 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Specify ...',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupRoiMask',... 
	  'UserData',''); 
      popupVoxelMask = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''popupVoxelMask'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.81 yMiddle 0.17 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Specify ...',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupVoxelMask',... 
	  'UserData',''); 

      
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_viewvol(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.88 yBottom 0.1 hControl ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'String', 'Close',...
	  'UserData',''); 

      handle_list = [ ...  
	    figVolume ...
	    textSliderX textSliderY textSliderZ ... 
	    sliderTransversal sliderSagittal sliderCoronal ...
	    popupVolume popupEditMask buttonApply ... 
	    checkRoiMask checkVoxelMask ...
	    popupRoiMask popupVoxelMask ...
	    buttonClose ...
	    ]; 

      set(popupVolume, 'UserData', arg1);
      description = '';
      
      n = 2;
      while n < nargin
        eval(sprintf('arg = lower(arg%d);', n)); 
        if strcmp(arg, 'description')
          n = n + 1;
          eval(sprintf('arg = arg%d;', n));
          if isstr(arg)
            description = arg;
          else    
            error('Argument to ''description'' should be a string');
          end
	else
          error(sprintf('Invalid property: %s', arg));
        end
        n = n + 1;
      end

      roi = lyngby_roi;
      set(checkRoiMask, 'Value', 0);
      if ~isempty(ROI_VOXELS) 
	if ROI_VOXELS == roi
	  set(checkRoiMask, 'Value', 1);
	end
      end
      
      
      set(sliderSagittal, 'Min', 1);
      set(sliderSagittal, 'Max', NUM_VOXELS(1));
      set(sliderSagittal, 'Value', round(mean(roi(1,:))));	
      
      if NUM_VOXELS(1) == 1
	set(sliderSagittal, 'Max', 1+eps);
%	set(sliderSagittal, 'Visible', 'off');
      end
      
      set(sliderCoronal, 'Min', 1);
      set(sliderCoronal, 'Max', NUM_VOXELS(2));
      set(sliderCoronal, 'Value', round(mean(roi(2,:))));
      if NUM_VOXELS(2) == 1
	set(sliderCoronal, 'Max', 1+eps);
%	set(sliderCoronal, 'Visible', 'off');
      end
      
      
	set(sliderTransversal, 'Min', 1);
	set(sliderTransversal, 'Max', NUM_VOXELS(3));
	set(sliderTransversal, 'Value', round(mean(roi(3,:))));
      if NUM_VOXELS(3) == 1
	set(sliderTransversal, 'Max', 1+eps);
%	set(sliderTransversal, 'Visible', 'off');
      end
      
      
      set(checkVoxelMask, 'Value', 0);

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 
      set(figVolume,'visible','on'); 

      eval(UpdateFullVolume);

	
    elseif command == 101 
      %disp('sliderTransversal selected.') 
      
      set(sliderTransversal, 'Value', round(get(sliderTransversal, 'Value')));
      eval(UpdateTransversal);
      
    elseif command == 102 
      %disp('sliderSagittal selected.') 
      
      set(sliderSagittal, 'Value', round(get(sliderSagittal, 'Value')));
      eval(UpdateSagittal);
      
    elseif command == 103 
      %disp('sliderCoronal selected.') 
      
      set(sliderCoronal, 'Value', round(get(sliderCoronal, 'Value')));
      eval(UpdateCoronal);
      
    
    elseif command == 200 
      %disp('popupVolume selected.') 

      eval(UpdateMask);
      eval(UpdateFullVolume);

    elseif command == 300 
      %disp('popupEditMask selected.') 

      lyngby_ui_message('Not implemented yet');

    elseif command == 301 
      disp('buttonApply selected.') 

      lyngby_ui_message('Not implemented yet');
     
      
    elseif command == 600 
      %disp('checkRoiMask selected.') 
      
      lyngby_ui_message('Not implemented yet');
      
    elseif command == 601 
      %disp('checkVoxelMask selected.') 
      
      lyngby_ui_message('Not implemented yet');
      
    elseif command == 700
      %disp('popupRoiMask selected.') 

      lyngby_ui_message('Not implemented yet');

    
    elseif command == 701 
      %disp('popupVoxelMask selected.') 

      lyngby_ui_message('Not implemented yet');
      
      
    elseif command == 900 
      %disp('Close selected.');
      
      close(figVolume);
      close(gcf);

      
    else 
      error('Error: lyngby_ui_viewvol.m called with incorrect command.') 
    end 











