function lyngby_ui_volume(command,parameter1) 

% lyngby_ui_volume     - View full volume timeserie and specify mask
%
%       function lyngby_ui_volume(command,parameter1) 
%       function lyngby_ui_volume 
%
%       This function controls windows for viewing one volume at a
%       time before the complete datamatrix is loaded and explore it
%       from various viewpoints. There are five different window
%       layouts to allow maximum flexibility - choose the one that
%       best suits the data and your requirements. 
%
%       In each of the layouts, you have the choice of viewing
%       directions: Transversal, coronal, and sagittal. Use the
%       appropriate sliders next to each view to walk through the
%       slices along that direction. The 3-dimensional view will only
%       be shown if there is enough data. 
%
%       The horizontal slider in the Control window determines which
%       volume of the full time-volume set (the datamatrix) should be
%       shown. 
%
%       'Define ROI' will enable the ROI_VOXELS mask. The values for
%       the mask can be set in the edit fields. 
%
%       See also LYNGBY, LYNGBY_UI_VIEW, LYNGBY_UI_MAIN
%
% $Id: lyngby_ui_volume.m,v 1.28 2002/03/04 16:23:59 fnielsen Exp $

%	Made with GUI Maker Ver 2.1 by Patrick Marchand
%  Created: 15-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


    lyngby_global;
    lyngby_ui_option;

    global      CMap MaxData MinData % Parameters for producing the images
    global	UI_VOLUME_V
    global      THREE_D_VIEW  % Flag indicating whether the 3D viewport 
                              %   should be active [ 0 = off, 1 = on ]
    global      VIEW          % Flag for indicating which viewing layout is chosen 
                              %   [ A = single, B = double, C = triple, D = 3D, E = multiple slice ]
    global      CHOSEN_SLICE  % Flag indicating the slice viewport to be used 
                              %   [ A = all (i.e. 3 orthogonal views), S = sagittal, C = coronal, 
                              %     T = transversal, D = double (Transversal and Coronal by default), 
                              %     M = multiple (i.e. use slice axes and not orthogonal viewports) ]
    global      SLICE_MIN     % Index number of first slice, used in multiple viewport
    global      DOUBLE_LEFT_AXES    % Flag for left axes determining which view direction is to be 
                                    % used for double view  [ T = transversal, S = sagittal, C = coronal ]
    global      DOUBLE_RIGHT_AXES   % Flag for right axes determining which view direction is to be 
                                    % used for double view  [ T = transversal, S = sagittal, C = coronal ]
    global      LINKED        % Flag indicating whether the slices in the double view are linked
                              %   [ 0 = no, 1 = yes ]

    UpdateLeftAxes = [ ...
	  'axes(axesLeft);',...
          'if DOUBLE_LEFT_AXES == ''T'',',...
	  '  lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'','...
	  '    round(get(sliderLeft, ''Value''))), '...
	  '    ''Colormap'', CMap, ''Range'', [MinData MaxData]);'...
	  '  title(sprintf(''Transversal, Slice %d, Volume no. %s'',', ...
	  '    round(get(sliderLeft, ''Value'')), get(textVolumeNo, ''String'')));',...
	  '  xlabel(''x'');',...
	  '  ylabel(''y'');',...
          'elseif DOUBLE_LEFT_AXES == ''S'',',...
	  '  lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'','...
	  '    round(get(sliderLeft, ''Value''))),'...
	  '    ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  '  title(sprintf(''Sagittal, Slice %d, Volume no. %s'',', ...
	  '    round(get(sliderLeft, ''Value'')), get(textVolumeNo, ''String'')));',...
	  '  xlabel(''y'');',...
	  '  ylabel(''z'');',...
          'elseif DOUBLE_LEFT_AXES == ''C'',',...
	  '  lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', round(get(sliderLeft, ''Value''))), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  '  title(sprintf(''Coronal, Slice %d, Volume no. %s'',', ...
	  '    round(get(sliderLeft, ''Value'')), get(textVolumeNo, ''String'')));',...
	  '  xlabel(''x'');',...
	  '  ylabel(''z'');',...
          'else,',...
          '  error(''Unable to determine the view direction for the left axes!'');',...
          'end,',...
          ];

    UpdateRightAxes = [ ... 
	  'axes(axesRight);',...
          'if DOUBLE_RIGHT_AXES == ''T'',',...
	  '  lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'', round(get(sliderRight, ''Value''))), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  '  title(sprintf(''Transversal, Slice %d, Volume no. %s'',', ...
	  '    round(get(sliderRight, ''Value'')), get(textVolumeNo, ''String'')));',...
	  '  xlabel(''x'');',...
	  '  ylabel(''y'');',...
          'elseif DOUBLE_RIGHT_AXES == ''S'',',...
	  '  lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'','...
	  '    round(get(sliderRight, ''Value''))),'...
	  '    ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  '  title(sprintf(''Sagittal, Slice %d, Volume no. %s'',', ...
	  '    round(get(sliderRight, ''Value'')), get(textVolumeNo, ''String'')));',...
	  '  xlabel(''y'');',...
	  '  ylabel(''z'');',...
          'elseif DOUBLE_RIGHT_AXES == ''C'',',...
	  '  lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', round(get(sliderRight, ''Value''))), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  '  title(sprintf(''Coronal, Slice %d, Volume no. %s'',', ...
	  '    round(get(sliderRight, ''Value'')), get(textVolumeNo, ''String'')));',...
	  '  xlabel(''x'');',...
	  '  ylabel(''z'');',...
          'else,',...
          '  error(''Unable to determine the view direction for the right axes!'');',...
          'end,',...
          ];


    UpdateTransversalSlices = [ ...
	  'axes(axesSlice01);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'', (SLICE_MIN)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Transversal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice02);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'', (SLICE_MIN+1)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Transversal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+1), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice03);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'', (SLICE_MIN+2)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Transversal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+2), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice04);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'', (SLICE_MIN+3)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Transversal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+3), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice05);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'', (SLICE_MIN+4)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Transversal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+4), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice06);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'','...
	  '  (SLICE_MIN+5)), ''Colormap'', CMap,'...
	  '  ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Transversal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+5), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice07);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'', (SLICE_MIN+6)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Transversal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+6), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice08);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'','...
	  '  (SLICE_MIN+7)), ''Colormap'', CMap,'...
	  '  ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Transversal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+7), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  ];

    UpdateSagittalSlices = [ ...
	  'axes(axesSlice01);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'', (SLICE_MIN)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Sagittal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice02);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'', (SLICE_MIN+1)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Sagittal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+1), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice03);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'', (SLICE_MIN+2)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Sagittal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+2), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice04);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'', (SLICE_MIN+3)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Sagittal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+3), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice05);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'', (SLICE_MIN+4)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Sagittal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+4), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice06);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'', (SLICE_MIN+5)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Sagittal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+5), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice07);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'', (SLICE_MIN+6)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Sagittal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+6), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice08);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'', (SLICE_MIN+7)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Sagittal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+7), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  ];

    UpdateCoronalSlices = [ ...
	  'axes(axesSlice01);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', (SLICE_MIN)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Coronal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice02);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', (SLICE_MIN+1)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Coronal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+1), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice03);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', (SLICE_MIN+2)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Coronal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+2), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice04);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', (SLICE_MIN+3)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Coronal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+3), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice05);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', (SLICE_MIN+4)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Coronal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+4), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice06);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', (SLICE_MIN+5)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Coronal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+5), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice07);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', (SLICE_MIN+6)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Coronal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+6), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  'axes(axesSlice08);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', (SLICE_MIN+7)), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Coronal, Slice %d, Volume no. %s'',', ...
	  '    (SLICE_MIN+7), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  ];

    UpdateSagittal = [ ...
	  'axes(axesSagittal);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''s'', str2num(get(textSagittalSlice, ''String''))), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Sagittal, Slice %s, Volume no. %s'',', ...
	  '    get(textSagittalSlice, ''String''), get(textVolumeNo, ''String'')));',...
	  'xlabel(''y'');',...
	  'ylabel(''z'');',...
	  ];
    
    UpdateCoronal = [ ...
	  'axes(axesCoronal);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''c'', str2num(get(textCoronalSlice, ''String''))), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Coronal, Slice %s, Volume no. %s'',', ...
	  '    get(textCoronalSlice, ''String''), get(textVolumeNo, ''String'')));',...
	  'xlabel(''x'');',...
	  'ylabel(''z'');',...
	  ];
    
    UpdateTransversal = [ ...
	  'axes(axesTransversal);',...
	  'lyngby_image(lyngby_getslice(UI_VOLUME_V, ''t'', str2num(get(textTransversalSlice, ''String''))), ''Colormap'', CMap, ''Range'', [MinData MaxData]);',...
	  'title(sprintf(''Transversal, Slice %s, Volume no. %s'',', ...
	  '    get(textTransversalSlice, ''String''), get(textVolumeNo, ''String'')));',...
	  'xlabel(''x'');',...
	  'ylabel(''y'');',...
	  ];
    
    UpdateFullVolume = [ ...
	  'eval(UpdateSagittal);',...
	  'eval(UpdateCoronal);',...
	  'eval(UpdateTransversal);',...
          'eval(Update3DView);',...
	  ];
    
    UpdateNewVolume = [ ...
	  'set(popupMask, ''value'', 1);',...
	  'UI_VOLUME_V = lyngby_getvolume(str2num(get(textVolumeNo, ''String'')));',...
	  'eval(UpdateFullVolume);',...
	  ];
    
    UpdateMaskVolume = [ ...
	  'PopupMask = get(popupMask, ''value'');'...
	  'if PopupMask == 1,',...
	  '  eval(UpdateNewVolume);',...
	  'elseif PopupMask == 2,',...
	  '  if get(checkROI, ''value''),',...
	  '    eval(UpdateNewVolume);',...
	  '  elseif get(checkVoxelMask, ''value''),',...
	  '    if issparse(VOXEL_MASK),',...
	  '      UI_VOLUME_V = any(VOXEL_MASK'');'...
	  '      eval(UpdateFullVolume);',...
	  '    else,',...
	  '      eval(UpdateNewVolume);',...
	  '    end,',...
	  '  else,',...
	  '    eval(UpdateNewVolume);',...
	  '  end,',...
	  'end,',...
	  ];
   
   
    ReadFields = [ ...
	  'bOk = 0;',...
	  'if get(checkROI, ''value''),',...
	  '[XBegin, count1] = sscanf(get(editROIXBegin, ''String''), ''%d'');',...
	  '[XEnd, count2] = sscanf(get(editROIXEnd, ''String''), ''%d'');',...
	  '[YBegin, count3] = sscanf(get(editROIYBegin, ''String''), ''%d'');',...
	  '[YEnd, count4] = sscanf(get(editROIYEnd, ''String''), ''%d'');',...
	  '[ZBegin, count5] = sscanf(get(editROIZBegin, ''String''), ''%d'');',...
	  '[ZEnd, count6] = sscanf(get(editROIZEnd, ''String''), ''%d'');',...
	  'if count1 ~= 1,',...
	  'error(''Cannot read left X ROI value as an integer'');',...
	  'elseif count2 ~= 1,',...
	  'error(''Cannot read right X ROI value as an integer'');',...
	  'elseif count3 ~= 1,',...
	  'error(''Cannot read left Y ROI value as an integer'');',...
	  'elseif count4 ~= 1,',...
	  'error(''Cannot read right Y ROI value as an integer'');',...
	  'elseif count5 ~= 1,',...
	  'error(''Cannot read left Z ROI value as an integer'');',...
	  'elseif count6 ~= 1,',...
	  'error(''Cannot read right Z ROI value as an integer'');',...
	  'else,',... 
	  'Xlimit = [min([XBegin XEnd]) max([XBegin XEnd])];',...
	  'Ylimit = [min([YBegin YEnd]) max([YBegin YEnd])];',...
	  'Zlimit = [min([ZBegin ZEnd]) max([ZBegin ZEnd])];',...
	  'if Xlimit(1)<1 | Xlimit(2)>NUM_VOXELS(1),',...
	  'error([''The X ROI must be within 1 and '' num2str(NUM_VOXELS(1))]);',...
	  'elseif Ylimit(1)<1 | Ylimit(2)>NUM_VOXELS(2),',...
	  'error([''The Y ROI must be within 1 and '' num2str(NUM_VOXELS(2))]);',...
	  'elseif Zlimit(1)<1 | Zlimit(2)>NUM_VOXELS(3),',...
	  'error([''The Z ROI must be within 1 and '' num2str(NUM_VOXELS(3))]);',...
	  'else,',...
	  'ROI_VOXELS = [Xlimit ; Ylimit ; Zlimit];',...
	  'bOk = 1;',...
	  'end,',...
	  'end,',...
	  'else,',...
	  'ROI_VOXELS = [];',...
	  'bOk = 1;',...
	  'end',...
	  ];
    
    % UpdateCheckVoxel = [ ...
    %   'if get(checkVoxelMask, ''Value'')',...
    %     'set(editVoxelMask, ''Visible'', ''on'');',...
    %     'set(popupVoxelMask, ''Visible'', ''on'');',...
    %   'else,',...
    %     'set(editVoxelMask, ''Visible'', ''off'');',...
    %     'set(popupVoxelMask, ''Visible'', ''off'');',...
    %   'end,',...
    %   ];
    
    UpdateCheckVoxel = [ ''];

    Update3DView = [ ...
	  'axes(axesThreeD);',...
	  'if THREE_D_VIEW == 1,',...
	  '  set(text3dview, ''Visible'', ''off'');',...
	  '  set(axesThreeD, ''Visible'', ''on'');',...
	  '  VOL = reshape(UI_VOLUME_V, NUM_VOXELS(:)'');',...
	  '  h = slice(VOL,'...
	  '    str2num(get(textCoronalSlice, ''String'')),'...
	  '    str2num(get(textSagittalSlice, ''String'')), '...
	  '    str2num(get(textTransversalSlice, ''String'')));',...
	  '  set(axesThreeD, ''YDir'', ''reverse''); '...
	  '  set(h, ''edgecolor'', ''none'');'...  
	  '  xlabel(''Coronal Plane (Y)'');',...
	  '  ylabel(''Sagittal Plane (X)'');',...
	  '  zlabel(''Transversal Plane (Z)'');',...
	  'else,',...
	  '  set(axesThreeD, ''Visible'', ''off'');',...
	  '  axes(axesThreeD);',...
	  '  cla;',...
	  'end,',...
	  ];
    
  
    UpdateRoiButtonEnabling = [ ...
	  'if get(checkROI, ''Value''),',...
	  '  set(textROIX, ''Enable'', ''on'');',...
	  '  set(textROIY, ''Enable'', ''on'');',...
	  '  set(textROIZ,  ''Enable'', ''on'');',...
	  '  set(editROIXBegin, ''Enable'', ''on'');',...
	  '  set(editROIXEnd, ''Enable'', ''on'');',...
	  '  set(editROIYBegin, ''Enable'', ''on'');',...
	  '  set(editROIYEnd, ''Enable'', ''on'');',...
	  '  set(editROIZBegin, ''Enable'',''on'' );',...
	  '  set(editROIZEnd, ''Enable'', ''on'');',...
	  '  set(textROIXL, ''Enable'', ''on'');',...
	  '  set(textROIXR, ''Enable'', ''on'');',...
	  '  set(textROIYL, ''Enable'', ''on'');',...
	  '  set(textROIYR, ''Enable'', ''on'');',...
	  '  set(textROIZL, ''Enable'', ''on'');',...
	  '  set(textROIZR, ''Enable'', ''on'');',...
	  'else',...
	  '  set(textROIX, ''Enable'', ''off'');',...
	  '  set(textROIY, ''Enable'', ''off'');',...
	  '  set(textROIZ, ''Enable'', ''off'');',...
	  '  set(editROIXBegin, ''Enable'', ''off'');',...
	  '  set(editROIXEnd, ''Enable'', ''off'');',...
	  '  set(editROIYBegin, ''Enable'', ''off'');',...
	  '  set(editROIYEnd, ''Enable'', ''off'');',...
	  '  set(editROIZBegin, ''Enable'',''off'' );',...
	  '  set(editROIZEnd, ''Enable'', ''off'');',...
	  '  set(textROIXL, ''Enable'', ''off'');',...
	  '  set(textROIXR, ''Enable'', ''off'');',...
	  '  set(textROIYL, ''Enable'', ''off'');',...
	  '  set(textROIYR, ''Enable'', ''off'');',...
	  '  set(textROIZL, ''Enable'', ''off'');',...
	  '  set(textROIZR, ''Enable'', ''off'');',...
	  'end',...
	  ];
    
    
    if nargin == 0 
      command = 'new'; 
    end 
    
    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('checkVoxelMask')) 
	command = 1; 
      elseif strcmp(lower(command),lower('checkROI')) 
	command = 2; 
      elseif strcmp(lower(command),lower('editROIYEnd')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editROIXEnd')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editROIZEnd')) 
	command = 5; 
      elseif strcmp(lower(command),lower('editROIZBegin')) 
	command = 6; 
      elseif strcmp(lower(command),lower('editROIYBegin')) 
	command = 7; 
      elseif strcmp(lower(command),lower('editROIXBegin')) 
	command = 8; 
      elseif strcmp(lower(command),lower('sliderVolumeNo')) 
	command = 9; 
      elseif strcmp(lower(command),lower('sliderTransversal')) 
	command = 10; 
      elseif strcmp(lower(command),lower('sliderSagittal')) 
	command = 11; 
      elseif strcmp(lower(command),lower('sliderCoronal')) 
	command = 12; 
      elseif strcmp(lower(command),lower('popupVoxelMask')) 
	command = 13; 
      elseif strcmp(lower(command),lower('popupMask')) 
	command = 14; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 15; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 16; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 17; 
      elseif strcmp(lower(command),lower('radioOptionA')) 
	command = 18; 
      elseif strcmp(lower(command),lower('radioOptionB')) 
	command = 19; 
      elseif strcmp(lower(command),lower('radioOptionC')) 
	command = 20; 
      elseif strcmp(lower(command),lower('radioOptionD')) 
	command = 21; 
      elseif strcmp(lower(command),lower('radioOptionE')) 
	command = 22; 
      elseif strcmp(lower(command),lower('radioCoronal')) 
	command = 30; 
      elseif strcmp(lower(command),lower('radioSagittal')) 
	command = 31; 
      elseif strcmp(lower(command),lower('radioTransversal')) 
	command = 32; 
      elseif strcmp(lower(command),lower('popupViewPlane')) 
	command = 33; 
      elseif strcmp(lower(command),lower('sliderSliceIndex')) 
	command = 34; 
      elseif strcmp(lower(command),lower('popupViewPlaneDoubleLeft')) 
	command = 40; 
      elseif strcmp(lower(command),lower('popupViewPlaneDoubleRight')) 
	command = 41; 
      elseif strcmp(lower(command),lower('sliderLeft')) 
	command = 42; 
      elseif strcmp(lower(command),lower('sliderRight')) 
	command = 43; 
      elseif strcmp(lower(command),lower('radioLinkSlices'))
        command = 44;
     end 
    end 
    
    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_volume'); 
      if length(h_fig_list) > 1 
          if strcmp(get(gcf, 'tag'), 'lyngby_ui_volume')
              h_fig_list = gcf; 
          else
              error('Ops, Can''t get a unique figure identifier');
          end
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_volume.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	checkVoxelMask = handle_list(1); 
	checkROI = handle_list(2); 
	editROIYEnd = handle_list(3); 
	editROIXEnd = handle_list(4); 
	editROIZEnd = handle_list(5); 
	editROIZBegin = handle_list(6); 
	editROIYBegin = handle_list(7); 
	editROIXBegin = handle_list(8); 
	sliderVolumeNo = handle_list(9); 
	sliderTransversal = handle_list(10); 
	sliderSagittal = handle_list(11); 
	sliderCoronal = handle_list(12); 
	textROIZ = handle_list(13); 
	textROIX = handle_list(14); 
	textROIY = handle_list(15); 
	editVoxelMask = handle_list(16); 
	textVolumeNo = handle_list(17); 
	textTransversalSlice = handle_list(18); 
	textSagittalSlice = handle_list(19); 
	textCoronalSlice = handle_list(20); 
	popupVoxelMask = handle_list(21); 
	popupMask = handle_list(22); 
	axesTransversal = handle_list(23); 
	axesSagittal = handle_list(24); 
	axesCoronal = handle_list(25); 
	buttonHelp = handle_list(26); 
	buttonApply = handle_list(27); 
	buttonClose = handle_list(28); 
	textVolumeLabel = handle_list(29);
        figControl = handle_list(30);
        figVolume = handle_list(31);
        text3dview = handle_list(32);
        axesThreeD = handle_list(33);
        frameLayout = handle_list(34);
        frameROI = handle_list(35);
        frameVolume = handle_list(36);
        frameSystem = handle_list(37);
        radioOptionA = handle_list(38);
        radioOptionB = handle_list(39);
        radioOptionC = handle_list(40);
        radioOptionD = handle_list(41);
        radioOptionE = handle_list(42);
        textROIXL = handle_list(43);
        textROIXR = handle_list(44);
        textROIYL = handle_list(45);
        textROIYR = handle_list(46);
        textROIZL = handle_list(47);
        textROIZR = handle_list(48);
	textTransversalSlider = handle_list(49); 
	textSagittalSlider = handle_list(50); 
	textCoronalSlider = handle_list(51); 
        frameVolumeWindowA = handle_list(52);
        radioTransversal = handle_list(53);
        radioSagittal = handle_list(54);
        radioCoronal = handle_list(55);
        axesSlice01 = handle_list(56);
        axesSlice02 = handle_list(57);
        axesSlice03 = handle_list(58);
        axesSlice04 = handle_list(59);
        axesSlice05 = handle_list(60);
        axesSlice06 = handle_list(61);
        axesSlice07 = handle_list(62);
        axesSlice08 = handle_list(63);
        popupViewPlane = handle_list(64);
        sliderSliceIndex = handle_list(65);
        textViewPlane = handle_list(66);
        textSliceIndex = handle_list(67);
        popupViewPlaneDoubleLeft = handle_list(68);
        popupViewPlaneDoubleRight = handle_list(69);
        axesLeft = handle_list(70);
        axesRight = handle_list(71);
        sliderLeft = handle_list(72);
        sliderRight = handle_list(73);
        textLeftSlider = handle_list(74);
        textRightSlider = handle_list(75);
        textLinkSlices = handle_list(76);
        radioLinkSlices = handle_list(77);
      end 
    end 
    
    
    if command == 0 
      
      figControl = figure('position',[ 738 37 279 500 ],... 
	  'resize','on','tag','lyngby_ui_volume',... 
	  'visible','off',...
	  'name', 'lyngby - Volume Control Window',...
	  'numbertitle', 'off',...
	  'color', UI_COLOUR_WINBACK); 

      figVolume = figure('position',[ 180 37 550 500 ],... 
	  'resize','on','tag','lyngby_ui_volume_Volume',... 
	  'visible','off',...
	  'name', 'lyngby - Volume View Window',...
	  'numbertitle', 'off',...
	  'color', UI_COLOUR_FRAME); 

      % figure(figControl);
      
      %  Uicontrol Object Creation 

      x4 = 0.55;   % Check
      x5 = 0.68;    % Text ROI
      x6 = 0.73;   % Edit ROI Begin
      x7 = 0.8;   % Edit ROI End
      hc = 0.05;	% Height controls
      hvslider = 0.4;	% Height Volume slider.
      hoc = 0.4;	% Height offset control panel
      hcsl = 0.01;	% Height control separation little
      hcsb = 0.01;	% Height control sparation big
      hocb = 0.03;	% Height offset Control Buttons
      
      
      wcb = 0.1;	% Width control buttons

      % Button default positions
      bx  = 0.0367;
      by1 = 0.838;
      by2 = 0.772;
      by3 = 0.704;
      by4 = 0.634;
      by5 = 0.572;
      bw  = 0.923;
      bh  = 0.044;

      % ROI Labels defaults
      tx1 = 0.20;
      tx2 = 0.65;
      ty1 = 0.428;
      ty2 = 0.368;
      ty3 = 0.308;
      tw  = 0.15;
      th  = 0.044;

      % Frame default positions
      fx  = 0.0133;
      fy1 = 0.552;
      fy2 = 0.284;
      fy3 = 0.134;
      fy4 = 0.006;
      fw  = 0.9733;
      fh1 = 0.440;
      fh2 = 0.264;
      fh3 = 0.144;
      fh4 = 0.124;

      % Setup frames
      frameLayout = uicontrol(...
          'Parent',figControl,...
	  'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ fx fy1 fw fh1 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framelayout',... 
          'UserData',''); 
      frameROI = uicontrol(...
          'Parent',figControl,...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ fx fy2 fw fh2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameroi',... 
          'UserData',''); 
      frameVolume = uicontrol(...
          'Parent',figControl,...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ fx fy3 fw fh3 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framevolume',... 
          'UserData',''); 
      frameSystem = uicontrol(...
          'Parent',figControl,...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ fx fy4 fw fh4 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framesystem',... 
          'UserData',''); 

      frameVolumeWindowA = uicontrol(...
          'Parent',figVolume,...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ fx fx fw fw ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framevolumewindowa',... 
          'Visible','off', ...
          'UserData',''); 

      % Setup frameLayout buttons
      radioOptionA = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''radioOptionA'');',... 
	  'Units','normalized',... 
	  'Position',[ bx by1 bw bh ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','radio',... 
	  'Tag','radiooptiona',... 
	  'String', 'Single Slice View',...
          'Value',0,...
	  'UserData',''); 
      radioOptionB = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''radioOptionB'');',... 
	  'Units','normalized',... 
	  'Position',[ bx by2 bw bh ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','radio',... 
	  'Tag','radiooptionb',... 
	  'String', 'Double Slice View',...
          'Value',0,...
	  'UserData',''); 
      radioOptionC = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''radioOptionC'');',... 
	  'Units','normalized',... 
	  'Position',[ bx by3 bw bh ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','radio',... 
	  'Tag','radiooptionc',... 
	  'String', 'Triple Slice View',...
          'Value',1,...
	  'UserData',''); 
      radioOptionD = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''radioOptionD'');',... 
	  'Units','normalized',... 
	  'Position',[ bx by4 bw bh ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','radio',... 
	  'Tag','radiooptiond',... 
	  'String', 'Three Dimensional View',...
          'Value',0,...
	  'UserData',''); 
      radioOptionE = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''radioOptionE'');',... 
	  'Units','normalized',... 
	  'Position',[ bx by5 bw bh ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','radio',... 
	  'Tag','radiooptione',... 
	  'String', 'Multiple Slide View',...
          'Value',0,...
	  'UserData',''); 

     textControlTitle = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textControlTitle'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.0433 0.892 0.90 0.08 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textControlTitle',... 
	  'String', [ 'This window acts as the control panel ' ...
	    'for the volume views. Choose the viewing layout ' ...
	    'you want, the ROI (if required) and the particular '...
	    'volume (time point).'],...
	  'UserData',''); 

      textROIXL = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textROIXL'');',... 
	  'Units','normalized',...
	  'Position',[ tx1 ty1 tw th ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textROIXL',... 
	  'String', 'Left',...
	  'UserData',''); 
      textROIXR = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textROIXR'');',... 
	  'Units','normalized',...
	  'Position',[ tx2 ty1 tw th ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textROIXR',... 
	  'String', 'Right',...
	  'UserData',''); 
      textROIYL = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textROIYL'');',... 
	  'Units','normalized',...
	  'Position',[ tx1 ty2 tw th ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textROIYL',... 
	  'String', 'Back',...
	  'UserData',''); 
      textROIYR = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textROIYR'');',... 
	  'Units','normalized',...
	  'Position',[ tx2 ty2 tw th ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textROIYR',... 
	  'String', 'Front',...
	  'UserData',''); 
      textROIZL = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textROIZL'');',... 
	  'Units','normalized',...
	  'Position',[ tx1 ty3 tw th ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textROIZL',... 
	  'String', 'Bottom',...
	  'UserData',''); 
      textROIZR = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textROIZR'');',... 
	  'Units','normalized',...
	  'Position',[ tx2 ty3 tw th ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textROIZR',... 
	  'String', 'Top',...
	  'UserData',''); 



      buttonApply = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''buttonApply'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.0567 0.038 0.25 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'String', 'Apply',...
	  'UserData',''); 
      buttonClose = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.3733 0.038 0.25 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'String', 'Close',...
	  'UserData',''); 
      buttonHelp = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''buttonHelp'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.69 0.038 0.25 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'String', 'Help',...
	  'UserData',''); 

      checkROI = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''checkROI'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.0367 0.486 0.923 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Define ROI',... 
	  'Style','checkbox',... 
	  'Tag','checkROI',... 
	  'UserData',''); 

      textROIX = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textROIX'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.3667 0.428 0.2667 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textROIX',... 
	  'String', 'X',...
	  'UserData',''); 
      editROIXBegin = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''editROIXBegin'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.0367 0.428 0.15 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editROIXBegin',... 
	  'UserData',''); 
      editROIXEnd = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''editROIXEnd'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.8097 0.428 0.15 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editROIXEnd',... 
	  'UserData',''); 

      textROIY = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textROIY'');',... 
	  'Units','normalized',...
	  'Position',[ 0.3667 0.368 0.2667 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textROIY',... 
	  'String', 'Y',...
	  'UserData',''); 
      editROIYBegin = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''editROIYBegin'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.0367 0.368 0.15 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editROIYBegin',... 
	  'UserData',''); 
      editROIYEnd = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''editROIYEnd'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.8097 0.368 0.15 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editROIYEnd',... 
	  'UserData',''); 

      textROIZ = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textROIZ'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.3667 0.308 0.2667 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textROIZ',... 
	  'String', 'Z',...
	  'UserData',''); 
      editROIZBegin = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''editROIZBegin'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.0367 0.308 0.15 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editROIZBegin',... 
	  'UserData',''); 
      editROIZEnd = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''editROIZEnd'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.8097 0.308 0.15 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','edit',... 
	  'Tag','editROIZEnd',... 
	  'UserData',''); 

      checkVoxelMask = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''checkVoxelMask'');',... 
	  'Units','normalized',... 
	  'Position',[ x4 hoc-3*(hcsl+hc)-hcsb 0.12 hc ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Voxel mask',... 
	  'Style','checkbox',... 
	  'Value',[ 1 ],... 
	  'Tag','checkVoxelMask',... 
	  'UserData','',...
	  'Visible', 'off'); 
      editVoxelMask = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''editVoxelMask'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.65 hoc-3*(hcsl+hc)-hcsb 0.1 hc ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','text',... 
	  'Tag','editVoxelMask',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      popupVoxelMask = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''popupVoxelMask'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.7 hoc-3*(hcsl+hc)-hcsb 0.27 hc ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Absolute for this volume|Percent for this Volume',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupVoxelMask',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      popupMask = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''popupMask'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.82 hoc-4*(hcsl+hc)-2*hcsb 0.11 hc ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Data|Mask',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupMask',... 
	  'UserData','', ...
	  'Visible', 'off'); 

      sliderVolumeNo = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''sliderVolumeNo'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.0367 0.15 0.923 0.044 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Voxel mask',... 
	  'Style','slider',... 
	  'Value',[ 0.2 ],... 
	  'Tag','sliderVolumeNo',... 
	  'UserData',''); 
      textVolumeNo = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textVolumeNo'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.7033 0.208 0.2500 0.046 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK2,... 
	  'Style','text',... 
	  'Tag','textVolumeNo',... 
	  'UserData','');

      % Added label for the Volume slider (mgl 6 Oct 1998)
     textVolumeLabel = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''VolumeLabel'');',... 
	  'Units','normalized',... 
	  'Position',[0.0367 0.208 0.6433 0.046 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_BACK,... 
	  'Style','text',... 
	  'Tag','textVolumeLabel',... 
	  'String', 'Volume (Time Point) Number:',...
	  'UserData',''); 


      
      sliderTransversal = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''sliderTransversal'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.56 0.085 0.33 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','slider',... 
	  'Tag','sliderTransversal',... 
	  'UserData',''); 
      sliderSagittal = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''sliderSagittal'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.56 0.205 0.33 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','slider',... 
	  'Tag','sliderSagittal',... 
	  'UserData',''); 
      sliderCoronal = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''sliderCoronal'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.56 0.325 0.33 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','slider',... 
	  'Tag','sliderCoronal',... 
	  'UserData',''); 

      textTransversalSlider = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''textTransversalSlider'');',... 
	  'Visible', 'on',...
	  'Units','normalized',... 
	  'Position',[ 0.56 0.135 0.33 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
          'String','Transversal Slider',...
	  'Style','text',... 
	  'Tag','textTransversalSlider',... 
	  'UserData',''); 
      textSagittalSlider = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''textSagittalSlider'');',... 
	  'Visible', 'on',...
	  'Units','normalized',... 
	  'Position',[ 0.56 0.255 0.33 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
          'String','Sagittal Slider',...
	  'Style','text',... 
	  'Tag','textSagittalSlider',... 
	  'UserData',''); 
      textCoronalSlider = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''textCoronalSlider'');',... 
	  'Visible', 'on',...
	  'Units','normalized',... 
	  'Position',[ 0.56 0.375 0.33 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
          'String','Coronal Slider',...
	  'Style','text',... 
	  'Tag','textCoronalSlider',... 
	  'UserData',''); 


      textTransversalSlice = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textTransversalSlice'');',... 
	  'Visible', 'off',...
	  'Units','normalized',... 
	  'Position',[ 0.02 0.36 0.03 hc ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','text',... 
	  'Tag','textTransversalSlice',... 
	  'UserData',''); 
      textSagittalSlice = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textSagittalSlice'');',... 
	  'Visible', 'off',...
	  'Units','normalized',... 
	  'Position',[ 0.48 0.85 0.03 hc ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','text',... 
	  'Tag','textSagittalSlice',... 
	  'UserData',''); 
      textCoronalSlice = uicontrol(... 
          'Parent',figControl,...
	  'CallBack','lyngby_ui_volume(''textCoronalSlice'');',... 
	  'Visible', 'off',...
	  'Units','normalized',... 
	  'Position',[ 0.01 0.85 0.03 hc ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','text',... 
	  'Tag','textCoronalSlice',... 
	  'UserData',''); 



      %  Axes and Text Object Creation 

      axesTransversal = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.08 0.085 0.37 0.35 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesTransversal', ... 
	  'UserData',''); 
      axesSagittal = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.56 0.58 0.37 0.35 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesSagittal', ... 
	  'UserData',''); 
      axesCoronal = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.08 0.58 0.37 0.35 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesCoronal', ...
	  'UserData',''); 

      axesThreeD = axes(... 
          'Parent',figVolume,...
	  'Visible', 'off',...
	  'Units','normalized', ... 
	  'Position',[ 0.60 0.11 0.37 0.79 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesThreeD', ...
	  'UserData',''); 

      % Added error-label placeholder for the 3D view when not enough data available
     text3dview = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''text3dview'');',... 
	  'Units','normalized',... 
	  'Position',[0.6 0.5 0.33 0.05],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'Style','text',... 
	  'Tag','text3dview',... 
	  'String', 'Not enough data to show 3D view!',...
          'Visible','off', ...
	  'UserData',''); 

      radioTransversal = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''radioTransversal'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.65 0.68 0.33 0.07 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','radio',... 
	  'Tag','radiotransversal',... 
	  'String', 'Transversal View',...
          'Value',0,...
          'Visible','off', ...
	  'UserData',''); 
      radioSagittal = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''radioSagittal'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.65 0.77 0.33 0.07 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','radio',... 
	  'Tag','radiosagittal',... 
	  'String', 'Sagittal View',...
          'Value',0,...
          'Visible','off', ...
	  'UserData',''); 
      radioCoronal = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''radioCoronal'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.65 0.86 0.33 0.07 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','radio',... 
	  'Tag','radiocoronal',... 
	  'String', 'Coronal View',...
          'Value',0,...
          'Visible','off', ...
	  'UserData',''); 
      
      % Multiple slice view objects
      axesSlice01 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.07 0.73 0.23 0.23 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesSlice01', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesSlice02 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.4 0.73 0.23 0.23 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesSlice02', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesSlice03 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.73 0.73 0.23 0.23 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesSlice03', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesSlice04 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.07 0.4 0.23 0.23 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesSlice04', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesSlice05 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.4 0.4 0.23 0.23 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesSlice05', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesSlice06 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.73 0.4 0.23 0.23 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesSlice06', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesSlice07 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.07 0.07 0.23 0.23 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesSlice07', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesSlice08 = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.4 0.07 0.23 0.23 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesSlice08', ... 
          'Visible','off', ...
	  'UserData',''); 
      popupViewPlane = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''popupViewPlane'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.73 0.20 0.23 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Transversal|Sagittal|Coronal',... 
	  'Style','popupmenu',... 
	  'Value',[ 2 ],... 
	  'Tag','popupViewPlane',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      sliderSliceIndex = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''sliderSliceIndex'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.73 0.07 0.23 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','slider',... 
	  'Tag','sliderSliceIndex',... 
          'Visible','off', ...
	  'UserData',''); 
     textViewPlane = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''textViewPlane'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.73 0.25 0.23 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'Style','text',... 
	  'Tag','textViewPlane',... 
	  'String', 'Choose the viewing plane',...
          'Visible','off', ...
	  'UserData',''); 
     textSliceIndex = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''textSliceIndex'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.73 0.12  0.23 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'Style','text',... 
	  'Tag','textSliceIndex',... 
	  'String', 'Images start from slice number:',...
          'Visible','off', ...
	  'UserData',''); 

      % Extra objects for the Double View
      popupViewPlaneDoubleLeft = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''popupViewPlaneDoubleLeft'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.08 0.07 0.35 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Transversal|Sagittal|Coronal',... 
	  'Style','popupmenu',... 
	  'Value',[ 2 ],... 
	  'Tag','popupViewPlaneDoubleLeft',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      popupViewPlaneDoubleRight = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''popupViewPlaneDoubleRight'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ 0.55 0.07 0.35 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Transversal|Sagittal|Coronal',... 
	  'Style','popupmenu',... 
	  'Value',[ 2 ],... 
	  'Tag','popupViewPlaneDoubleRight',... 
	  'UserData','', ...
	  'Visible', 'off'); 
      axesLeft = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.08 0.32 0.35 0.6 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesLeft', ... 
          'Visible','off', ...
	  'UserData',''); 
      axesRight = axes(... 
          'Parent',figVolume,...
	  'Units','normalized', ... 
	  'Position',[ 0.55 0.32 0.35 0.6 ],... 
	  'Xgrid','off', ... 
	  'Ygrid','off', ... 
	  'Xlim',[ 0 1 ],... 
	  'Ylim',[ 0 1 ],... 
	  'Clipping','on', ... 
	  'Tag','axesRight', ... 
          'Visible','off', ...
	  'UserData',''); 
      sliderLeft = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''sliderLeft'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.08 0.12 0.35 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','slider',... 
	  'Tag','sliderLeft',... 
          'Visible','off', ...
	  'UserData',''); 
      sliderRight = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''sliderRight'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.55 0.12 0.35 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','slider',... 
	  'Tag','sliderRight',... 
          'Visible','off', ...
	  'UserData',''); 
     textLeftSlider = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''textLeftSlider'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.08 0.17 0.35 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'Style','text',... 
	  'Tag','textLeftSlider',... 
	  'String', 'Slice control for left axes',...
          'Visible','off', ...
	  'UserData',''); 
     textRightSlider = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''textRightSlider'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.55 0.17 0.35 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'Style','text',... 
	  'Tag','textRightSlider',... 
	  'String', 'Slice control for right axes',...
          'Visible','off', ...
	  'UserData',''); 
     textLinkSlices = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''textLinkSlices'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.44 0.12 0.10 0.10 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'Style','text',... 
	  'Tag','textLinkSlices',... 
	  'String', 'Link The Slices Together?',...
          'Visible','off', ...
	  'UserData',''); 
     radioLinkSlices = uicontrol(... 
          'Parent',figVolume,...
	  'CallBack','lyngby_ui_volume(''radioLinkSlices'');',... 
	  'Units','normalized',... 
	  'Position',[ 0.44 0.07 0.10 0.05 ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Style','radio',... 
	  'Tag','radioLinkSlices',... 
	  'String', 'On/Off',...
          'Value',0,...
          'Visible','off', ...
	  'UserData',''); 


      handle_list = [ ...  
	    checkVoxelMask checkROI editROIYEnd ... 
	    editROIXEnd editROIZEnd editROIZBegin editROIYBegin ... 
	    editROIXBegin sliderVolumeNo sliderTransversal sliderSagittal ... 
	    sliderCoronal textROIZ textROIX textROIY ... 
	    editVoxelMask textVolumeNo textTransversalSlice textSagittalSlice ... 
	    textCoronalSlice popupVoxelMask popupMask ... 
	    axesTransversal axesSagittal axesCoronal ... 
	    buttonHelp buttonApply buttonClose textVolumeLabel ...
            figControl figVolume ...
            text3dview axesThreeD ...
            frameLayout frameROI frameVolume frameSystem ...
            radioOptionA radioOptionB radioOptionC radioOptionD radioOptionE ...
            textROIXL textROIXR textROIYL textROIYR textROIZL textROIZR ...
            textTransversalSlider textSagittalSlider textCoronalSlider ...
            frameVolumeWindowA ...
            radioTransversal radioSagittal radioCoronal ...
            axesSlice01 axesSlice02 axesSlice03 axesSlice04 ...
            axesSlice05 axesSlice06 axesSlice07 axesSlice08 ...
            popupViewPlane sliderSliceIndex ...
            textViewPlane textSliceIndex ...
            popupViewPlaneDoubleLeft popupViewPlaneDoubleRight ...
            axesLeft axesRight sliderLeft sliderRight ...
            textLeftSlider textRightSlider ...
            textLinkSlices radioLinkSlices ...
	    ]; 
      
      set(figControl, 'userdata',handle_list); 
      drawnow;pause(.1); 
      set(figControl, 'visible','on'); 
      
      roi = lyngby_roi;
      set(checkROI, 'Value', 0);
      if ~isempty(ROI_VOXELS) 
	if ROI_VOXELS == roi
	  set(checkROI, 'Value', 1);
	end
      end
      roi = lyngby_roi;
      set(editROIXBegin, 'String', roi(1,1));
      set(editROIXEnd, 'String', roi(1,2));
      set(editROIYBegin, 'String', roi(2,1));
      set(editROIYEnd, 'String', roi(2,2));
      set(editROIZBegin, 'String', roi(3,1));
      set(editROIZEnd, 'String', roi(3,2));
      
      if NUM_VOXELS(1) ~= 1
	set(sliderSagittal, 'Min', 1);
	set(sliderSagittal, 'Max', NUM_VOXELS(1));
	set(sliderSagittal, 'Value', round(mean(roi(1,:))));	
      else
	set(sliderSagittal, 'Enable', 'off');
      end
      
      if NUM_VOXELS(2) ~= 1
	set(sliderCoronal, 'Min', 1);
	set(sliderCoronal, 'Max', NUM_VOXELS(2));
	set(sliderCoronal, 'Value', round(mean(roi(2,:))));
      else
	set(sliderCoronal, 'Enable', 'off');
      end
      
      if NUM_VOXELS(3) ~= 1
	set(sliderTransversal, 'Min', 1);
	set(sliderTransversal, 'Max', NUM_VOXELS(3));
	set(sliderTransversal, 'Value', round(mean(roi(3,:))));
      else
	set(sliderTransversal, 'Enable', 'off');
      end
      
      set(checkVoxelMask, 'Value', 0);

      set(sliderVolumeNo, 'Min', FILENAME_STARTINDEX);%%%%%%%%%%%
      set(sliderVolumeNo, 'Max', NUM_SCANS+FILENAME_STARTINDEX-1);%%%%%%%%%%%
      set(sliderVolumeNo, 'Value', FILENAME_STARTINDEX); %%%%%%%%%%%

      set(textVolumeNo, 'String', get(sliderVolumeNo, 'Value'));

      set(textSagittalSlice, 'String', round(mean(roi(1,:))));
      set(textCoronalSlice, 'String', round(mean(roi(2,:))));
      set(textTransversalSlice, 'String', round(mean(roi(3,:))));

      UI_VOLUME_V = lyngby_getvolume(str2num(get(textVolumeNo, 'String')));
      
      eval(UpdateRoiButtonEnabling);
      % Check for status of view-selection buttons
      if get(radioOptionD, 'Value')
         % Three-D view selected
         THREE_D_VIEW = 1;
         set(axesThreeD, 'Visible', 'on');
      else
         % Three-D view not used
         THREE_D_VIEW = 0;
         set(axesThreeD, 'Visible', 'off');
	 axes(axesThreeD);
         cla;
      end

      
      % Check for view status
      if  get(radioOptionA, 'Value')
         % Single-slice view selected
         VIEW = 'A';
	 CHOSEN_SLICE = 'T';
       elseif get(radioOptionB, 'Value')
         % Double-slice view selected
         VIEW = 'B';
	 CHOSEN_SLICE = 'D';
      elseif get(radioOptionC, 'Value')
         % Triple-slice view selected
         VIEW = 'C';
       	 CHOSEN_SLICE = 'A';
       elseif get(radioOptionD, 'Value')
         % Three-D view selected
         VIEW = 'D';
	 CHOSEN_SLICE = 'A';
      elseif get(radioOptionE, 'Value')
         % Multiple-slice view selected
         VIEW = 'E';
	 CHOSEN_SLICE = 'M';
      end

      % Use default or grey colourmap?
      CMap = gray(64);
      
      % Calculate min and max of current volume for display normalisation 
      MaxData = max(UI_VOLUME_V);
      MinData = min(UI_VOLUME_V);

      eval(UpdateCheckVoxel);
      
      eval(UpdateFullVolume);
      
    elseif command == 1 
      %disp('checkVoxelMask selected.') 
      
      eval(UpdateCheckVoxel);
      
    elseif command == 2 
      %disp('checkROI selected.') 
      
      eval(UpdateRoiButtonEnabling);
      
    elseif command == 3 
      %disp('editROIYEnd selected.') 
      
    elseif command == 4 
      %disp('editROIXEnd selected.') 
      
    elseif command == 5 
      %disp('editROIZEnd selected.') 
      
    elseif command == 6 
      %disp('editROIZBegin selected.') 
      
    elseif command == 7 
      %disp('editROIYBegin selected.') 
      
    elseif command == 8 
      %disp('editROIXBegin selected.') 
      
    elseif command == 9 
      %disp('sliderVolumeNo selected.') 
      
      set(textVolumeNo, 'String', round(get(sliderVolumeNo, 'Value')));
      
      % Not used now, due to possibility of < 3 slices being viewed. Done explicitly instead
      %   eval(UpdateNewVolume);
      
      % Code for calculating new volume
      set(popupMask, 'value', 1);
      UI_VOLUME_V = lyngby_getvolume(str2num(get(textVolumeNo, 'String')));
      % Now update only the relevant slices
      if  CHOSEN_SLICE == 'A'  % Triple or 3-D view 
	eval(UpdateFullVolume);
      elseif CHOSEN_SLICE == 'S'    % Sagittal single slice
	eval(UpdateSagittal);
      elseif CHOSEN_SLICE == 'C'    % Coronal single slice
	eval(UpdateCoronal);
      elseif CHOSEN_SLICE == 'T'    % Transversal single slice
	eval(UpdateTransversal);
      elseif CHOSEN_SLICE == 'D'    % Double-slice view
	eval(UpdateLeftAxes);
	eval(UpdateRightAxes); 
      elseif CHOSEN_SLICE == 'M'    % Multiple slices
	% Find out which slice plane is being used and only update that one
	viewplane = get(popupViewPlane, 'Value');
	if viewplane == 1                % Transversal view plane
	  eval(UpdateTransversalSlices);
	elseif viewplane == 2            % Sagittal view plane
	  eval(UpdateSagittalSlices);
	elseif viewplane == 3            % Coronal view plane
	  eval(UpdateCoronalSlices);
	else
	  error('Unable to determine which view plane to update');
	end
      else
	error('Unable to find out what view is chosen and to update');
      end
      
    elseif command == 10 
      %disp('sliderTransversal selected.') 
      
      set(textTransversalSlice, 'String', round(get(sliderTransversal, 'Value')));
      eval(UpdateTransversal);
      if THREE_D_VIEW == 1
	eval(Update3DView);
      end

    elseif command == 11 
      %disp('sliderSagittal selected.') 
      
      set(textSagittalSlice, 'String', round(get(sliderSagittal, 'Value')));
      eval(UpdateSagittal);
      if THREE_D_VIEW == 1
	eval(Update3DView);
      end
      
    elseif command == 12 
      %disp('sliderCoronal selected.') 

      set(textCoronalSlice, 'String', round(get(sliderCoronal, 'Value')));
      eval(UpdateCoronal);
      if THREE_D_VIEW == 1
       eval(Update3DView);
      end

    elseif command == 13 
      %disp('popupVoxelMask selected.') 
      
      lyngby_ui_message('Not implemented yet');
      
    elseif command == 14 
      %disp('popupMask selected.') 
      
      eval(UpdateMaskVolume);
      
    elseif command == 15 
      %disp('buttonHelp selected.') 

      helpwin('lyngby_ui_volume');
      
    elseif command == 16 
      %disp('Apply selected.') 

      eval(ReadFields);
      
    elseif command == 17 
      %disp('buttonClose selected.');
      
      clear UI_VOLUME_V;
      close(figControl);
      close(figVolume);

    elseif command == 18 
      %disp('Option A selected.')        Single slice view 
      set(radioOptionA, 'Value', 1);

      set(radioOptionB, 'Value', 0);
      set(radioOptionC, 'Value', 0);
      set(radioOptionD, 'Value', 0);
      set(radioOptionE, 'Value', 0);

      % Turn slice axes off
      set(axesSlice01, 'Visible', 'off');
      set(axesSlice02, 'Visible', 'off');
      set(axesSlice03, 'Visible', 'off');
      set(axesSlice04, 'Visible', 'off');
      set(axesSlice05, 'Visible', 'off');
      set(axesSlice06, 'Visible', 'off');
      set(axesSlice07, 'Visible', 'off');
      set(axesSlice08, 'Visible', 'off');
      axes(axesSlice01);
      cla;
      axes(axesSlice02);
      cla;
      axes(axesSlice03);
      cla;
      axes(axesSlice04);
      cla;
      axes(axesSlice05);
      cla;
      axes(axesSlice06);
      cla;
      axes(axesSlice07);
      cla;
      axes(axesSlice08);
      cla;
      
      % Turn off other invalid objects
      set(popupViewPlane, 'Visible', 'off');
      set(sliderSliceIndex, 'Visible', 'off');
      set(textViewPlane, 'Visible', 'off');
      set(textSliceIndex, 'Visible', 'off');
      
      % Turn-off double-view objects and clear double-view axes
      set(popupViewPlaneDoubleLeft, 'Visible', 'off');
      set(popupViewPlaneDoubleRight, 'Visible', 'off');
      set(textLeftSlider, 'Visible', 'off');
      set(textRightSlider, 'Visible', 'off');
      set(sliderLeft, 'Visible', 'off');
      set(sliderRight, 'Visible', 'off');
      set(textLinkSlices, 'Visible', 'off');
      set(radioLinkSlices, 'Visible', 'off');
      set(axesLeft, 'Visible', 'off');
      set(axesRight, 'Visible', 'off');
      axes(axesLeft);
      cla;
      axes(axesRight);
      cla;
      
      % Set flags
      VIEW = 'A';
      
      % Default slice choice
      CHOSEN_SLICE = 'T';
      
      % Set radio buttons to desired view
      if CHOSEN_SLICE == 'T'                   % Transversal view
	set(radioCoronal, 'Value', 0);
	set(radioSagittal, 'Value', 0);
	set(radioTransversal, 'Value', 1);
      elseif CHOSEN_SLICE == 'S'               % Sagittal view
	set(radioCoronal, 'Value', 0);
	set(radioSagittal, 'Value', 1);
	set(radioTransversal, 'Value', 0);
      else                                     % Coronal, and default for invalid options
	set(radioCoronal, 'Value', 1);
	set(radioSagittal, 'Value', 0);
        set(radioTransversal, 'Value', 0);
      end

      % Turn-off 3D axes
      THREE_D_VIEW = 0;
      set(text3dview, 'Visible', 'off');
      set(axesThreeD, 'Visible', 'off');
      axes(axesThreeD);
      cla;
      
      % Make sure all required objects etc are visible (some are turned off in other views)
      set(textSagittalSlider,    'Visible', 'on' );
      set(sliderSagittal,    'Visible', 'on' );       
      set(textCoronalSlider, 'Visible', 'on' );
      set(sliderCoronal,  'Visible', 'on' );
      set(textTransversalSlider,  'Visible', 'on' );
      set(sliderTransversal, 'Visible', 'on' );
      
      
      % Turn axes-colourbars off to enable re-positioning...
      hlist =  findobj(figVolume, 'Tag', 'colorbar');
      if length(hlist) ~= 0
	for i=1:length(hlist)
	  axes(hlist(i));
	  cla;
	end;
      else
	% error('Internal error, Can''t get hold of handles for colorbars'); 
      end
      
      set(radioTransversal, 'Visible', 'on');
      set(radioSagittal, 'Visible', 'on');
      set(radioCoronal, 'Visible', 'on');

      % Clear unwanted axes and grey-out invalid buttons
      if CHOSEN_SLICE == 'T'                     % Transversal slice
	% Display with Transversal slice
	set(axesCoronal, 'Visible', 'off');  
	set(axesSagittal, 'Visible', 'off');
	set(axesTransversal, 'Visible', 'on');
	axes(axesCoronal);
	cla;
	axes(axesSagittal);
	cla;
	% Grey-out non-valid buttons
	if NUM_VOXELS(3) ~= 1
	  set(sliderTransversal, 'Enable', 'on');
	else 
	  set(sliderTransversal, 'Enable', 'off');
	end
	set(textTransversalSlider, 'Enable', 'on');
	set(textCoronalSlider, 'Enable', 'off');
	set(sliderCoronal, 'Enable', 'off');
	set(textSagittalSlider, 'Enable', 'off');
	set(sliderSagittal, 'Enable', 'off');
      elseif CHOSEN_SLICE == 'S'                  % Sagittal slice
	% Display with Sagittal slice
	set(axesCoronal, 'Visible', 'off');  
	set(axesSagittal, 'Visible', 'on');
	set(axesTransversal, 'Visible', 'off');
	axes(axesCoronal);
	cla;
	axes(axesTransversal);
	cla;
	% Grey-out non-valid buttons
	set(textTransversalSlider, 'Enable', 'off');
	set(sliderTransversal, 'Enable', 'off');
	set(textCoronalSlider, 'Enable', 'off');
	set(sliderCoronal, 'Enable', 'off');
	set(textSagittalSlider, 'Enable', 'on');
	if NUM_VOXELS(1) ~= 1
	  set(sliderSagittal, 'Enable', 'on');
	else
	  set(sliderSagittal, 'Enable', 'off');
	end
      else                                        % Coronal, and default for invalid options
	% Display with Coronal slice
	set(axesCoronal, 'Visible', 'on');  
	set(axesSagittal, 'Visible', 'off');
	set(axesTransversal, 'Visible', 'off');
	axes(axesTransversal);
	cla;
	axes(axesSagittal);
	cla;
	% Grey-out non-valid buttons
	set(textTransversalSlider, 'Enable', 'off');
	set(sliderTransversal, 'Enable', 'off');
	set(textCoronalSlider, 'Enable', 'on');
	if NUM_VOXELS(2) ~= 1
	  set(sliderCoronal, 'Enable', 'on');
	else
	  set(sliderCoronal, 'Enable', 'off');
	end
	set(textSagittalSlider, 'Enable', 'off');
	set(sliderSagittal, 'Enable', 'off');
      end 

      % Re-position objects
      set(axesCoronal,     'Position', [ 0.08 0.085 0.5 0.85 ] );
      set(axesSagittal,    'Position', [ 0.08 0.085 0.5 0.85 ] );
      set(axesTransversal, 'Position', [ 0.08 0.085 0.5 0.85 ] );
      set(textCoronalSlider,     'Position', [ 0.65 0.48 0.33 0.07 ] );
      set(textSagittalSlider,    'Position', [ 0.65 0.32 0.33 0.07 ] );
      set(textTransversalSlider, 'Position', [ 0.65 0.15 0.33 0.07 ] );
      set(sliderCoronal,     'Position', [ 0.65 0.41 0.33 0.07 ] );
      set(sliderSagittal,    'Position', [ 0.65 0.25 0.33 0.07 ] );
      set(sliderTransversal, 'Position', [ 0.65 0.08 0.33 0.07 ] );

      % Resize and move window
      set(figVolume, 'position', [ 85 37 645 355 ]);

      if CHOSEN_SLICE == 'T'
	eval(UpdateTransversal);
      elseif CHOSEN_SLICE == 'S'
	eval(UpdateSagittal);
      else
	eval(UpdateCoronal);
      end

    elseif command == 19 
      %disp('Option B selected.')        Double slice view
      set(radioOptionB, 'Value', 1);

      set(radioOptionA, 'Value', 0);
      set(radioOptionC, 'Value', 0);
      set(radioOptionD, 'Value', 0);
      set(radioOptionE, 'Value', 0);

      % Set flags
      LINKED = 0;           % Do not link slices initially
      VIEW = 'B';
      CHOSEN_SLICE = 'D';   % D = double (initial assumption - transversal and coronal)

      set(radioTransversal, 'Visible', 'off');
      set(radioSagittal, 'Visible', 'off');
      set(radioCoronal, 'Visible', 'off');

      % Turn slice axes off
      set(axesSlice01, 'Visible', 'off');
      set(axesSlice02, 'Visible', 'off');
      set(axesSlice03, 'Visible', 'off');
      set(axesSlice04, 'Visible', 'off');
      set(axesSlice05, 'Visible', 'off');
      set(axesSlice06, 'Visible', 'off');
      set(axesSlice07, 'Visible', 'off');
      set(axesSlice08, 'Visible', 'off');
      axes(axesSlice01);
      cla;
      axes(axesSlice02);
      cla;
      axes(axesSlice03);
      cla;
      axes(axesSlice04);
      cla;
      axes(axesSlice05);
      cla;
      axes(axesSlice06);
      cla;
      axes(axesSlice07);
      cla;
      axes(axesSlice08);
      cla;

      % Turn-off 3D axes
      THREE_D_VIEW = 0;
      set(text3dview, 'Visible', 'off');
      set(axesThreeD, 'Visible', 'off');
      axes(axesThreeD);
      cla;

      % Turn off other invalid objects
      set(popupViewPlane, 'Visible', 'off');
      set(sliderSliceIndex, 'Visible', 'off');
      set(textViewPlane, 'Visible', 'off');
      set(textSliceIndex, 'Visible', 'off');

      % Turn off orthogonal sliders and their text labels
      set(textSagittalSlider,    'Visible', 'off' );
      set(sliderSagittal,    'Visible', 'off' );       
      set(textCoronalSlider, 'Visible', 'off' );
      set(sliderCoronal,  'Visible', 'off' );
      set(textTransversalSlider,  'Visible', 'off' );
      set(sliderTransversal, 'Visible', 'off' );

      % Turn-off orthogonal axes
      set(axesTransversal, 'Visible', 'off');
      axes(axesTransversal);
      cla;
      set(axesSagittal, 'Visible', 'off');
      axes(axesSagittal);
      cla;
      set(axesCoronal, 'Visible', 'off');
      axes(axesCoronal);
      cla;

      % Turn-on the double-view axes
      set(axesLeft, 'Visible', 'on');
      set(axesRight, 'Visible', 'on');

      % Turn on popup view control buttons
      set(popupViewPlaneDoubleLeft, 'Visible', 'on');
      set(popupViewPlaneDoubleRight, 'Visible', 'on');

      % Turn on buttons to link slices
      set(textLinkSlices, 'Visible', 'on');
      set(radioLinkSlices, 'Visible', 'on');
      
      % Set sliders on and test if there are enough slices (Transversal and Coronal by default)
      set(textLeftSlider, 'Visible', 'on');
      set(textRightSlider, 'Visible', 'on');
      set(textLeftSlider, 'Enable', 'on');
      set(textRightSlider, 'Enable', 'on');

      set(sliderLeft, 'Visible', 'on');
      set(sliderRight, 'Visible', 'on');

      % Set left slider. Try sagittal, then coronal and finally transversal.
      if NUM_VOXELS(1) ~= 1                                  % Test number of Sagittal slices
	set(sliderLeft, 'Enable', 'on');                     % Enable slider
	set(textLeftSlider, 'String', 'Sagittal Slider');    % Set text above slider to sagittal
	set(popupViewPlaneDoubleLeft, 'Value', 2);           % Set left popup button to sagittal
	DOUBLE_LEFT_AXES = 'S';                              % Set flag for left axes
	set(sliderLeft, 'Min', 1);
	set(sliderLeft, 'Max', NUM_VOXELS(1));
	set(sliderLeft, 'Value', round(NUM_VOXELS(1)/2));	
      elseif NUM_VOXELS(2) ~= 1                           % Test number of coronal slices
	set(sliderLeft, 'Enable', 'on');                  % Enable slider
	set(textLeftSlider, 'String', 'Coronal Slider');  % Set text above slider to coronal
	set(popupViewPlaneDoubleLeft, 'Value', 3);        % Set left popup button to coronal       
	DOUBLE_LEFT_AXES = 'C';                           % Set flag for left axes
	set(sliderLeft, 'Min', 1);
	set(sliderLeft, 'Max', NUM_VOXELS(2));
	set(sliderLeft, 'Value', round(NUM_VOXELS(2)/2));	
      elseif NUM_VOXELS(3) ~= 1                                % Test number of transversal slices
	set(sliderLeft, 'Enable', 'on');                       % Enable slider
	set(textLeftSlider, 'String', 'Transversal Slider');   % Set text above slider to transversal
	set(popupViewPlaneDoubleLeft, 'Value', 1);             % Set left popup button to transversal
	DOUBLE_LEFT_AXES = 'T';                                % Set flag for left axes
	set(sliderLeft, 'Min', 1);
	set(sliderLeft, 'Max', NUM_VOXELS(3));
	set(sliderLeft, 'Value', round(NUM_VOXELS(3)/2));	
      else
	set(sliderLeft, 'Enable', 'off');
	set(textLeftSlider, 'String', 'Not enough data!!');
	set(popupViewPlaneDoubleLeft, 'Enable', 'off');
      end

      % Set right slider. Try transversal, then coronal and finally sagittal.
      if NUM_VOXELS(3) ~= 1                                  % Test number of transversal slices
	set(sliderRight, 'Enable', 'on');                     % Enable slider
	set(textRightSlider, 'String', 'Transversal Slider'); % Set text above slider to transversal
	set(popupViewPlaneDoubleRight, 'Value', 1);           % Set left popup button to transversal
	DOUBLE_RIGHT_AXES = 'T';                              % Set flag for right axes
	set(sliderRight, 'Min', 1);
	set(sliderRight, 'Max', NUM_VOXELS(3));
	set(sliderRight, 'Value', round(NUM_VOXELS(3)/2));	
      elseif NUM_VOXELS(2) ~= 1                           % Test number of coronal slices
	set(sliderRight, 'Enable', 'on');                  % Enable slider
	set(textRightSlider, 'String', 'Coronal Slider');  % Set text above slider to coronal
	set(popupViewPlaneDoubleRight, 'Value', 3);        % Set left popup button to coronal       
	DOUBLE_RIGHT_AXES = 'C';                           % Set flag for right axes
	set(sliderRight, 'Min', 1);
	set(sliderRight, 'Max', NUM_VOXELS(2));
	set(sliderRight, 'Value', round(NUM_VOXELS(2)/2));	
      elseif NUM_VOXELS(1) ~= 1                                % Test number of sagittal slices
	set(sliderRight, 'Enable', 'on');                       % Enable slider
	set(textRightSlider, 'String', 'Sagittal Slider');      % Set text above slider to sagittal
	set(popupViewPlaneDoubleRight, 'Value', 2);             % Set left popup button to sagittal
	DOUBLE_RIGHT_AXES = 'S';                                % Set flag for right axes
	set(sliderRight, 'Min', 1);
	set(sliderRight, 'Max', NUM_VOXELS(1));
	set(sliderRight, 'Value', round(NUM_VOXELS(1)/2));	
      else
	set(sliderRight, 'Enable', 'off');
	set(textRightSlider, 'String', 'Not enough data!!');
	set(popupViewPlaneDoubleRight, 'Enable', 'off');
      end

      % Determine whether views are the the same and therefore able to be linked.
      if DOUBLE_LEFT_AXES == DOUBLE_RIGHT_AXES
	set(textLinkSlices, 'Enable', 'on');
	set(radioLinkSlices, 'Enable', 'on');
      else
	set(textLinkSlices, 'Enable', 'off');
	set(radioLinkSlices, 'Enable', 'off');
	set(radioLinkSlices, 'Value', 0);
      end     

      % Turn axes-colourbars off to enable re-positioning...
      hlist =  findobj(figVolume,'Tag', 'colorbar');
      if length(hlist) ~= 0
	for i=1:length(hlist)
	  axes(hlist(i));
	  cla;
	end;
      else
	error('Oops, Can''t get hold of handles for colorbars');
      end

      % Re-position objects
      % Left
      set(axesLeft,     'Position', [ 0.08 0.32 0.35 0.6 ] );
      set(textLeftSlider,     'Position', [ 0.08 0.17 0.35 0.05 ] );
      set(sliderLeft,     'Position', [ 0.08 0.12 0.35 0.05 ] );
      % Right
      set(axesRight, 'Position', [ 0.55 0.32 0.35 0.6 ] );
      set(textRightSlider, 'Position', [ 0.55 0.17 0.35 0.05 ] );
      set(sliderRight, 'Position', [ 0.55 0.12 0.35 0.05 ] );

      % Resize and move window
      set(figVolume, 'position', [ 82 37 648 387 ]);

      % Update axes
      eval(UpdateLeftAxes);
      eval(UpdateRightAxes);

    elseif command == 20 
      %disp('Option C selected.')        Triple slice view
      set(radioOptionC, 'Value', 1);

      set(radioOptionA, 'Value', 0);
      set(radioOptionB, 'Value', 0);
      set(radioOptionD, 'Value', 0);
      set(radioOptionE, 'Value', 0);

      VIEW = 'C';             
      CHOSEN_SLICE = 'A';      % A = all

      set(radioTransversal, 'Visible', 'off');
      set(radioSagittal, 'Visible', 'off');
      set(radioCoronal, 'Visible', 'off');

      % Turn slice axes off
      set(axesSlice01, 'Visible', 'off');
      set(axesSlice02, 'Visible', 'off');
      set(axesSlice03, 'Visible', 'off');
      set(axesSlice04, 'Visible', 'off');
      set(axesSlice05, 'Visible', 'off');
      set(axesSlice06, 'Visible', 'off');
      set(axesSlice07, 'Visible', 'off');
      set(axesSlice08, 'Visible', 'off');
      axes(axesSlice01);
      cla;
      axes(axesSlice02);
      cla;
      axes(axesSlice03);
      cla;
      axes(axesSlice04);
      cla;
      axes(axesSlice05);
      cla;
      axes(axesSlice06);
      cla;
      axes(axesSlice07);
      cla;
      axes(axesSlice08);
      cla;

      % Turn off other invalid objects
      set(popupViewPlane, 'Visible', 'off');
      set(sliderSliceIndex, 'Visible', 'off');
      set(textViewPlane, 'Visible', 'off');
      set(textSliceIndex, 'Visible', 'off');

      % Turn-off double-view objects and clear double-view axes
      set(popupViewPlaneDoubleLeft, 'Visible', 'off');
      set(popupViewPlaneDoubleRight, 'Visible', 'off');
      set(textLeftSlider, 'Visible', 'off');
      set(textRightSlider, 'Visible', 'off');
      set(sliderLeft, 'Visible', 'off');
      set(sliderRight, 'Visible', 'off');
      set(textLinkSlices, 'Visible', 'off');
      set(radioLinkSlices, 'Visible', 'off');
      set(axesLeft, 'Visible', 'off');
      set(axesRight, 'Visible', 'off');
      axes(axesLeft);
      cla;
      axes(axesRight);
      cla;

      % Make sure all objects etc are visible (some are turned off in other views)
      set(axesSagittal, 'Visible', 'on');
      set(textSagittalSlider,    'Visible', 'on' );
      set(sliderSagittal,    'Visible', 'on' );       
      set(axesCoronal,  'Visible', 'on' );
      set(textCoronalSlider, 'Visible', 'on' );
      set(sliderCoronal,  'Visible', 'on' );
      set(axesTransversal,  'Visible', 'on' );
      set(textTransversalSlider,  'Visible', 'on' );
      set(sliderTransversal, 'Visible', 'on' );


      % Set sliders on if there are enough slices
      set(textTransversalSlider, 'Enable', 'on');
      set(textCoronalSlider, 'Enable', 'on');
      set(textSagittalSlider, 'Enable', 'on');

      if NUM_VOXELS(1) ~= 1
	set(sliderSagittal, 'Enable', 'on');
      else
	set(sliderSagittal, 'Enable', 'off');
      end

      if NUM_VOXELS(2) ~= 1
	set(sliderCoronal, 'Enable', 'on');
      else
	set(sliderCoronal, 'Enable', 'off');
      end

      if NUM_VOXELS(3) ~= 1
	set(sliderTransversal, 'Enable', 'on');
      else
	set(sliderTransversal, 'Enable', 'off');
      end

      % Turn-off 3D axes
      THREE_D_VIEW = 0;
      set(text3dview, 'Visible', 'off');
      set(axesThreeD, 'Visible', 'off');
      axes(axesThreeD);
      cla;

      % Turn axes-colourbars off to enable re-positioning...
      hlist =  findobj(figVolume,'Tag','colorbar');
      if length(hlist) ~= 0
	for i=1:length(hlist)
	  axes(hlist(i));
	  cla;
	end;
      else
	error('Oops, Can''t get hold of handles for colorbars');
      end

      % Re-position objects
      set(axesCoronal,     'Position', [ 0.08 0.580 0.37 0.35 ] );
      set(axesSagittal,    'Position', [ 0.56 0.580 0.37 0.35 ] );
      set(axesTransversal, 'Position', [ 0.08 0.085 0.37 0.35 ] );
      set(textCoronalSlider,     'Position', [ 0.56 0.375 0.37 0.05 ] );
      set(textSagittalSlider,    'Position', [ 0.56 0.255 0.37 0.05 ] );
      set(textTransversalSlider, 'Position', [ 0.56 0.135 0.37 0.05 ] );
      set(sliderCoronal,     'Position', [ 0.56 0.325 0.37 0.05 ] );
      set(sliderSagittal,    'Position', [ 0.56 0.205 0.37 0.05 ] );
      set(sliderTransversal, 'Position', [ 0.56 0.085 0.37 0.05 ] );

      % Resize and move window
      set(figVolume, 'position', [ 180 37 550 500 ]);

      % Update slices
      eval(UpdateFullVolume);

    elseif command == 21 
      %disp('Option D selected.')        Three dimensional view
      set(radioOptionD, 'Value', 1);

      set(radioOptionA, 'Value', 0);
      set(radioOptionB, 'Value', 0);
      set(radioOptionC, 'Value', 0);
      set(radioOptionE, 'Value', 0);
      
      VIEW = 'D'; 
      CHOSEN_SLICE = 'A';      % A = all

      set(radioTransversal, 'Visible', 'off');
      set(radioSagittal, 'Visible', 'off');
      set(radioCoronal, 'Visible', 'off');

      % Turn slice axes off
      set(axesSlice01, 'Visible', 'off');
      set(axesSlice02, 'Visible', 'off');
      set(axesSlice03, 'Visible', 'off');
      set(axesSlice04, 'Visible', 'off');
      set(axesSlice05, 'Visible', 'off');
      set(axesSlice06, 'Visible', 'off');
      set(axesSlice07, 'Visible', 'off');
      set(axesSlice08, 'Visible', 'off');
      axes(axesSlice01);
      cla;
      axes(axesSlice02);
      cla;
      axes(axesSlice03);
      cla;
      axes(axesSlice04);
      cla;
      axes(axesSlice05);
      cla;
      axes(axesSlice06);
      cla;
      axes(axesSlice07);
      cla;
      axes(axesSlice08);
      cla;

      % Turn off other invalid objects
      set(popupViewPlane, 'Visible', 'off');
      set(sliderSliceIndex, 'Visible', 'off');
      set(textViewPlane, 'Visible', 'off');
      set(textSliceIndex, 'Visible', 'off');

      % Turn-off double-view objects and clear double-view axes
      set(popupViewPlaneDoubleLeft, 'Visible', 'off');
      set(popupViewPlaneDoubleRight, 'Visible', 'off');
      set(textLeftSlider, 'Visible', 'off');
      set(textRightSlider, 'Visible', 'off');
      set(sliderLeft, 'Visible', 'off');
      set(sliderRight, 'Visible', 'off');
      set(textLinkSlices, 'Visible', 'off');
      set(radioLinkSlices, 'Visible', 'off');
      set(axesLeft, 'Visible', 'off');
      set(axesRight, 'Visible', 'off');
      axes(axesLeft);
      cla;
      axes(axesRight);
      cla;


      % Make sure all objects etc are visible (some are turned off in other views)
      set(axesSagittal, 'Visible', 'on');
      set(textSagittalSlider,    'Visible', 'on' );
      set(sliderSagittal,    'Visible', 'on' );       
      set(axesCoronal,  'Visible', 'on' );
      set(textCoronalSlider, 'Visible', 'on' );
      set(sliderCoronal,  'Visible', 'on' );
      set(axesTransversal,  'Visible', 'on' );
      set(textTransversalSlider,  'Visible', 'on' );
      set(sliderTransversal, 'Visible', 'on' );


      % Set sliders on if there are enough slices
      set(textTransversalSlider, 'Enable', 'on');
      set(textCoronalSlider, 'Enable', 'on');
      set(textSagittalSlider, 'Enable', 'on');

      if NUM_VOXELS(1) ~= 1
	set(sliderSagittal, 'Enable', 'on');
      else
	set(sliderSagittal, 'Enable', 'off');
      end

      if NUM_VOXELS(2) ~= 1
	set(sliderCoronal, 'Enable', 'on');
      else
	set(sliderCoronal, 'Enable', 'off');
      end

      if NUM_VOXELS(3) ~= 1
	set(sliderTransversal, 'Enable', 'on');
      else
	set(sliderTransversal, 'Enable', 'off');
      end

      % Turn axes-colourbars off to enable re-positioning...
      hlist =  findobj(figVolume,'Tag','colorbar');
      if length(hlist) ~= 0
	for i=1:length(hlist)
	  axes(hlist(i));
	  cla;
	end;
      else
	error('Oops, Can''t get hold of handles for colorbars');
      end

      % Resize window
      set(figVolume, 'position', [ 9 37 720 361 ]);

      % Re-position objects
      set(axesThreeD,      'Position', [ 0.600 0.110 0.37 0.79 ] );
      set(axesCoronal,     'Position', [ 0.045 0.580 0.20 0.35 ] );
      set(axesSagittal,    'Position', [ 0.320 0.580 0.20 0.35 ] );
      set(axesTransversal, 'Position', [ 0.045 0.085 0.20 0.35 ] );
      set(textCoronalSlider,     'Position', [ 0.32 0.375 0.20 0.05 ] );
      set(textSagittalSlider,    'Position', [ 0.32 0.255 0.20 0.05 ] );
      set(textTransversalSlider, 'Position', [ 0.32 0.135 0.20 0.05 ] );
      set(sliderCoronal,     'Position', [ 0.32 0.325 0.20 0.05 ] );
      set(sliderSagittal,    'Position', [ 0.32 0.205 0.20 0.05 ] );
      set(sliderTransversal, 'Position', [ 0.32 0.085 0.20 0.05 ] );

      % Setup 3D view of volume, if the volume is big enough (i.e. smallest
      % dimension is greater than 5)
      % Check for minimum size
      if ( (NUM_VOXELS(1) < 5) | (NUM_VOXELS(2) < 5) | (NUM_VOXELS(3) < 5) )
	% Print "Not enough data for 3D view"
	set(text3dview, 'Visible', 'on');
	set(axesThreeD, 'Visible', 'off');
	THREE_D_VIEW = 0;
      else
	% Update 3D view
	THREE_D_VIEW = 1;
	set(text3dview, 'Visible', 'off');
	set(axesThreeD, 'Visible', 'on');
      end
      % End of 3D code

      eval(UpdateFullVolume);

    elseif command == 22 
      %disp('Option E selected.')        Multiple slice view
      set(radioOptionE, 'Value', 1);

      set(radioOptionA, 'Value', 0);
      set(radioOptionB, 'Value', 0);
      set(radioOptionC, 'Value', 0);
      set(radioOptionD, 'Value', 0);

      VIEW = 'E';
      CHOSEN_SLICE = 'M';             % M = multiple slices

      set(radioTransversal, 'Visible', 'off');
      set(radioSagittal, 'Visible', 'off');
      set(radioCoronal, 'Visible', 'off');

      % Make sure all invalid objects etc are not visible
      set(axesSagittal, 'Visible', 'off');
      set(textSagittalSlider,    'Visible', 'off' );
      set(sliderSagittal,    'Visible', 'off' );       
      set(axesCoronal,  'Visible', 'off' );
      set(textCoronalSlider, 'Visible', 'off' );
      set(sliderCoronal,  'Visible', 'off' );
      set(axesTransversal,  'Visible', 'off' );
      set(textTransversalSlider,  'Visible', 'off' );
      set(sliderTransversal, 'Visible', 'off' );

      % Turn-off 3D axes
      THREE_D_VIEW = 0;
      set(text3dview, 'Visible', 'off');
      set(axesThreeD, 'Visible', 'off');
      axes(axesThreeD);
      cla;

      % Turn off normal axes
      axes(axesSagittal);
      cla;
      axes(axesCoronal);
      cla;
      axes(axesTransversal);
      cla;

      % Turn-off double-view objects and clear double-view axes
      set(popupViewPlaneDoubleLeft, 'Visible', 'off');
      set(popupViewPlaneDoubleRight, 'Visible', 'off');
      set(textLeftSlider, 'Visible', 'off');
      set(textRightSlider, 'Visible', 'off');
      set(sliderLeft, 'Visible', 'off');
      set(sliderRight, 'Visible', 'off');
      set(textLinkSlices, 'Visible', 'off');
      set(radioLinkSlices, 'Visible', 'off');
      set(axesLeft, 'Visible', 'off');
      set(axesRight, 'Visible', 'off');
      axes(axesLeft);
      cla;
      axes(axesRight);
      cla;

      % Turn axes-colourbars off to enable re-positioning
      hlist =  findobj(figVolume,'Tag','colorbar');
      if length(hlist) ~= 0
	for i=1:length(hlist)
	  axes(hlist(i));
	  cla;
	end;
      else
	error('Oops, Can''t get hold of handles for colorbars');
      end

      % Turn slice axes on
      set(axesSlice01, 'Visible', 'on');
      set(axesSlice02, 'Visible', 'on');
      set(axesSlice03, 'Visible', 'on');
      set(axesSlice04, 'Visible', 'on');
      set(axesSlice05, 'Visible', 'on');
      set(axesSlice06, 'Visible', 'on');
      set(axesSlice07, 'Visible', 'on');
      set(axesSlice08, 'Visible', 'on');

      % Turn valid buttons on
      set(popupViewPlane, 'Visible', 'on');
      set(sliderSliceIndex, 'Visible', 'on');
      set(textViewPlane, 'Visible', 'on');
      set(textSliceIndex, 'Visible', 'on');

      % Resize window - keeping original corner
      %  pos = get(figVolume, 'position');
      %  pos(3) = 408;
      %  set(figVolume, 'position', pos);
      % OR
      % Resize and move window
      set(figVolume, 'position', [ 180 37 550 500 ]);


      % Set default slice index from which to start (usually middle of dataset)
      SLICE_MIN = 15; % Default start index value
      
      % Check that there are at least 8 slices in at least one view plane
      % Try Sagittal first
      if NUM_VOXELS(1) > 7    % Sagittal
	% Set slider to correct values, min = (first slice), max = (last slice-7), initial position in the middle
	set(sliderSliceIndex, 'Min', 1);
	set(sliderSliceIndex, 'Max', NUM_VOXELS(1)-7);
	if NUM_VOXELS(1) > 16                                         % Check where to locate initial index
	  set(sliderSliceIndex, 'Value', round(NUM_VOXELS(1)/2));     % Initial value set to middle of plane
	else
	  set(sliderSliceIndex, 'Value', 1);                          % Initial value set to beginning of plane
	end
	set(popupViewPlane, 'Value', 2);
	% Update all 8 slices for the relevant view plane
	SLICE_MIN = round(get(sliderSliceIndex, 'Value'));
	eval(UpdateSagittalSlices);
      elseif NUM_VOXELS(2) > 7  % Coronal
	% Set slider to correct values, min = (first slice), max = (last slice-7), initial position in the middle
	set(sliderSliceIndex, 'Min', 1);
	set(sliderSliceIndex, 'Max', NUM_VOXELS(2)-7);
	if NUM_VOXELS(2) > 16                                          % Check where to locate initial index
	  set(sliderSliceIndex, 'Value', round(NUM_VOXELS(2)/2));      % Initial value set to middle of plane
	else
	  set(sliderSliceIndex, 'Value', 1);                           % Initial value set to beginning of plane
	end
	set(popupViewPlane, 'Value', 3);
	% Update all 8 slices for the relevant view plane
	SLICE_MIN = round(get(sliderSliceIndex, 'Value'));
	eval(UpdateCoronalSlices);
      elseif NUM_VOXELS(3) > 7 % Transversal
	% Set slider to correct values, min = (first slice), max = (last slice-7), initial position in the middle
	set(sliderSliceIndex, 'Min', 1);
	set(sliderSliceIndex, 'Max', NUM_VOXELS(3)-7);
	if NUM_VOXELS(3) > 16                                           % Check where to locate initial index
	  set(sliderSliceIndex, 'Value', round(NUM_VOXELS(3)/2));       % Initial value set to middle
	else
	  set(sliderSliceIndex, 'Value', 1);                            % Initial value set to beginning of plane
	end
	set(popupViewPlane, 'Value', 1);
	% Update all 8 slices for the relevant view plane
	SLICE_MIN = round(get(sliderSliceIndex, 'Value'));
	eval(UpdateTransversalSlices);
      else
	error('Too few slices in this view plane to show all 8!');
      end

    elseif command == 30
      % Coronal slice chosen in single-view
      set(radioSagittal, 'Value', 0);
      set(radioTransversal, 'Value', 0);
      set(radioCoronal, 'Value', 1);

      CHOSEN_SLICE = 'C';

      set(axesCoronal, 'Visible', 'on');      % Coronal slice chosen
      set(axesSagittal, 'Visible', 'off');
      set(axesTransversal, 'Visible', 'off');
      axes(axesTransversal);
      cla;
      axes(axesSagittal);
      cla;

      % Turn axes-colourbars off to enable correct re-drawing...
      hlist =  findobj(figVolume,'Tag','colorbar');
      if length(hlist) ~= 0
	for i=1:length(hlist)
	  axes(hlist(i));
	  cla;
	end;
      else
	error('Oops, Can''t get hold of handles for colorbars');
      end


      % Grey-out non-valid buttons
      set(textTransversalSlider, 'Enable', 'off');
      set(sliderTransversal, 'Enable', 'off');
      set(textSagittalSlider, 'Enable', 'off');
      set(sliderSagittal, 'Enable', 'off');
      if NUM_VOXELS(2) ~= 1
	set(textCoronalSlider, 'Enable', 'on');
	set(sliderCoronal, 'Enable', 'on');
      else
	set(textCoronalSlider, 'Enable', 'on');
	set(sliderCoronal, 'Enable', 'off');
      end

      eval(UpdateCoronal);

    elseif command == 31
      % Sagittal slice chosen in single-view
      set(radioCoronal, 'Value', 0);
      set(radioTransversal, 'Value', 0);
      set(radioSagittal, 'Value', 1);

      CHOSEN_SLICE = 'S';

      set(axesCoronal, 'Visible', 'off');      % Sagittal slice chosen
      set(axesSagittal, 'Visible', 'on');
      set(axesTransversal, 'Visible', 'off');
      axes(axesCoronal);
      cla;
      axes(axesTransversal);
      cla;

      % Turn axes-colourbars off to enable correct re-drawing...
      hlist =  findobj(figVolume,'Tag','colorbar');
      if length(hlist) ~= 0
	for i=1:length(hlist)
	  axes(hlist(i));
	  cla;
	end;
      else
	error('Oops, Can''t get hold of handles for colorbars');
      end

      % Grey-out non-valid buttons
      set(textTransversalSlider, 'Enable', 'off');
      set(sliderTransversal, 'Enable', 'off');
      set(textCoronalSlider, 'Enable', 'off');
      set(sliderCoronal, 'Enable', 'off');
      if NUM_VOXELS(1) ~= 1
	set(textSagittalSlider, 'Enable', 'on');
	set(sliderSagittal, 'Enable', 'on');
      else
	set(textSagittalSlider, 'Enable', 'on');
	set(sliderSagittal, 'Enable', 'off');
      end

      eval(UpdateSagittal);

    elseif command == 32
      % Transversal slice chosen in single-view
      set(radioCoronal, 'Value', 0);
      set(radioSagittal, 'Value', 0);
      set(radioTransversal, 'Value', 1);

      CHOSEN_SLICE = 'T';

      set(axesCoronal, 'Visible', 'off');      % Transversal slice chosen
      set(axesSagittal, 'Visible', 'off');
      set(axesTransversal, 'Visible', 'on');
      axes(axesCoronal);
      cla;
      axes(axesSagittal);
      cla;

      % Turn axes-colourbars off to enable correct re-drawing...
      hlist =  findobj(figVolume,'Tag','colorbar');
      if length(hlist) ~= 0
	for i=1:length(hlist)
	  axes(hlist(i));
	  cla;
	end;
      else
	error('Oops, Can''t get hold of handles for colorbars');
      end

      % Grey-out non-valid buttons
      set(textCoronalSlider, 'Enable', 'off');
      set(sliderCoronal, 'Enable', 'off');
      set(textSagittalSlider, 'Enable', 'off');
      set(sliderSagittal, 'Enable', 'off');
      if NUM_VOXELS(3) ~= 1
	set(textTransversalSlider, 'Enable', 'on');
	set(sliderTransversal, 'Enable', 'on');
      else
	set(textTransversalSlider, 'Enable', 'on');
	set(sliderTransversal, 'Enable', 'off');
      end

      eval(UpdateTransversal);

    elseif command == 33
      % Popup button for choosing slice plane in multiple view (popupViewPlane)
      viewplane = get(popupViewPlane, 'Value');
      if viewplane == 1               % Transversal plane
	% Error-checking - enough slices?
	if NUM_VOXELS(3) > 7
	  CHOSEN_SLICE = 'M';        % Viewport is multislice
	  % Set slider to correct values, min = (first slice), max = (last slice-7), initial position in the middle
	  set(sliderSliceIndex, 'Min', 1);
	  set(sliderSliceIndex, 'Max', NUM_VOXELS(3)-7);
	  if NUM_VOXELS(3) > 16                                           % Check where to locate initial index
	    set(sliderSliceIndex, 'Value', round(NUM_VOXELS(3)/2));       % Initial value set to middle
	  else
	    set(sliderSliceIndex, 'Value', 1);                            % Initial value set to beginning of plane
	  end
	  % Update all 8 slices for the relevant view plane
	  SLICE_MIN = round(get(sliderSliceIndex, 'Value'));
	  eval(UpdateTransversalSlices);
	else
	  lyngby_ui_message('Not enough slices to show all! Displaying Coronal instead!');
	  set(popupViewPlane, 'Value', 3);
	  lyngby_ui_volume('popupViewPlane');
	end
      elseif viewplane == 2           % Sagittal plane
	% Error-checking - enough slices?
	if NUM_VOXELS(1) > 7
	  CHOSEN_SLICE = 'M';        % Viewport is multislice
	  % Set slider to correct values, min = (first slice), max = (last slice-7), initial position in the middle
	  set(sliderSliceIndex, 'Min', 1);
	  set(sliderSliceIndex, 'Max', NUM_VOXELS(1)-7);
	  if NUM_VOXELS(1) > 16                                         % Check where to locate initial index
	    set(sliderSliceIndex, 'Value', round(NUM_VOXELS(1)/2));     % Initial value set to middle of plane
	  else
	    set(sliderSliceIndex, 'Value', 1);                          % Initial value set to beginning of plane
	  end
	  % Update all 8 slices for the relevant view plane
	  SLICE_MIN = round(get(sliderSliceIndex, 'Value'));
	  eval(UpdateSagittalSlices);
	else
	  lyngby_ui_message('Not enough slices to show all! Displaying Transversal instead!');
	  set(popupViewPlane, 'Value', 1);
	  lyngby_ui_volume('popupViewPlane');
	end
      elseif viewplane == 3           % Coronal plane
	% Error-checking - enough slices?
	if NUM_VOXELS(2) > 7
	  CHOSEN_SLICE = 'M';        % Viewport is multislice
	  % Set slider to correct values, min = (first slice), max = (last slice-7), initial position in the middle
	  set(sliderSliceIndex, 'Min', 1);
	  set(sliderSliceIndex, 'Max', NUM_VOXELS(2)-7);
	  if NUM_VOXELS(2) > 16                                          % Check where to locate initial index
	    set(sliderSliceIndex, 'Value', round(NUM_VOXELS(2)/2));      % Initial value set to middle of plane
	  else
	    set(sliderSliceIndex, 'Value', 1);                           % Initial value set to beginning of plane
	  end
	  % Update all 8 slices for the relevant view plane
	  SLICE_MIN = round(get(sliderSliceIndex, 'Value'));
	  eval(UpdateCoronalSlices);
	else
	  lyngby_ui_message('Not enough slices to show all! Displaying Sagittal instead!');
	  set(popupViewPlane, 'Value', 2);
	  lyngby_ui_volume('popupViewPlane');
	end
      else
	error('Incorrect choice of viewing plane');
      end

    elseif command == 34
      % Slider for index of first image in multiple view (sliderSliceIndex)
      SLICE_MIN = round(get(sliderSliceIndex, 'Value'));
      multislice_view_plane = get(popupViewPlane, 'Value');
      if multislice_view_plane == 1       % Transversal plane chosen
	eval(UpdateTransversalSlices);
      elseif multislice_view_plane == 2   % Sagittal plane chosen
	eval(UpdateSagittalSlices)
      elseif multislice_view_plane == 3   % Coronal plane chosen
	eval(UpdateCoronalSlices)
      else
	error('Unable to determine which viewing plane is being viewed');
      end

    elseif command == 40
      % Popup button controlling the view plane for the left viewport in the double view
      % (popupViewPlaneDoubleLeft)

      if (get(popupViewPlaneDoubleLeft, 'Value')) == 1      % Transversal
	set(textLeftSlider, 'String', 'Transversal Slider');   % Set text above slider to transversal
	set(popupViewPlaneDoubleLeft, 'Value', 1);             % Set left popup button to transversal
	DOUBLE_LEFT_AXES = 'T';                                % Set flag for left axes
	if NUM_VOXELS(3) ~= 1                                    % Test number of transversal slices
	  set(sliderLeft, 'Enable', 'on');                       % Enable slider
	  set(sliderLeft, 'Min', 1);
	  set(sliderLeft, 'Max', NUM_VOXELS(3));
	  set(sliderLeft, 'Value', round(NUM_VOXELS(3)/2));	
	else
	  set(sliderLeft, 'Enable', 'off');
	  set(sliderLeft, 'Value', 1);
	end
      elseif (get(popupViewPlaneDoubleLeft, 'Value')) == 2  % Sagittal
	set(textLeftSlider, 'String', 'Sagittal Slider');    % Set text above slider to sagittal
	set(popupViewPlaneDoubleLeft, 'Value', 2);           % Set left popup button to sagittal
	DOUBLE_LEFT_AXES = 'S';                              % Set flag for left axes
	if NUM_VOXELS(1) ~= 1                                  % Test number of Sagittal slices
	  set(sliderLeft, 'Enable', 'on');                     % Enable slider
	  set(sliderLeft, 'Min', 1);
	  set(sliderLeft, 'Max', NUM_VOXELS(1));
	  set(sliderLeft, 'Value', round(NUM_VOXELS(1)/2));	
	else
	  set(sliderLeft, 'Enable', 'off');
	  set(sliderLeft, 'Value', 1);
	end
      elseif (get(popupViewPlaneDoubleLeft, 'Value')) == 3  % Coronal
	set(textLeftSlider, 'String', 'Coronal Slider');  % Set text above slider to coronal
	set(popupViewPlaneDoubleLeft, 'Value', 3);        % Set left popup button to coronal       
	DOUBLE_LEFT_AXES = 'C';                           % Set flag for left axes
	if NUM_VOXELS(2) ~= 1                           % Test number of coronal slices
	  set(sliderLeft, 'Enable', 'on');                  % Enable slider
	  set(sliderLeft, 'Min', 1);
	  set(sliderLeft, 'Max', NUM_VOXELS(2));
	  set(sliderLeft, 'Value', round(NUM_VOXELS(2)/2));	
	else
	  set(sliderLeft, 'Enable', 'off');
	  set(sliderLeft, 'Value', 1);
	end
      else
	error('Unable to determine which view to update in left axes!');
      end

      leftpopup = get(popupViewPlaneDoubleLeft, 'Value');   % 1=Transversal, 2=Sagittal, 3=Coronal
      rightpopup = get(popupViewPlaneDoubleRight, 'Value');   % 1=Transversal, 2=Sagittal, 3=Coronal
      if (leftpopup == rightpopup) & ( ( (leftpopup == 1) & (NUM_VOXELS(3) ~= 1) ) | ( (leftpopup == 2) & (NUM_VOXELS(1) ~= 1) ) | ( (leftpopup == 3) & (NUM_VOXELS(2) ~= 1) ) )
	set(textLinkSlices, 'Enable', 'on');
	set(radioLinkSlices, 'Enable', 'on');
      else
	set(textLinkSlices, 'Enable', 'off');
	set(radioLinkSlices, 'Enable', 'off');
	set(radioLinkSlices, 'Value', 0);
	LINKED = 0;
      end

      eval(UpdateLeftAxes);

    elseif command == 41
      % Popup button controlling the view plane for the right viewport in the double view
      % (popupViewPlaneDoubleRight)

      if (get(popupViewPlaneDoubleRight, 'Value')) == 1      % Transversal
	set(textRightSlider, 'String', 'Transversal Slider');  % Set text above slider to transversal
	set(popupViewPlaneDoubleRight, 'Value', 1);            % Set left popup button to transversal
	DOUBLE_RIGHT_AXES = 'T';                               % Set flag for right axes
	if NUM_VOXELS(3) ~= 1                                    % Test number of transversal slices
	  set(sliderRight, 'Enable', 'on');                      % Enable slider
	  set(sliderRight, 'Min', 1);
	  set(sliderRight, 'Max', NUM_VOXELS(3));
	  set(sliderRight, 'Value', round(NUM_VOXELS(3)/2));	
	else
	  set(sliderRight, 'Enable', 'off');
	  set(sliderRight, 'Value', 1);
	end
      elseif (get(popupViewPlaneDoubleRight, 'Value')) == 2  % Sagittal
	set(textRightSlider, 'String', 'Sagittal Slider');      % Set text above slider to sagittal
	set(popupViewPlaneDoubleRight, 'Value', 2);             % Set left popup button to sagittal
	DOUBLE_RIGHT_AXES = 'S';                                % Set flag for right axes
	if NUM_VOXELS(1) ~= 1                                     % Test number of sagittal slices
	  set(sliderRight, 'Enable', 'on');                       % Enable slider
	  set(sliderRight, 'Min', 1);
	  set(sliderRight, 'Max', NUM_VOXELS(1));
	  set(sliderRight, 'Value', round(NUM_VOXELS(1)/2));	
	else
	  set(sliderRight, 'Enable', 'off');
	  set(sliderRight, 'Value', 1);
	end
      elseif (get(popupViewPlaneDoubleRight, 'Value')) == 3  % Coronal
	set(textRightSlider, 'String', 'Coronal Slider');    % Set text above slider to coronal
	set(popupViewPlaneDoubleRight, 'Value', 3);          % Set left popup button to coronal       
	DOUBLE_RIGHT_AXES = 'C';                             % Set flag for right axes
	if NUM_VOXELS(2) ~= 1                                  % Test number of coronal slices
	  set(sliderRight, 'Enable', 'on');                    % Enable slider
	  set(sliderRight, 'Min', 1);
	  set(sliderRight, 'Max', NUM_VOXELS(2));
	  set(sliderRight, 'Value', round(NUM_VOXELS(2)/2));	
	else
	  set(sliderRight, 'Enable', 'off');
	  set(sliderRight, 'Value', 1);
	end
      else
	error('Unable to determine which view to update in left axes!');
      end
      

      leftpopup = get(popupViewPlaneDoubleLeft, 'Value');   % 1=Transversal, 2=Sagittal, 3=Coronal
      rightpopup = get(popupViewPlaneDoubleRight, 'Value');   % 1=Transversal, 2=Sagittal, 3=Coronal
      if (leftpopup == rightpopup) & ( ( (leftpopup == 1) & (NUM_VOXELS(3) ~= 1) ) | ( (leftpopup == 2) & (NUM_VOXELS(1) ~= 1) ) | ( (leftpopup == 3) & (NUM_VOXELS(2) ~= 1) ) )
	set(textLinkSlices, 'Enable', 'on');
	set(radioLinkSlices, 'Enable', 'on');
      else
	set(textLinkSlices, 'Enable', 'off');
	set(radioLinkSlices, 'Enable', 'off');
	set(radioLinkSlices, 'Value', 0);
	LINKED = 0;
      end

      eval(UpdateRightAxes);

    elseif command == 42
      % Slider controlling slices in the left axes
      % (sliderLeft)

      if LINKED == 1                                % If slices in both axes are linked
	left = round(get(sliderLeft, 'Value'));
	leftmax = round(get(sliderLeft, 'Max'));
	if left == leftmax               % In case left slider is max (forcing right slider to max+1)
	  set(sliderLeft, 'Value', leftmax-1);
	  left = leftmax - 1;
	end
	set(sliderRight, 'Value', left+1);
	eval(UpdateLeftAxes);
	eval(UpdateRightAxes);
      else
	eval(UpdateLeftAxes);
      end

    elseif command == 43
      % Slider controlling slices in the right axes
      % (sliderRight)

      if LINKED == 1                                % If slices in both axes are linked
	right = round(get(sliderRight, 'Value'));
	set(sliderLeft, 'Value', right-1);
	eval(UpdateLeftAxes);
	eval(UpdateRightAxes);
      else
	eval(UpdateRightAxes);
      end

    elseif command == 44
      % Radio button for linking the slices in the left and right axes together in double view
      % (radioLinkSlices)

      linkstatus = round(get(radioLinkSlices, 'Value'));
      left = round(get(sliderLeft, 'Value'));
      right = round(get(sliderRight, 'Value'));

      leftmax = round(get(sliderLeft, 'Max'));
      rightman = round(get(sliderRight, 'Max'));

      leftmin = round(get(sliderLeft, 'Min'));
      rightmin = round(get(sliderRight, 'Min'));

      if linkstatus == 1
	if left == leftmax
	  left = left-1;
	end
	right = left + 1;
	set(sliderLeft, 'Value', left);
	set(sliderRight, 'Value', right);
	LINKED = 1;
      elseif linkstatus == 0
	LINKED = 0;
      else
	error('Unable to determine if slices are linked!');
      end
      eval(UpdateLeftAxes);
      eval(UpdateRightAxes);

    else 
      error('Error: lyngby_ui_volume.m called with incorrect command.') 
    end 
