
% lyngby_uis_cc_v      - Script for cross-correlation view
%
%       See also: lyngby_cc_global, lyngby_ui_global

% cvs : $Id: lyngby_uis_cc_v.m,v 1.3 2000/05/16 15:06:18 mgl Exp $ 
%       $Revision: 1.3 $    

    if exist('RESULT_CC') & ~isempty(RESULT_CC) 
      lyngby_log('Computing energy ...');

      Energy = sum(RESULT_CC.^2);
      lag = size(RESULT_CC,1)/2 -1;
      lyngby_log('Computing max correlation ...');
      [STRENGTH_CC,DELAY_CC] = max(RESULT_CC);
      DELAY_CC = DELAY_CC-lag-1;
      lyngby_log('Calling result view ...');

%      lyngby_ui_view([X_MEAN ; X_STD ; Energy ; STRENGTH_CC ; DELAY_CC ], ...
%	  [ 'Mean(data)|Std(data)|Energy|Max Correlation|Delay' ], ...
%	  'title', 'Cross-correlation', ...
%	  'callback', 'lyngby_ui_view_cc', ...
%	  'CallbackType', 'Time|Correlation');

      lyngby_ui_view([Energy ; STRENGTH_CC ; DELAY_CC ; X_MEAN ; X_STD], ...
	  [ 'Energy|Max Correlation|Delay|Mean(data)|Std(data)' ], ...
	  'title', 'Cross-correlation', ...
	  'callback', 'lyngby_ui_view_cc', ...
	  'CallbackType', 'Time|Correlation');

      lyngby_log('Result view called!');

    else
      lyngby_ui_message('There is no Cross-covariance results. Please press ''Calculate!''');
    end
