
% lyngby_uis_efir      - Script executed at the EFIR analysis
%
%       See also: lyngby_efir_global, lyngby_ui_global

% cvs : $Id: lyngby_uis_efir.m,v 1.1 1998/11/18 19:42:50 fnielsen Exp $ 
%       $Revision: 1.1 $    


    [RESULT_EFIR,RESULT_EFIR_ORDER] = ...
	lyngby_efir_main(PN, ...
	XN, R, ...
	EFIR_MAXORDER, ...
	EFIR_MAXSHUFFLE);

    lyngby_log('Computing std ...');
    stdEFIRinput = std(PN);

    RESULT_EFIR_CONV = lyngby_fir_convolve(PN, RESULT_EFIR);

    stdEFIRoutput = std(RESULT_EFIR_CONV);
    STRENGTH_EFIR = stdEFIRoutput ./ (stdEFIRinput+realmin);
    RESULT = RESULT_EFIR;
    lyngby_log('Computing DELAY_EFIR ...');
    [lag,voxels] = size(RESULT_EFIR);
    if size(RESULT_EFIR,1) == 1
      DELAY_EFIR = ones(size(RESULT_EFIR));
      SUMCOEF_EFIR = RESULT_EFIR; 
    else
      DELAY_EFIR = sum(RESULT_EFIR .* ((1:lag)'*ones(1,voxels))  ./ ...
	  (realmin + ones(lag,1) * sum(RESULT_EFIR)));
      SUMCOEF_EFIR = sum(RESULT_EFIR); 
    end
    mask = abs(sum(RESULT_EFIR))>0.5*sum(abs(RESULT_EFIR));
    DELAY_EFIR = DELAY_EFIR.*(mask==1)-(mask==0); 

