
% lyngby_uis_efir_v    - Script for 'exhaustive FIR' viewing
%
%       See also: lyngby_efir_global, lyngby_ui_global

% cvs : $Id: lyngby_uis_efir_v.m,v 1.3 2000/05/16 15:06:18 mgl Exp $ 
%       $Revision: 1.3 $    

    if exist('RESULT_EFIR') & ~isempty(RESULT_EFIR)
      stdEFIRinput = std(PN);
      
      lyngby_log('Computing std ...');
      stdEFIRoutput = std(RESULT_EFIR_CONV);
      STRENGTH_EFIR = stdEFIRoutput ./ (stdEFIRinput+realmin);
      
      lyngby_log('Computing moment ...');
      [lag,voxels] = size(RESULT_EFIR);
      if size(RESULT_EFIR,1) == 1
	DELAY_EFIR = ones(size(RESULT_EFIR));
	sumEFIR = RESULT_EFIR; 
      else
	DELAY_EFIR = sum(RESULT_EFIR .* ((1:lag)'*ones(1,voxels))  ./ ...
	    (realmin + ones(lag,1) * sum(RESULT_EFIR)));
	sumEFIR = sum(RESULT_EFIR);
      end
      
      lyngby_log('Calling result view ...');
      
%      lyngby_ui_view( [ X_MEAN ; X_STD ; sumEFIR ; ... 
%	STRENGTH_EFIR ; DELAY_EFIR ; RESULT_EFIR_ORDER ], ...
%	  [ 'Mean(data)|Std(data)|Sum of Coefficients|' ...
%	    'Activation strength|Delay: first moment|Model order' ], ...
%	  'title', 'Exhaustive FIR', ...
%	  'callback', 'lyngby_ui_view_efir', 'CallbackType', ...
%	  [ 'Time|Error|Error, abs|Filter|Histogram of ' ...
%	    'data|Histogram of error|Histogram of error, bell']);

      lyngby_ui_view( [sumEFIR ; STRENGTH_EFIR ; DELAY_EFIR ; RESULT_EFIR_ORDER ; X_MEAN ; X_STD ], ...
	  [ 'Sum of Coefficients|Activation strength|Delay: first moment|Model order|Mean(data)|Std(data)' ], ...
	  'title', 'Exhaustive FIR', ...
	  'callback', 'lyngby_ui_view_efir', 'CallbackType', ...
	  [ 'Time|Error|Error, abs|Filter|Histogram of ' ...
	    'data|Histogram of error|Histogram of error, bell']);

      
      lyngby_log('Result view called!');
      
    else
      lyngby_ui_message(['There are no Exhaustive FIR filter '...
	    'results. Please press ''Calculate!''']);
    end
