
% lyngby_uis_fir       - Script executed at the FIR analysis
%
%       See also: lyngby_fir_global, lyngby_ui_global

% cvs : $Id: lyngby_uis_fir.m,v 1.1 1998/11/18 18:56:59 fnielsen Exp $ 
%       $Revision: 1.1 $    

    RESULT_FIR = lyngby_fir_main(PN, XN, ...
	'FilterOrder', FIR_ORDER, ...
	'RegMethod', FIR_REGMETHOD,...
	'Regularization', FIR_REGULARIZATION,...
	'PCRComp', FIR_PCRCOMP, ...
	'ConvType', FIR_CONVTYPE);

    lyngby_log('Computing std ...');
    stdFIRinput = std(PN);

    RESULT_FIR_CONV = lyngby_fir_convolve(PN, RESULT_FIR);

    lyngby_log('Computing STRENGTH_FIR ...');
    stdFIRoutput = std(RESULT_FIR_CONV);

    STRENGTH_FIR = stdFIRoutput ./ (stdFIRinput+realmin);
    RESULT = RESULT_FIR;

    lyngby_log('Computing DELAY_FIR ...');
    [lag,voxels] = size(RESULT_FIR);

    if size(RESULT_FIR,1) == 1
      DELAY_FIR = ones(size(RESULT_FIR));
      SUMCOEF_FIR = RESULT_FIR; 
    else
      DELAY_FIR = sum(RESULT_FIR .* ((1:lag)'*ones(1,voxels))  ./ ...
	  (realmin + ones(lag,1) * sum(RESULT_FIR)));
      SUMCOEF_FIR = sum(RESULT_FIR); 
    end
    mask = abs(sum(RESULT_FIR))>0.5*sum(abs(RESULT_FIR));
    DELAY_FIR = DELAY_FIR.*(mask==1)-(mask==0); 
