
% lyngby_uis_ica_v      - Script for ICA view
%
%       This script is called from the graphical user interface when
%       the view button for ICA is pressed. 
%
%       See also LYNGBY, LYNGBY_UIS_ICA, LYNGBY_ICA_MS_EST.
%
% $Id: lyngby_uis_ica_v.m,v 1.2 2002/04/22 16:22:23 fnielsen Exp $ 


    if exist('RESULT_ICA_TIME') & ~isempty(RESULT_ICA_TIME)
      lyngby_log('Calling result view ...');

      comp = size(RESULT_ICA_TIME,2);
      sVol = 'Mean(data)|Std(data)';
      sTime = ['Time|Histogram'];
      for n = 1:comp
	sVol = [sVol sprintf('|%d mix', n)];
      end
      for n = 1:min([10 comp])
	sTime = [ sTime sprintf('|%d source', n) ];
      end

      lyngby_ui_view( [...
	    X_MEAN ; X_STD ; RESULT_ICA_IMAGE ...
	    ], sVol, ...
	  'title', 'ICA', ...
	  'callback', 'lyngby_ui_view_ica', ...
	  'CallbackType', sTime);

      lyngby_log('Result view called!');
    else
      lyngby_ui_message('There are no ICA results. Please press ''Calculate!''');
    end








