
% lyngby_uis_ikm_v     - Script for Iterative K-means view
%
%       See also: lyngby_ikm_global, lyngby_ui_global

% cvs : $Id: lyngby_uis_ikm_v.m,v 1.2 2000/05/16 15:06:18 mgl Exp $
%       $Revision: 1.2 $

    if exist('RESULT_IKM_CENTER') & ~isempty(RESULT_IKM_CENTER)
      lyngby_log('Calling result view ...');

      sLabels = 'Mean|Std';
      for k = 1:length(RESULT_IKM_PROPERTY.Clusters)
	sLabels = [ sLabels sprintf('|Clusters (K=%d)', ...
	      RESULT_IKM_PROPERTY.Clusters(k)) ];
      end
      
      lyngby_ui_view( [ X_MEAN ; X_STD ; RESULT_IKM_ASSIGN ], ...
	  sLabels, ...
	  'title', 'K-means', ...
	  'callback', 'lyngby_ui_view_ikm', 'CallbackType', ...
	  [ 'Time|Cluster members|Cluster mean seq.|' ...
	    'Cluster center scattergram|Within variance']);

      lyngby_log('Result view called!');
    else
      lyngby_ui_message([ 'There are no Iterative K-Means results. ' ...
	    'Please press ''Calculate!''']);
    end






