
% lyngby_uis_lzit_v    - Script for Lange-Zeger 'iterative' view
%
%       See also: lyngby_lzit_global, lyngby_ui_global

% cvs : $Id: lyngby_uis_lzit_v.m,v 1.3 2000/05/16 15:06:18 mgl Exp $ 
%       $Revision: 1.3 $    



    if exist('RESULT_LZIT') & ~isempty(RESULT_LZIT)
      STRENGTH_LZIT = RESULT_LZIT(1,:);
      DELAY_LZIT = RESULT_LZIT(2,:)./RESULT_LZIT(3,:);
      lyngby_log('Calling result view ...');

%      lyngby_ui_view([X_MEAN ; X_STD ; RESULT_LZIT; DELAY_LZIT ], ...
%	  ['Mean(data)|Std(data)|Beta (Activation strength)|', ...
%	    'Theta 1|Theta 2|Delay'], ...
%	  'title', 'Lange-Zeger, iterative', ...
%	  'callback', 'lyngby_ui_view_lzit', 'CallbackType', ...
%	  [ 'Time|Error|Error, abs|Filter|Histogram of ' ...
%	    'data|Histogram of error|Histogram of error, bell']);

      lyngby_ui_view([RESULT_LZIT; DELAY_LZIT ; X_MEAN ; X_STD ], ...
	  ['Beta (Activation strength)|Theta 1|Theta 2|Delay|Mean(data)|Std(data)'], ...
	  'title', 'Lange-Zeger, iterative', ...
	  'callback', 'lyngby_ui_view_lzit', 'CallbackType', ...
	  [ 'Time|Error|Error, abs|Filter|Histogram of ' ...
	    'data|Histogram of error|Histogram of error, bell']);
    
    else
      lyngby_ui_message(['There are no Lange-Zeger ' ...
	    '(iterative estimation) results. Please press ''Calculate!''']);
    end    
