% lyngby_uis_mkm       - Script executed for Meta K-means analysis
%
%       See also LYNGBY, LYNGBY_MKM_GLOBAL, LYNGBY_UI_GLOBAL.
%
% $Id: lyngby_uis_mkm.m,v 1.4 2002/03/11 23:54:29 fnielsen Exp $ 



    if strcmp(lower(MKM_VARIABLE), 'fir coefficients') 
      if exist('RESULT_FIR') & ~isempty(RESULT_FIR)
	M = RESULT_FIR';
      else
	lyngby_ui_message([ 'No results from FIR analysis. Please press' ...
	      ' on the above ''Calculate!'' for the ''FIR filter''']);
	return
      end
    elseif strcmp(lower(MKM_VARIABLE), 'lz parameters') 
      if exist('RESULT_LZIT') & ~isempty(RESULT_LZIT)
	M = [ RESULT_LZIT' ];
      else
	lyngby_ui_message([ 'No results from LZ analysis. ' ...
	      'Please  press on the above ''Calculate!'' ' ...
	      'for the ''Iterative Lange-Zeger''.']);
	return
      end
    elseif strcmp(lower(MKM_VARIABLE), 'fir coef/lz param') 
      if exist('RESULT_FIR') & ~isempty(RESULT_FIR)
	if exist('RESULT_LZIT') & ~isempty(RESULT_LZIT)
	  M = [ RESULT_FIR'  RESULT_LZIT' ];
	else
	  lyngby_ui_message([ 'No results from LZ analysis. ' ...
		'Please press on the above ''Calculate!'' ' ...
		'for the ''Iterative Lange-Zeger''.']);
	  return
	end
      else
	lyngby_ui_message([ 'No results from FIR filter. Please press' ...
	      ' on the above ''Calculate!'' for the ''FIR filter''.']);
	return
      end
    else
      error(sprintf('The value of MKM_VARIABLE is wrong: %s', ...
	  MKM_VARIABLE));
    end

    
    [RESULT_MKM_CENTER, RESULT_MKM_ASSIGN, RESULT_MKM_INFO] = ...
	lyngby_km_main(M, ...
	'Type', MKM_TYPE, ...
	'Standardization', MKM_STANDARDIZATION, ...
	'Clusters', MKM_CLUSTERS, ...
	'DecayRate', MKM_DECAYRATE, ...
	'PositionWeight', MKM_POSITIONWEIGHT, ...
	'Iterations', MKM_ITERATIONS, ...
	'Variable', 'Time');

    RESULT_MKM_CENTER = RESULT_MKM_CENTER';
    RESULT_MKM_ASSIGN = RESULT_MKM_ASSIGN';
	
