
% lyngby_uis_svd_v     - Script for SVD view
%
%       See also: lyngby_svd_global, lyngby_ui_global

% cvs : $Id: lyngby_uis_svd_v.m,v 1.4 2000/05/16 15:06:19 mgl Exp $ 
%       $Revision: 1.4 $    



    if exist('RESULT_SVD_V') & ~isempty(RESULT_SVD_V)
      comp = size(RESULT_SVD_U,2);
      sVol = 'Mean(data)|Std(data)';
      sTime = ['Time|Histogram|Singular values'];
      for n = 1:comp
	sVol = [sVol sprintf('|%d eigenimage', n)];
      end
      for n = 1:min([10 comp])
	sTime = [sTime sprintf('|%d eigenseq. & time|%d Eigensequence', ...
	      n, n)];
      end
      
      lyngby_ui_view([ ...
	    X_MEAN; X_STD; RESULT_SVD_V(:,1:comp)' ... 
	    ], ...
	  sVol, ...
	  'title', 'SVD', ...
	  'callback','lyngby_ui_view_svd', 'CallbackType', sTime);
      
    else
      lyngby_ui_message(['There are no SVD '...
	    'results. Please press ''Calculate!''']);
    end
    

