function Indices = lyngby_vmask2index(Vmask, itype)

% lyngby_vmask2index   - Return Indices from voxel mask 
%
%	function Indices = lyngby_vmask2index(Vmask, itype)
%
%	Input:	Vmask	a voxel mask (a sparse matrix)
%		itype	(Optional) [ {1} | 0 ]  Indicator for one- or
%		        zero-relative indices. 
%
%	Output:	Indices	Indices for all voxels that will be in the
%	                masked voloume 
%
%	See also: lyngby_index2vmask, lyngby_tmask2index

% cvs : $Id: lyngby_vmask2index.m,v 1.3 1998/11/10 13:08:53 fnielsen Exp $
%       $Revision: 1.3 $    

    if nargin < 2
      itype = 1;
    end
    
    [Indices, dummy] = find(Vmask);
    if itype ~= 1
      Indices = Indices - (1-itype);
    end






