% M-File: fun_plt1.m
% All UIcontrol items are in normalized units so
% that the user can resize the screen as desired.

% Create the figure object and store its handle.
h_fig = figure('MenuBar','none');

% Create the axes object in the upper half of the figure.
axes('position',[.07 .5 .86 .4],'box','on')

% Create the two frames. The first lies below all uiobjects
% while the second is used to make a border for the status/
% message window.
h_frame_1 = uicontrol(h_fig,... 
		'Position',[ 0 0 1 0.4 ],... 
		'Style','frame',... 
		'Units','normalized'); 
h_frame_2 = uicontrol(h_fig,... 
		'Position',[0.08 0.05 0.84 0.11 ],... 
		'Style','frame',... 
		'Units','normalized');

% Create the callback for check box labeled "Box".
% This callback will determine the value of the
% checkbox object, whose handle is stored in h_box,
% and then set the current axes property accordingly.
% Finally, it displays a message by setting the
% string of the static text uicontrol whose handle
% is stored in h_status (created later).
box_clbk_str = ['boxstatus = get(h_box,''value'');'...
                'if boxstatus == 0;'...
                '  set(gca,''box'',''off'');'...
                'else;'...
                '  set(gca,''box'',''on'');'...
                'end;'...
                'boxstatus = get(gca,''box'');'...
                'set(h_status,''string'',' ...
                '[''The box property is '' boxstatus]);'];
% Create the check box, setting its value to 1
% since we initialized the axes figure this way.
h_box = uicontrol(h_fig,... 
		'CallBack',box_clbk_str,... 
		'Position',[ 0.7 0.2 0.16 0.07 ],... 
		'String','Box',... 
		'Style','checkbox',... 
		'Units','normalized',... 
		'Value',[ 1 ]); 

% Create the callback for the check box labeled "Grid"
% This callback will determine the value of the
% checkbox object, whose handle is stored in h_grid,
% and then use the grid function accordingly.
% Finally it displays a message by setting the
% string of the static text uicontrol whose handle
% is stored in h_status (created later).
grid_clbk_str = ['gridstatus = get(h_grid,''value'');'...
                'if gridstatus == 0;'...
                '  grid off;'...
                'else;'...
                '  grid on;'...
                'end;'...
                'gridstatus = get(gca,''xgrid'');'...
                'set(h_status,''string'',' ...
                '[''The grid is '' gridstatus]);'];

% Create the grid check box.
h_grid = uicontrol(h_fig,... 
		'CallBack',grid_clbk_str,... 
		'Position',[ 0.7 0.3 0.16 0.07 ],... 
		'String','Grid',... 
		'Style','checkbox',... 
		'Units','normalized');

% Create the callback that will plot the function any
% time the x data values or y function has been altered
% by the user.  Some error checking is performed just
% in case the user types in values or a function that
% cannot be plotted.
plot_clbk_str = [...
	'err_ind = 0;'...
	'eval([''x = '' get(h_xdata,''string'') '';''],'...
	'      ''err_ind=1;'');'...
	'if err_ind == 0;'...
	' eval([''y = '' get(h_ydata,''string'') '';''],'...
	'      ''err_ind=2;'');'...
	'end;'...
	'if err_ind == 0;'...
	'  plot(x,y);'...
	'  boxstatus = get(h_box,''value'');'...
	'  if boxstatus == 0;'...
 	'   set(gca,''box'',''off'');'...
	'  else;'...
	'   set(gca,''box'',''on'');'...
	'  end;'...
	'  gridstatus = get(h_grid,''value'');'...
	'  if gridstatus == 0;'...
	'   grid off;'...
	'  else;'...
	'   grid on;'...
	'  end;'...
	'  set(h_status,''string'',''Function Plotted'');'...
	'elseif err_ind == 1;'...
	'  set(h_status,''string'',''Error defining x'');'...
	'elseif err_ind == 2;'...
	'  set(h_status,''string'',''Error defining y(x)'');'...
	'end'];
% Create the edit boxes for the x and y data.  Both of
% these edit boxes will use the previous callback. In
% addition, initialize them with valid inputs.
h_ydata = uicontrol(h_fig,... 
		'CallBack',plot_clbk_str,... 
		'Position',[ 0.25 0.2 0.39 0.07 ],... 
		'String','(x*.1).^2',... 
		'Style','edit',... 
		'Units','normalized'); 
h_xdata = uicontrol(h_fig,... 
		'CallBack',plot_clbk_str,... 
		'Position',[ 0.25 0.3 0.39 0.07 ],... 
		'String','-10:10',... 
		'Style','edit',... 
		'Units','normalized'); 

% Create a static text object that will be used
% to display messages to the user.
h_status = uicontrol(h_fig,... 
		'CallBack','guiplot1(''h_uic_12'');',... 
		'Position',[ 0.1 0.07 0.8 0.07 ],... 
		'String','Status Window',... 
		'Style','text',... 
		'Units','normalized'); 

% Create the "x = " and "y(x)=" static text objects.
% We do not need to store their handles since these
% objects are neither manipulated nor queried by other
% object callbacks.
uicontrol(h_fig,... 
		'Position',[ 0.08 0.3 0.15 0.07 ],... 
		'String','x =',... 
		'Style','text',... 
		'Units','normalized'); 
uicontrol(h_fig,... 
		'Position',[ 0.08 0.2 0.15 0.07 ],... 
		'String','y(x) =',... 
		'Style','text',... 
		'Units','normalized'); 

% Initialize the plot with the initial x and y data
% by evaluating the callback string that would be
% evaluated if the x or y data changes.

eval(plot_clbk_str);
