function fun_plt2(command_str)
% FUN_PLT2
%
% This function demonstrates how global variables
% can be used to create a GUI in a function.

if nargin == 0
  command_str = 'initialize';
end

% DEFINE VARIABLES THAT WILL STORE THE HANDLES AS GLOBAL
global h_box h_grid h_ydata h_xdata h_status

% INITIALIZE THE GUI SECTION.
if strcmp(command_str,'initialize')
    % Make sure that the GUI has not been already
    % initialized in another existing figure.
    h_figs = get(0,'children');
    fig_exists = 0;
    for fig = h_figs'
      fig_exists = strcmp(get(fig,'name'),...
                       'Function Plotter');
      if fig_exists
         figure(fig);  % Bring figure to front of screen.
         return;  % No need to reinitialize, exit function.
      end
    end

    h_fig = figure('name','Function Plotter');

	axes('position',[.07 .5 .86 .4])

	% Create the two frames.
	uicontrol(h_fig,... 
		'Position',[ 0 0 1 0.4 ],... 
		'Style','frame',... 
		'Units','normalized'); 
	uicontrol(h_fig,... 
		'Position',[0.08 0.05 0.84 0.11 ],... 
		'Style','frame',... 
		'Units','normalized');

	% Create the "Box" check box.
	h_box = uicontrol(h_fig,... 
		'CallBack','fun_plt2(''Set Box'');',... 
		'Position',[ 0.7 0.2 0.16 0.07 ],... 
		'String','Box',... 
		'Style','checkbox',... 
		'Units','normalized',... 
		'Value',[ 1 ]); 
	% Create the check box labeled "Grid".
	h_grid = uicontrol(h_fig,... 
		'CallBack','fun_plt2(''Set Grid'');',... 
		'Position',[ 0.7 0.3 0.16 0.07 ],... 
		'String','Grid',... 
		'Style','checkbox',... 
		'Units','normalized');

	% Create the edit boxes for the x data.
	h_ydata = uicontrol(h_fig,... 
		'CallBack','fun_plt2(''Plot Function'');',... 
		'Position',[ 0.25 0.2 0.39 0.07 ],... 
		'String','(x*.1).^2',... 
		'Style','edit',... 
		'Units','normalized'); 
	% Create the edit boxes for the y data.
	h_xdata = uicontrol(h_fig,... 
		'CallBack','fun_plt2(''Plot Function'');',... 
		'Position',[ 0.25 0.3 0.39 0.07 ],... 
		'String','-10:10',... 
		'Style','edit',... 
		'Units','normalized'); 

	% Create a static text object that will be used
	% to display messages to the user.
	h_status = uicontrol(h_fig,... 
		'Position',[ 0.1 0.07 0.8 0.07 ],... 
		'String','Status Window',... 
		'Style','text',... 
		'Units','normalized'); 
	% Create the "x = " and "y(x)=" static text objects.
	uicontrol(h_fig,... 
		'Position',[ 0.08 0.3 0.15 0.07 ],... 
		'String','x =',... 
		'Style','text',... 
		'Units','normalized'); 
	uicontrol(h_fig,... 
		'Position',[ 0.08 0.2 0.15 0.07 ],... 
		'String','y(x) =',... 
		'Style','text',... 
		'Units','normalized'); 

	% INITIALIZE the plot with the initial x and y data.
	fun_plt2('Plot Function');

% CALLBACK FOR THE "Box" CHECK BOX.
elseif strcmp(command_str,'Set Box')
	boxstatus = get(h_box,'value');
	if boxstatus == 0;
	  set(gca,'box','off');
	else
	  set(gca,'box','on');
	end
	set(h_status,'string',...
	    ['The box property is ' get(gca,'box')]);

% CALLBACK FOR THE "Grid" CHECK BOX.
elseif strcmp(command_str,'Set Grid')
	gridstatus = get(h_grid,'value');
	if gridstatus == 0
	  grid off
	else;
	  grid on
	end
	set(h_status,'string',...
	    ['The grid is ' get(gca,'xgrid')]);

% CALLBACK FOR THE X and Y(X) EDIT BOXES.
elseif strcmp(command_str,'Plot Function')
	err_ind = 0;
	eval(['x = ' get(h_xdata,'string') ';'],'err_ind=1;');
	if err_ind == 0;
	 eval(['y = ' get(h_ydata,'string') ';'],'err_ind=2;');
	end

	if err_ind == 0
	  plot(x,y);
	  fun_plt2('Set Box');
	  fun_plt2('Set Grid');
	  set(h_status,'string','Function Plotted');
	elseif err_ind == 1
	  set(h_status,'string','Error defining x');
	elseif err_ind == 2
	  set(h_status,'string','Error defining y(x)');
	end

end % END command_str comparison checks.
