function varargout = fun_pltg(varargin)
% FUN_PLTG Application M-file for fun_pltg.fig
%    FIG = FUN_PLTG launch fun_pltg GUI.
%    FUN_PLTG('callback_name', ...) invoke the named callback.

% Last Modified by GUIDE v2.0 07-Aug-2002 11:14:24

if nargin == 0  % LAUNCH GUI

	fig = openfig(mfilename,'reuse');

	% Use system color scheme for figure:
	set(fig,'Color',get(0,'defaultUicontrolBackgroundColor'));

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);

	if nargout > 0
		varargout{1} = fig;
	end

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		disp(lasterr);
	end

end


%| ABOUT CALLBACKS:
%| GUIDE automatically appends subfunction prototypes to this file, and 
%| sets objects' callback properties to call them through the FEVAL 
%| switchyard above. This comment describes that mechanism.
%|
%| Each callback subfunction declaration has the following form:
%| <SUBFUNCTION_NAME>(H, EVENTDATA, HANDLES, VARARGIN)
%|
%| The subfunction name is composed using the object's Tag and the 
%| callback type separated by '_', e.g. 'slider2_Callback',
%| 'figure1_CloseRequestFcn', 'axis1_ButtondownFcn'.
%|
%| H is the callback object's handle (obtained using GCBO).
%|
%| EVENTDATA is empty, but reserved for future use.
%|
%| HANDLES is a structure containing handles of components in GUI using
%| tags as fieldnames, e.g. handles.figure1, handles.slider2. This
%| structure is created at GUI startup using GUIHANDLES and stored in
%| the figure's application data using GUIDATA. A copy of the structure
%| is passed to each callback.  You can store additional information in
%| this structure at GUI startup, and you can change the structure
%| during callbacks.  Call guidata(h, handles) after changing your
%| copy to replace the stored original so that subsequent callbacks see
%| the updates. Type "help guihandles" and "help guidata" for more
%| information.
%|
%| VARARGIN contains any extra arguments you have passed to the
%| callback. Specify the extra arguments by editing the callback
%| property in the inspector. By default, GUIDE sets the property to:
%| <MFILENAME>('<SUBFUNCTION_NAME>', gcbo, [], guidata(gcbo))
%| Add any extra arguments after the last argument, before the final
%| closing parenthesis.



% --------------------------------------------------------------------
function varargout = x_value_Callback(x_value, eventdata, handles, varargin)
fun_pltg('y_fun_Callback',handles.y_fun, eventdata, handles, varargin);



% --------------------------------------------------------------------
function varargout = y_fun_Callback(y_fun, eventdata, handles, varargin)

err_ind = 0;
	eval(['x = ' get(handles.x_value,'string') ';'],'err_ind=1;');
	if err_ind == 0;
	 eval(['y = ' get(y_fun,'string') ';'],'err_ind=2;');
	end
    if err_ind == 0
	  plot(x,y);
	  set(handles.box_check,'Value',1);
      fun_pltg('box_check_Callback',handles.box_check, eventdata, handles, varargin);
      set(handles.grid_check,'Value',1);
      fun_pltg('grid_check_Callback',handles.grid_check, eventdata, handles, varargin);
      
	  set(handles.status,'string','Function Plotted');
	elseif err_ind == 1
	  set(handles.status,'string','Error defining x');
	elseif err_ind == 2
	  set(handles.status,'string','Error defining y(x)');
	end


% --------------------------------------------------------------------
function varargout = grid_check_Callback(grid_check, eventdata, handles, varargin)

gridstatus = get(grid_check,'value');
	if gridstatus == 0
	  grid off
	else;
	  grid on
	end
	set(handles.status,'string',...
	    ['The grid is ' get(gca,'xgrid')]);


% --------------------------------------------------------------------
function varargout = box_check_Callback(box_check, eventdata, handles, varargin)

 boxstatus = get(box_check,'value');
	if boxstatus == 0;
	  set(gca,'box','off');
	else
	  set(gca,'box','on');
	end
	set(handles.status,'string',...
	    ['The box property is ' get(gca,'box')]);
   