function gui_scrl(command_str,Argument2)
% GUI_SCRL
% examples/chap10/gui_scrl.m
%
% Example of scrolling window.
% Type gui_scrl or gui_scrl('initialize',string_matrix);

if nargin < 1
	command_str = 'initialize';
end

if ~strcmp(command_str,'initialize')
	handles = get(gcf,'userdata');
	h_sldr = handles(1);
	h_edit = handles(2);
end

if strcmp(command_str,'initialize')

	h_fig = figure('position',[200 200 200 100],...
				 'resize','off',...
				 'name','Scroll Bar',...
				 'numbertitle','off');
	
	h_frm = uicontrol(h_fig,...
		'style','frame',...
		'position',[0 0 200 100]);
	
	if nargin < 2
		init_string = str2mat('This is the first',...
	  	'La','La','La','This is the fifth','Blah',...
		'Blah','Blah','This is the last');
	else
		init_string = Argument2;
	end
	h_edit = uicontrol(h_fig,...
		'style','edit',...
		'max',2,...
		'string',init_string,...
		'position',[5 5 175 90],...
		'userdata',init_string);

	h_sldr = uicontrol(h_fig,...
		'callback','gui_scrl(''Scrolling'');',...
		'style','slider',...
		'min',1,...
		'max',size(init_string,2),...
		'sliderstep',[1 2]*(1/(size(init_string,2)-1)),...
		'value',1,...
		'position',[180 5 15 90],...
		'userdata',1);
		
	handles = [h_sldr,h_edit];
	set(h_fig,'userdata',handles);

elseif strcmp(command_str,'Scrolling')
	old_val = get(h_sldr,'userdata');
	newval = round(get(h_sldr,'max')-get(h_sldr,'value')+1);
	set(h_sldr, 'userdata',newval);
	str = get(h_edit,'userdata');
	set(h_edit,'string',str(1,newval:size(str,2)));
end
